/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Cutlet;

import UI_CutletScript.send.CutletExecutor;
import UI_Script.Cutlet.CutletListener;
import UI_Script.Cutlet.CutletTokenizer;
import UI_Script.Cutlet.OpenCutletAction;
import UI_Script.Default.KDefaultHelp;
import UI_Script.Help.KAbstractHelp;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Text.KTextPane.KTextPane;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class CutletScriptHandler
extends ScriptHandler {
    static final String cutletExtension = ".cutlet";

    @Override
    public boolean canRunSelection() {
        return false;
    }

    public CutletScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = cutletExtension;
        this.ext[1] = ".CUTLET";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new CutletTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.cutlet");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Cutlet";
    }

    @Override
    public String getExecuteLabel() {
        return "Execute " + this.getScriptName();
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(File file) {
        CutletExecutor ce = new CutletExecutor();
        ce.execute(file);
    }

    @Override
    public void execute(String str) {
        CutletExecutor ce = new CutletExecutor();
        ce.execute(str);
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(KDefaultHelp.class.getName(), textpane);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return CutletListener.class.getName();
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Cutlet");
        item.addActionListener(new OpenCutletAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    @Override
    public JMenu getTemplateMenu() {
        return null;
    }

    public static void createDocument(String title, String docType) {
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("cutlet", "Cutlet Script");
        return filter;
    }
}

