/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Cutlet;

import UI_Desktop.Cutter;
import UI_Script.Cutlet.CutletFunctionsRsrc;
import UI_Script.Tcl.TclTokenizer;
import Utilities.RegExpUtils;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class CutletTokenizer
extends TclTokenizer {
    public static final String USER_VARIABLE = "user_variable";
    private static ResourceBundle CutletFunctionsRes;
    public static Hashtable<String, String> language;

    private static String getLanguage(String nm) {
        String str;
        try {
            str = CutletFunctionsRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numLanguageItems() {
        int num = 0;
        try {
            num = ((CutletFunctionsRsrc)CutletFunctionsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read CutletFunctionsRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < CutletTokenizer.numLanguageItems(); ++i) {
            language.put(((CutletFunctionsRsrc)CutletFunctionsRes).getKey(i), ((CutletFunctionsRsrc)CutletFunctionsRes).getContent(i));
        }
    }

    public CutletTokenizer() {
        String[] ext = new String[]{"cutlet", "CUTLET"};
        Tokenizer.addToRegistry(CutletTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public boolean isDataType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("datatype");
        }
        return false;
    }

    @Override
    public boolean isLanguageType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("language");
        }
        return false;
    }

    @Override
    public boolean isFunction(String str) {
        return false;
    }

    @Override
    public boolean isUserVariable(String str) {
        if (RegExpUtils.isIPAddress(str)) {
            return true;
        }
        if (language.containsKey(str)) {
            return language.get(str).equals(USER_VARIABLE);
        }
        return false;
    }

    static {
        language = new Hashtable();
        try {
            CutletFunctionsRes = ResourceBundle.getBundle("UI_Script.Cutlet.CutletFunctionsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: CutletFunctionsRsrc = " + mre);
        }
        CutletTokenizer.initHashTable();
    }
}

