/*
 * Decompiled with CFR 0.152.
 */
package UI_Script;

import UI_Desktop.Cutter;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.Segment;

public class Escape {
    public static final String QUOTES = "QUOTES";
    public static final String TAB = "TAB";
    public static final String NEWLINE = "NEWLINE";
    public static final String QUOTE = "QUOTE";
    public static final String ESCAPE = "ESCAPE";
    private static final String[][] DEFAULT_NAMES_LOOKUP = new String[][]{{"\"", "QUOTES"}, {"\t", "TAB"}, {"\n", "NEWLINE"}, {"'", "QUOTE"}, {"\\", "ESCAPE"}, {"a", "ALERT"}, {"\f", "FORM"}, {"\r", "RETURN"}, {"v", "VERTICAL_TAB"}};
    public static boolean _isOpenEscape = false;
    public static boolean _isCloseEscape = false;
    public String openStr = null;
    public char[] openChars = null;
    public int openLen = 0;
    public String closeStr = null;
    public char[] closeChars = null;
    public int closeLen = 0;
    private static Hashtable<Escape, Escape> table;

    public static Escape getEscape(String openStr, String closeStr) {
        Enumeration<Escape> e = table.elements();
        while (e.hasMoreElements()) {
            Escape esc = e.nextElement();
            if (esc == null) continue;
            if (openStr != null && esc.openStr.equals(openStr)) {
                return esc;
            }
            if (closeStr == null || !esc.closeStr.equals(closeStr)) continue;
            return esc;
        }
        return null;
    }

    public Escape(String open, String close) {
        int n;
        this.openStr = open;
        this.openLen = open.length();
        this.openChars = new char[this.openLen];
        for (n = 0; n < this.openLen; ++n) {
            this.openChars[n] = this.openStr.charAt(n);
        }
        this.closeStr = close;
        this.closeLen = close.length();
        this.closeChars = new char[this.closeLen];
        for (n = 0; n < this.closeLen; ++n) {
            this.closeChars[n] = this.closeStr.charAt(n);
        }
        table.put(this, this);
    }

    public String toString() {
        return "[" + this.openStr + "," + this.closeStr + "]";
    }

    public String getName() {
        for (int n = 0; n < DEFAULT_NAMES_LOOKUP.length; ++n) {
            if (!this.openStr.substring(1).equals(DEFAULT_NAMES_LOOKUP[n][0])) continue;
            return DEFAULT_NAMES_LOOKUP[n][1];
        }
        return "escape [" + this.openStr + "," + this.closeStr + "]";
    }

    public int findOpenEscape(String str) {
        if (str.length() < this.openLen) {
            return -1;
        }
        int offset = str.indexOf(this.openStr.charAt(0), 0);
        if (offset != -1 && offset + this.openLen < str.length() && (str = str.substring(offset, offset + 3)).equals(this.openStr)) {
            return offset;
        }
        return -1;
    }

    public int findOpenEscape(Segment segment, int from) {
        if (from + this.openLen > segment.count) {
            return -1;
        }
        int foundAt = -1;
        boolean match = false;
        for (int n = from; n < segment.count - this.openLen; ++n) {
            if (segment.array[n + segment.offset] != this.openChars[0]) continue;
            foundAt = n;
            match = true;
            for (int j = 0; j < this.openLen; ++j) {
                if (segment.array[n + j + segment.offset] == this.openChars[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return foundAt + this.openLen;
        }
        return foundAt;
    }

    public int findCloseEscape(Segment segment, int from) {
        if (from + this.closeLen > segment.count) {
            return -1;
        }
        int foundAt = -1;
        boolean match = false;
        for (int n = from; n < segment.count - this.closeLen; ++n) {
            if (segment.array[n + segment.offset] != this.closeChars[0]) continue;
            foundAt = n;
            match = true;
            for (int j = 0; j < this.closeLen; ++j) {
                if (segment.array[n + j + segment.offset] == this.closeChars[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return foundAt + this.closeLen;
        }
        return -1;
    }

    public boolean isOpenEscape(Segment segment, int from) {
        if (this.openLen == 1 && from + this.openLen >= segment.count || this.openLen > 1 && from + this.openLen > segment.count) {
            if (_isOpenEscape) {
                Cutter.setLog("Escape.isOpenEscape() from + openLen > segment.count returning false");
            }
            return false;
        }
        if (_isOpenEscape) {
            Cutter.setLog("Escape.isOpenEscape() from " + from);
            Cutter.setLog("Escape.isOpenEscape() openLen " + this.openLen);
            Cutter.setLog("Escape.isOpenEscape() segment.count " + segment.count);
        }
        for (int j = 0; j < this.openLen; ++j) {
            if (_isOpenEscape) {
                Cutter.setLog("  comparision at:" + (from + j) + " >" + segment.array[from + j + segment.offset] + "< to >" + this.openChars[j] + "<");
            }
            if (segment.array[from + j + segment.offset] == this.openChars[j]) continue;
            return false;
        }
        return true;
    }

    public boolean isOpenEscape(String str) {
        if (str == null) {
            return false;
        }
        if (this.openStr == null) {
            return false;
        }
        if ((str = str.trim()).length() < this.openStr.length()) {
            return false;
        }
        return str.substring(0, this.openStr.length()).equals(this.openStr);
    }

    public boolean isOpenEscape(char[] chars) {
        return this.isOpenEscape(new String(chars));
    }

    public boolean isCloseEscape(Segment segment, int from) {
        if (from + this.closeLen > segment.count) {
            return false;
        }
        for (int j = 0; j < this.closeLen; ++j) {
            if (segment.array[from + j + segment.offset] == this.closeChars[j]) continue;
            return false;
        }
        return true;
    }

    public boolean _isCloseEscape(Segment segment, int at) {
        return true;
    }

    public boolean isCloseEscape(String str) {
        if (str == null) {
            return false;
        }
        if (this.closeStr == null) {
            return false;
        }
        if (this.closeStr.length() > 1) {
            str = str.trim();
        }
        if (str.length() < this.closeStr.length()) {
            return false;
        }
        return str.substring(0, this.closeStr.length()).equals(this.closeStr);
    }

    public boolean isCloseEscape(char[] chars) {
        return this.isCloseEscape(new String(chars));
    }

    public boolean isPartialOpenEscape(String str) {
        for (int n = 0; n < str.length(); ++n) {
            for (int i = 0; i < this.openStr.length(); ++i) {
                if (str.charAt(n) != this.openStr.charAt(i)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsOpenEscape(String str) {
        if (str.length() < this.openLen) {
            return false;
        }
        int offset = str.indexOf(this.openChars[0], 0);
        return offset != -1 && offset + this.openLen <= str.length() && (str = str.substring(offset, offset + this.openLen)).equals(this.openStr);
    }

    public boolean containsClosingEscape(String str) {
        if (str.length() < this.closeLen) {
            return false;
        }
        int offset = str.indexOf(this.closeChars[0], 0);
        return offset != -1 && offset + this.closeLen <= str.length() && (str = str.substring(offset, offset + this.closeLen)).equals(this.closeStr);
    }

    static {
        try {
            Field[] fields = new Field[]{Escape.class.getDeclaredField("_isOpenEscape"), Escape.class.getDeclaredField("_isCloseEscape")};
            Cutter.addDebug(Escape.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: Escape.static - " + ex.toString());
        }
        table = new Hashtable();
    }
}

