/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.H;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.KCompletionManager;
import UI_Script.Rman.BlockDB;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KTextPane;
import Utilities.FileUtils;
import Utilities.FinderUtils;
import Utilities.RegExpUtils;
import Utilities.TextUtils;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;

public class HHelp
extends KAbstractHelp {
    private static Hashtable<String, String> languageTable = new Hashtable();
    private boolean isRSLTContainer = false;

    public HHelp(KTextPane textpane) {
        super(textpane);
        this.completer.completionActivate();
        char[] delims = KCaret.getDefaultDelimitors();
        char[] modified = new char[delims.length - 1];
        int counter = 0;
        for (int n = 0; n < delims.length; ++n) {
            if (delims[n] == '#') continue;
            modified[counter] = delims[n];
            ++counter;
        }
        this.completer.setWordStartDelims(modified);
        this.setCompletorListeners();
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
        this.isRSLTContainer = this.isRSLT();
        if (!this.isRSLTContainer) {
            this.completer.completionDeActivate();
            return;
        }
        this.completer.completionActivate();
        Cutter.setLog("    Info:HHelp.setCompletorListeners() - doc is a pixar rslt container");
        languageTable.clear();
        languageTable.put("rfm_nodeid", "rfm_nodeid");
        languageTable.put("rfm_classification", "rfm_classification");
        languageTable.put("rslplugin", "RSLPlugin");
        languageTable.put("rfmshadeops", "RfMShadeops");
        languageTable.put("rslinclude", "RSLInclude");
        languageTable.put("rslfunction", "RSLFunction");
        languageTable.put("rslsource", "RSLSource");
        languageTable.put("rslinject_preamble", "RSLINJECT_preamble");
        languageTable.put("rslinject_shaderdef", "RSLINJECT_shaderdef");
        languageTable.put("rslinject_members", "RSLINJECT_members");
        languageTable.put("rslinject_prelighting", "RSLINJECT_prelighting");
        languageTable.put("shaderpipeline", "ShaderPipeline");
        languageTable.put("evaluatesamples", "evaluateSamples");
        languageTable.put("generatesamples", "generateSamples");
        languageTable.put("codegenhints", "codegenhints");
        languageTable.put("shaderobject", "shaderobject");
        languageTable.put("begin", "begin");
        languageTable.put("construct", "construct");
        languageTable.put("prelighting", "prelighting");
        languageTable.put("lighting", "lighting");
        languageTable.put("_thisfile_", "_thisfile_");
        Enumeration<String> e = languageTable.keys();
        while (e.hasMoreElements()) {
            String str = e.nextElement().toString();
            if (!str.startsWith("#")) continue;
            languageTable.put(str, str.substring(1));
        }
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        if (!this.isRSLTContainer) {
            return false;
        }
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        if (str.startsWith("#")) {
            return true;
        }
        if (str.startsWith("_")) {
            return true;
        }
        return str.length() >= KCompletionManager.MIN_LEN;
    }

    @Override
    public String[] completionCandidates(String str) {
        return this.completionCandidates(str, languageTable);
    }

    public boolean isRSLT() {
        String srcText = this.textpane.getText();
        if (srcText == null || srcText.trim().length() == 0) {
            return false;
        }
        return RegExpUtils.split(srcText, "(\\s*rman\\s+id\\s*=\\s*\"rslt\"\\s*)") != null;
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu(this);
        int begin = insertAt - selection.length();
        JComponent[] items = this.getDefaultPopupItems(e, selection, begin, insertAt);
        if (items == null) {
            return;
        }
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            popup.add(items[n]);
        }
        if (popup != null) {
            popup.setRequestFocusEnabled(false);
            try {
                popup.show(this.textpane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:SloHelp.popupOnlineHelp()\n      " + ex.toString());
            }
        }
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        this.useCutterBrowser = false;
        return this.launchBrowser(item);
    }

    @Override
    protected void lookup(String item) {
        Cutter.setLog("    Debug:HHelp.lookup() - delegating item \"" + item + "\" to SloHelp._lookup_()");
    }

    public void openPreViewInBrowser(String text) {
        if (text == null || text.trim().length() == 0) {
            Cutter.setLog("    Error: HHelp.openPreViewInBrowser() - received null or empty text.");
            return;
        }
        FinderUtils.FindDB db = FinderUtils.doFind(text, "<rman id=\"rslt\">", 0, true, true);
        if (db.absBegin == -1 || db.absEnd == -1) {
            Cutter.setLog("    Error: HHelp.openPreViewInBrowser() cannot find start of rslt block");
            return;
        }
        int slimBlockBegin = db.absEnd;
        db = FinderUtils.doFind(text, "</rman>", 0, true, true);
        if (db.absBegin == -1 || db.absEnd == -1) {
            Cutter.setLog("    Error: HHelp.openPreViewInBrowser() cannot find end of rslt block");
            return;
        }
        int slimBlockEnd = db.absBegin;
        String slimBlockStr = text.substring(slimBlockBegin, slimBlockEnd);
        db = FinderUtils.doFind(text, "template", slimBlockBegin, true, true);
        if (db.absBegin == -1 || db.absEnd == -1) {
            Cutter.setLog("    Error: HHelp.openPreViewInBrowser() cannot find template keyword.");
            return;
        }
        int templateBegin = db.absBegin - slimBlockBegin;
        if (templateBegin < slimBlockBegin) {
            Cutter.setLog("    Error: HHelp.openPreViewInBrowser() - template keyword found at offset " + templateBegin);
            return;
        }
        String templateBlockStr = text.substring(templateBegin, slimBlockEnd);
        BlockDB[] blocks = this.getDeclaredBlocks(templateBlockStr);
        if (blocks == null) {
            return;
        }
        try {
            String title = BBxt.getWindowTitle();
            if (title.endsWith(" [NOT EDITABLE]")) {
                title = title.substring(0, title.length() - " [NOT EDITABLE]".length());
            }
            title = TextUtils.removeExtension(title);
            File d = new File(FileUtils.getPWDFile(), "previs_" + title);
            File file = new File(d, "index.html");
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:HHelp.openPreViewInBrowser\n        " + ex.toString());
        }
    }

    private String _getPrevisTitle() {
        String title = TextUtils.removeExtension(this.textpane.getFrameTitle());
        if (title.endsWith("UI")) {
            title = title.substring(0, title.length() - 2);
        }
        return title;
    }

    private BlockDB[] getDeclaredBlocks(String text) {
        return null;
    }

    private String grabNextString(String head, String str) {
        String tail;
        try {
            tail = str.substring(head.length()).trim();
        }
        catch (IndexOutOfBoundsException e) {
            Cutter.setLog("    Exeception:RmanHelp.grabNextString()\n        " + e.toString());
            return "";
        }
        tail = TextUtils.trimLeadingChar(tail, '\"');
        tail = TextUtils.trimTrailingChar(tail, '\"');
        tail = TextUtils.trimLeadingChar(tail, '{');
        tail = TextUtils.trimTrailingChar(tail, '}');
        return tail;
    }
}

