/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.H;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.H.HHelp;
import UI_Script.H.HListener;
import UI_Script.H.HTokenizer;
import UI_Script.H.OpenHAction;
import UI_Script.Help.KAbstractHelp;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractTextWindow;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import java.io.File;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;

public class HScriptHandler
extends ScriptHandler {
    @Override
    public boolean canRunSelection() {
        return false;
    }

    public HScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".h";
        this.ext[1] = ".H";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new HTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.h");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "h";
    }

    @Override
    public String getExecuteLabel() {
        return null;
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(File file) {
        KAbstractHelp helper;
        JEditorPane pane = BBxt.getTextPane();
        KTextPane textpane = null;
        if (pane != null && pane instanceof KTextPane) {
            textpane = (KTextPane)pane;
        }
        if ((helper = this.getHelper(textpane)) == null || !(helper instanceof HHelp)) {
            Cutter.setLog("    Error:HScriptHandler.execute() - cannot get an instance of HHelp");
            return;
        }
        KAbstractTextWindow kat = textpane.getFrame();
        if (kat != null) {
            ((HHelp)helper).openPreViewInBrowser(kat.getAllText());
        } else {
            Cutter.setLog("    Error: HScriptHandler.execute(File) - textpane returned null for KAbstractTextWindow");
        }
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp.h");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return HListener.class.getName();
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(HHelp.class.getName(), textpane);
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("H");
        item.addActionListener(new OpenHAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("h", "C/C++ Header File");
        return filter;
    }
}

