/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.H;

import UI_Desktop.Cutter;
import UI_Script.C.CTokenizer;
import UI_Script.ScriptParser.ProcDBItem;
import Utilities.TextUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.text.Segment;
import kernal.Tokenizers.Tokenizer;

public class HTokenizer
extends CTokenizer {
    private static final char[] ptrs = new char[]{'[', ']', '&', '*'};
    private static boolean IGNORE_OPERATOR = true;

    public HTokenizer() {
        this.commonInit();
    }

    public HTokenizer(String filename) throws FileNotFoundException, IOException {
        super(filename);
        this.commonInit();
    }

    public HTokenizer(Segment segment) {
        super(segment);
        this.commonInit();
    }

    @Override
    protected void commonInit() {
        this.name = "HTokenizer";
        this.addComment("/*", "*/");
        this.addComment("//", "\n");
        this.addQuotation("\"", "\"", '\\');
        this.addQuotation("'", "'", '\\');
        this.addEscape("\\\"", "");
        this.addEscape("\\\\", "");
        this.addEscape("\\'", "");
        this.setSyntaxLength(2);
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.removeDelimitor("~");
        String[] ext = new String[]{"h", "H"};
        Tokenizer.addToRegistry(HTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        String peek;
        if (this.isOpenComment(str)) {
            return null;
        }
        if (str.equals("typedef") || str.equals("{") || str.equals("}")) {
            return null;
        }
        int index = this.getBufferIndex();
        StringBuffer b = new StringBuffer();
        String enclosingClassname = "";
        this.lpGetEnclosingNameAtIndex(b, index);
        if (b.length() > 0) {
            enclosingClassname = b.toString() + "::";
        }
        if (str.startsWith("#")) {
            String name = this.getNextStr();
            int temp = this.getBufferIndex() - str.length();
            int offset = this.findNewline(index);
            if (offset != -1) {
                this.setBufferIndex(offset);
                return null;
            }
            return null;
        }
        if (str.equals("public") || str.equals("private")) {
            int[] offset;
            ProcDBItem out = new ProcDBItem();
            out.access = str;
            str = this.getNextStr();
            if (str.equals("") || !this.isDataType(str)) {
                return null;
            }
            out.procType = enclosingClassname + str;
            str = this.getNextStr();
            if (str.equals("")) {
                return null;
            }
            out.procNameOffset[0] = this.getBufferIndex() - str.length();
            out.procNameOffset[1] = this.getBufferIndex();
            out.procName = enclosingClassname + str;
            int temp = this.getBufferIndex();
            String ptext = this.lpGrabProcParams("(", ")");
            if (ptext == null) {
                this.setBufferIndex(temp);
            }
            if ((offset = this.lpGrabProcBody("{", "}", null)) == null) {
                this.setBufferIndex(temp);
            }
            Cutter.setLog("    Debug:HTokenizer.lpGrabProc() - return 1");
            return out;
        }
        if (str.equals("struct")) {
            String typeStr = str;
            Tokenizer.StringPosition structDB = new Tokenizer.StringPosition(this);
            String structName = "";
            String tagName = "";
            int[] offset = null;
            String s = this.getNextStr();
            structDB.offset = this.getBufferIndex();
            int structBodyIndex = -1;
            if (s.equals("")) {
                return null;
            }
            if (s.equals("{")) {
                tagName = "";
            } else {
                structDB.str = tagName = s;
                s = this.getNextStr();
                if (s.equals("")) {
                    return null;
                }
                if (s.equals(";")) {
                    Cutter.setLog("    Debug:HTokenizer.lpGrabProc() - return null at 1.1");
                    return null;
                }
            }
            if (!s.equals("{")) {
                Cutter.setLog("    Debug:HTokenizer.lpGrabProc() - return 1.2");
                return null;
            }
            structBodyIndex = this.getBufferIndex();
            this.setBufferIndex(this.getBufferIndex() - 1);
            offset = this.lpGrabProcBody("{", "}", null);
            if (offset == null) {
                Cutter.setLog("    Debug:HTokenizer.lpGrabProc() - return null at 1.3");
                return null;
            }
            s = this.getNextStr();
            if (s.equals("")) {
                return null;
            }
            if (!s.equals(";")) {
                structDB.str = s;
                s = this.getNextStr();
                if (!s.equals(";")) {
                    Cutter.setLog("    Warning:HTokenizer.lpGrabProc() - expected \";\" but found \"" + s + "\" at " + this.getBufferIndex());
                }
            }
            if (typeStr.equals("enum")) {
                Cutter.setLog("    Debug:HTokenizer.lpGrabProc() - return null at 1.4");
                return null;
            }
            ProcDBItem out = new ProcDBItem(typeStr + " : " + structDB.str, structDB.offset - structDB.str.length(), structDB.offset);
            out.procOffset[0] = structDB.offset - structDB.str.length();
            out.procOffset[1] = offset[1];
            if (structBodyIndex != -1) {
                this.setBufferIndex(structBodyIndex);
            }
            Cutter.setLog("    Debug:HTokenizer.lpGrabProc() - return null at 2");
            return out;
        }
        if (this.lpSkip(str, "class", '{') || this.lpSkip(str, "public", ':') || this.lpSkip(str, "private", ':') || this.lpSkip(str, "protected", ':') || this.lpSkip(str, "#include", '\n') || this.lpSkip(str, "#ifndef", '\n') || this.lpSkip(str, "#define", '\n')) {
            return null;
        }
        if (str.equals("inline") && (peek = this.peekNextStr()) != null && peek.equals("friend")) {
            str = this.getNextStr();
        }
        index = this.getBufferIndex();
        Tokenizer.StringPosition[] sp = this.lpGetSignature(str, 5, ptrs, '(');
        int foundAt = -1;
        if (sp != null) {
            for (int n = 0; n < sp.length; ++n) {
                if (!sp[n].str.equals("(")) continue;
                foundAt = n;
                break;
            }
        }
        if (foundAt > 0) {
            this.setBufferIndex(sp[foundAt].offset - 1);
            String ignoreMe = this.lpGrabProcParams("(", ")");
            char c = this.lpGotoIndexOfFirst('{', ';');
            if (c == ';' || c == '\u0000') {
                this.setBufferIndex(this.getBufferIndex() + 1);
                return null;
            }
            Tokenizer.StringPosition namePos = sp[foundAt - 1];
            int[] offset = this.lpGrabProcBody("{", "}", null);
            if (offset == null) {
                Cutter.setLog("    Debug:HTokenizer.lpGrabProc() - return null at 2.3 unable to find proc body");
                return null;
            }
            for (int n = 0; n < ILLEGAL_PROC_NAMES.length; ++n) {
                if (!namePos.str.equals(ILLEGAL_PROC_NAMES[n])) continue;
                this.setBufferIndex(offset[1]);
                return null;
            }
            if (IGNORE_OPERATOR && namePos.str.startsWith("operator")) {
                this.setBufferIndex(offset[1]);
                return null;
            }
            ProcDBItem out = new ProcDBItem(namePos.str, namePos.offset - namePos.str.length(), namePos.offset);
            if (out.procName.equals("if") || TextUtils.contains("*-+=/", out.procName.charAt(0)) || out.procName.equals(">") || out.procName.equals("<")) {
                return null;
            }
            out.procName = enclosingClassname + namePos.str;
            this.setBufferIndex(offset[1]);
            return out;
        }
        this.setBufferIndex(index);
        int semi = this.findForward(this.getBufferIndex(), ';');
        if (semi != -1) {
            this.setBufferIndex(semi + 1);
        }
        return null;
    }

    @Override
    protected void lpGetClassInterfaceSpan(String str) {
        if (this.isOpenComment(str)) {
            return;
        }
        if (this.lpSkip(str, "#include", '\n') || this.lpSkip(str, "#ifndef", '\n') || this.lpSkip(str, "#define", '\n')) {
            return;
        }
        if (!str.equals("class")) {
            return;
        }
        int index = this.getBufferIndex();
        String s = this.getNextStr();
        if (s.equals("")) {
            return;
        }
        int n = this.getBufferIndex();
        int curlyIndex = this.findForward(this.getBufferIndex(), '{');
        this.setBufferIndex(n);
        int semiColonIndex = this.findForward(this.getBufferIndex(), ';');
        if (semiColonIndex != -1 && curlyIndex != -1 && semiColonIndex < curlyIndex) {
            return;
        }
        this.setBufferIndex(n);
        Tokenizer.ClassInterfaceSpan out = new Tokenizer.ClassInterfaceSpan(this);
        out.name = s;
        out.span[0] = this.findForward(this.getBufferIndex(), '{');
        if (out.span[0] == -1) {
            this.setBufferIndex(index);
            return;
        }
        this.setBufferIndex(this.getBufferIndex() - 1);
        if (this.lpGrabProcBody("{", "}", null) == null) {
            this.setBufferIndex(index);
            return;
        }
        out.span[1] = this.getBufferIndex();
        this.listOfClassInterfaceSpans.addElement(out);
    }
}

