/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Help;

import Preferences.Preferences;
import UI_Actions.AddCommentsAction;
import UI_Actions.ColorEditAction;
import UI_Actions.RemoveCommentsAction;
import UI_Actions.TextShiftAction;
import UI_Actions.ToLowerCaseAction;
import UI_Actions.ToUpperCaseAction;
import UI_BBXT.BBxt;
import UI_Components.Dialog.OpenFileDialog;
import UI_Components.GBC;
import UI_Components.ToolTip.MultiLineToolTip;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Script.Default.KDefaultHelp;
import UI_Script.Help.InstallHelpDocsDialog;
import UI_Script.Help.KCompletionActions;
import UI_Script.Help.KCompletionManager;
import UI_Script.Help.PopUpTriggerListener;
import UI_Script.Help.Url;
import UI_Script.Mel.MelHelp;
import UI_Script.Rib.RibHelp;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import UI_Script.Tcl.TclHelp;
import UI_Script.Vfl.VflHelp;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Mail.SendMailTool;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.RenderInfoListener;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.BrowserUtils;
import Utilities.DocumentUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.GraphicsFileUtils;
import Utilities.NumberUtils;
import Utilities.RibInZipUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import kernal.Tokenizers.Tokenizer;

public abstract class KAbstractHelp
implements RenderInfoListener,
PopUpTriggerListener,
KCompletionActions {
    public static final String HELP_DOCS_DIRECTORY = "Cutter_Help";
    public static final String HELP_DOCS_BASE_URL = KAbstractHelp.configurePath(FileUtils.getPWD()) + "/" + "Cutter_Help" + "/";
    protected static final String DEFAULT_POPUP_MENU_TITLE = "General Options";
    protected static final String RMAN_INDEX = "index.html";
    protected static final String RMAN_MAIN_URL = HELP_DOCS_BASE_URL + "/" + "index.html";
    public static final String TCLCMD_DIRECTORY = "tcl";
    protected static final Vector<Class> listOfSubClasses = new Vector();
    public static boolean _finalize = false;
    private static InstallHelpDocsDialog installDialog;
    protected KTextPane textpane = null;
    protected int selRawBegin = -1;
    protected int selRawEnd = -1;
    protected String selRawStr = null;
    protected int selExtBegin = -1;
    protected int selExtEnd = -1;
    protected String selExtStr = null;
    protected String lineOfText = null;
    protected int lineBegin = -1;
    protected MouseEvent mouseEvent = null;
    protected String initialSelection;
    public KCompletionManager completer = null;
    protected boolean useCutterBrowser = true;
    private int maxTextWidth = 0;
    private static Vector<KAbstractHelp> freelist;
    private ColorEditAction rgbEditAction = new ColorEditAction("Edit Color...");
    ScriptHandler handler = null;
    private File lastFindDir = null;
    public static boolean doDeleted;

    public KAbstractHelp(KTextPane textpane) {
        this.textpane = textpane;
        this.completer = new KCompletionManager(textpane, this);
    }

    @Override
    public void setCompletorListeners() {
    }

    @Override
    public void completionHappenedAt(String str, int offset) {
    }

    @Override
    public boolean completionDotIsValid(String str) {
        return false;
    }

    @Override
    public String[] completionDotCandidates(String str) {
        return null;
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        return false;
    }

    @Override
    public String[] completionCandidates(String str) {
        return null;
    }

    @Override
    public String[] completionCandidates(String str, Hashtable tableOfCandidates) {
        Vector<String> keys = new Vector<String>();
        Vector<String> out = new Vector<String>();
        Enumeration e = tableOfCandidates.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if (key.equalsIgnoreCase(str) || !key.startsWith(str.toLowerCase())) continue;
            keys.add(key);
        }
        if (keys.isEmpty()) {
            return null;
        }
        String[] keylist = VectorUtils.toStringArray(keys);
        keylist = TextUtils.sortByAlpha(keylist);
        for (int n = 0; n < keylist.length; ++n) {
            String ribstatement = (String)tableOfCandidates.get(keylist[n]);
            out.add(ribstatement);
        }
        return VectorUtils.toStringArray(out);
    }

    public static void add(KAbstractHelp helper) {
        if (helper == null || freelist.contains(helper)) {
            return;
        }
        freelist.addElement(helper);
    }

    public static synchronized KAbstractHelp getInstanceByName(String name, KTextPane textpane) {
        Constructor<?> constr = null;
        KAbstractHelp helper = null;
        try {
            Class<?> cls = Class.forName(name);
            Class[] params = new Class[]{textpane.getClass()};
            constr = cls.getDeclaredConstructor(params);
            Object[] p = new Object[]{textpane};
            helper = (KAbstractHelp)constr.newInstance(p);
            return helper;
        }
        catch (ExceptionInInitializerError ei) {
            Cutter.setLog("    Exception: 1 AbstractHelp.getInstanceByName() - name = >" + name + "<");
            Cutter.setLog(ei.toString());
            return null;
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: 2 AbstractHelp.getInstanceByName() - name = >" + name + "<");
            Cutter.setLog(e.toString());
            return null;
        }
    }

    public static boolean isOK(KTextPane pane) {
        if (pane.helper == null) {
            return false;
        }
        String title = TextUtils.remove(pane.getFrameTitle(), '*');
        if ((title.endsWith(".rib") || title.endsWith(".RIB")) && pane.helper instanceof RibHelp) {
            return true;
        }
        if ((title.endsWith(".mel") || title.endsWith(".MEL")) && pane.helper instanceof MelHelp) {
            return true;
        }
        if ((title.endsWith(".vfl") || title.endsWith(".VFL")) && pane.helper instanceof VflHelp) {
            return true;
        }
        if ((title.endsWith(".tcl") || title.endsWith(".TCL")) && pane.helper instanceof TclHelp) {
            return true;
        }
        return (title.endsWith(".txt") || title.endsWith(".TXT")) && pane.helper instanceof KDefaultHelp;
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        if (selection.length() == 0) {
            return;
        }
        this.mouseEvent = e;
        int begin = insertAt - selection.length();
        KPopupMenu popup = this.getDefaultPopup(e, selection, begin, insertAt);
        popup.setRequestFocusEnabled(false);
        if (popup != null) {
            try {
                popup.show(this.textpane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:KAbstractHelp.popupOnlineHelp()\n        " + ex.toString());
            }
        }
    }

    public KPopupMenu getDefaultPopup(MouseEvent e, String initialSelection, int begin, int end) {
        int n;
        KPopupMenu popup = new KPopupMenu();
        JComponent[] items = this.getDefaultPopupItems(e, initialSelection, begin, end);
        for (n = 0; n < items.length; ++n) {
            if (items[n] != null) {
                popup.add(items[n]);
            }
            if (n != 0 || items[n] == null) continue;
            popup.add(new JSeparator());
        }
        items = this.getSpecialPopupItems(e, initialSelection, begin, end);
        for (n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            popup.add(items[n]);
        }
        popup.pack();
        return popup;
    }

    protected KPopupMenuItem getDefaultSendMailMenu() {
        if (this.selRawStr == null || this.selRawStr.trim().length() == 0) {
            return null;
        }
        String[] lines = TextUtils.tokenize(this.selRawStr, "\n");
        if (lines == null || lines.length == 0) {
            return null;
        }
        if (!lines[0].trim().contains("@")) {
            return null;
        }
        String address = SendMailTool.getUsersEmailAddress();
        if (address.equals("")) {
            Cutter.setLog("    Debug:KAbstractHelp.getDefaultSendMailMenu() - users email address\n            not set in preferences");
            return null;
        }
        KPopupMenuItem mi = new KPopupMenuItem("Send Mail");
        mi.setForeground(Color.blue);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SendMailTool.setStatusColor(Color.black);
                        SendMailTool.setStatusText("Trying to connect");
                        SendMailTool.sendGrade();
                    }
                });
            }
        });
        return mi;
    }

    protected JComponent[] getDefaultPopupItems(MouseEvent e, String initialSelection, int begin, int end) {
        this.initSelectionData(initialSelection, begin, end);
        this.mouseEvent = e;
        JComponent[] list = new JComponent[]{this.getDefaultSendMailMenu(), this.getDefaultOpenPathMenu(), this.getDefaultSelectBlockMenu(), this.getDefaultFileBrowseMenu(), this.getDefaultEditMenu(), this.getDefaultTextShiftMenu(), this.getDefaultCmntMenu(), this.getDefaultCaseMenu(), this.getDefaultEditRGBMenu(), this.getDefaultExportAsHtml(), this.getDefaultLineNumbering(), this.getDefaultBreakLines(), this.getDefaultTypingCompletion(), new JSeparator(), this.getDefaultExecute()};
        return list;
    }

    protected JComponent[] getSpecialPopupItems(MouseEvent e, String initialSelection, int begin, int end) {
        this.initSelectionData(initialSelection, begin, end);
        JComponent[] list = new JComponent[]{};
        Vector<KPopupMenuItem> v = new Vector<KPopupMenuItem>();
        if (this.selRawStr == null || this.selRawStr.indexOf(10) != -1) {
            return list;
        }
        KPopupMenuItem item = this.getBrickmakeMenu();
        if (item != null) {
            v.addElement(item);
        }
        list = new JComponent[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            list[n] = (JComponent)v.elementAt(n);
        }
        return list;
    }

    private KPopupMenuItem getBrickmakeMenu() {
        if (this.selRawStr.equals("")) {
            int selDeltaBegin;
            int selDeltaEnd = selDeltaBegin = this.selRawBegin - this.lineBegin;
            String sel = this.doOrderedExpansion(selDeltaBegin, selDeltaEnd);
            if (sel == null || sel.equals("")) {
                return null;
            }
            this.selExtBegin = this.textpane.getSelectionStart();
            this.selExtEnd = this.textpane.getSelectionEnd();
            this.selExtStr = this.textpane.getSelection();
        }
        if (!this.selExtStr.endsWith(".ptc")) {
            return null;
        }
        final File file = this.convertSelectionToFile(this.selExtStr);
        if (file == null || !file.exists()) {
            return null;
        }
        KPopupMenuItem mi = new KPopupMenuItem("Convert to brickmap");
        mi.addMouseListener(new KSelectionExpander());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (file != null && file.exists() && GraphicsFileUtils.canBrickMakeConvert(file)) {
                    GraphicsFileUtils.BrickMakeConvert(file);
                }
            }
        });
        return mi;
    }

    protected void initSelectionData(String initialSelection, int begin, int end) {
        this.selRawBegin = -1;
        this.selRawEnd = -1;
        this.selRawStr = initialSelection;
        this.initialSelection = initialSelection;
        this.lineBegin = -1;
        this.lineOfText = null;
        this.selExtBegin = -1;
        this.selExtEnd = -1;
        this.selExtStr = null;
        if (this.textpane == null || this.textpane.getDocument() == null) {
            Cutter.setLog("    Error:KAbstractHelp.initSelectionData() - either textpane or its document is null");
            return;
        }
        this.selRawStr = initialSelection;
        this.selRawBegin = begin;
        this.selRawEnd = end;
        if (this.selRawBegin == -1 || this.selRawEnd == -1 || this.selRawStr == null) {
            Cutter.setLog("    Error:KAbstractHelp.initSelectionData() - cannot get selection offsets from the textpane.");
            return;
        }
        Element element = DocumentUtils.getParagraphElement(this.textpane.getDocument(), this.selRawBegin);
        if (element != null) {
            Segment s = DocumentUtils.getSegment(this.textpane.getDocument(), element);
            this.lineOfText = s.toString();
            this.lineOfText = this.lineOfText.endsWith("\n") ? this.lineOfText.substring(0, this.lineOfText.length() - 1) : this.lineOfText;
            this.lineBegin = element.getStartOffset();
        }
        this.selExtBegin = this.selRawBegin;
        this.selExtEnd = this.selRawEnd;
        this.selExtStr = this.selRawStr;
    }

    protected KPopupMenu getDefaultMenu(MouseEvent e, String initialSelection, int begin, int end) {
        KPopupMenu popup = new KPopupMenu();
        JMenu defaultMenu = new JMenu(DEFAULT_POPUP_MENU_TITLE);
        Font f = defaultMenu.getFont();
        defaultMenu.setFont(new Font(f.getName(), 3, f.getSize()));
        JComponent[] items = this.getDefaultPopupItems(e, initialSelection, begin, end);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            defaultMenu.add(items[n]);
        }
        popup.add(defaultMenu);
        return popup;
    }

    protected KPopupMenuItem getDefaultSelectBlockMenu() {
        KPopupMenuItem mi = new KPopupMenuItem("Select Block");
        if (this.selRawStr == null || this.selRawStr.trim().length() > 1) {
            mi.setEnabled(false);
            return mi;
        }
        mi.addActionListener(new KAbstractDesktop.SelectBlockAction(this.textpane, this.selRawBegin));
        return mi;
    }

    protected KPopupMenuItem getDefaultOpenPathMenu() {
        String browser;
        String[] paths;
        File file;
        KPopupMenuItem mi = new KPopupMenuItem("Open Selection");
        if (this.selRawStr == null || this.selRawStr.indexOf(10) != -1) {
            mi.setEnabled(false);
            return mi;
        }
        if (this.selRawStr.equals("")) {
            int selDeltaBegin;
            int selDeltaEnd = selDeltaBegin = this.selRawBegin - this.lineBegin;
            String sel = this.doOrderedExpansion(selDeltaBegin, selDeltaEnd);
            if (sel == null || sel.equals("")) {
                mi.setEnabled(false);
                return mi;
            }
            this.selExtBegin = this.textpane.getSelectionStart();
            this.selExtEnd = this.textpane.getSelectionEnd();
            this.selExtStr = this.textpane.getSelection();
        }
        if ((file = this.convertSelectionToFile(this.selExtStr)) != null) {
            Cutter.setLog("    Debug:KAbstractHelp.getDefaultOpenPathMenu() - convertSelectionToFile() returned \"" + file.getPath() + "\"");
        }
        String zipfilePath = null;
        String zipEntry = null;
        if (file == null && (paths = RibInZipUtils.ribInZipPath(this.selExtStr)) != null) {
            zipfilePath = paths[0];
            zipEntry = paths[1];
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:KAbstractHelp.getDefaultOpenPathMenu() - zipfilePath \"" + zipfilePath);
                Cutter.setLog("    Debug:KAbstractHelp.getDefaultOpenPathMenu() - zipEntry \"" + zipEntry);
            }
        }
        if (file != null && file.isDirectory()) {
            mi.setEnabled(false);
            return mi;
        }
        String appName = null;
        if (file != null && !file.isDirectory() && (appName = GraphicsFileUtils.canOpenUsing(file)) != null) {
            mi.setText("Open with \"" + appName + "\"");
        } else if (this.selExtStr != null && this.selExtStr.endsWith("xml")) {
            browser = Preferences.get(Preferences.WEB_BROWSER_PREFERRED);
            if (browser.trim().length() == 0) {
                browser = "Browser";
            } else {
                browser = TextUtils.removeExtension(browser);
                browser = TextUtils.capitalize(browser);
            }
            mi.setText("Open in " + browser);
        } else if (this.selExtStr != null && (this.selExtStr.startsWith("http://") || this.selExtStr.startsWith("www."))) {
            if (this.mouseEvent != null && this.mouseEvent.isShiftDown()) {
                mi.setText("View HTML Source");
            } else {
                browser = Preferences.get(Preferences.WEB_BROWSER_PREFERRED);
                if (browser.trim().length() == 0) {
                    browser = "Browser";
                } else {
                    browser = TextUtils.removeExtension(browser);
                    browser = TextUtils.capitalize(browser);
                }
                mi.setText("Open in " + browser);
            }
        }
        final String ribInZipPath = zipfilePath;
        final String ribInZipEntry = zipEntry;
        ActionListener openAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KAbstractWindow w;
                File zipfile;
                File binaryRibfile;
                if (ribInZipPath != null && ribInZipEntry != null && (binaryRibfile = RibInZipUtils.unZipPixarRibInZip(zipfile = KAbstractHelp.this.convertSelectionToFile(ribInZipPath), ribInZipEntry)) != null && binaryRibfile.exists()) {
                    RibInZipUtils ribInZip = new RibInZipUtils();
                    ribInZip.pixarBinRibToAsciiRib(binaryRibfile, true);
                    return;
                }
                if (file != null && file.exists()) {
                    File hostfile = KAbstractHelp.this.textpane.getFrameFile();
                    if (hostfile == null) {
                        return;
                    }
                    File hostdir = hostfile.getParentFile();
                    if (KAbstractHelp.this.selExtStr.endsWith("xml")) {
                        File f = new File(KAbstractHelp.this.selExtStr);
                        String fullpath = KAbstractHelp.this.selExtStr;
                        if (f.exists()) {
                            BrowserUtils.open(KAbstractHelp.this.selExtStr);
                            return;
                        }
                        if (KAbstractHelp.this.selExtStr.startsWith("renderman")) {
                            File rmsProjRoot = FileUtils.isRMSRibFile(file);
                            if (rmsProjRoot != null) {
                                fullpath = new File(rmsProjRoot, KAbstractHelp.this.selExtStr).getPath();
                                File tmp = new File(fullpath);
                                if (tmp.exists()) {
                                    BrowserUtils.open(fullpath);
                                    return;
                                }
                            } else {
                                f = new File(hostdir, KAbstractHelp.this.selExtStr);
                                if (f.exists()) {
                                    BrowserUtils.open(f.getPath());
                                    return;
                                }
                            }
                        } else {
                            f = new File(hostdir, KAbstractHelp.this.selExtStr);
                            if (f.exists()) {
                                BrowserUtils.open(f.getPath());
                                return;
                            }
                            f = new File(FileUtils.getPWDFile(), KAbstractHelp.this.selExtStr);
                            if (f.exists()) {
                                BrowserUtils.open(f.getPath());
                                return;
                            }
                        }
                        JOptionPane.showMessageDialog(KDesktop.desktopPane, "Unable to find the XML file.\n\n", "Missing XML File", 2);
                    } else if (GraphicsFileUtils.canOpen(file)) {
                        GraphicsFileUtils.open(file);
                        return;
                    }
                    w = KAbstractDesktop.getWindowWithFile(file);
                    if (w != null) {
                        KAbstractDesktop.toFront(w);
                    } else {
                        BBxt.newDocument(file);
                        return;
                    }
                }
                if (KAbstractHelp.this.selExtStr == null) {
                    return;
                }
                if (KAbstractHelp.this.selExtStr.startsWith("file://")) {
                    File temp;
                    String subpath = KAbstractHelp.this.selExtStr.substring(7, KAbstractHelp.this.selExtStr.length());
                    if (subpath.indexOf("#") != -1) {
                        subpath = subpath.substring(0, subpath.indexOf("#"));
                    }
                    if ((w = KAbstractDesktop.getWindowWithFile(temp = new File(subpath))) != null) {
                        KAbstractDesktop.toFront(w);
                    } else {
                        BBxt.newDocument(temp);
                        return;
                    }
                }
                if (KAbstractHelp.this.selExtStr.startsWith("http://") || KAbstractHelp.this.selExtStr.startsWith("www.")) {
                    if (KAbstractHelp.this.mouseEvent != null && KAbstractHelp.this.mouseEvent.isShiftDown()) {
                        String name;
                        String content = Url.getContentFromURL(KAbstractHelp.this.selExtStr);
                        int offset = KAbstractHelp.this.selExtStr.lastIndexOf(47);
                        String string = name = offset == -1 ? KAbstractHelp.this.selExtStr : KAbstractHelp.this.selExtStr.substring(offset + 1);
                        if (content != null) {
                            BBxt.newDocument("source.html", content);
                        }
                    } else if (KAbstractHelp.this.selExtStr.startsWith("www.")) {
                        BrowserUtils.open("http://" + KAbstractHelp.this.selExtStr);
                    } else {
                        BrowserUtils.open(KAbstractHelp.this.selExtStr);
                    }
                    return;
                }
            }
        };
        mi.addActionListener(openAction);
        mi.addMouseListener(new KSelectionExpander());
        String subpath = null;
        if (this.selExtStr != null && this.selExtStr.startsWith("file://") && this.selExtStr.length() > 7) {
            File temp;
            subpath = this.selExtStr.substring(7, this.selExtStr.length());
            if (subpath.indexOf("#") != -1) {
                subpath = subpath.substring(0, subpath.indexOf("#"));
            }
            if ((temp = new File(subpath)).exists() && !temp.isDirectory()) {
                mi.setEnabled(true);
                return mi;
            }
        }
        if (zipfilePath != null && zipEntry != null) {
            mi.setEnabled(true);
            return mi;
        }
        if (file == null || !file.exists() || file.isDirectory() || this.selExtStr == null) {
            mi.setEnabled(false);
            return mi;
        }
        mi.setEnabled(true);
        if (this.selExtStr != null && this.selExtStr.startsWith("http://") || this.selExtStr.startsWith("www.")) {
            mi.setEnabled(true);
        }
        return mi;
    }

    protected File convertSelectionToFile(String selExtStr) {
        boolean isRelative = selExtStr.startsWith(".");
        if (!isRelative) {
            File f1 = new File(selExtStr);
            if (f1.exists()) {
                if (f1.getParentFile() == null) {
                    return new File(FileUtils.getPWDFile(), f1.getPath());
                }
                return f1;
            }
            String copySelExtStr = TextUtils.replace(selExtStr.trim(), '#', "0001");
            f1 = new File(copySelExtStr);
            if (f1.exists()) {
                if (f1.getParentFile() == null) {
                    return new File(FileUtils.getPWDFile(), f1.getPath());
                }
                return f1;
            }
        }
        File hostFile = this.textpane.getFrameFile();
        File baseDir = FileUtils.getPWDFile();
        File f2 = !isRelative ? new File(baseDir, selExtStr) : FileUtils.resolveRelativePath(baseDir, selExtStr);
        if (f2.exists()) {
            return f2;
        }
        if (hostFile == null || !hostFile.exists()) {
            return null;
        }
        ScriptHandler handler = ScriptRegistry.getHandlerForFile(hostFile);
        File f4 = null;
        if (handler != null) {
            Class<?> cls = handler.getClass();
            if (cls == null) {
                return null;
            }
            String handlerName = cls.getName();
            File[] dirs = handler.getSystemHeadersDirs(hostFile);
            if (dirs != null || handlerName == null || handlerName.equals("UI_Script.H.HScriptHandler")) {
                // empty if block
            }
            if (dirs != null && dirs.length > 0) {
                for (int n = 0; n < dirs.length; ++n) {
                    File f3 = new File(dirs[n], selExtStr);
                    if (!f3.exists()) continue;
                    return f3;
                }
            }
            handler = ScriptRegistry.getHandlerForFile(hostFile);
            f4 = handler.convertSelectionToFile(selExtStr);
        }
        if (f4 != null && f4.exists()) {
            return f4;
        }
        for (hostFile = this.textpane.getFrameFile(); hostFile != null && hostFile.exists(); hostFile = hostFile.getParentFile()) {
            f4 = new File(hostFile, selExtStr);
            if (!f4.exists()) continue;
            return f4;
        }
        return null;
    }

    protected String doOrderedExpansion(int begin, int end) {
        if (this.selRawEnd != -1) {
            String s = this.textpane.getCharAt(this.selRawEnd);
            if (s == null) {
                return null;
            }
            if (s.equals(" ") || s.equals("\t") || s.equals("\n")) {
                return null;
            }
        }
        char[] spsp = new char[]{' ', ' '};
        char[] sptab = new char[]{' ', '\t'};
        char[] tabsp = new char[]{'\t', ' '};
        String sel = this.expandSelection(begin, end, spsp);
        if (sel == null || sel.trim().length() == 0) {
            sel = this.expandSelection(begin, end, sptab);
        }
        if (sel == null || sel.trim().length() == 0) {
            sel = this.expandSelection(begin, end, tabsp);
        }
        return this.expandSelection(begin, end, null);
    }

    private String expandSelection(int selDeltaBegin, int selDeltaEnd) {
        return this.expandSelection(selDeltaBegin, selDeltaEnd, null);
    }

    protected String expandSelection(int selDeltaBegin, int selDeltaEnd, char[] delims) {
        int[] offsets;
        if (this.selRawBegin != this.selRawEnd) {
            return this.selRawStr;
        }
        StringBuffer buf = new StringBuffer();
        if (delims == null) {
            offsets = FileUtils.getTextBoundedBy(this.lineOfText, selDeltaBegin, selDeltaEnd, '\'', '\'', buf);
            if (offsets == null) {
                buf.setLength(0);
                offsets = FileUtils.getTextBoundedBy(this.lineOfText, selDeltaBegin, selDeltaEnd, '\"', '\"', buf);
            }
            if (offsets == null) {
                buf.setLength(0);
                offsets = FileUtils.getTextBoundedBy(this.lineOfText, selDeltaBegin, selDeltaEnd, '<', '>', buf);
            }
            if (offsets == null) {
                buf.setLength(0);
                offsets = FileUtils.getTextBoundedBy(this.lineOfText, selDeltaBegin, selDeltaEnd, '[', ']', buf);
            }
            if (offsets == null) {
                buf.setLength(0);
                offsets = FileUtils.getTextBoundedBy(this.lineOfText, selDeltaBegin, selDeltaEnd, '{', '}', buf);
            }
            if (offsets == null) {
                buf.setLength(0);
                offsets = FileUtils.getTextBoundedBy(this.lineOfText, selDeltaBegin, selDeltaEnd, '(', ')', buf);
            }
            if (offsets == null) {
                buf.setLength(0);
                offsets = FileUtils.getTextBoundedBySpace(this.lineOfText, selDeltaBegin, selDeltaEnd, buf);
            }
        } else {
            offsets = FileUtils.getTextBoundedBy(this.lineOfText, selDeltaBegin, selDeltaEnd, delims[0], delims[1], buf);
        }
        if (offsets == null) {
            return null;
        }
        BBxt.setSelection(this.lineBegin + offsets[0], this.lineBegin + offsets[1]);
        int b = this.lineBegin + offsets[0];
        int e = this.lineBegin + offsets[1];
        String preTrimmedSelection = BBxt.getSelection();
        String illegalFileChars = "+-*&!~#$%^()=|:;'\"<>,?";
        String trimmed = TextUtils.trimLeadingChars(preTrimmedSelection, illegalFileChars);
        if (trimmed.length() < preTrimmedSelection.length()) {
            preTrimmedSelection = trimmed;
            this.selExtBegin = e - trimmed.length();
            this.selExtEnd = e;
            BBxt.setSelection(this.selExtBegin, this.selExtEnd);
            return BBxt.getSelection(e - trimmed.length(), e);
        }
        this.selExtBegin = this.lineBegin + offsets[0];
        this.selExtEnd = this.lineBegin + offsets[1];
        return buf.toString();
    }

    protected JMenu getDefaultEditMenu() {
        JMenu menu = new JMenu("Text Edits");
        menu.addMouseListener(new KSelectionExpander());
        KPopupMenuItem mi = new KPopupMenuItem("Cut");
        mi.addMouseListener(new KSelectionExpander());
        ActionListener cutAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.cut();
            }
        };
        mi.addActionListener(cutAction);
        if (BBxt.getSelection().trim().length() == 0) {
            mi.setEnabled(false);
        }
        menu.add(mi);
        mi = new KPopupMenuItem("Copy");
        mi.addMouseListener(new KSelectionExpander());
        ActionListener copyAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.copy();
            }
        };
        mi.addActionListener(copyAction);
        if (BBxt.getSelection().trim().length() == 0) {
            mi.setEnabled(false);
        }
        menu.add(mi);
        mi = new KPopupMenuItem("Paste");
        ActionListener pasteAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.paste();
            }
        };
        mi.addActionListener(pasteAction);
        menu.add(mi);
        mi = new KPopupMenuItem("Select All");
        ActionListener selectAllAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.selectAll();
            }
        };
        mi.addActionListener(selectAllAction);
        menu.add(mi);
        return menu;
    }

    protected JMenu getDefaultCmntMenu() {
        JMenu menu = new JMenu("Comments");
        KPopupMenuItem mi = new KPopupMenuItem("Add");
        mi.addActionListener(new AddCommentsAction());
        menu.add(mi);
        mi = new KPopupMenuItem("Remove");
        mi.addActionListener(new RemoveCommentsAction());
        if (BBxt.getSelection().trim().length() == 0) {
            mi.setEnabled(false);
        }
        menu.add(mi);
        return menu;
    }

    protected JMenu getDefaultCaseMenu() {
        JMenu menu = new JMenu("Case");
        menu.addMouseListener(new KSelectionExpander());
        KPopupMenuItem mi = new KPopupMenuItem("To Upper");
        mi.addMouseListener(new KSelectionExpander());
        mi.addActionListener(new ToUpperCaseAction());
        menu.add(mi);
        mi = new KPopupMenuItem("To Lower");
        mi.addMouseListener(new KSelectionExpander());
        mi.addActionListener(new ToLowerCaseAction());
        menu.add(mi);
        if (BBxt.getSelection().trim().length() == 0) {
            menu.setEnabled(false);
        }
        return menu;
    }

    protected JMenu getDefaultTextShiftMenu() {
        JMenu menu = new JMenu("Text Shift");
        menu.addMouseListener(new KSelectionExpander());
        KPopupMenuItem mi = new KPopupMenuItem("Right");
        mi.addMouseListener(new KSelectionExpander());
        mi.addActionListener(new TextShiftAction(2));
        menu.add(mi);
        mi = new KPopupMenuItem("Left");
        mi.addMouseListener(new KSelectionExpander());
        mi.addActionListener(new TextShiftAction(1));
        menu.add(mi);
        if (BBxt.getSelection().trim().length() == 0) {
            menu.setEnabled(false);
        }
        return menu;
    }

    protected KPopupMenuItem getDefaultEditRGBMenu() {
        KPopupMenuItem mi = new KPopupMenuItem("Edit Color...");
        mi.addActionListener(this.rgbEditAction);
        mi.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                int selDeltaBegin = KAbstractHelp.this.selRawBegin - KAbstractHelp.this.lineBegin;
                int selDeltaEnd = KAbstractHelp.this.selRawEnd - KAbstractHelp.this.lineBegin;
                String exp = KAbstractHelp.this.expandSelection(selDeltaBegin, selDeltaEnd);
                if (exp == null) {
                    Cutter.setLog("    Warning:KAbstractHelp.getDefaultEditRGBMenu() cannot find expanded selection.");
                    return;
                }
            }
        });
        mi.setEnabled(false);
        String str = BBxt.getSelection();
        if (str != null && str.trim().length() > 0) {
            String[] t = TextUtils.tokenize(str, " ,();");
            float r = -1.0f;
            float g = -1.0f;
            float b = -1.0f;
            if (t != null && t.length == 3) {
                try {
                    r = Float.parseFloat(t[0]);
                    g = Float.parseFloat(t[1]);
                    b = Float.parseFloat(t[2]);
                }
                catch (NumberFormatException e) {
                    return mi;
                }
                if (r < 0.0f || g < 0.0f || b < 0.0f || r > 1.0f || g > 1.0f || b > 1.0f) {
                    return mi;
                }
                mi.setEnabled(true);
            }
        }
        return mi;
    }

    protected KPopupMenuItem getDefaultExportAsHtml() {
        KPopupMenuItem mi = new KPopupMenuItem("Export As Html");
        String selection = BBxt.getSelection();
        if (selection == null || selection.length() <= 0) {
            mi.setEnabled(false);
            return mi;
        }
        mi.setEnabled(true);
        mi.addActionListener(new KAbstractDesktop.ExportHtmlAction());
        mi.addMouseListener(new KSelectionExpander(true));
        return mi;
    }

    protected KPopupMenuItem getDefaultLineNumbering() {
        KPopupMenuItem mi = new KPopupMenuItem("Show Line Numbers");
        mi.setEnabled(true);
        mi.addActionListener(new KAbstractDesktop.LineNumberingAction(mi));
        KAbstractWindow fw = BBxt.frontWindow();
        if (fw != null && fw instanceof KTextWindow && ((KTextWindow)fw).lineNumberingIsVisible()) {
            mi.setText("Hide Line Numbers");
        }
        return mi;
    }

    private KPopupMenuItem getDefaultLineMargin() {
        KPopupMenuItem mi = new KPopupMenuItem("Show Right Margin");
        mi.setEnabled(true);
        mi.addActionListener(new KAbstractDesktop.LineMarginAction(mi));
        KAbstractWindow fw = BBxt.frontWindow();
        if (fw != null && fw instanceof KTextWindow && ((KTextWindow)fw).lineMarginIsVisible()) {
            mi.setText("Hide Right Margin");
        }
        return mi;
    }

    protected KPopupMenuItem getDefaultTypingCompletion() {
        final boolean isActive = this.completer.completionIsActive();
        String label = isActive ? "Deactivate Completion" : "Activate Completion";
        KPopupMenuItem mi = new KPopupMenuItem(label);
        mi.setEnabled(true);
        mi.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (isActive) {
                    KAbstractHelp.this.completer.completionDeActivate();
                } else {
                    KAbstractHelp.this.completer.completionActivate();
                }
            }
        });
        return mi;
    }

    private KPopupMenuItem getDefaultBreakLines() {
        String str = Preferences.get(Preferences.DOCUMENT_RIGHT_MARGIN_WIDTH);
        int width = NumberUtils.strToInt(str, 100);
        KPopupMenuItem mi = new KPopupMenuItem("Reformat to " + width + " Chars");
        mi.setEnabled(false);
        String sel = "";
        if (this.selRawStr.equals("")) {
            int selDeltaBegin;
            int selDeltaEnd = selDeltaBegin = this.selRawBegin - this.lineBegin;
            sel = this.doOrderedExpansion(selDeltaBegin, selDeltaEnd);
        } else {
            sel = this.initialSelection;
        }
        if (sel == null || sel.trim().length() == 0) {
            return mi;
        }
        mi.setEnabled(true);
        mi.addActionListener(new KAbstractDesktop.BraakLinesAction(mi));
        KAbstractWindow fw = BBxt.frontWindow();
        return mi;
    }

    protected KPopupMenuItem getDefaultExecute() {
        String selection = BBxt.getSelection();
        if (selection == null) {
            return null;
        }
        KPopupMenuItem mi = new KPopupMenuItem("temp label");
        File file = this.textpane.getFrameFile();
        if (file != null && file.exists()) {
            this.handler = ScriptRegistry.getHandlerForFile(file);
            if (this.handler != null) {
                mi.setText(this.handler.getExecuteLabel());
            }
        }
        if (selection.length() >= 2) {
            mi.setText("Execute Selection");
        }
        mi.addMouseListener(new KSelectionExpander());
        mi.setEnabled(true);
        ActionListener executeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (BBxt.isRibDocument()) {
                    int begin = BBxt.getSelectionStart();
                    int end = BBxt.getSelectionEnd();
                    if (begin != -1 && end != -1) {
                        BBxt.setSelection(begin, begin);
                    }
                }
                BBxt.execute();
            }
        };
        mi.addActionListener(executeAction);
        return mi;
    }

    protected JMenu getDefaultFileBrowseMenu() {
        File dir;
        JMenu pathOptionsMenu = new JMenu("File Paths");
        pathOptionsMenu.addMouseListener(new KSelectionExpander());
        JMenu checkPathOption = new JMenu("Verify");
        checkPathOption.addMouseListener(new KSelectionExpander());
        boolean found = new File(BBxt.getSelection().trim()).exists();
        String itemStr = found ? "Path OK" : "Path not found";
        String tipText = TextUtils.format("Cutter has checked the existance of selected file or directory", MultiLineToolTip.DEFAULT_TIP_TEXT_WIDTH);
        KPopupMenuItem mi = new KPopupMenuItem(itemStr, tipText);
        mi.addMouseListener(new KSelectionExpander());
        if (BBxt.getSelection().trim().length() == 0) {
            checkPathOption.setEnabled(false);
        }
        checkPathOption.add(mi);
        if (BBxt.getSelection().trim().length() == 0) {
            if (this.lastFindDir != null) {
                dir = this.lastFindDir;
                dir = FileUtils.getExistingParent(dir);
            } else {
                dir = Cutter.getParentDir();
            }
        } else {
            String selection = BBxt.getSelection().trim();
            dir = FileUtils.getExistingParent(new File(selection));
        }
        final File f = dir;
        JMenu browseMenu = new JMenu("Browse");
        browseMenu.addMouseListener(new KSelectionExpander());
        mi = new KPopupMenuItem("Find Directory...");
        mi.addMouseListener(new KSelectionExpander());
        ActionListener dirAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenFileDialog dialog = OpenFileDialog.getInstance(Cutter.desktop);
                File prevF = dialog.getPrevFile();
                dialog.setCurrentDirectory(f);
                dialog.rescanCurrentDirectory(true);
                File[] files = dialog.showSelf(null, "Choose Directory", 1);
                dialog.setPrevFile(prevF);
                if (files != null && files.length != 0) {
                    KAbstractHelp.this.lastFindDir = files[0];
                    BBxt.paste(files[0].getPath().replace('\\', '/'));
                }
            }
        };
        mi.addActionListener(dirAction);
        browseMenu.add(mi);
        mi = new KPopupMenuItem("Find File...");
        mi.addMouseListener(new KSelectionExpander());
        ActionListener fileAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenFileDialog dialog = OpenFileDialog.getInstance(Cutter.desktop);
                File prevF = dialog.getPrevFile();
                dialog.setCurrentDirectory(f);
                dialog.rescanCurrentDirectory(true);
                File[] files = dialog.showSelf(null, "Choose File", 2);
                dialog.setPrevFile(prevF);
                if (files != null && files.length != 0) {
                    KAbstractHelp.this.lastFindDir = files[0].getParentFile();
                    BBxt.paste(files[0].getPath().replace('\\', '/'));
                }
            }
        };
        mi.addActionListener(fileAction);
        browseMenu.add(mi);
        pathOptionsMenu.add(checkPathOption);
        pathOptionsMenu.add(browseMenu);
        return pathOptionsMenu;
    }

    public static String getDocsIndexURL() {
        return null;
    }

    public static boolean docsIndexURLIsValid() {
        return false;
    }

    public static boolean docsIndexURLIsValid(String str) {
        try {
            if (FileUtils.exists(new URL(str).getPath())) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            Cutter.setLog("    Exception:KAbstractHelp.docsIndexURLIsValid()\n          " + e.toString());
        }
        return false;
    }

    public abstract boolean showDocFor(String var1, MouseEvent var2);

    protected abstract void lookup(String var1);

    @Override
    public void renderInfoChanged(RenderInfo info) {
    }

    protected boolean launchBrowser(final String item) {
        if (item == null) {
            return false;
        }
        Cutter.setLog("    Debug:KAbstractHelp.launchBrowser() item >" + item + "<");
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KAbstractHelp.this.lookup(item);
                }
            });
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:KAbstractHelp.launchBrowser() - " + e.toString());
            return false;
        }
        return true;
    }

    protected boolean setHelpPage(String urlStr) {
        return this.setHelpPage(urlStr, true);
    }

    protected boolean setHelpPage(String urlStr, boolean showWarningMessage) {
        if (urlStr == null) {
            return false;
        }
        if (Cutter.htmlWindow == null) {
            Cutter.setLog("    Error: KAbstractHelp.setHelpPage() Cutter.htmlWindow == null");
            this.textpane.setCursor(Cursor.getPredefinedCursor(2));
            return false;
        }
        TextUtils.replace(urlStr, ' ', "%20");
        if (!this.useCutterBrowser) {
            BrowserUtils.open(urlStr, true);
            return true;
        }
        try {
            Cutter.htmlWindow.setPage(urlStr, null);
        }
        catch (Exception ex) {
            showWarningMessage = false;
            if (showWarningMessage) {
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "Cutter is unable to locate a document at:\n\n" + urlStr + "\n\n", "Missing Documentation", 2);
            }
            Cutter.setLog("    Exception:KAbstractHelp.setHelpPage() - " + ex.toString());
            return false;
        }
        Cutter.htmlWindow.setVisible(true);
        return true;
    }

    protected boolean setHelpPageContent(String content) {
        if (Cutter.htmlWindow == null) {
            Cutter.setLog("    Error: KAbstractHelp.setHelpPage() has been given a null url");
            return false;
        }
        try {
            Cutter.htmlWindow.setContent(content);
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:KAbstractHelp.setHelpPageContent()\n        " + ex.toString());
            return false;
        }
        Cutter.htmlWindow.setVisible(true);
        return true;
    }

    public static String configurePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if ((path = path.replace('\\', '/')).startsWith(".")) {
            File f = FileUtils.resolveRelativePath(FileUtils.getPWDFile(), path);
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:KAbstractHelp.configurePath() - path resolved to >" + f.getPath() + "<");
            }
            path = f.getPath();
        }
        boolean fileProtocol = false;
        boolean httpProtocol = false;
        Tokenizer tok = new Tokenizer();
        tok.setBuffer(path);
        if (tok.charSearch("file:", true) != null) {
            fileProtocol = true;
        }
        tok.rewindBuffer();
        if (tok.charSearch("http", true) != null) {
            httpProtocol = true;
        }
        if (fileProtocol || httpProtocol) {
            String originalPath = path;
            path = path.substring(5, path.length());
            while (path.charAt(0) == '/') {
                int lngth = path.length();
                path = path.substring(1, lngth);
            }
            path = fileProtocol ? "file:/" + path : originalPath;
        } else {
            while (path.charAt(0) == '/') {
                int lngth = path.length();
                path = path.substring(1, lngth);
            }
            path = "file:/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static boolean extractHelpFiles() {
        if (!KAbstractHelp.helpDocsInJar()) {
            if (Cutter.input.debug) {
                System.out.println("Help Files absent from cutter.jar");
            } else {
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "Cutter has been unable to locate the help docs\nthat are part of the cutter.jar file. Cutter must\nbe launched from the directory in which its jar\nfile is located. If you are using a batch file to\nlaunch Cutter it must be located in the same\ndirectory as the cutter.jar file.\n\n", "Cannot Find Help Docs", 0);
            }
            return false;
        }
        File helpDocDir = new File(FileUtils.getPWD(), HELP_DOCS_DIRECTORY);
        File versionFolder = new File(helpDocDir, Cutter.version);
        if (versionFolder.exists() && !EnvUtils.isLinuxEnvironment()) {
            return false;
        }
        FileUtils.deleteAll(helpDocDir);
        File zipfile = new File(EnvUtils.getCutterAppDir(), "cutter.jar");
        try {
            JarFile jarfile = new JarFile(zipfile);
            installDialog = new InstallHelpDocsDialog(350);
            installDialog.initBar(jarfile.size());
            installDialog.showSelf();
            int count = 0;
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipentry = e.nextElement();
                if (zipentry == null) continue;
                InputStream in = jarfile.getInputStream(zipentry);
                String tail = zipentry.getName();
                String head = FileUtils.getPWD();
                if (tail.regionMatches(0, HELP_DOCS_DIRECTORY, 0, HELP_DOCS_DIRECTORY.length())) {
                    if (!FileUtils.saveInputStreamToFile(in, zipentry, new File(head), new File(tail))) {
                        Cutter.setLog("    Error:KAbstractHelp.extractHelpFiles() " + tail + " zipentry.getSize() = " + zipentry.getSize());
                        in.close();
                        return false;
                    }
                    if (count % 15 == 0) {
                        KAbstractHelp.installDialog.tf.setText(tail);
                        try {
                            Thread.currentThread();
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ee) {
                            ee.printStackTrace();
                        }
                    }
                }
                in.close();
                installDialog.incrValue();
                ++count;
            }
            installDialog.setVisible(false);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: KAbstractHelp.extractHelpFiles()\n" + e.toString());
        }
        versionFolder.mkdir();
        return true;
    }

    private static boolean helpDocsInJar() {
        try {
            ZipEntry zipentry;
            File cutterFile = new File(EnvUtils.getCutterAppDir(), "cutter.jar");
            FileInputStream stream = new FileInputStream(cutterFile);
            ZipInputStream in = new ZipInputStream(stream);
            while ((zipentry = in.getNextEntry()) != null) {
                String name = zipentry.getName();
                if (name.regionMatches(0, HELP_DOCS_DIRECTORY, 0, HELP_DOCS_DIRECTORY.length())) {
                    return true;
                }
                in.closeEntry();
            }
            in.close();
            stream.close();
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:KAbstractHelp.helpDocsInJar()");
            Cutter.setLog("           " + e.toString());
            return false;
        }
        return false;
    }

    static {
        try {
            Field[] fields = new Field[]{KAbstractHelp.class.getDeclaredField("_finalize")};
            Cutter.addDebug(KAbstractHelp.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("    Error:KAbstractHelp.static - " + ex.toString());
        }
        installDialog = null;
        freelist = new Vector();
        doDeleted = false;
    }

    public class KPopupMenu
    extends JPopupMenu
    implements PopupMenuListener {
        private int originalToolTipDelay = -1;

        public KPopupMenu() {
            this.addPopupMenuListener(this);
        }

        @Override
        public JMenuItem add(JMenuItem menuItem) {
            if (menuItem instanceof KPopupMenuItem) {
                int textWidth = ((KPopupMenuItem)menuItem).entireFlagsTextWidth;
                KAbstractHelp.this.maxTextWidth = textWidth > KAbstractHelp.this.maxTextWidth ? textWidth : KAbstractHelp.this.maxTextWidth;
            }
            super.add(menuItem);
            return menuItem;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            KAbstractHelp.this.textpane.hideCaret();
            KAbstractHelp.this.textpane.isSelectable(false);
            if (e.getSource() instanceof KPopupMenu) {
                ((KPopupMenu)e.getSource()).grabFocus();
            }
            this.originalToolTipDelay = ToolTipManager.sharedInstance().getInitialDelay();
            ToolTipManager.sharedInstance().setDismissDelay(15000);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            KAbstractHelp.this.textpane.setCursor(Cursor.getPredefinedCursor(2));
            KAbstractHelp.this.textpane.isSelectable(true);
            KAbstractHelp.this.textpane.showCaret();
            ToolTipManager.sharedInstance().setDismissDelay(this.originalToolTipDelay);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            KAbstractHelp.this.textpane.setCursor(Cursor.getPredefinedCursor(2));
            KAbstractHelp.this.textpane.isSelectable(true);
            KAbstractHelp.this.textpane.showCaret();
        }

        @Override
        public void show(Component invoker, int x, int y) {
            try {
                super.show(invoker, x + 5, y);
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:KAbstractHelp.show() x = " + (x + 5) + " y = " + y + "\n          " + ex.toString());
            }
            MenuElement[] element = this.getSubElements();
            for (int n = 0; n < element.length; ++n) {
                JMenuItem item = (JMenuItem)element[n];
                Graphics g = item.getGraphics();
                item.paint(g);
            }
        }
    }

    public class KPopupMenuItem
    extends JMenuItem {
        private String shortFlag;
        private String longFlag;
        public int shortFlagTextWidth;
        public int entireFlagsTextWidth;
        private MultiLineToolTip tip;
        private Dimension toolTipDimension;
        private int tooltipwidth;
        public Point mouseReleaseAt;

        public KPopupMenuItem(String title) {
            super(title);
            this.tip = null;
            this.toolTipDimension = null;
            this.tooltipwidth = -1;
            this.mouseReleaseAt = null;
        }

        public KPopupMenuItem(String title, String tipText) {
            super(title);
            this.tip = null;
            this.toolTipDimension = null;
            this.tooltipwidth = -1;
            this.mouseReleaseAt = null;
            this.tip = new MultiLineToolTip(tipText);
            this.setToolTipText(tipText);
            this.tooltipwidth = this.tip.getWidth();
        }

        public KPopupMenuItem(String shortFlag, String longFlag, String tipText, int insertAt) {
            this.tip = null;
            this.toolTipDimension = null;
            this.tooltipwidth = -1;
            this.mouseReleaseAt = null;
            String title = "-" + shortFlag + "/" + longFlag;
            this.shortFlag = shortFlag;
            this.longFlag = longFlag;
            this.setText(title);
            this.tip = new MultiLineToolTip(tipText);
            this.setToolTipText(tipText);
            this.tooltipwidth = this.tip.getWidth();
            this.initAction(insertAt);
        }

        private void initTextWidths() {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.shortFlagTextWidth = SwingUtilities.computeStringWidth(metrics, "-" + this.shortFlag);
            this.entireFlagsTextWidth = SwingUtilities.computeStringWidth(metrics, this.getActionCommand());
        }

        private void initAction(final int insertAt) {
            this.setHorizontalTextPosition(2);
            this.initTextWidths();
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KAbstractHelp.this.textpane.setSelectionStart(insertAt);
                    KAbstractHelp.this.textpane.setSelectionEnd(insertAt);
                    if (KPopupMenuItem.this.mouseReleaseAt == null) {
                        return;
                    }
                    int margin = (KPopupMenuItem.this.getWidth() - KAbstractHelp.this.maxTextWidth) / 2;
                    String text = "";
                    text = KPopupMenuItem.this.mouseReleaseAt.x <= (margin += KPopupMenuItem.this.shortFlagTextWidth) ? "-" + KPopupMenuItem.this.shortFlag : "-" + KPopupMenuItem.this.longFlag;
                    try {
                        KAbstractHelp.this.textpane.getDocument().insertString(insertAt, " " + text, null);
                    }
                    catch (BadLocationException ex) {
                        Cutter.setLog("    Exception: KPopupMenuItem.actionPerformed()" + ex);
                    }
                }
            });
        }

        private void initUI(String title) {
            this.setLayout(new GridBagLayout());
            GBC gbc = new GBC(0, 0, 1, 1, 1.0, 1.0, 1, 1, 17, 1, new Insets(5, 5, 5, 5));
            JLabel label = new JLabel("-" + title, 2);
            label.setFont((Font)UIManager.get("MenuItem.font"));
            this.getRootPane().add((Component)label, gbc);
        }

        public void applyItalic() {
            Font f = this.getFont();
            Font font = new Font(f.getName(), f.getStyle() | 2, f.getSize());
            this.setFont(font);
        }

        @Override
        public JToolTip createToolTip() {
            return this.tip;
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            int ourwidth = this.getBounds().width;
            int tipwidth = this.tip.get_Width();
            int x = tipwidth - ourwidth;
            int offset = ourwidth + x;
            return new Point(-offset + 5, 8);
        }

        @Override
        public void processKeyEvent(KeyEvent e, MenuElement[] path, MenuSelectionManager manager) {
            if (e.getKeyCode() == 10) {
                this.mouseReleaseAt = new Point(0, 0);
            }
            super.processKeyEvent(e, path, manager);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (TextUtils.search(false, e.paramString(), "MOUSE_RELEASED")) {
                this.mouseReleaseAt = new Point(e.getX(), e.getY());
            }
            super.processMouseEvent(e);
        }
    }

    protected class KSelectionExpander
    extends MouseAdapter {
        private int initialStartIndex = -1;
        private boolean fullSelection = false;

        public KSelectionExpander() {
        }

        public KSelectionExpander(boolean f) {
            this.fullSelection = f;
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            this.initialStartIndex = BBxt.getSelectionStart();
            if (!this.fullSelection && KAbstractHelp.this.selExtBegin != -1 && KAbstractHelp.this.selExtEnd != -1) {
                BBxt.setSelection(KAbstractHelp.this.selExtBegin, KAbstractHelp.this.selExtEnd);
            }
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            if (this.fullSelection && KAbstractHelp.this.selRawEnd != -1) {
                BBxt.setSelection(this.initialStartIndex, KAbstractHelp.this.selRawEnd);
            } else if (KAbstractHelp.this.selRawBegin != -1 && KAbstractHelp.this.selRawEnd != -1) {
                BBxt.setSelection(KAbstractHelp.this.selRawBegin, KAbstractHelp.this.selRawEnd);
            }
        }
    }
}

