/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Help;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Comment;
import UI_Script.Help.KAbstractHelp;
import UI_Text.KTextPane.KTextPane;
import Utilities.DocumentUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.text.Segment;

public class KCompletionManager
implements MouseListener,
CaretListener {
    public static boolean globalIsActive = true;
    public static int MIN_LEN = 3;
    private static Color itemBackground = Color.white;
    private static Color itemForeground = Color.darkGray;
    private KTextPane textpane = null;
    KAbstractHelp helper = null;
    private boolean isActive = false;
    private boolean generalPopupIsActive = false;
    private boolean doubleClickIsActive = false;
    private char[] wordStartDelims = new char[]{'\n', '\t', ' '};
    private KPopupMenu popup = null;
    private Vector<KMenuItem> menuItems = new Vector();
    private int MAX_NUM_POPUP_ITEMS = 40;
    private String firstWordOnTargetLine = "";

    public KCompletionManager(KTextPane tp, KAbstractHelp helper) {
        this.textpane = tp;
        this.helper = helper;
        this.popup = new KPopupMenu();
        this.popup.setFocusable(false);
    }

    public void setListeners(KTextPane textpane, KAbstractHelp helper) {
        EventListener item;
        int n;
        this.textpane = textpane;
        this.helper = helper;
        MouseListener[] mice = textpane.getMouseListeners();
        CaretListener[] cars = textpane.getCaretListeners();
        Vector<MouseListener> miceList = new Vector<MouseListener>();
        Vector<MouseListener> carsList = new Vector<MouseListener>();
        for (n = 0; n < mice.length; ++n) {
            item = mice[n];
            if (!(item instanceof KCompletionManager)) continue;
            miceList.add((MouseListener)item);
        }
        for (n = 0; n < miceList.size(); ++n) {
            textpane.removeMouseListener((MouseListener)miceList.elementAt(n));
        }
        textpane.addMouseListener(this);
        for (n = 0; n < cars.length; ++n) {
            item = cars[n];
            if (!(item instanceof KCompletionManager)) continue;
            carsList.add((MouseListener)item);
        }
        for (n = 0; n < miceList.size(); ++n) {
            textpane.removeCaretListener((CaretListener)carsList.elementAt(n));
        }
        textpane.addCaretListener(this);
        this.isActive = true;
    }

    public void completionActivate() {
        String str = Preferences.get(Preferences.DOCUMENT_TYPINGCOMPLETION_ACTIVE);
        if (str.equals("false")) {
            this.isActive = true;
            return;
        }
        this.isActive = true;
    }

    public boolean completionIsActive() {
        return this.isActive;
    }

    public void completionDeActivate() {
        this.isActive = false;
    }

    public void setWordStartDelims(char[] d) {
        this.wordStartDelims = d;
    }

    public void hidePopup() {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        }
    }

    private boolean targetLineIsAComment(int offset) {
        Segment segment = DocumentUtils.getSegment(this.textpane.getDocument(), offset);
        if (segment == null) {
            return false;
        }
        Comment[] cmnts = this.textpane.getComments();
        if (cmnts == null || cmnts.length < 1) {
            return false;
        }
        for (int n = 0; n < cmnts.length; ++n) {
            Comment cmnt = cmnts[n];
            if (!cmnt.isOpenComment(segment.toString())) continue;
            return true;
        }
        return false;
    }

    public String getFirstWordOnTargetLine() {
        return this.firstWordOnTargetLine;
    }

    private void showPopup(Point pnt) {
        if (!this.isActive) {
            return;
        }
        if (!globalIsActive) {
            return;
        }
        if (this.doubleClickIsActive) {
            return;
        }
        if (BBxt.getSelectionStart() == 0 && BBxt.getSelectionEnd() == 0) {
            return;
        }
        int offset = this.textpane.viewToModel(pnt);
        this.showPopup(offset);
    }

    private void showPopup(int offset) {
        String[] strs;
        String s2;
        String styleName;
        if (!this.isActive) {
            return;
        }
        if (!globalIsActive) {
            return;
        }
        if (this.doubleClickIsActive) {
            return;
        }
        String sel = BBxt.getSelection();
        if (sel != null && sel.length() > 2 && sel.contains("\n")) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            return;
        }
        if (this.targetLineIsAComment(offset)) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            return;
        }
        if (this.textpane.syntaxColorationIsActive() && (styleName = this.textpane.getStyleNameAtOffset(offset)) != null && styleName.equals("c1mnt")) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            return;
        }
        try {
            boolean isSpace;
            s2 = this.textpane.getDocument().getText(offset, 1);
            boolean bl = isSpace = s2.equals(" ") || s2.equals("\n") || s2.equals("\t");
            if (s2 != null && !isSpace) {
                if (this.popup.isVisible()) {
                    this.popup.setVisible(false);
                }
                return;
            }
        }
        catch (Exception s2) {
            // empty catch block
        }
        if (this.textpane.getDocument().getLength() > 2) {
            try {
                s2 = this.textpane.getDocument().getText(offset - 1, 1);
                if (s2 != null && s2.equals(".")) {
                    String[] strs2 = this.textpane.getWordAt(offset - 1, this.wordStartDelims);
                    if (!this.helper.completionDotIsValid(strs2[1])) {
                        if (this.popup.isVisible()) {
                            this.popup.setVisible(false);
                        }
                        return;
                    }
                    String[] candidates = this.helper.completionDotCandidates(strs2[1]);
                    this.addAndShowPopup(offset, candidates, true);
                    return;
                }
            }
            catch (Exception expq) {
                Cutter.setLog("    Exception:KCompletionManager.showPopup() - " + expq.toString());
            }
        }
        String string = this.firstWordOnTargetLine = (strs = this.textpane.getWordAt(offset, this.wordStartDelims)) == null || strs[0] == null ? "" : strs[0];
        if (strs == null || strs[1] == null) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            return;
        }
        if (!this.helper.completionTargetIsValid(strs[1])) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            return;
        }
        String[] candidates = this.helper.completionCandidates(strs[1]);
        if (candidates == null || candidates.length == 0) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            return;
        }
        if (candidates.length == 1 && candidates[0].equals(strs[1])) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            return;
        }
        this.addAndShowPopup(offset, candidates, true);
    }

    private void addAndShowPopup(int offset, String[] candidates, boolean setActionable) {
        Rectangle r = null;
        try {
            r = this.textpane.modelToView(offset);
        }
        catch (Exception ex) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            return;
        }
        if (candidates == null) {
            return;
        }
        candidates = TextUtils.sortByAlpha(candidates);
        this.popup.removeAll();
        this.menuItems.removeAllElements();
        int num = candidates.length > this.MAX_NUM_POPUP_ITEMS ? this.MAX_NUM_POPUP_ITEMS : candidates.length;
        for (int n = 0; n < num; ++n) {
            KMenuItem mi = new KMenuItem(candidates[n]);
            mi.setFocusable(true);
            if (setActionable) {
                mi.addActionListener(this.getAction(candidates[n]));
            }
            this.popup.add(mi);
            this.menuItems.add(mi);
        }
        if (candidates.length > this.MAX_NUM_POPUP_ITEMS) {
            KMenuItem mi = new KMenuItem("Remaining " + (candidates.length - this.MAX_NUM_POPUP_ITEMS) + " items not shown.");
            mi.setFocusable(false);
            this.popup.add(mi);
            this.menuItems.add(mi);
        }
        this.popup.pack();
        this.menuItems.elementAt(0).setArmed(true);
        if (this.textpane != null && r != null) {
            this.popup.show(this.textpane, r.x, r.y);
        }
    }

    private AbstractAction getAction(final String str) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KCompletionManager.this.popup.setVisible(false);
                KCompletionManager.this.isActive = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KCompletionManager.this.textpane.selectWord();
                        KCompletionManager.this.textpane.replaceSelection(str);
                        KCompletionManager.this.isActive = true;
                        KCompletionManager.this.helper.completionHappenedAt(str, KCompletionManager.this.textpane.getCaretPosition());
                    }
                });
            }
        };
        return action;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.isActive) {
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isActive) {
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isActive) {
            return;
        }
        if (e.getClickCount() > 1) {
            this.popup.setVisible(false);
            this.doubleClickIsActive = true;
            return;
        }
        this.doubleClickIsActive = false;
        if (SwingUtilities.isRightMouseButton(e) || e.isControlDown()) {
            this.generalPopupIsActive = true;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isActive) {
            return;
        }
        if (e.getClickCount() > 1) {
            this.popup.setVisible(false);
            this.doubleClickIsActive = true;
            return;
        }
        this.doubleClickIsActive = false;
        if (SwingUtilities.isRightMouseButton(e) || e.isControlDown()) {
            this.generalPopupIsActive = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isActive) {
            return;
        }
        if (e.getClickCount() > 1) {
            this.popup.setVisible(false);
            this.doubleClickIsActive = true;
            return;
        }
        this.doubleClickIsActive = false;
        if (SwingUtilities.isRightMouseButton(e) || e.isControlDown()) {
            this.generalPopupIsActive = true;
            return;
        }
        this.generalPopupIsActive = false;
        this.showPopup(e.getPoint());
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (e == null) {
            return;
        }
        if (e.getDot() == 0) {
            return;
        }
        if (!this.isActive) {
            return;
        }
        if (this.generalPopupIsActive) {
            return;
        }
        if (this.doubleClickIsActive) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            return;
        }
        this.showPopup(e.getDot());
    }

    public boolean canHandle(KeyEvent e) {
        if (!this.popup.isVisible()) {
            return false;
        }
        int keyCode = e.getKeyCode();
        if (e.getID() == 402 && keyCode == 27) {
            this.popup.setVisible(false);
            return false;
        }
        if (e.getID() == 402 && (keyCode == 38 || keyCode == 40 || keyCode == 9)) {
            int armedIndex = 0;
            for (int n = 0; n < this.menuItems.size(); ++n) {
                if (!this.menuItems.elementAt(n).isArmed()) continue;
                armedIndex = n;
            }
            this.menuItems.elementAt(armedIndex).setArmed(false);
            if (keyCode == 40) {
                armedIndex = armedIndex > this.menuItems.size() - 2 ? 0 : armedIndex + 1;
            } else if (keyCode == 38) {
                armedIndex = armedIndex > 0 ? armedIndex - 1 : this.menuItems.size() - 1;
            }
            this.menuItems.elementAt(armedIndex).setArmed(true);
            if (keyCode == 9) {
                this.menuItems.elementAt(armedIndex).doClick();
                this.popup.setVisible(false);
            }
            return true;
        }
        return keyCode == 38 || keyCode == 40 || keyCode == 9;
    }

    private class KPopupMenu
    extends JPopupMenu {
        public JMenuItem add(KMenuItem menuItem) {
            menuItem.setBackground(itemBackground);
            menuItem.setForeground(itemForeground);
            Font f = menuItem.getFont();
            Font F = new Font(f.getName(), 0, f.getSize());
            menuItem.setFont(F);
            super.add(menuItem);
            return menuItem;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            Font f = KCompletionManager.this.textpane.getFont();
            int ht = f.getSize();
            int delta = ht / 4;
            try {
                super.show(invoker, x + 5, y + ht + delta);
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:KTypingCompletion.show() x = " + (x + 5) + " y = " + y + "\n          " + ex.toString());
            }
            MenuElement[] element = this.getSubElements();
            for (int n = 0; n < element.length; ++n) {
                KMenuItem item = (KMenuItem)element[n];
                Graphics g = item.getGraphics();
                item.paint(g);
            }
        }
    }

    private class KMenuItem
    extends JMenuItem {
        public KMenuItem(String text) {
            super(text);
            this.setUI(new KMenuItemUI());
        }
    }

    private class KMenuItemUI
    extends BasicMenuItemUI {
        public KMenuItemUI() {
            this.selectionForeground = Color.black;
        }

        @Override
        protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
            ButtonModel model = menuItem.getModel();
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                bgColor = new Color(210, 210, 210);
            }
            super.paintBackground(g, menuItem, bgColor);
        }

        @Override
        protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
            ButtonModel model = menuItem.getModel();
            Font oldfont = g.getFont();
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                Font f = new Font(oldfont.getName(), 1, oldfont.getSize());
                g.setFont(f);
            }
            super.paintText(g, menuItem, textRect, text);
            g.setFont(oldfont);
        }
    }
}

