/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Help;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.BrowserUtils;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.GraphicsFileUtils;
import Utilities.RibInZipUtils;
import Utilities.TextUtils;
import java.io.File;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public class OpenSelectionHandler {
    private static KTextPane textpane = null;
    private static int selRawBegin = -1;
    private static int selRawEnd = -1;
    private static String selRawStr = null;
    private static int selExtBegin = -1;
    private static int selExtEnd = -1;
    private static String selExtStr = null;
    private static String lineOfText = null;
    private static int lineBegin = -1;
    private static String initialSelection;
    private static String zipfilePath;
    private static String zipEntry;
    private static File file;
    private static boolean validData;
    final String ribInZipPath = zipfilePath;
    final String ribInZipEntry = zipEntry;

    public OpenSelectionHandler() throws Exception {
        KCaret karet = BBxt.getKCaret();
        JEditorPane pane = BBxt.getTextPane();
        if (!(pane instanceof KTextPane)) {
            throw new Exception("Front window does not use a KTextPane");
        }
        textpane = (KTextPane)pane;
        int begin = karet.getMark() < karet.getDot() ? karet.getMark() : karet.getDot();
        int end = begin == karet.getMark() ? karet.getDot() : karet.getMark();
        try {
            initialSelection = textpane.getDocument().getText(begin, end - begin);
            if (initialSelection == null || initialSelection.trim().length() == 0) {
                throw new Exception("OpenSelectionHandler - no selection");
            }
            selExtStr = initialSelection;
            validData = this.initSelectionData(selExtStr, begin, end);
        }
        catch (BadLocationException ex) {
            throw new Exception("OpenSelectionHandler - can't get valid offsets");
        }
        if (!validData) {
            throw new Exception("OpenSelectionHandler - can't get valid offsets");
        }
        this.setFile();
        if (file == null) {
            throw new Exception("OpenSelectionHandler - can't get file for selection");
        }
    }

    private boolean setFile() {
        String[] paths;
        file = this.convertSelectionToFile(selExtStr);
        if (file != null) {
            return true;
        }
        if (file == null && (paths = RibInZipUtils.ribInZipPath(selExtStr)) != null) {
            zipfilePath = paths[0];
            zipEntry = paths[1];
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:OpenSelectionAction.handleSelection() - zipfilePath \"" + zipfilePath);
                Cutter.setLog("    Debug:OpenSelectionAction.handleSelection() - zipEntry \"" + zipEntry);
            }
            return true;
        }
        return true;
    }

    private boolean initSelectionData(String initialSelection, int begin, int end) {
        selRawBegin = -1;
        selRawEnd = -1;
        selRawStr = initialSelection;
        OpenSelectionHandler.initialSelection = initialSelection;
        lineBegin = -1;
        lineOfText = null;
        selExtBegin = -1;
        selExtEnd = -1;
        selExtStr = null;
        if (textpane == null || textpane.getDocument() == null) {
            Cutter.setLog("    Error:OpenSelectionAction.initSelectionData() - either textpane or its document is null");
            return false;
        }
        selRawStr = initialSelection;
        selRawBegin = begin;
        selRawEnd = end;
        if (selRawBegin == -1 || selRawEnd == -1 || selRawStr == null) {
            Cutter.setLog("    Error:OpenSelectionAction.initSelectionData() - cannot get selection offsets from the textpane.");
            return false;
        }
        Element element = DocumentUtils.getParagraphElement(textpane.getDocument(), selRawBegin);
        if (element != null) {
            Segment s = DocumentUtils.getSegment(textpane.getDocument(), element);
            lineOfText = s.toString();
            lineOfText = lineOfText.endsWith("\n") ? lineOfText.substring(0, lineOfText.length() - 1) : lineOfText;
            lineBegin = element.getStartOffset();
        }
        selExtBegin = selRawBegin;
        selExtEnd = selRawEnd;
        selExtStr = selRawStr;
        return true;
    }

    public void openSelection() {
        KAbstractWindow w;
        File zipfile;
        File binaryRibfile;
        if (zipfilePath != null && this.ribInZipEntry != null && (binaryRibfile = RibInZipUtils.unZipPixarRibInZip(zipfile = this.convertSelectionToFile(zipfilePath), this.ribInZipEntry)) != null && binaryRibfile.exists()) {
            RibInZipUtils ribInZip = new RibInZipUtils();
            ribInZip.pixarBinRibToAsciiRib(binaryRibfile, true);
            return;
        }
        if (file != null && file.exists()) {
            File hostfile = textpane.getFrameFile();
            File hostdir = hostfile.getParentFile();
            if (selExtStr.endsWith("xml")) {
                File f = new File(selExtStr);
                String fullpath = selExtStr;
                if (f.exists()) {
                    BrowserUtils.open(selExtStr);
                    return;
                }
                if (selExtStr.startsWith("renderman")) {
                    File rmsProjRoot = FileUtils.isRMSRibFile(file);
                    if (rmsProjRoot != null) {
                        fullpath = new File(rmsProjRoot, selExtStr).getPath();
                        File tmp = new File(fullpath);
                        if (tmp.exists()) {
                            BrowserUtils.open(fullpath);
                            return;
                        }
                    } else {
                        f = new File(hostdir, selExtStr);
                        if (f.exists()) {
                            BrowserUtils.open(f.getPath());
                            return;
                        }
                    }
                } else {
                    f = new File(hostdir, selExtStr);
                    if (f.exists()) {
                        BrowserUtils.open(f.getPath());
                        return;
                    }
                    f = new File(FileUtils.getPWDFile(), selExtStr);
                    if (f.exists()) {
                        BrowserUtils.open(f.getPath());
                        return;
                    }
                }
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "Unable to find the XML file.\n\n", "Missing XML File", 2);
            } else if (GraphicsFileUtils.canOpen(file)) {
                GraphicsFileUtils.open(file);
                return;
            }
            w = KAbstractDesktop.getWindowWithFile(file);
            if (w != null) {
                KAbstractDesktop.toFront(w);
            } else {
                BBxt.newDocument(file);
                return;
            }
        }
        if (selExtStr == null) {
            return;
        }
        if (selExtStr.startsWith("file://")) {
            File temp;
            String subpath = selExtStr.substring(7, selExtStr.length());
            if (subpath.indexOf("#") != -1) {
                subpath = subpath.substring(0, subpath.indexOf("#"));
            }
            if ((w = KAbstractDesktop.getWindowWithFile(temp = new File(subpath))) != null) {
                KAbstractDesktop.toFront(w);
            } else {
                BBxt.newDocument(temp);
                return;
            }
        }
        if (selExtStr.startsWith("http://") || selExtStr.startsWith("www.")) {
            if (selExtStr.startsWith("www.")) {
                BrowserUtils.open("http://" + selExtStr);
            } else {
                BrowserUtils.open(selExtStr);
            }
            return;
        }
    }

    protected File convertSelectionToFile(String selection) {
        boolean isRelative = selection.startsWith(".");
        if (!isRelative) {
            File f1 = new File(selection);
            if (f1.exists()) {
                if (f1.getParentFile() == null) {
                    return new File(FileUtils.getPWDFile(), f1.getPath());
                }
                return f1;
            }
            String copySelExtStr = TextUtils.replace(selection.trim(), '#', "0001");
            f1 = new File(copySelExtStr);
            if (f1.exists()) {
                if (f1.getParentFile() == null) {
                    return new File(FileUtils.getPWDFile(), f1.getPath());
                }
                return f1;
            }
        }
        File hostFile = textpane.getFrameFile();
        File baseDir = FileUtils.getPWDFile();
        File f2 = !isRelative ? new File(baseDir, selection) : FileUtils.resolveRelativePath(baseDir, selection);
        if (f2.exists()) {
            return f2;
        }
        if (hostFile == null || !hostFile.exists()) {
            Cutter.setLog("    Debug:KAbstractHelp.convertSelectionToFile() - failed because host document has not been saved");
            return null;
        }
        ScriptHandler handler = ScriptRegistry.getHandlerForFile(hostFile);
        String hname = handler.getClass().getName();
        Cutter.setLog("    Debug:KAbstractHelp.convertSelectionToFile() - handler is \"" + hname + "\"");
        File f4 = null;
        if (handler != null) {
            String handlerName = handler.getClass().getName();
            File[] dirs = handler.getSystemHeadersDirs(hostFile);
            if (dirs == null && handlerName != null && handlerName.equals("UI_Script.H.HScriptHandler")) {
                handler = ScriptRegistry.getHandlerForExtension(".sl");
                handlerName = handler.getClass().getName();
                Cutter.setLog("    Debug:KAbstractHelp.convertSelectionToFile() - now using \"" + handlerName + "\"");
                dirs = handler.getSystemHeadersDirs(hostFile);
            }
            if (dirs != null && dirs.length > 0) {
                for (int n = 0; n < dirs.length; ++n) {
                    File f3 = new File(dirs[n], selection);
                    if (!f3.exists()) continue;
                    return f3;
                }
            }
            handler = ScriptRegistry.getHandlerForFile(hostFile);
            f4 = handler.convertSelectionToFile(selection);
        }
        if (f4 != null && f4.exists()) {
            return f4;
        }
        for (hostFile = textpane.getFrameFile(); hostFile != null && hostFile.exists(); hostFile = hostFile.getParentFile()) {
            f4 = new File(hostFile, selection);
            if (!f4.exists()) continue;
            return f4;
        }
        return null;
    }

    static {
        zipfilePath = null;
        zipEntry = null;
        file = null;
        validData = true;
    }
}

