/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Html;

import UI_BBXT.BBxt;
import UI_Components.Dialog.AbstractDialog;
import UI_Components.GBC;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Help.KAbstractHelp;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import Utilities.DialogUtils;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.FinderUtils;
import Utilities.HTMLUtils;
import Utilities.SegmentUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;

public class HtmlHelp
extends KAbstractHelp {
    public static final String REFORMAT_DOC = "Format Document";
    private static HtmlColorChooserDialog colorChooser = null;
    public static String docsPath = null;
    public static String docsIndexURL = null;

    public HtmlHelp(KTextPane textpane) {
        super(textpane);
        this.completer.completionDeActivate();
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
        this.completer.completionDeActivate();
    }

    @Override
    public void popupOnlineHelp(Point pnt, final String selection, final int end, MouseEvent e) {
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, end - selection.length(), end);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null || items[n] instanceof KAbstractHelp.KPopupMenuItem && ((KAbstractHelp.KPopupMenuItem)items[n]).getText().contains("Completion")) continue;
            defaultMenu.add(items[n]);
        }
        popup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                int begin = end - selection.length();
                if (begin >= 0 && end >= 0) {
                    BBxt.setSelection(begin, end);
                }
            }
        });
        int tabs = BBxt.countLineTabs();
        KPopupTagItem mi = new KPopupTagItem("Break", selection, "<BR>", end, tabs);
        popup.add(mi);
        mi = new KPopupTagItem("Space", selection, "&nbsp;", end, tabs);
        popup.add(mi);
        mi = new KPopupTagItem("Paragraph", "<P>", selection, "</P>", end, tabs);
        popup.add(mi);
        mi = new KPopupTagItem("Pre", "<PRE>", selection, "</PRE>", end, tabs);
        popup.add(mi);
        mi = new KPopupTagItem("Code", "<CODE>", selection, "</CODE>", end);
        popup.add(mi);
        mi = new KPopupTagItem("Comment", "<!--", selection, "-->", end, tabs);
        popup.add(mi);
        mi = new KPopupTagItem("TextArea", "<blockquote><textarea rows=\"19\" cols=\"85\" wrap=\"off\" readonly>", selection, "</textarea></blockquote>", end, tabs);
        popup.add(mi);
        mi = new KPopupTagItem("Span", "<SPAN class=\"\">", selection, "</SPAN>", end);
        popup.add(mi);
        popup.addSeparator();
        JMenu stylesMenu = new JMenu("Text Styling");
        mi = new KPopupTagItem("Bold", "<B>", selection, "</B>", end);
        stylesMenu.add(mi);
        mi = new KPopupTagItem("Italic", "<I>", selection, "</I>", end);
        stylesMenu.add(mi);
        mi = new KPopupTagItem("Underline", "<U>", selection, "</U>", end);
        stylesMenu.add(mi);
        mi = new KPopupTagItem("Coloration", "<FONT COLOR=\"#000000\">", selection, "</FONT>", end);
        stylesMenu.add(mi);
        popup.add(stylesMenu);
        JMenu linksMenu = new JMenu("Hyper Links");
        mi = new KPopupTagItem("Anchor", "<A HREF=\"\">", selection, "</A>", end);
        linksMenu.add(mi);
        String prefix = "<p class=\"\" align=\"middle\">\n";
        String postfix = "<br>\n\t\tFigure ?\n\t\t</p>\n\t\t";
        mi = new KPopupTagItem("Image", prefix + "\t\t<img src=\"\" alt=\"\" border=\"0\">", selection, postfix + "<br>", end);
        linksMenu.add(mi);
        mi = new KPopupTagItem("Image Rollover", prefix + "\t\t<img src=\"path_front_image\" onmouseover=\"this.src='path_rollover_image'\" onmouseout=\"this.src='path_front_image'\" alt=\"\" border=\"0\">", selection, postfix + "<br>", end, true);
        linksMenu.add(mi);
        mi = new KPopupTagItem("MP4 Movie", "<video id=\"movie_name\" src=\"img/mymovie.mp4\" controls width=450>", "", "</video>", end, tabs);
        linksMenu.add(mi);
        popup.add(linksMenu);
        JMenu listsMenu = new JMenu("Lists");
        mi = new KPopupTagItem("ordered", "<OL>\n\t\t\t\t<LI>item</LI>\n\t\t\t\t<LI>item</LI>\n\t\t\t</OL>\n", "", end);
        listsMenu.add(mi);
        mi = new KPopupTagItem("unordered", "<UL type=\"circle\">\n\t\t\t\t<LI>item</LI>\n\t\t\t\t<LI>item</LI>\n\t\t\t</UL>\n", "", end);
        listsMenu.add(mi);
        popup.add(listsMenu);
        JMenu CSSMenu = new JMenu("CSS");
        mi = new KPopupTagItem("Style", "<STYLE type=\"text/css\"><!--", selection, "--></STYLE>", end, 0);
        CSSMenu.add(mi);
        mi = new KPopupTagItem("define font", "H4 {font-family: Helvetica, Arial, sans-serif;\n\tfont-size: 12pt;\n\tfont-weight: bold;\n\tline-height: 15pt;\n\tmargin-right: 0pt;\n\tmargin-left: 0pt;\n\tmargin-bottom: 0pt;\n\t}", "", end);
        CSSMenu.add(mi);
        mi = new KPopupTagItem("define a color", "mycolor", "", " { color: #555555; }", end);
        CSSMenu.add(mi);
        mi = new KPopupTagItem("apply a color", "<H4 CLASS=\"mycolor\">", selection, "</H4>", end);
        CSSMenu.add(mi);
        popup.add(CSSMenu);
        KAbstractHelp.KPopupMenuItem picker = new KAbstractHelp.KPopupMenuItem("Color Picker");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (colorChooser == null) {
                    colorChooser = new HtmlColorChooserDialog();
                }
                colorChooser.showSelf(selection, end);
            }
        };
        picker.addActionListener(action);
        popup.add(picker);
        popup.addSeparator();
        KAbstractHelp.KPopupMenuItem case_checker = new KAbstractHelp.KPopupMenuItem("Check Image Links");
        ActionListener case_action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Vector<String> imgInfo = HtmlHelp.this.checkImageLinks();
                Vector<String> vidInfo = HtmlHelp.this.checkVideoLinks();
                Vector<String> overInfo = HtmlHelp.this.checkRollOverImageLinks();
                int totalInfoItems = imgInfo.size() + vidInfo.size() + overInfo.size();
                Cutter.setLog("totalInfoItems = " + totalInfoItems);
                if (totalInfoItems > 0) {
                    int n;
                    String[] msgs = new String[totalInfoItems];
                    int counter = 0;
                    for (n = 0; n < imgInfo.size(); ++n) {
                        msgs[counter++] = imgInfo.elementAt(n);
                    }
                    for (n = 0; n < vidInfo.size(); ++n) {
                        msgs[counter++] = vidInfo.elementAt(n);
                    }
                    for (n = 0; n < overInfo.size(); ++n) {
                        msgs[counter++] = overInfo.elementAt(n);
                    }
                    DialogUtils.showWarningMessage("Images Info", msgs);
                }
            }
        };
        case_checker.addActionListener(case_action);
        popup.add(case_checker);
        popup.addSeparator();
        popup.add(defaultMenu);
        popup.pack();
        popup.show(this.textpane, pnt.x, pnt.y);
    }

    public Vector<String> checkImageLinks() {
        Vector<String> listOfErrors = new Vector<String>();
        String text = this.textpane.getText();
        if (text == null || text.trim().length() == 0) {
            return listOfErrors;
        }
        boolean doFind = true;
        int beginAt = 0;
        File docDir = this.textpane.getFrame().getFile().getParentFile();
        Document document = this.textpane.getDocument();
        while (doFind) {
            int quoteEnd;
            FinderUtils.FindDB db = FinderUtils.find(text, "<img ", beginAt, true, false);
            if (db.absBegin == -1 || db.absEnd == -1) {
                return listOfErrors;
            }
            int imgTagBegin = db.absBegin;
            int imgTagEnd = db.absEnd;
            db = FinderUtils.find(text, "<", imgTagEnd, true, false);
            int nextOpenTagBegin = db.absBegin;
            int nextOpenTagEnd = db.absEnd;
            db = FinderUtils.find(text, ">", imgTagEnd, true, false);
            int imgTagCloseBegin = db.absBegin;
            int imgTagCloseEnd = db.absEnd;
            if (imgTagCloseBegin > nextOpenTagBegin) {
                int[] result = DocumentUtils.getLineNumberAt(document, imgTagBegin);
                int lineNum = result == null ? -1 : result[0];
                listOfErrors.add("Could not find a closing \">\" for \"<img \" tag on line " + lineNum);
                return listOfErrors;
            }
            String imgTagStr = text.substring(imgTagBegin, imgTagCloseEnd);
            int[] result = DocumentUtils.getLineNumberAt(document, imgTagBegin);
            int lineNum = result == null ? -1 : result[0];
            db = FinderUtils.find(imgTagStr, "onmouseover", 0, true, false);
            int onmouseoverBegin = db.absBegin;
            int onmouseoverEnd = db.absEnd;
            if (onmouseoverBegin != -1) {
                beginAt = imgTagCloseEnd;
                continue;
            }
            int quoteBegin = imgTagStr.indexOf(34);
            if (quoteBegin == -1) {
                beginAt = imgTagCloseEnd;
                continue;
            }
            if ((quoteEnd = imgTagStr.indexOf(34, ++quoteBegin)) == -1) {
                beginAt = imgTagCloseEnd;
                continue;
            }
            String src_path = imgTagStr.substring(quoteBegin, quoteEnd);
            File f = new File(docDir, src_path);
            if (f.exists()) {
                String imageExt = FileUtils.getExtension(src_path);
                String src_name = f.getName();
                String[] ext = new String[]{imageExt.toLowerCase(), imageExt.toUpperCase()};
                String[] imageNames = FileUtils.getListOfFileNames(f.getParentFile(), ext);
                boolean caseMatch = false;
                String possibleMismatch = "";
                if (imageNames != null) {
                    for (int n = 0; n < imageNames.length; ++n) {
                        if (imageNames[n].equals(src_name)) {
                            caseMatch = true;
                        }
                        if (!imageNames[n].equalsIgnoreCase(src_name)) continue;
                        possibleMismatch = imageNames[n];
                    }
                }
                if (!caseMatch && possibleMismatch.length() > 0) {
                    String msg = "Corrected \"" + src_name + "\" to \"" + possibleMismatch + "\"";
                    listOfErrors.add(msg);
                    int absQouteBegin = imgTagBegin + quoteBegin;
                    int absQuoteEnd = absQouteBegin + src_path.length();
                    this.textpane.setSelectionStart(absQuoteEnd - possibleMismatch.length());
                    this.textpane.setSelectionEnd(absQuoteEnd);
                    this.textpane.replaceSelection(possibleMismatch);
                }
            } else {
                String msg = "Line: " + lineNum + ". The image \"" + src_path + "\" cannot be found.";
                listOfErrors.add(msg);
            }
            beginAt = imgTagCloseEnd;
        }
        return listOfErrors;
    }

    public Vector<String> checkVideoLinks() {
        Vector<String> listOfErrors = new Vector<String>();
        String text = this.textpane.getText();
        if (text == null || text.trim().length() == 0) {
            return listOfErrors;
        }
        boolean doFind = true;
        int beginAt = 0;
        File docDir = this.textpane.getFrame().getFile().getParentFile();
        Document document = this.textpane.getDocument();
        while (doFind) {
            int quoteEnd;
            FinderUtils.FindDB db = FinderUtils.find(text, "<video ", beginAt, true, false);
            if (db.absBegin == -1 || db.absEnd == -1) {
                return listOfErrors;
            }
            int videoTagBegin = db.absBegin;
            int videoTagEnd = db.absEnd;
            db = FinderUtils.find(text, "<", videoTagEnd, true, false);
            int nextOpenTagBegin = db.absBegin;
            int nextOpenTagEnd = db.absEnd;
            db = FinderUtils.find(text, ">", videoTagEnd, true, false);
            int videoTagCloseBegin = db.absBegin;
            int videoTagCloseEnd = db.absEnd;
            if (videoTagCloseBegin > nextOpenTagBegin) {
                int[] result = DocumentUtils.getLineNumberAt(document, videoTagBegin);
                int lineNum = result == null ? -1 : result[0];
                listOfErrors.add("Could not find a closing \">\" for \"<video \" tag on line " + lineNum);
                return listOfErrors;
            }
            String videoTagStr = text.substring(videoTagBegin, videoTagCloseEnd);
            int[] result = DocumentUtils.getLineNumberAt(document, videoTagBegin);
            int videoLineNum = result == null ? -1 : result[0];
            db = FinderUtils.find(videoTagStr, "src", 0, true, false);
            int embeddedSrcTagBegin = db.absBegin;
            int embeddedSrcTagEnd = db.absEnd;
            if (embeddedSrcTagBegin == -1 || embeddedSrcTagEnd == -1) {
                beginAt = videoTagCloseEnd;
                continue;
            }
            int quoteBegin = videoTagStr.indexOf(34, embeddedSrcTagEnd);
            if (quoteBegin == -1) {
                beginAt = videoTagCloseEnd;
                continue;
            }
            if ((quoteEnd = videoTagStr.indexOf(34, ++quoteBegin)) == -1) {
                beginAt = videoTagCloseEnd;
                continue;
            }
            String src_path = videoTagStr.substring(quoteBegin, quoteEnd);
            File f = new File(docDir, src_path);
            if (f.exists()) {
                String imageExt = FileUtils.getExtension(src_path);
                String src_name = f.getName();
                String[] ext = new String[]{imageExt.toLowerCase(), imageExt.toUpperCase()};
                String[] imageNames = FileUtils.getListOfFileNames(f.getParentFile(), ext);
                boolean caseMatch = false;
                String possibleMismatch = "";
                if (imageNames != null) {
                    for (int n = 0; n < imageNames.length; ++n) {
                        if (imageNames[n].equals(src_name)) {
                            caseMatch = true;
                        }
                        if (!imageNames[n].equalsIgnoreCase(src_name)) continue;
                        possibleMismatch = imageNames[n];
                    }
                }
                if (!caseMatch && possibleMismatch.length() > 0) {
                    String msg = "Corrected \"" + src_name + "\" to \"" + possibleMismatch + "\"";
                    listOfErrors.add(msg);
                    int absQouteBegin = videoTagBegin + quoteBegin;
                    int absQuoteEnd = absQouteBegin + src_path.length();
                    this.textpane.setSelectionStart(absQuoteEnd - possibleMismatch.length());
                    this.textpane.setSelectionEnd(absQuoteEnd);
                    this.textpane.replaceSelection(possibleMismatch);
                }
            } else {
                String msg = "Line: " + videoLineNum + ". The video \"" + src_path + "\" cannot be found.";
                listOfErrors.add(msg);
            }
            beginAt = videoTagCloseEnd;
        }
        return listOfErrors;
    }

    public Vector<String> checkRollOverImageLinks() {
        Vector<String> listOfErrors = new Vector<String>();
        String text = this.textpane.getText();
        if (text == null || text.trim().length() == 0) {
            return listOfErrors;
        }
        boolean doFind = true;
        int beginAt = 0;
        File docDir = this.textpane.getFrame().getFile().getParentFile();
        Document document = this.textpane.getDocument();
        while (doFind) {
            int quoteEnd;
            FinderUtils.FindDB db = FinderUtils.find(text, "<img ", beginAt, true, false);
            if (db.absBegin == -1 || db.absEnd == -1) {
                return listOfErrors;
            }
            int imgTagBegin = db.absBegin;
            int imgTagEnd = db.absEnd;
            db = FinderUtils.find(text, "<", imgTagEnd, true, false);
            int nextOpenTagBegin = db.absBegin;
            int nextOpenTagEnd = db.absEnd;
            db = FinderUtils.find(text, ">", imgTagEnd, true, false);
            int imgTagCloseBegin = db.absBegin;
            int imgTagCloseEnd = db.absEnd;
            if (imgTagCloseBegin > nextOpenTagBegin) {
                int[] result = DocumentUtils.getLineNumberAt(document, imgTagBegin);
                int lineNum = result == null ? -1 : result[0];
                listOfErrors.add("Could not find a closing \">\" for \"<img \" tag on line " + lineNum);
                return listOfErrors;
            }
            String imgTagStr = text.substring(imgTagBegin, imgTagCloseEnd);
            int[] result = DocumentUtils.getLineNumberAt(document, imgTagBegin);
            int lineNum = result == null ? -1 : result[0];
            db = FinderUtils.find(imgTagStr, "onmouseover", 0, true, false);
            int onmouseoverBegin = db.absBegin;
            int onmouseoverEnd = db.absEnd;
            if (onmouseoverBegin == -1) {
                beginAt = imgTagCloseEnd;
                continue;
            }
            int quoteBegin = imgTagStr.indexOf(34);
            if (quoteBegin == -1) {
                beginAt = imgTagCloseEnd;
                continue;
            }
            if ((quoteEnd = imgTagStr.indexOf(34, ++quoteBegin)) == -1) {
                beginAt = imgTagCloseEnd;
                continue;
            }
            String front_src_path = imgTagStr.substring(quoteBegin, quoteEnd);
            File f = new File(docDir, front_src_path);
            if (f.exists()) {
                String imageExt = FileUtils.getExtension(front_src_path);
                String src_name = f.getName();
                String[] ext = new String[]{imageExt.toLowerCase(), imageExt.toUpperCase()};
                String[] imageNames = FileUtils.getListOfFileNames(f.getParentFile(), ext);
                boolean caseMatch = false;
                String possibleMismatch = "";
                if (imageNames != null) {
                    for (int n = 0; n < imageNames.length; ++n) {
                        if (imageNames[n].equals(src_name)) {
                            caseMatch = true;
                        }
                        if (!imageNames[n].equalsIgnoreCase(src_name)) continue;
                        possibleMismatch = imageNames[n];
                    }
                }
                if (!caseMatch && possibleMismatch.length() > 0) {
                    String msg = "Corrected \"" + src_name + "\" to \"" + possibleMismatch + "\"";
                    listOfErrors.add(msg);
                    int absQouteBegin = imgTagBegin + quoteBegin;
                    int absQuoteEnd = absQouteBegin + front_src_path.length();
                    this.textpane.setSelectionStart(absQuoteEnd - possibleMismatch.length());
                    this.textpane.setSelectionEnd(absQuoteEnd);
                    this.textpane.replaceSelection(possibleMismatch);
                }
            } else {
                String msg = "Line: " + lineNum + ". The image \"" + front_src_path + "\" cannot be found.";
                listOfErrors.add(msg);
            }
            quoteBegin = imgTagStr.indexOf(39);
            if (quoteBegin == -1) {
                beginAt = imgTagCloseEnd;
                continue;
            }
            if ((quoteEnd = imgTagStr.indexOf(39, ++quoteBegin)) == -1) {
                beginAt = imgTagCloseEnd;
                continue;
            }
            String rollover_src_path = imgTagStr.substring(quoteBegin, quoteEnd);
            f = new File(docDir, rollover_src_path);
            if (f.exists()) {
                String imageExt = FileUtils.getExtension(rollover_src_path);
                String src_name = f.getName();
                String[] ext = new String[]{imageExt.toLowerCase(), imageExt.toUpperCase()};
                String[] imageNames = FileUtils.getListOfFileNames(f.getParentFile(), ext);
                boolean caseMatch = false;
                String possibleMismatch = "";
                if (imageNames != null) {
                    for (int n = 0; n < imageNames.length; ++n) {
                        if (imageNames[n].equals(src_name)) {
                            caseMatch = true;
                        }
                        if (!imageNames[n].equalsIgnoreCase(src_name)) continue;
                        possibleMismatch = imageNames[n];
                    }
                }
                if (!caseMatch && possibleMismatch.length() > 0) {
                    String msg = "Corrected \"" + src_name + "\" to \"" + possibleMismatch + "\"";
                    listOfErrors.add(msg);
                    int absQouteBegin = imgTagBegin + quoteBegin;
                    int absQuoteEnd = absQouteBegin + rollover_src_path.length();
                    this.textpane.setSelectionStart(absQuoteEnd - possibleMismatch.length());
                    this.textpane.setSelectionEnd(absQuoteEnd);
                    this.textpane.replaceSelection(possibleMismatch);
                }
            } else {
                String msg = "Line: " + lineNum + ". The image \"" + rollover_src_path + "\" cannot be found.";
                listOfErrors.add(msg);
            }
            quoteBegin = imgTagStr.indexOf(39, quoteEnd + 1);
            if (quoteBegin == -1) {
                beginAt = imgTagCloseEnd;
                continue;
            }
            if ((quoteEnd = imgTagStr.indexOf(39, ++quoteBegin)) == -1) {
                beginAt = imgTagCloseEnd;
                continue;
            }
            String onmouseout_src_path = imgTagStr.substring(quoteBegin, quoteEnd);
            f = new File(docDir, onmouseout_src_path);
            if (f.exists()) {
                String imageExt = FileUtils.getExtension(onmouseout_src_path);
                String src_name = f.getName();
                String[] ext = new String[]{imageExt.toLowerCase(), imageExt.toUpperCase()};
                String[] imageNames = FileUtils.getListOfFileNames(f.getParentFile(), ext);
                boolean caseMatch = false;
                String possibleMismatch = "";
                if (imageNames != null) {
                    for (int n = 0; n < imageNames.length; ++n) {
                        if (imageNames[n].equals(src_name)) {
                            caseMatch = true;
                        }
                        if (!imageNames[n].equalsIgnoreCase(src_name)) continue;
                        possibleMismatch = imageNames[n];
                    }
                }
                if (!caseMatch && possibleMismatch.length() > 0) {
                    String msg = "Corrected \"" + src_name + "\" to \"" + possibleMismatch + "\"";
                    listOfErrors.add(msg);
                    int absQouteBegin = imgTagBegin + quoteBegin;
                    int absQuoteEnd = absQouteBegin + onmouseout_src_path.length();
                    this.textpane.setSelectionStart(absQuoteEnd - possibleMismatch.length());
                    this.textpane.setSelectionEnd(absQuoteEnd);
                    this.textpane.replaceSelection(possibleMismatch);
                }
            } else {
                String msg = "Line: " + lineNum + ". The image \"" + onmouseout_src_path + "\" cannot be found.";
                listOfErrors.add(msg);
            }
            beginAt = imgTagCloseEnd;
        }
        return listOfErrors;
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
        this.popupOnlineHelp(pnt, BBxt.getSelection(), insertAt, e);
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        return true;
    }

    public static void initPaths() {
    }

    @Override
    protected void lookup(String item) {
    }

    private void ___getDefaultSelectBlockMenu________() {
    }

    @Override
    protected KAbstractHelp.KPopupMenuItem getDefaultSelectBlockMenu() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Select HTML Block");
        if (this.selRawStr == null || this.selRawStr.trim().length() > 1) {
            mi.setEnabled(false);
            return mi;
        }
        mi.addActionListener(new SelectBlockAction(this.textpane, this.selRawBegin));
        return mi;
    }

    public KAbstractHelp.KPopupMenuItem getReformatDocItem() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(REFORMAT_DOC);
        ActionListener reformatAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int cursorAt = BBxt.getSelectionStart();
                String src = BBxt.getWindowText();
                if (src == null || src.trim().length() == 0) {
                    return;
                }
                String[] result = HTMLUtils.reformat(src);
                if (result == null) {
                    return;
                }
                BBxt.selectAll();
                BBxt.paste(result[1]);
                if (cursorAt != -1) {
                    BBxt.setSelection(cursorAt, cursorAt);
                }
            }
        };
        mi.addActionListener(reformatAction);
        mi.setEnabled(true);
        return mi;
    }

    public class HtmlColorChooserDialog
    extends AbstractDialog {
        private JColorChooser chooser;
        private Color outColor;
        private Color inColor;
        private int end;
        private String selection;
        private boolean colorStatement;

        public HtmlColorChooserDialog() {
            super(Cutter.desktop, "Html Color Chooser", true, false);
            this.outColor = new Color(255, 255, 255);
            this.inColor = new Color(255, 255, 255);
            this.colorStatement = false;
            this.setDefaultCloseOperation(1);
            this.contentPane.setLayout(new BorderLayout());
            this.chooser = new JColorChooser();
            KTitledPanel mainPanel = new KTitledPanel(" Select a Color ");
            this.contentPane.add((Component)mainPanel, "Center");
            mainPanel.add(this.chooser, new GBC(0, 0, 6, 1, 1.0, 1.0, 0, 0, 10, 0, new Insets(10, 10, 10, 10)));
            mainPanel.add(this.cancelButton, new GBC(4, 1, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(0, 0, 10, 10)));
            mainPanel.add(this.okButton, new GBC(5, 1, 1, 1, 0.0, 0.0, 0, 0, 13, 0, new Insets(0, 0, 10, 10)));
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != this.okButton) {
                this.setVisible(false);
                return;
            }
            this.outColor = this.chooser.getColor();
            String red = Integer.toHexString(this.outColor.getRed());
            String green = Integer.toHexString(this.outColor.getGreen());
            String blue = Integer.toHexString(this.outColor.getBlue());
            red = red.length() == 1 ? "0" + red : red;
            green = green.length() == 1 ? "0" + green : green;
            blue = blue.length() == 1 ? "0" + blue : blue;
            StringBuffer buf = new StringBuffer();
            buf.append(red).append(green).append(blue);
            HtmlHelp.this.textpane.setSelectionStart(this.end - this.selection.length());
            HtmlHelp.this.textpane.setSelectionEnd(this.end);
            if (this.selection.length() == 6) {
                HtmlHelp.this.textpane.replaceSelection(buf.toString());
            } else {
                HtmlHelp.this.textpane.replaceSelection("#" + buf.toString());
            }
            this.setVisible(false);
        }

        private Color selectionToColor() {
            Color defaultColor = new Color(255, 255, 255);
            if (this.selection == null || this.selection.trim().length() == 0) {
                return new Color(255, 255, 255);
            }
            if (this.selection.trim().length() < 6 || this.selection.trim().length() > 7) {
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "The Html Color PIcker works with hexadecimal color.\nAn acceptable Hex color, white for example, is\n#ffffff", "Error -  Html Color Picker", 0);
                return null;
            }
            if (this.selection.length() == 6) {
                int val;
                try {
                    val = Integer.decode("#" + this.selection);
                }
                catch (NumberFormatException e) {
                    Cutter.setLog(e.toString());
                    JOptionPane.showMessageDialog(KDesktop.desktopPane, "The Html Color PIcker works with hexadecimal values.\nAcceptable hex value are,\n12345678abcdef", "Error -  Color Picker", 0);
                    return null;
                }
                return new Color(val);
            }
            if (this.selection.length() == 7) {
                int val;
                try {
                    val = Integer.decode(this.selection);
                }
                catch (NumberFormatException e) {
                    Cutter.setLog(e.toString());
                    JOptionPane.showMessageDialog(KDesktop.desktopPane, "The Html Color PIcker works with hexadecimal values.\nAcceptable hex value are,\n12345678abcdef", "Error -  Color Picker", 0);
                    return null;
                }
                return new Color(val);
            }
            return null;
        }

        @Override
        public void enterKeyPressed() {
            this.setVisible(false);
        }

        @Override
        public void escKeyPressed() {
            this.setVisible(false);
        }

        public void showSelf(String selection, int end) {
            Rectangle desk = KDesktop.desktopPane.getBounds();
            Dimension dialogsize = this.getSize();
            Rectangle r = HtmlHelp.this.textpane.getFrame().getBounds();
            int x = r.width / 2 - dialogsize.width / 2;
            int y = r.height / 2 - dialogsize.height / 2;
            this.setBounds(x + r.x, y + r.y, dialogsize.width, dialogsize.height);
            this.selection = selection;
            this.end = end;
            Color color = this.selectionToColor();
            if (color == null) {
                return;
            }
            this.chooser.setColor(color);
            AbstractColorChooserPanel[] p = this.chooser.getChooserPanels();
            for (int n = 0; n < p.length; ++n) {
                if (p[n] == null) continue;
                p[n].updateChooser();
            }
            JComponent c = this.chooser.getPreviewPanel();
            Graphics g = c.getGraphics();
            c.update(g);
            this.setVisible(true);
        }

        private void showFormatError() {
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "One of the items you have chosen is not a number!\n\nAn example of an acceptable statement would be,\n[1 1 1]", "Color Picker - Number Format Error", 0);
        }

        private void showNumberError() {
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "Color Picker requires three numbers in order\nto definde the rgb value of a color.\n", "Color Picker - Insufficient Values Error", 0);
        }

        private void showOutOfRangeError() {
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "RGB values must be in the range 0 to 1.\nColor Picker will correct the error.", "Color Picker - RGB Format Error", 0);
        }
    }

    protected class KPopupTagItem
    extends KAbstractHelp.KPopupMenuItem {
        public KPopupTagItem(String title, String selection, final String tagClose, final int end, int tabs) {
            super(title);
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StringBuffer buf = new StringBuffer();
                    Element element = DocumentUtils.getParagraphElement(HtmlHelp.this.textpane.getDocument(), end);
                    int begin = element.getStartOffset();
                    Segment segment = DocumentUtils.getSegment(HtmlHelp.this.textpane.getDocument(), begin, end - begin);
                    if (segment == null || segment.toString().trim().length() != 0) {
                        // empty if block
                    }
                    buf.append(tagClose);
                    HtmlHelp.this.textpane.setSelectionStart(end);
                    HtmlHelp.this.textpane.setSelectionEnd(end);
                    HtmlHelp.this.textpane.replaceSelection(buf.toString());
                }
            };
            this.addActionListener(action);
        }

        public KPopupTagItem(String title, String tagOpen, String selection, String tagClose, int end) {
            this(title, tagOpen, selection, tagClose, end, false);
        }

        public KPopupTagItem(String title, final String tagOpen, final String selection, final String tagClose, final int end, final boolean deleteSelection) {
            super(title);
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StringBuffer buf = new StringBuffer();
                    if (deleteSelection) {
                        buf.append(tagOpen).append(tagClose);
                    } else {
                        buf.append(tagOpen).append(selection).append(tagClose);
                    }
                    HtmlHelp.this.textpane.setSelectionStart(end - selection.length());
                    HtmlHelp.this.textpane.setSelectionEnd(end);
                    HtmlHelp.this.textpane.replaceSelection(buf.toString());
                }
            };
            this.addActionListener(action);
        }

        public KPopupTagItem(String title, final String tagOpen, final String selection, final String tagClose, final int end, final int tabs) {
            super(title);
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int n;
                    StringBuffer buf = new StringBuffer();
                    buf.append(tagOpen).append("\n");
                    for (n = 0; n < tabs; ++n) {
                        buf.append("\t");
                    }
                    buf.append(selection).append("\n");
                    for (n = 0; n < tabs; ++n) {
                        buf.append("\t");
                    }
                    buf.append(tagClose).append("\n");
                    HtmlHelp.this.textpane.setSelectionStart(end - selection.length());
                    HtmlHelp.this.textpane.setSelectionEnd(end);
                    HtmlHelp.this.textpane.replaceSelection(buf.toString());
                }
            };
            this.addActionListener(action);
        }

        public KPopupTagItem(String title, final String tagOpen, final String selection, final int end) {
            super(title);
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(tagOpen).append(selection);
                    HtmlHelp.this.textpane.setSelectionStart(end - selection.length());
                    HtmlHelp.this.textpane.setSelectionEnd(end);
                    HtmlHelp.this.textpane.replaceSelection(buf.toString());
                }
            };
            this.addActionListener(action);
        }
    }

    public static class SelectBlockAction
    extends AbstractAction {
        private KTextPane textpane = null;
        private Document doc = null;
        private Segment segment = null;
        SyntaxListener listener = null;
        private int caretAt = -1;
        private Color cmntColor = null;
        private Color strColor = null;

        public SelectBlockAction(KTextPane textpane, int caretAt) {
            this.textpane = textpane;
            this.doc = textpane.getDocument();
            this.listener = textpane.getSyntaxListener();
            this.segment = DocumentUtils.getSegment(this.doc, 0, this.doc.getLength());
            this.caretAt = caretAt;
            this.cmntColor = StyleConstants.getForeground(textpane.styleContext.commentStyle1);
            this.strColor = StyleConstants.getForeground(textpane.styleContext.stringStyle1);
        }

        private boolean doIgnore(int offset) {
            Color c = DocumentUtils.getCharacterStyleColor(this.doc, offset);
            return c == this.cmntColor || c == this.strColor;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String eStr;
            String bStr;
            char c;
            int blockOpenOffset = -1;
            int blockCloseOffset = -1;
            int beginAt = this.segment.offset + this.caretAt;
            int paraOpenCount = 1;
            int tdOpenCount = 1;
            int trOpenCount = 1;
            int tableOpenCount = 1;
            int bodyOpenCount = 1;
            int headOpenCount = 1;
            int closeDelta = 4;
            for (int offset = beginAt; offset < this.segment.count; ++offset) {
                c = this.segment.array[offset + this.segment.offset];
                if (this.doIgnore(offset) || c != '<') continue;
                bStr = SegmentUtils.toNonNullString(this.segment, offset, 2);
                eStr = SegmentUtils.toNonNullString(this.segment, offset, 4);
                if (bStr.equalsIgnoreCase("<P")) {
                    ++paraOpenCount;
                } else if (eStr.equalsIgnoreCase("</P>")) {
                    --paraOpenCount;
                }
                bStr = SegmentUtils.toNonNullString(this.segment, offset, 3);
                if (bStr.equalsIgnoreCase("<TD")) {
                    ++tdOpenCount;
                } else if (eStr.equalsIgnoreCase("</TD")) {
                    --tdOpenCount;
                } else if (bStr.equalsIgnoreCase("<TR")) {
                    ++trOpenCount;
                } else if (eStr.equalsIgnoreCase("</TR")) {
                    --trOpenCount;
                }
                bStr = SegmentUtils.toNonNullString(this.segment, offset, 6);
                eStr = SegmentUtils.toNonNullString(this.segment, offset, 7);
                if (bStr.equalsIgnoreCase("<TABLE")) {
                    ++tableOpenCount;
                } else if (eStr.equalsIgnoreCase("</TABLE")) {
                    --tableOpenCount;
                }
                eStr = bStr;
                bStr = SegmentUtils.toNonNullString(this.segment, offset, 5);
                if (bStr.equalsIgnoreCase("<BODY")) {
                    ++bodyOpenCount;
                } else if (eStr.equalsIgnoreCase("</BODY")) {
                    --bodyOpenCount;
                } else if (bStr.equalsIgnoreCase("<HEAD")) {
                    ++headOpenCount;
                } else if (eStr.equalsIgnoreCase("</HEAD")) {
                    --headOpenCount;
                }
                if (paraOpenCount != 0 && tdOpenCount != 0 && trOpenCount != 0 && tableOpenCount != 0 && bodyOpenCount != 0 && headOpenCount != 0) continue;
                if (tdOpenCount == 0 || trOpenCount == 0) {
                    closeDelta = 5;
                } else if (tableOpenCount == 0) {
                    closeDelta = 8;
                } else if (bodyOpenCount == 0 || headOpenCount == 0) {
                    closeDelta = 7;
                }
                blockCloseOffset = offset;
                break;
            }
            if (blockCloseOffset == -1) {
                return;
            }
            int paraCloseCount = 0;
            int tdCloseCount = 0;
            int trCloseCount = 0;
            int tableCloseCount = 0;
            int headCloseCount = 0;
            int bodyCloseCount = 0;
            boolean isParaBlock = paraOpenCount == 0;
            boolean isTdBlock = tdOpenCount == 0;
            boolean isTrBlock = trOpenCount == 0;
            boolean isTableBlock = tableOpenCount == 0;
            boolean isBodyBlock = bodyOpenCount == 0;
            boolean isHeadBlock = headOpenCount == 0;
            for (int offset = beginAt = blockCloseOffset; offset >= this.segment.offset; --offset) {
                c = this.segment.array[offset + this.segment.offset];
                if (this.doIgnore(offset) || c != '<') continue;
                bStr = SegmentUtils.toNonNullString(this.segment, offset, 2);
                eStr = SegmentUtils.toNonNullString(this.segment, offset, 4);
                if (eStr.equalsIgnoreCase("</P>")) {
                    ++paraCloseCount;
                } else if (bStr.equalsIgnoreCase("<P")) {
                    --paraCloseCount;
                }
                bStr = SegmentUtils.toNonNullString(this.segment, offset, 3);
                if (eStr.equalsIgnoreCase("</TD")) {
                    ++tdCloseCount;
                } else if (bStr.equalsIgnoreCase("<TD")) {
                    --tdCloseCount;
                } else if (eStr.equalsIgnoreCase("</TR")) {
                    ++trCloseCount;
                } else if (bStr.equalsIgnoreCase("<TR")) {
                    --trCloseCount;
                }
                bStr = SegmentUtils.toNonNullString(this.segment, offset, 6);
                eStr = SegmentUtils.toNonNullString(this.segment, offset, 7);
                if (bStr.equalsIgnoreCase("<TABLE")) {
                    ++tableCloseCount;
                } else if (eStr.equalsIgnoreCase("</TABLE")) {
                    --tableCloseCount;
                }
                eStr = bStr;
                bStr = SegmentUtils.toNonNullString(this.segment, offset, 5);
                if (bStr.equalsIgnoreCase("<BODY")) {
                    ++bodyCloseCount;
                } else if (eStr.equalsIgnoreCase("</BODY")) {
                    --bodyCloseCount;
                } else if (bStr.equalsIgnoreCase("<HEAD")) {
                    ++headCloseCount;
                } else if (eStr.equalsIgnoreCase("</HEAD")) {
                    --headCloseCount;
                }
                if (!(isParaBlock && paraCloseCount == 0 || isTdBlock && tdCloseCount == 0 || isTrBlock && trCloseCount == 0 || isTableBlock && tableCloseCount == 0 || isHeadBlock && headCloseCount == 0) && (!isBodyBlock || bodyCloseCount != 0)) continue;
                blockOpenOffset = offset;
                break;
            }
            if (blockOpenOffset == -1) {
                return;
            }
            this.textpane.setSelectionStart(blockOpenOffset);
            this.textpane.setSelectionEnd(blockCloseOffset + closeDelta);
            this.textpane.requestFocus();
        }
    }
}

