/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Html;

import Preferences.Preferences;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Html.HtmlHelp;
import UI_Script.Html.HtmlListener;
import UI_Script.Html.HtmlTokenizer;
import UI_Script.Html.OpenHtmlAction;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KTextHistoryWindow;
import Utilities.BrowserUtils;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class HtmlScriptHandler
extends ScriptHandler {
    private static int preferredSlashCount = -1;

    @Override
    public boolean canRunSelection() {
        return false;
    }

    public HtmlScriptHandler() {
        this.ext = new String[4];
        this.ext[0] = ".html";
        this.ext[1] = ".HTML";
        this.ext[2] = ".htm";
        this.ext[3] = ".HTM";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new HtmlTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.html");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Html";
    }

    @Override
    public String getExecuteLabel() {
        return "Display in Browser";
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp.html");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public void execute(File file) {
        KTextPane textpane;
        KAbstractHelp kah;
        boolean auto_correct;
        if (BBxt.containsAppletTag()) {
            Cutter.setLog("    Info:HtmlScriptHandler.execute(file) - web page contains applet tag");
            String[] items = new String[]{"appletviewer", file.getName()};
            ProcessManager fp = new ProcessManager();
            fp.launch(items, null, false, null, false);
            return;
        }
        String str = Preferences.get(Preferences.HTML_AUTO_CORRECT_IMAGE_NAMES);
        boolean bl = auto_correct = str.equals("true");
        if (auto_correct && (kah = this.getHelper(textpane = (KTextPane)BBxt.getTextPane())) != null && kah instanceof HtmlHelp) {
            HtmlHelp helper = (HtmlHelp)kah;
            Vector<String> imgInfo = helper.checkImageLinks();
            Vector<String> vidInfo = helper.checkVideoLinks();
            Vector<String> overInfo = helper.checkRollOverImageLinks();
            int totalInfoItems = imgInfo.size() + vidInfo.size() + overInfo.size();
            if (totalInfoItems > 0) {
                int n;
                String[] msgs = new String[totalInfoItems];
                int counter = 0;
                for (n = 0; n < imgInfo.size(); ++n) {
                    msgs[counter++] = imgInfo.elementAt(n);
                }
                for (n = 0; n < vidInfo.size(); ++n) {
                    msgs[counter++] = vidInfo.elementAt(n);
                }
                for (n = 0; n < overInfo.size(); ++n) {
                    msgs[counter++] = overInfo.elementAt(n);
                }
                Cutter.setLog("    Info: HtmlScriptHandler.execute() - automatic correction of upper/lower case image names.");
                for (n = 0; n < msgs.length; ++n) {
                    Cutter.setLog("        " + msgs[n]);
                }
                BBxt.save();
            }
        }
        String url = TextUtils.replace(file.getPath(), ' ', "%20");
        if (preferredSlashCount != -1 && !BBxt.fileURL(url, preferredSlashCount)) {
            Cutter.setLog("    HtmlScriptHandler.execute() - cannot load \"" + url + "\" using " + preferredSlashCount + " leading forward slashes!");
            return;
        }
        BrowserUtils.open(url);
    }

    @Override
    public void executeFromHistory(KTextHistoryWindow window) {
        Document document = window.getTextPane().getDocument();
        Segment segment = DocumentUtils.getSegment(document, 0, document.getLength());
        if (segment == null) {
            return;
        }
        File file = window.getOwnersFile();
        if (file == null) {
            return;
        }
        String parent = file.getParent();
        if (parent == null || parent.trim().length() == 0) {
            return;
        }
        file = new File(parent, "temp.html");
        FileUtils.writeFile(file, segment.toString());
        this.execute(file);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        Class<HtmlListener> cls = HtmlListener.class;
        if (cls == null) {
            Cutter.setLog("HtmlScriptHandler.getSyntaxListenerClassName - NO CLASS !!!");
            return "HtmlListener";
        }
        return cls.getName();
    }

    @Override
    public synchronized KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(HtmlHelp.class.getName(), textpane);
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Html");
        item.addActionListener(new OpenHtmlAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("html", "Html Script");
        return filter;
    }
}

