/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Html;

import UI_Desktop.Cutter;
import UI_Script.ScriptParser.ProcDBItem;
import Utilities.HTMLUtils;
import Utilities.TextUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Vector;
import kernal.Tokenizers.Tokenizer;

public class HtmlTokenizer
extends Tokenizer {
    public static final double version = 1.0;
    public static final int COMMENT = 5;
    public static final int TAG = 6;
    public static final int NEWLINE = 7;
    public static boolean _searchBodyTextFor = false;
    public boolean ignoreTags = false;
    public boolean grabPreformatted = false;
    String lastProcName = "";

    public static HtmlTokenizer getHtmlTokenizerFor(String path) {
        HtmlTokenizer tok = null;
        try {
            tok = HtmlTokenizer.isHTTP(path) ? new HtmlTokenizer(new URL(path)) : new HtmlTokenizer(path);
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception: HtmlTokenizer.getHtmlTokenizerFor(" + path + ")\n" + ex);
        }
        return tok;
    }

    public HtmlTokenizer() {
        this.addComment("<!--", "-->");
        this.setSyntaxLength(4);
        String[] ext = new String[]{"html", "HTML", "htm", "HTM"};
        Tokenizer.addToRegistry(HtmlTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    private HtmlTokenizer(String path) throws FileNotFoundException, IOException {
        super(path);
        this.addComment("<!--", "-->");
        this.setSyntaxLength(4);
        String[] ext = new String[]{"html", "HTML", "htm", "HTM"};
        Tokenizer.addToRegistry(HtmlTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    private HtmlTokenizer(URL url) throws IOException {
        this.addComment("<!--", "-->");
        this.setSyntaxLength(4);
        String[] ext = new String[]{"html", "HTML", "htm", "HTM"};
        Tokenizer.addToRegistry(HtmlTokenizer.class, ext, this.getComments(), this.getDelimitors());
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            LineNumberReader in = new LineNumberReader(new InputStreamReader(url.openStream()));
            while ((line = in.readLine()) != null) {
                buffer.append(line).append('\n');
            }
            in.close();
        }
        catch (IOException ex) {
            Cutter.setLog("    Exception: HtmlTokenizer(" + url.toString() + ")" + ex);
            throw ex;
        }
        this.setBuffer(buffer);
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        String[] token = TextUtils.tokenize(str, "< =");
        int endIndex = this.getBufferIndex();
        int beginIndex = endIndex - str.length();
        if (token != null && token.length >= 2 && token[0].equalsIgnoreCase("A") && token[1].equalsIgnoreCase("NAME")) {
            this.setBufferIndex(beginIndex);
            char c = this.readChar();
            boolean found = false;
            while (c != '\u0000') {
                if (c == '\"') {
                    found = true;
                    break;
                }
                if (c == '>') break;
                c = this.readChar();
            }
            if (!found) {
                this.setBufferIndex(endIndex);
            }
            ProcDBItem out = new ProcDBItem();
            out.procNameOffset[0] = this.getBufferIndex();
            found = false;
            c = this.readChar();
            while (c != '\u0000') {
                if (c == '\"') {
                    found = true;
                    break;
                }
                if (c == '>') break;
                c = this.readChar();
            }
            if (!found) {
                this.setBufferIndex(endIndex);
            }
            out.procNameOffset[1] = this.getBufferIndex() - 1;
            int b = out.procNameOffset[0] - beginIndex;
            int e = out.procNameOffset[1] - beginIndex;
            if (b < 0 || e < b) {
                return null;
            }
            out.procName = str.substring(b, e);
            if (out.procName.equalsIgnoreCase(this.lastProcName)) {
                return null;
            }
            this.lastProcName = out.procName;
            out.procOffset[0] = out.procNameOffset[0];
            out.procOffset[1] = out.procNameOffset[1];
            return out;
        }
        if (token != null && token.length >= 1 && (token[0].startsWith("h") || token[0].startsWith("H")) && token[0].length() >= 2 && token[0].charAt(1) >= '0' && token[0].charAt(1) <= '9') {
            this.setBufferIndex(beginIndex);
            char c = this.readChar();
            boolean found = false;
            while (c != '\u0000' && c != '>') {
                c = this.readChar();
            }
            if (c == '\u0000') {
                this.setBufferIndex(endIndex);
                return null;
            }
            ProcDBItem out = new ProcDBItem();
            out.procNameOffset[0] = this.getBufferIndex();
            while (c != '\u0000' && c != '<') {
                c = this.readChar();
            }
            if (c == '\u0000') {
                this.setBufferIndex(endIndex);
                return null;
            }
            out.procNameOffset[1] = this.getBufferIndex() - 1;
            int b = out.procNameOffset[0];
            int e = out.procNameOffset[1];
            if (b < 0 || e < b) {
                return null;
            }
            String[] t = TextUtils.tokenize(new String(this.getBuffer(b, e)), " \t\n");
            StringBuffer buf = new StringBuffer();
            for (int n = 0; n < t.length; ++n) {
                if (t[n].trim().equals("<")) continue;
                buf.append(t[n]).append(" ");
            }
            out.procName = buf.toString().trim();
            if (out.procName.length() == 0) {
                this.setBufferIndex(endIndex);
                return null;
            }
            if (out.procName.endsWith("<")) {
                out.procName = out.procName.substring(0, out.procName.lastIndexOf(60));
            }
            out.procName = out.procName.replaceAll("(&nbsp;)", " ");
            if (out.procName.equalsIgnoreCase(this.lastProcName)) {
                return null;
            }
            this.lastProcName = out.procName;
            out.procOffset[0] = out.procNameOffset[0];
            out.procOffset[1] = out.procNameOffset[1];
            return out;
        }
        this.setBufferIndex(endIndex);
        return null;
    }

    public static boolean isHTTP(String path) {
        return path.startsWith("http:");
    }

    @Override
    public void setBuffer(String inStr) {
        super.setBuffer(inStr);
        this.getCR_Newlines = false;
    }

    public static int isOfType(String str) {
        boolean isHtmlComment = false;
        int len = str.length();
        if (len == 0) {
            return 0;
        }
        int n = 0;
        if (str.charAt(n) == '<') {
            if (str.charAt(n + 1) == '!' && str.charAt(n + 2) == '-' && str.charAt(n + 3) == '-') {
                isHtmlComment = true;
            }
            while (str.charAt(n) != '>') {
                if (++n != len) continue;
                System.out.println("error2");
                return 0;
            }
            if (isHtmlComment) {
                return 5;
            }
            return 6;
        }
        return Tokenizer.isOfType(str);
    }

    public static boolean isHrefTag(String str) {
        String[] token = TextUtils.tokenize(str, "< =");
        return token.length >= 2 && token[0].equalsIgnoreCase("A") && token[1].equalsIgnoreCase("HREF");
    }

    public static boolean isArefTag(String str) {
        String[] token = TextUtils.tokenize(str, "< =");
        if (token.length >= 2 && token[0].equalsIgnoreCase("A") && token[1].equalsIgnoreCase("NAME")) {
            return true;
        }
        return token.length > 0 && (token[0].startsWith("/A") || token[0].startsWith("/a"));
    }

    public static boolean isImageTag(String str) {
        String[] token = TextUtils.tokenize(str, "< =");
        return token.length >= 2 && token[0].equalsIgnoreCase("IMG") && token[1].equalsIgnoreCase("SRC");
    }

    public static boolean isTag(String str) {
        return str.length() > 0 && str.charAt(0) == '<' && str.charAt(str.length() - 1) == '>';
    }

    @Override
    public boolean isComment(String str) {
        return str.startsWith("<!--") && str.endsWith("-->");
    }

    @Override
    public String getNextStr() {
        char c;
        boolean endOfPlainText = false;
        if (this.mEndOfBuffer || (c = this.readChar()) == '\u0000') {
            return "";
        }
        this.outBuff.setLength(0);
        if (this.isSpace(c) && (c = this.removeSpace()) == '\u0000') {
            return "";
        }
        if (this.getCR_Newlines && c == '\n') {
            return "\n";
        }
        if (c == '<') {
            String tag = this.captureTag(c);
            if (tag != null) {
                this.outBuff.append(tag);
                return this.outBuff.toString();
            }
            this.outBuff.append(c);
        } else if (c == '&' && this.ignoreTags) {
            if (this.captureEntity(c)) {
                this.outBuff.setLength(0);
                return this.getNextStr();
            }
        } else {
            this.outBuff.append(c);
        }
        block6: while (!endOfPlainText) {
            c = this.readChar();
            switch (c) {
                case '\u0000': {
                    return this.outBuff.toString();
                }
                case '&': {
                    if (!this.ignoreTags) break;
                    this.captureEntity(c);
                    if (this.isSpace(this.peekNextChar())) continue block6;
                    this.outBuff.append(" ");
                    continue block6;
                }
                case '\n': 
                case '\r': {
                    if (!this.getCR_Newlines) {
                        this.ungetChar();
                        if (this.outBuff.length() == 0) {
                            return this.getNextStr();
                        }
                        return this.outBuff.toString();
                    }
                    if (this.outBuff.length() == 0) {
                        return this.getNextStr();
                    }
                    return this.outBuff.append(c).toString();
                }
                case '<': {
                    if (c == '<') {
                        this.ungetChar();
                        return this.outBuff.toString();
                    }
                    if (this.peekNextChar() != '/') break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
            }
            this.outBuff.append(c);
        }
        return this.outBuff.toString();
    }

    private String captureTag(char c) {
        String tag;
        char[] next2;
        int beginIndex = this.getBufferIndex();
        StringBuffer captureBuff = new StringBuffer();
        captureBuff.append(c);
        c = this.readChar();
        if (c == '\u0000') {
            Cutter.setLog("    Info: HtmlTokenizer.captureTag(char) readChar() == 0 at buffer index " + this.getBufferIndex());
            this.setBufferIndex(beginIndex);
            return null;
        }
        captureBuff.append(c);
        boolean isHtmlComment = false;
        if (c == '!') {
            next2 = this.peekNextChars(2);
            if (next2 == null) {
                return null;
            }
            if (next2[0] == '-' && next2[1] == '-') {
                isHtmlComment = true;
                captureBuff.append('-');
                captureBuff.append('-');
                this.readChar();
                this.readChar();
            }
        }
        boolean isPreTag = false;
        if (this.grabPreformatted && (c == 'P' || c == 'p') && (next2 = this.peekNextChars(2)) != null && (tag = c + new String(next2)).equalsIgnoreCase("pre")) {
            isPreTag = true;
            captureBuff.append('r').append('e');
            this.readChar();
            this.readChar();
        }
        while (c != '\u0000') {
            String tmp;
            if (!isHtmlComment && isPreTag && c == '>' && (tmp = captureBuff.toString()) != null && tmp.length() > 5 && (tmp = tmp.substring(tmp.length() - 5)).equalsIgnoreCase("/pre>")) {
                return captureBuff.toString();
            }
            if (isHtmlComment && c == '-' && (next2 = this.peekNextChars(2)) != null && next2[0] == '-' && next2[1] == '>') {
                captureBuff.append(this.readChar()).append(this.readChar());
                return captureBuff.toString();
            }
            if (!isPreTag && !isHtmlComment && c == '>') {
                boolean isTag;
                String tagStr = captureBuff.toString();
                boolean bl = isTag = HTMLUtils.isBeginTagStr(tagStr) || HTMLUtils.isEndTagStr(tagStr) || HTMLUtils.isStyleBeginTagStr(tagStr);
                if (isTag) {
                    return tagStr;
                }
            }
            c = this.readChar();
            captureBuff.append(c);
        }
        this.setBufferIndex(beginIndex);
        return null;
    }

    private boolean _startOfValidTag(char c) {
        boolean result;
        int beginIndex = this.getBufferIndex();
        c = this.peekNextChar();
        if (c == '\u0000') {
            Cutter.setLog("    Debug: HtmlTokenizer.isTagOpenChar(char) readChar() == 0 at buffer index " + this.getBufferIndex());
            return false;
        }
        if (this.peekNextNonWhite() == '/') {
            return true;
        }
        if (c == '!') {
            char[] next2 = this.peekNextChars(2);
            if (next2 == null || next2[0] != '-' && next2[1] != '-') {
                this.setBufferIndex(beginIndex);
                return false;
            }
            if (next2[0] == '-' && next2[1] == '-') {
                this.setBufferIndex(beginIndex);
                return true;
            }
        }
        int nextCloseCharIndex = this.peekNextCharIndex(62, beginIndex);
        int nextWhiteCharIndex = this.peekNextWhiteChar(beginIndex);
        if (nextCloseCharIndex == -1) {
            this.setBufferIndex(beginIndex);
            return false;
        }
        int endIndex = nextWhiteCharIndex < nextCloseCharIndex ? nextWhiteCharIndex : nextCloseCharIndex;
        char[] nextChars = endIndex > beginIndex + 1 ? this.getBuffer(beginIndex, endIndex - 1) : this.getBuffer(beginIndex);
        if (nextChars == null) {
            Cutter.setLog("    Debug: HtmlTokenizer.isTagOpenChar(char) nextChars == null at buffer index " + this.getBufferIndex());
            result = false;
        } else {
            String possibleTag = new String(nextChars).trim();
            Cutter.setLog("new String(nextChars).trim() " + possibleTag);
            if (possibleTag.startsWith("/")) {
                result = true;
            } else {
                if (!possibleTag.startsWith("<")) {
                    possibleTag = "<" + possibleTag;
                }
                result = HTMLUtils.isBeginTagStr(possibleTag);
                Cutter.setLog("isTagOpenChar() - possibleTag = \"" + possibleTag + "\"      result = " + result);
            }
        }
        this.setBufferIndex(beginIndex);
        return result;
    }

    private boolean isTagOpenChar(char c) {
        boolean result;
        Cutter.setLog("isTagOpenChar  " + c);
        int beginIndex = this.getBufferIndex();
        c = this.readChar();
        if (c == '\u0000') {
            Cutter.setLog("    Debug: HtmlTokenizer.isTagOpenChar(char) readChar() == 0 at buffer index " + this.getBufferIndex());
            this.setBufferIndex(beginIndex);
            return false;
        }
        if (this.peekNextNonWhite() == '/') {
            return true;
        }
        if (c == '!') {
            char[] next2 = this.peekNextChars(2);
            if (next2 == null || next2[0] != '-' && next2[1] != '-') {
                this.setBufferIndex(beginIndex);
                return false;
            }
            if (next2[0] == '-' && next2[1] == '-') {
                this.setBufferIndex(beginIndex);
                return true;
            }
        }
        int nextCloseCharIndex = this.peekNextCharIndex(62, beginIndex);
        int nextWhiteCharIndex = this.peekNextWhiteChar(beginIndex);
        if (nextCloseCharIndex == -1) {
            this.setBufferIndex(beginIndex);
            return false;
        }
        int endIndex = nextWhiteCharIndex < nextCloseCharIndex ? nextWhiteCharIndex : nextCloseCharIndex;
        Cutter.setLog("endIndex = " + endIndex);
        char[] nextChars = endIndex > beginIndex + 1 ? this.getBuffer(beginIndex, endIndex - 1) : this.getBuffer(beginIndex);
        if (nextChars == null) {
            Cutter.setLog("    Debug: HtmlTokenizer.isTagOpenChar(char) nextChars == null at buffer index " + this.getBufferIndex());
            result = false;
        } else {
            String possibleTag = new String(nextChars).trim();
            Cutter.setLog("new String(nextChars).trim() " + possibleTag);
            if (possibleTag.startsWith("/")) {
                result = true;
            } else {
                if (!possibleTag.startsWith("<")) {
                    possibleTag = "<" + possibleTag;
                }
                result = HTMLUtils.isBeginTagStr(possibleTag);
                Cutter.setLog("isTagOpenChar() - possibleTag = \"" + possibleTag + "\"      result = " + result);
            }
        }
        this.setBufferIndex(beginIndex);
        return result;
    }

    private boolean captureEntity(char c) {
        StringBuffer buff = new StringBuffer();
        buff.append(c);
        while ((c = this.readChar()) != '\u0000') {
            if (this.isSpace(c)) {
                this.outBuff.append(buff);
                return false;
            }
            if (c == ';') {
                return true;
            }
            buff.append(c);
        }
        this.outBuff.append(buff);
        return false;
    }

    private boolean _handleEntity(char c) {
        this.outBuff.append(c);
        while ((c = this.readChar()) != '\u0000') {
            if (this.isSpace(c)) {
                this.outBuff.append(c);
                return false;
            }
            if (c == ';') {
                return true;
            }
            this.outBuff.append(c);
        }
        return false;
    }

    public int searchBodyTextFor(int fromIndex, char ch) {
        boolean oldFlag = this.ignoreTags;
        this.ignoreTags = true;
        this.setBufferIndex(fromIndex);
        String str = this.getNextStr();
        while (str != "") {
            Cutter.setLog("HtmlTokenizer.searchBodyTextFor(char) >" + str + "<");
            for (int n = 0; n < str.length(); ++n) {
                if (str.charAt(n) != ch) continue;
                this.ignoreTags = oldFlag;
                int offset = this.getBufferIndex();
                return offset - str.length() + n;
            }
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        return -1;
    }

    public int searchBodyTextFor(int fromIndex, String pattern, boolean ignoreCase) {
        boolean oldFlag = this.ignoreTags;
        boolean match = true;
        int matchIndex = -1;
        this.ignoreTags = true;
        this.setBufferIndex(fromIndex);
        String str = this.getNextStr();
        while (!str.equals("")) {
            for (int n = 0; n < str.length(); ++n) {
                if (str.charAt(n) != pattern.charAt(0)) continue;
                match = true;
                if (str.length() - n < pattern.length() || !str.regionMatches(ignoreCase, n, pattern, 0, pattern.length())) continue;
                this.ignoreTags = oldFlag;
                int offset = this.getBufferIndex();
                if (_searchBodyTextFor && str.trim().length() > 0) {
                    Cutter.setLog("\n\n");
                }
                return offset - str.length() + n;
            }
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        return -1;
    }

    public String getBodyText() {
        StringBuffer buffer = new StringBuffer();
        boolean oldFlag = this.ignoreTags;
        int oldIndex = this.getBufferIndex();
        this.ignoreTags = true;
        this.setBufferIndex(0);
        String str = this.getNextStr();
        while (!str.equals("")) {
            buffer.append(str + " ");
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return buffer.toString();
    }

    public String getBodyTextBetween(String beginStr, String endStr) {
        if (beginStr == null || endStr == null) {
            return this.getBodyText();
        }
        int begin = this.searchBodyTextFor(0, beginStr, false);
        if (begin == -1) {
            return null;
        }
        int end = this.searchBodyTextFor(begin, endStr, false);
        if (end == -1) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.setBufferIndex(begin + beginStr.length());
        this.ignoreTags = true;
        String str = this.getNextStr();
        while (!str.equals("") && this.getBufferIndex() < end) {
            buffer.append(str + " ");
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return buffer.toString();
    }

    public String getBodyTextBetween(int begin, String endStr) {
        if (endStr == null || begin == -1) {
            return null;
        }
        int end = this.searchBodyTextFor(begin, endStr, true);
        if (end == -1) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.setBufferIndex(begin);
        this.ignoreTags = true;
        String str = this.getNextStr();
        while (!str.equals("") && this.getBufferIndex() < end) {
            buffer.append(str + " ");
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return buffer.toString();
    }

    public String getBodyTextBetween(int begin, int end) {
        if (end == -1 || begin == -1) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.setBufferIndex(begin);
        this.ignoreTags = true;
        String str = this.getNextStr();
        while (!str.equals("") && this.getBufferIndex() < end) {
            buffer.append(str + " ");
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return buffer.toString();
    }

    public String[] getHRefsBetween(String beginStr, String endStr) {
        int end;
        int begin;
        if (beginStr == null) {
            begin = 0;
        } else {
            begin = this.searchBodyTextFor(0, beginStr, false);
            if (begin == -1) {
                Cutter.setLog("getHRefsBetween cannot find " + beginStr);
                return null;
            }
        }
        if (endStr == null) {
            end = this.getBufferLength();
        } else {
            end = this.searchBodyTextFor(begin, endStr, false);
            if (end == -1) {
                Cutter.setLog("getHRefsBetween cannot find " + endStr);
                return null;
            }
        }
        Vector<String> list = new Vector<String>();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.ignoreTags = false;
        if (beginStr == null) {
            this.setBufferIndex(0);
        } else {
            this.setBufferIndex(begin + beginStr.length());
        }
        String str = this.getNextStr();
        while (!str.equals("") && this.getBufferIndex() < end) {
            String link;
            if (HtmlTokenizer.isHrefTag(str) && (link = TextUtils.getInnerQuotedString(str)) != null) {
                list.addElement(link);
            }
            str = this.getNextStr();
        }
        String[] out = new String[list.size()];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = (String)list.elementAt(n);
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return out;
    }

    public String[] getHRefsBetween(int begin, int end) {
        if (begin == -1 || end == -1) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.ignoreTags = false;
        this.setBufferIndex(begin);
        String str = this.getNextStr();
        while (!str.equals("") && this.getBufferIndex() < end) {
            String link;
            if (HtmlTokenizer.isHrefTag(str) && (link = TextUtils.getInnerQuotedString(str)) != null) {
                list.addElement(link);
            }
            str = this.getNextStr();
        }
        String[] out = new String[list.size()];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = (String)list.elementAt(n);
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return out;
    }

    public int findTag(String tagStr, int begin, boolean findEndOf) {
        int oldIndex = this.getBufferIndex();
        this.setBufferIndex(begin);
        int offset = this.searchFor(tagStr, findEndOf);
        this.setBufferIndex(oldIndex);
        return offset;
    }

    @Override
    public int searchFor(String pattern, boolean findEndOf) {
        String str = this.getNextStr();
        while (HtmlTokenizer.isOfType(str) != 0) {
            if (pattern.equalsIgnoreCase(str)) {
                if (!findEndOf) {
                    for (int i = 0; i < pattern.length(); ++i) {
                        this.ungetChar();
                    }
                    return this.getBufferIndex();
                }
                return this.getBufferIndex();
            }
            str = this.getNextStr();
        }
        return -1;
    }

    public int findARef(int begin, String name) {
        Vector list = new Vector();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.ignoreTags = false;
        this.setBufferIndex(begin);
        String str = this.getNextStr();
        while (!str.equals("")) {
            if (HtmlTokenizer.isArefTag(str)) {
                String[] tokens = TextUtils.tokenize(str, "=>");
                if (tokens == null || tokens.length == 0) continue;
                for (int n = 0; n < tokens.length; ++n) {
                    if (!TextUtils.removeQuotes(tokens[n]).equalsIgnoreCase(name)) continue;
                    int offset = this.getBufferIndex();
                    this.ignoreTags = oldFlag;
                    this.setBufferIndex(oldIndex);
                    return offset;
                }
            }
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return -1;
    }

    static {
        try {
            Field[] fields = new Field[]{HtmlTokenizer.class.getDeclaredField("_searchBodyTextFor")};
            Cutter.addDebug(HtmlTokenizer.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("    Error: HtmlTokenizer.static - " + ex.toString());
        }
    }
}

