/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Ifd;

import Preferences.Preferences;
import UI_Script.Ifd.IfdTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import javax.swing.text.StyleConstants;

public class IfdListener
extends SyntaxListener {
    public IfdListener(KTextPane textpane) {
        super(textpane, new IfdTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        char[] delim = new char[]{'-', '$'};
        textpane.addWordDelimitors(delim, delim);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_RIB_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RIB_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RIB_STATEMENT));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RIB_STRING));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_MEL_COMMAND));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_MEL_USER_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_RIB_STRING));
        StyleConstants.setUnderline(textpane.styleContext.stringStyle2, true);
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (this.tok.isCommand(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle4, true);
            return true;
        }
        return false;
    }

    @Override
    public void addComments() {
        this.addComments("#");
    }
}

