/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Ifd;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Ifd.IfdListener;
import UI_Script.Ifd.IfdTokenizer;
import UI_Script.Ifd.OpenIfdAction;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Script.Vfl.VflTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Monitor.Monitor;
import UI_Tools.Preferences.PrefsPanels.Languages.VFLPanel;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.text.Segment;

public class IfdScriptHandler
extends ScriptHandler
implements ProcListener {
    public static final String BASIC_IFD = "basic_ifd_template";
    public static final String TAM_IFD = "tam_ifd_template";
    private static ResourceBundle res;
    private StringBuffer buf = new StringBuffer();

    protected static String getDocString(String nm) {
        String str = null;
        try {
            str = res.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Error: IfdScriptHandler.getDocsSting()\n" + mre);
            str = null;
        }
        return str;
    }

    @Override
    public boolean canRunSelection() {
        return false;
    }

    public IfdScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".ifd";
        this.ext[1] = ".IFD";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new IfdTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.ifd");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Ifd";
    }

    @Override
    public String getExecuteLabel() {
        return "Execute " + this.getScriptName();
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(File file) {
        String unixPath = file.getPath().replace('\\', '/');
        String dosPath = Preferences.get(Preferences.PATH_HOUDINI_BIN).replace('\\', '/');
        String mantraCmd = dosPath.trim().length() == 0 ? "mantra" : "\"" + dosPath + "/mantra\"";
        String[] items = new String[]{mantraCmd, "-f", unixPath};
        ProcessManager fp = new ProcessManager("Mantra");
        fp.launch(items, null, false, this, false);
    }

    @Override
    public void processSentString(String procName, String output) {
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
    }

    @Override
    public void processFinished(String[] progarray) {
        Monitor.finalizePanelText("Mantra", "Rendering:\n");
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp.ifd");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return IfdListener.class.getName();
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Ifd");
        item.addActionListener(new OpenIfdAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    public static void createDocument(String title, String docType) {
        String docStr = IfdScriptHandler.getDocString(docType);
        templateBuffer.setLength(0);
        String[] lineItems = TextUtils.tokenize(docStr);
        for (int n = 0; n < lineItems.length; ++n) {
            String line = IfdScriptHandler.getDocString(lineItems[n]);
            templateBuffer.append(line);
        }
        BBxt.newDocument(title, templateBuffer);
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("ifd", "Houdini-Mantra Ifd");
        return filter;
    }

    @Override
    public String preprocessTemplateText(String inStr) {
        String pwdPath = FileUtils.getPWD();
        pwdPath = pwdPath.replace('\\', '/');
        String text = inStr.replaceAll("PATH_TO_CUTTER", pwdPath);
        File file = BBxt.getWindowFile();
        String ext = BBxt.getWindowExtension();
        if (ext == null || !ext.equalsIgnoreCase(".vfl")) {
            return text;
        }
        String shdName = VflTokenizer.vflGetShaderName(BBxt.getWindowText(new Segment()));
        if (shdName != null && shdName.trim().length() > 0) {
            text = text.replaceAll("NAME_OF_VFL_SHADER", shdName);
        }
        String otlPath = VFLPanel.getOTLPath();
        String otlDir = null;
        boolean otlNameIsShaderName = false;
        if (otlPath.trim().length() == 0) {
            otlNameIsShaderName = true;
            String string = otlPath = file == null ? null : file.getPath();
        }
        if (otlPath != null) {
            otlDir = new File(otlPath).getParent();
        }
        if (otlDir != null && otlDir.trim().length() != 0 && new File(otlDir).exists()) {
            otlDir = otlDir.replace('\\', '/');
            text = text.replaceAll("PATH_TO_OTL_DIRECTORY", otlDir);
        }
        if (otlPath != null && otlPath.trim().length() != 0 && new File(otlPath).exists()) {
            if (otlNameIsShaderName) {
                text = text.replaceAll("NAME_OF_OTL_FILE", shdName);
            } else {
                String name = new File(otlPath).getName();
                name = TextUtils.removeExtension(name);
                text = text.replaceAll("NAME_OF_OTL_FILE", name);
            }
        }
        return text;
    }

    static {
        try {
            res = ResourceBundle.getBundle("UI_Script.Ifd.IfdDocumentsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("IfdScriptHandler: a resource file is missing --> " + mre);
        }
    }
}

