/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Ifd;

import UI_Desktop.Cutter;
import UI_Script.Ifd.IFDStatementsRsrc;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class IfdTokenizer
extends Tokenizer {
    public static final String RAY_COMMAND = "r_command";
    public static final int UNKNOWN_FUNCTION_ID = 0;
    public static final int RAY_COMMAND_ID = 0;
    private static ResourceBundle IFDStatementsRes;
    private static Hashtable<String, String> statements;
    public boolean parseComments = false;

    private static String getStatement(String nm) {
        String str;
        try {
            str = IFDStatementsRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numStatements() {
        int num = 0;
        try {
            num = ((IFDStatementsRsrc)IFDStatementsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read IFDStatementsRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < IfdTokenizer.numStatements(); ++i) {
            statements.put(((IFDStatementsRsrc)IFDStatementsRes).getKey(i), ((IFDStatementsRsrc)IFDStatementsRes).getContent(i));
        }
    }

    public IfdTokenizer() {
        this.addQuotation("`", "`", '\\');
        this.addQuotation("\"", "\"", '\\');
        this.addComment("#", "\n");
        this.setSyntaxLength(1);
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.removeDelimitor("$");
        String[] ext = new String[]{"ifd", "IFD"};
        Tokenizer.addToRegistry(IfdTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    public IfdTokenizer(String filename) throws FileNotFoundException, IOException {
        super(filename);
        this.addQuotation("`", "`", '\\');
        this.addQuotation("\"", "\"", '\\');
        this.addComment("#", "\n");
        this.setSyntaxLength(1);
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.removeDelimitor("$");
    }

    @Override
    public boolean isFunction(String str) {
        if (!statements.containsKey(str)) {
            return false;
        }
        String obj = statements.get(str);
        return obj != null;
    }

    @Override
    public boolean isLanguageType(String str) {
        if (!statements.containsKey(str)) {
            return false;
        }
        return statements.get(str).equals("language");
    }

    @Override
    public boolean isCommand(String str) {
        return str.charAt(0) == '`';
    }

    @Override
    public boolean isUserVariable(String str) {
        return str.charAt(0) == '$';
    }

    public String __getNextStr() {
        boolean literal = false;
        boolean endOfString = false;
        boolean endOfComment = false;
        boolean command = false;
        this.outBuff.setLength(0);
        char c = this.readChar();
        if (c == '\u0000') {
            return "";
        }
        if (this.isSpace(c)) {
            c = this.removeSpace();
        }
        if (c == '\u0000') {
            return "";
        }
        this.outBuff.append(c);
        for (int n = 0; n < this.comments.length; ++n) {
            char[] chars = this.peekNextChars(this.comments[n].openLen - 1);
            String temp = c + (chars == null ? "" : new String(chars));
            if (!this.comments[n].isOpenComment(temp)) continue;
            while ((c = this.readChar()) != '\u0000') {
                String tail;
                this.outBuff.append(c);
                if (this.outBuff.length() < this.comments[n].openLen + this.comments[n].closeLen || !this.comments[n].isCloseComment(tail = this.outBuff.substring(this.outBuff.length() - this.comments[n].closeLen))) continue;
                return this.outBuff.toString();
            }
            return this.outBuff.toString();
        }
        if (this.isDelimitor(c)) {
            return this.outBuff.toString();
        }
        if (c == '\"') {
            literal = true;
        }
        if (c == '`') {
            command = true;
        }
        while (!endOfString && !this.mEndOfBuffer) {
            c = this.readChar();
            switch (c) {
                case '\u0000': {
                    return this.outBuff.toString();
                }
                case '`': {
                    if (literal) break;
                    if (command) {
                        this.outBuff.append(c);
                        return this.outBuff.toString();
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\"': {
                    if (literal) {
                        this.outBuff.append(c);
                        return this.outBuff.toString();
                    }
                    if (command) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': {
                    if (literal || command) break;
                    if (this.debug) {
                        Cutter.setLog("Parenthesis c = " + c + " buff = |" + this.outBuff.toString() + "|");
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\t': 
                case ' ': {
                    if (literal || command) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\n': 
                case '\r': {
                    if (literal || command) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '/': {
                    if (literal || command) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
            }
            this.outBuff.append(c);
        }
        return this.outBuff.toString();
    }

    private char nextValidChar() {
        this.ungetChar();
        char c = this.readChar();
        while (c == '#' || this.isSpace(c)) {
            if (this.isSpace(c) && (c = this.removeSpace()) == '\u0000') {
                return '\u0000';
            }
            while (c == '#' && !this.getComments) {
                while (c != '\r' && c != '\n') {
                    c = this.readChar();
                    if (!this.mEndOfBuffer) continue;
                    return '\u0000';
                }
                c = this.readChar();
                if (!this.isSpace(c) || (c = this.removeSpace()) != '\u0000') continue;
                return '\u0000';
            }
            if (!this.mEndOfBuffer) continue;
            return '\u0000';
        }
        return c;
    }

    @Override
    public boolean isNamedSpace(String s) {
        return false;
    }

    public String remove(String target) {
        int n;
        this.rewindBuffer();
        int start = this.searchFor(target, false);
        if (start == -1) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        for (n = 0; n < start; ++n) {
            out.append(this.mBuff[n]);
        }
        boolean doCopy = false;
        for (n = start + 1; n < this.mBuff.length && this.mBuff[n] != '\n'; ++n) {
        }
        out.append(this.mBuff, n, this.mBuff.length - n);
        return out.toString();
    }

    static {
        statements = new Hashtable();
        try {
            IFDStatementsRes = ResourceBundle.getBundle("UI_Script.Ifd.IFDStatementsRsrc");
        }
        catch (MissingResourceException mre) {
            System.err.println("    Error: IFDTokenizer = " + mre);
        }
        IfdTokenizer.initHashTable();
    }
}

