/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Java;

import UI_Desktop.Cutter;
import UI_Script.Cpp.CppTokenizer;
import UI_Script.Java.JavaLanguageRsrc;
import UI_Script.ScriptParser.ProcDBItem;
import Utilities.TextUtils;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class JavaTokenizer
extends CppTokenizer {
    private static ResourceBundle JavaLanguageRes;
    private static Hashtable<String, String> language;
    public static boolean _languageProfile;

    private static String getLanguage(String nm) {
        String str;
        try {
            str = JavaLanguageRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numLanguageItems() {
        int num = 0;
        try {
            num = ((JavaLanguageRsrc)JavaLanguageRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read CPPFunctionsRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < JavaTokenizer.numLanguageItems(); ++i) {
            language.put(((JavaLanguageRsrc)JavaLanguageRes).getKey(i), ((JavaLanguageRsrc)JavaLanguageRes).getContent(i));
        }
    }

    public JavaTokenizer() {
        this.setSyntaxLength(2);
        String[] ext = new String[]{"java", "JAVA"};
        Tokenizer.addToRegistry(JavaTokenizer.class, ext, this.getComments(), this.getDelimitors());
        this.name = "JavaTokenizer";
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        if (str == null) {
            return null;
        }
        if (this.isOpenComment(str)) {
            return null;
        }
        if (this.lpSkip(str, "import", ';') || this.lpSkip(str, "=", ';') || this.lpSkip(str, "class", '{')) {
            return null;
        }
        int index = this.getBufferIndex();
        Tokenizer.StringPosition[] tokens = str.equals("static") || str.equals("private") || str.equals("public") || str.equals("protected") || str.equals("abstract") ? new Tokenizer.StringPosition[5] : (str.equals("private") || str.equals("public") || str.equals("protected") ? new Tokenizer.StringPosition[4] : new Tokenizer.StringPosition[3]);
        tokens[0] = new Tokenizer.StringPosition(this, str, index);
        String s = this.getNextStr();
        if (str.equals("static") && s.equals("{")) {
            this.setBufferIndex(index);
            StringBuffer sb = new StringBuffer();
            int[] offset = this.lpGrabProcBody("{", "}", sb);
            return null;
        }
        int n = 1;
        while (!s.equals("")) {
            if (!(s.equals("[") || s.equals("]") || this.isOpenComment(s))) {
                tokens[n++] = new Tokenizer.StringPosition(this, s, this.getBufferIndex());
            }
            if (n >= tokens.length) break;
            s = this.getNextStr();
        }
        Tokenizer.StringPosition procName = null;
        Tokenizer.StringPosition openParen = null;
        switch (tokens.length) {
            case 5: {
                if (tokens[tokens.length - 3] != null && tokens[tokens.length - 3].equals("(")) {
                    procName = tokens[tokens.length - 4];
                    openParen = tokens[tokens.length - 3];
                    break;
                }
            }
            case 3: 
            case 4: {
                if (tokens[tokens.length - 1] != null && tokens[tokens.length - 1].equals("(")) {
                    procName = tokens[tokens.length - 2];
                    openParen = tokens[tokens.length - 1];
                    break;
                }
                if (tokens[tokens.length - 2] == null || !tokens[tokens.length - 2].equals("(")) break;
                procName = tokens[tokens.length - 3];
                openParen = tokens[tokens.length - 2];
                break;
            }
        }
        if (procName == null) {
            this.setBufferIndex(index);
            return null;
        }
        String enclosingName = "";
        for (int j = 0; j < this.listOfClassInterfaceSpans.size(); ++j) {
            Tokenizer.ClassInterfaceSpan cis = (Tokenizer.ClassInterfaceSpan)this.listOfClassInterfaceSpans.elementAt(j);
            if (procName.offset < cis.span[0] || procName.offset > cis.span[1]) continue;
            enclosingName = cis.name;
            break;
        }
        if (enclosingName.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        StringBuffer en = new StringBuffer();
        this.lpGetEnclosingNameAtIndex(en, procName.offset);
        enclosingName = en.toString();
        if (tokens.length == 3 && !this.isDataType(str) && !procName.equals(enclosingName)) {
            this.setBufferIndex(index);
            return null;
        }
        if (_languageProfile) {
            Cutter.setLog("ProcName >" + procName.toString() + "<");
        }
        this.setBufferIndex(openParen.offset - 1);
        if (this.lpGrabProcParams("(", ")") == null) {
            if (_languageProfile) {
                Cutter.setLog("Cannot find args for " + procName.str);
            }
            this.setBufferIndex(index);
            return null;
        }
        int[] offset = this.lpGrabProcBody("{", "}", null);
        if (procName.str.equals("if") || TextUtils.contains("*-+=/", procName.str.charAt(0)) || procName.str.equals(">") || procName.str.equals("<")) {
            return null;
        }
        if (offset == null) {
            if (_languageProfile) {
                Cutter.setLog("Cannot find body for " + procName.str);
            }
            this.setBufferIndex(index);
            return null;
        }
        ProcDBItem db = new ProcDBItem(enclosingName + "." + procName.str, procName.offset - procName.str.length(), procName.offset);
        db.procOffset[0] = offset == null ? 0 : db.procNameOffset[0];
        db.procOffset[1] = offset == null ? 0 : offset[1];
        return db;
    }

    @Override
    public boolean isFunction(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("function");
        }
        return super.isFunction(str);
    }

    @Override
    public boolean isDataType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("datatype");
        }
        return super.isDataType(str);
    }

    @Override
    public boolean isDataModifier(String str) {
        return false;
    }

    @Override
    public boolean isLanguageType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("language");
        }
        return super.isLanguageType(str);
    }

    static {
        language = new Hashtable();
        _languageProfile = false;
        try {
            Field[] fields = new Field[]{JavaTokenizer.class.getDeclaredField("_languageProfile")};
            Cutter.addDebug(JavaTokenizer.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: JavaTokenizer.static - " + ex.toString());
        }
        try {
            JavaLanguageRes = ResourceBundle.getBundle("UI_Script.Java.JavaLanguageRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: JavaTokenizer = " + mre);
        }
        JavaTokenizer.initHashTable();
    }
}

