/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Json;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Script.Json.JsonKeywordsRsrc;
import UI_Script.Json.JsonTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import Utilities.TextUtils;
import java.awt.Color;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.text.StyleConstants;

public class JsonListener
extends SyntaxListener {
    private static Hashtable<String, String> keywords = new Hashtable();
    private static ResourceBundle jsonRes;

    private static int numKeywords() {
        int num = 0;
        try {
            num = ((JsonKeywordsRsrc)jsonRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read JsonKeywordsRsrc");
        }
        return num;
    }

    public JsonListener(KTextPane textpane) {
        super(textpane, new JsonTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    public void _initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_TCL_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_TCL_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_TCL_USER_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_TCL_FUNCTION));
        Color blue = SyntaxListener.defaultLanguageColor;
        StyleConstants.setForeground(this.textpane.styleContext.keywordStyle2, blue);
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_TCL_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_TCL_STRING));
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.commentStyle2, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_BUILT_IN));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_MODULE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_FUNCTION));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_METHOD));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_STRING));
        StyleConstants.setUnderline(textpane.styleContext.stringStyle2, true);
        StyleConstants.setForeground(textpane.styleContext.keywordStyle5, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_CONSTANT));
        StyleConstants.setUnderline(textpane.styleContext.keywordStyle5, true);
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (str.equals("$") || str.equals("@")) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.languageStyle, true);
            return true;
        }
        if (keywords.containsKey(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle1, true);
            return true;
        }
        String str1 = TextUtils.removeQuotes(str);
        if (keywords.containsKey(str1)) {
            editList.addEdit(begin, str1.length(), this.textpane.styleContext.keywordStyle1, true);
            return true;
        }
        return false;
    }

    static {
        try {
            jsonRes = ResourceBundle.getBundle("UI_Script.Json.JsonKeywordsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Exception: JsonListener = " + mre);
        }
        for (int i = 0; i < JsonListener.numKeywords(); ++i) {
            keywords.put(((JsonKeywordsRsrc)jsonRes).getKey(i), ((JsonKeywordsRsrc)jsonRes).getContent(i));
        }
    }
}

