/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Json;

import UI_Desktop.Cutter;
import UI_Script.Json.JsonRsrc;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class JsonTokenizer
extends Tokenizer {
    private static ResourceBundle JsonStatementsRes;
    private static Hashtable<String, String> language;

    private static String getFunction(String nm) {
        String str;
        try {
            str = JsonStatementsRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numFunctions() {
        int num = 0;
        try {
            num = ((JsonRsrc)JsonStatementsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read JsonRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < JsonTokenizer.numFunctions(); ++i) {
            language.put(((JsonRsrc)JsonStatementsRes).getKey(i), ((JsonRsrc)JsonStatementsRes).getContent(i));
        }
    }

    public JsonTokenizer() {
        this.addComment("/*", "*/");
        this.addComment("//", "\n");
        String[] ext = new String[]{"json", "JSON"};
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.removeDelimitor(".-");
    }

    public void addDelimitor(char c) {
        this.delimitors = this.delimitors + c;
    }

    static {
        language = new Hashtable();
        try {
            JsonStatementsRes = ResourceBundle.getBundle("UI_Script.Json.JsonRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Exception: JsonTokenizer = " + mre);
        }
        JsonTokenizer.initHashTable();
    }
}

