/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Lpe;

import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Lpe.LpeExpressionCalls;
import UI_Script.Lpe.LpeStrings;
import UI_Text.KTextPane.KTextPane;
import Utilities.BrowserUtils;
import Utilities.FileUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class LpeHelp
extends KAbstractHelp {
    public LpeHelp(KTextPane textpane) {
        super(textpane);
        this.completer.completionDeActivate();
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
        this.completer.completionDeActivate();
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        int begin = insertAt - selection.length();
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, insertAt - selection.length(), insertAt);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null || items[n] instanceof KAbstractHelp.KPopupMenuItem && items[n] != null && ((KAbstractHelp.KPopupMenuItem)items[n]).getText() != null && ((KAbstractHelp.KPopupMenuItem)items[n]).getText().contains("Completion")) continue;
            defaultMenu.add(items[n]);
        }
        JMenu lpe1_menu = this.getBasicLPEs("Basic LPEs", selection, insertAt);
        popup.add(lpe1_menu);
        JMenu lpeG_menu = this.getLobeLPEs("Lobe LPEs", selection, insertAt);
        popup.add(lpeG_menu);
        JMenu lpe2_menu = this.getHoldoutLPEs("Holdout LPEs", selection, insertAt);
        if (Cutter.EXPOSE_RMS20) {
            popup.add(lpe2_menu);
        }
        popup.add(new JSeparator());
        popup.add(this.showLpeHelp(e.isShiftDown()));
        popup.add(this.showPxrDoc());
        popup.add(new JSeparator());
        popup.add(defaultMenu);
        if (popup != null) {
            popup.setRequestFocusEnabled(false);
            try {
                popup.show(this.textpane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:LpeHelp.showPxrDoc()\n      " + ex.toString());
            }
        }
    }

    private JMenuItem showLpeHelp(final boolean wantsExternalBrowser) {
        JMenuItem item = new JMenuItem("Quick Reference");
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = new File(FileUtils.getPWD(), "LPE_Help.html");
                FileUtils.writeFile(f, LpeStrings.ShortHelp);
                BrowserUtils.open("file:" + f.getPath(), wantsExternalBrowser);
                Cutter.htmlWindow.setTitle("LPE Quick Reference");
                KAbstractDesktop.toFront(Cutter.htmlWindow, true);
            }
        };
        item.addActionListener(action);
        return item;
    }

    private JMenuItem showPxrDoc() {
        JMenuItem item = new JMenuItem("Pixar LPE Documentation");
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String index = "https://rmanwiki.pixar.com/display/REN/Light+Path+Expressions#LightPathExpressions-LPETokens";
                try {
                    BrowserUtils.open(index);
                }
                catch (Exception e) {
                    Cutter.setLog("    Error: LpeHelp.showPxrDoc() cannot load url \"" + index + "\"");
                }
            }
        };
        item.addActionListener(action);
        return item;
    }

    private JMenu getBasicLPEs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        LpeExpressionCalls calls = new LpeExpressionCalls(this.textpane);
        menu.add(calls.directDiffuse(sel, at));
        menu.add(calls.directSpecular(sel, at));
        menu.add(calls.emission(sel, at));
        menu.add(calls.indirectDiffuse(sel, at));
        menu.add(calls.indirectSpecular(sel, at));
        menu.add(calls.subsurface(sel, at));
        menu.add(calls.refraction(sel, at));
        menu.add(calls.shadowcollector(sel, at));
        menu.add(calls.caustics(sel, at));
        return menu;
    }

    private JMenu getLobeLPEs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        LpeExpressionCalls calls = new LpeExpressionCalls(this.textpane);
        menu.add(calls.directDiffuseLobe(sel, at));
        menu.add(calls.directSpecularClearcoatLobe(sel, at));
        menu.add(calls.directSpecularIridescenceLobe(sel, at));
        menu.add(calls.directSpecularFuzzLobe(sel, at));
        menu.add(calls.directSpecularGlassLobe(sel, at));
        menu.add(calls.directSpecularPrimaryLobe(sel, at));
        menu.add(calls.directSpecularRoughLobe(sel, at));
        menu.add(calls.indirectDiffuseLobe(sel, at));
        menu.add(calls.indirectSpecularClearcoatLobe(sel, at));
        menu.add(calls.indirectSpecularIridescenceLobe(sel, at));
        menu.add(calls.indirectSpecularFuzzLobe(sel, at));
        menu.add(calls.indirectSpecularGlassLobe(sel, at));
        menu.add(calls.indirectSpecularPrimaryLobe(sel, at));
        menu.add(calls.indirectSpecularRoughLobe(sel, at));
        menu.add(calls.subsurfaceLobe(sel, at));
        menu.add(calls.transmissiveGlassLobe(sel, at));
        menu.add(calls.transmissiveSingleScatterLobe(sel, at));
        return menu;
    }

    private JMenu getHoldoutLPEs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        LpeExpressionCalls calls = new LpeExpressionCalls(this.textpane);
        menu.add(calls.HoldoutShadows(sel, at));
        menu.add(calls.HoldoutReflections(sel, at));
        menu.add(calls.HoldoutIndirectdiffuse(sel, at));
        menu.add(calls.HoldoutSubsurface(sel, at));
        menu.add(calls.HoldoutRefraction(sel, at));
        return menu;
    }

    @Override
    protected void lookup(String item) {
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        return false;
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }
}

