/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Lpe;

import Preferences.Preferences;
import UI_Script.Lpe.LpeTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public class LpeListener
extends SyntaxListener {
    static String[] evtTypes = new String[]{"C", "R", "T", "V", "L", "O"};
    static String[] sctTypes = new String[]{"D", "S"};
    static String[] regTypes = new String[]{".", "+", "*"};
    static String[] lpePrefixes = new String[]{"unoccluded", "noclamp", "nothruput", "shadows", "holdout", "overwrite", "noinfinitecheck"};

    public LpeListener(KTextPane textpane, Tokenizer tok) {
        super(textpane, tok);
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    public LpeListener(KTextPane textpane) {
        super(textpane, new LpeTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        char[] delim = new char[]{'-', '$'};
        textpane.addWordDelimitors(delim, delim);
        char[] begin = new char[]{'$'};
        textpane.removeWordDelimitors(begin, null);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_LPE_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_LPE_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_LPE_KEYWORD));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_LPE_EVENTYPE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_LPE_SCATTERTYPE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_LPE_RE_QUALIFIER));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_LPE_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_LPE_STRING));
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        String ch;
        int n;
        int endQ;
        boolean handled = false;
        editList.addEdit(begin, str.length(), this.textpane.styleContext.plainStyle, true);
        int beginQ = str.indexOf("'", 0);
        if (beginQ != -1) {
            endQ = str.indexOf("'", beginQ + 1);
            editList.addEdit(beginQ + begin, endQ - beginQ, this.textpane.styleContext.stringStyle2, true);
            handled = true;
        }
        for (n = 0; n < evtTypes.length; ++n) {
            ch = evtTypes[n];
            beginQ = str.indexOf(ch, 0);
            if (beginQ == -1) continue;
            endQ = beginQ;
            editList.addEdit(beginQ + begin, 1, this.textpane.styleContext.keywordStyle2, true);
            handled = true;
        }
        for (n = 0; n < sctTypes.length; ++n) {
            ch = sctTypes[n];
            beginQ = str.indexOf(ch, 0);
            if (beginQ == -1) continue;
            endQ = beginQ;
            editList.addEdit(beginQ + begin, 1, this.textpane.styleContext.keywordStyle3, true);
            handled = true;
        }
        for (n = 0; n < regTypes.length; ++n) {
            ch = regTypes[n];
            beginQ = str.indexOf(ch, 0);
            if (beginQ == -1) continue;
            endQ = beginQ;
            editList.addEdit(beginQ + begin, 1, this.textpane.styleContext.keywordStyle4, true);
            handled = true;
        }
        return handled;
    }

    @Override
    public void addComments() {
        this.addComments("#");
    }
}

