/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Lpe;

import UI_Script.Lpe.LpeListener;
import kernal.Tokenizers.Tokenizer;

public class LpeTokenizer
extends Tokenizer {
    public LpeTokenizer() {
        this.addComment("#", "\n");
        char[] esc_chars = new char[]{'\\', '^'};
        this.addQuotation("'", "'", esc_chars);
        this.setSyntaxLength(1);
        this.addEscape("\\\"", "");
        this.addEscape("^\"", "");
        this.addEscape("\\\\", "");
        this.addEscape("\\'", "");
        this.addEscape("\\[", "");
        this.addEscape("\\]", "");
        this.addEscape("\\{", "");
        this.addEscape("\\}", "");
        this.addEscape("\\$", "");
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.appendDelimitor(">");
        this.appendDelimitor("<");
        this.grabCSystemHeader = false;
        this.removeDelimitor("$-");
        String[] ext = new String[]{"lpe", "LPE"};
        Tokenizer.addToRegistry(LpeTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public boolean isLanguageType(String str) {
        if (str.equals("color") || str.equals("float")) {
            // empty if block
        }
        return false;
    }

    @Override
    public boolean isFunction(String str) {
        for (int n = 0; n < LpeListener.lpePrefixes.length; ++n) {
            if (!str.equals(LpeListener.lpePrefixes[n])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSystemHeader(String str) {
        return false;
    }
}

