/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Make;

import Preferences.Preferences;
import UI_Script.Make.MakeTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public class MakeListener
extends SyntaxListener {
    private MakeTokenizer mk = new MakeTokenizer();

    public MakeListener(KTextPane textpane, Tokenizer tok) {
        super(textpane, tok);
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    public MakeListener(KTextPane textpane) {
        super(textpane, new MakeTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        char[] bothEnds = new char[]{'(', ')', '$', '@', ':', '=', '&'};
        textpane.removeWordDelimitors(bothEnds, bothEnds);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_TCL_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_TCL_USER_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_TCL_FUNCTION));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_TCL_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_TCL_STRING));
    }

    @Override
    protected void colorizeLiteral(int offset, String str, StyleEdits editList) {
        this.mk.setBuffer(str);
        this.mk.getComments = true;
        String s = this.mk.getNextStr();
        while (!s.equals("")) {
            int index = this.mk.getBufferIndex() - 1 < 0 ? 0 : this.mk.getBufferIndex();
            int begin = (index += offset) - s.length();
            int length = s.length();
            if (this.mk.isUserVariable(s)) {
                int i;
                if (s.charAt(0) == '-') {
                    editList.addEdit(begin, 1, this.textpane.styleContext.stringStyle1, true);
                    length = s.length() - 1;
                    editList.addEdit(++begin, length, this.textpane.styleContext.keywordStyle3, true);
                }
                if ((i = s.indexOf(92)) != -1) {
                    editList.addEdit(begin, length, this.textpane.styleContext.keywordStyle3, true);
                    editList.addEdit(begin += i, length -= i, this.textpane.styleContext.stringStyle1, true);
                } else {
                    editList.addEdit(begin, s.length(), this.textpane.styleContext.keywordStyle3, true);
                }
            } else {
                editList.addEdit(begin, s.length(), this.textpane.styleContext.stringStyle1, true);
            }
            s = this.mk.getNextStr();
        }
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (str.charAt(0) == '\"') {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.stringStyle1, true);
            String tmp = str.substring(1, str.length() - 0);
            if (tmp.length() > 0) {
                this.colorizeLiteral(begin + 1, tmp, editList);
                return true;
            }
            return false;
        }
        int index = str.indexOf(36);
        if (index != -1) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.plainStyle, true);
            editList.addEdit(begin + index, str.length() - index, this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (str.charAt(0) == '@' || str.charAt(str.length() - 1) == '@') {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.languageStyle, true);
            return true;
        }
        if (begin > 0 && str.equals(">") && (this.tok.peekAtChar(begin - 1) == '1' || this.tok.peekAtChar(begin - 1) == '2')) {
            editList.addEdit(begin - 1, 2, this.textpane.styleContext.languageStyle, true);
            return true;
        }
        return false;
    }

    @Override
    public void addComments() {
        this.addComments("#");
    }
}

