/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Make;

import Processes.ProcListener;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Make.MakeListener;
import UI_Script.Make.MakeTokenizer;
import UI_Script.Make.OpenMakeAction;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Monitor.Monitor;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MakeScriptHandler
extends ScriptHandler
implements ProcListener {
    public static final String DUMMY = "not_implemented";
    private static ResourceBundle res;

    protected static String getDocString(String nm) {
        String str = null;
        try {
            str = res.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Error: MakeScriptHandler.getDocsSting()\n" + mre);
            str = null;
        }
        return str;
    }

    @Override
    public boolean canRunSelection() {
        return false;
    }

    public MakeScriptHandler() {
        this.ext = null;
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new MakeTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.make");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "MakeFile";
    }

    @Override
    public String getExecuteLabel() {
        return "make " + BBxt.getWindowTitle();
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(File file) {
        String[] items = new String[]{"make", "-f", file.getPath()};
        ProcessManager fp = new ProcessManager("Make");
        fp.launch(items, file.getParentFile(), true, this, false);
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp.make");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public void processSentString(String procName, String output) {
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
        String[] strs = new String[]{"error", "stop", "Undefined Symbols"};
        Monitor.initErrorStrings("Make", strs);
    }

    @Override
    public void processFinished(String[] progarray) {
        Monitor.finalizePanelText("Make", "Make completed:\n");
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return MakeListener.class.getName();
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Makefile");
        item.addActionListener(new OpenMakeAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    @Override
    public JMenu getTemplateMenu() {
        JMenu mk = new JMenu("Make");
        return mk;
    }

    public static void createDocument(String title, String docType) {
        String docStr = MakeScriptHandler.getDocString(docType);
        templateBuffer.setLength(0);
        String[] lineItems = TextUtils.tokenize(docStr);
        for (int n = 0; n < lineItems.length; ++n) {
            String line = MakeScriptHandler.getDocString(lineItems[n]);
            templateBuffer.append(line);
        }
        BBxt.newDocument(title, templateBuffer);
    }

    @Override
    public KFileFilter getFileFilter() {
        return null;
    }

    static {
        try {
            res = ResourceBundle.getBundle("UI_Script.Make.MakeDocumentsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("MakeScriptHandler: a resource file is missing --> " + mre);
        }
    }
}

