/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Make;

import UI_Desktop.Cutter;
import UI_Script.Make.MakeLanguageRsrc;
import UI_Script.ScriptParser.ProcDBItem;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class MakeTokenizer
extends Tokenizer {
    private static ResourceBundle MakeLanguageRes;
    public static Hashtable<String, String> language;

    private static String getLanguage(String nm) {
        String str;
        try {
            str = MakeLanguageRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numLanguageItems() {
        int num = 0;
        try {
            num = ((MakeLanguageRsrc)MakeLanguageRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read MakeLanguageRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < MakeTokenizer.numLanguageItems(); ++i) {
            language.put(((MakeLanguageRsrc)MakeLanguageRes).getKey(i), ((MakeLanguageRsrc)MakeLanguageRes).getContent(i));
        }
    }

    public MakeTokenizer() {
        this.addComment("#", "\n");
        char[] esc_chars = new char[]{'\\', '^'};
        this.addQuotation("\"", "\"", esc_chars);
        this.setSyntaxLength(1);
        this.addEscape("\\\"", "");
        this.addEscape("^\"", "");
        this.addEscape("\\\\", "");
        this.addEscape("\\'", "");
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.removeDelimitor("$-()@+:=&<");
        String[] ext = null;
        Tokenizer.addToRegistry(MakeTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        return null;
    }

    @Override
    public boolean isUserVariable(String str) {
        if (this.isLanguageType(str)) {
            return false;
        }
        if (str.charAt(0) == '$') {
            return true;
        }
        return str.length() > 1 && str.charAt(0) == '-' && str.charAt(1) == '$';
    }

    public boolean isCommandSubstitution(String str) {
        return str.charAt(0) == '[';
    }

    @Override
    public boolean isFunction(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("function");
        }
        return false;
    }

    @Override
    public boolean isLanguageType(String str) {
        if (language.containsKey(str.trim())) {
            return language.get(str.trim()).equals("language");
        }
        return false;
    }

    static {
        language = new Hashtable();
        try {
            MakeLanguageRes = ResourceBundle.getBundle("UI_Script.Make.MakeLanguageRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: MakeLanguageRes = " + mre);
        }
        MakeTokenizer.initHashTable();
    }
}

