/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Mel;

import Preferences.Preferences;
import UI_Components.ToolTip.MultiLineToolTip;
import UI_Desktop.Cutter;
import UI_Script.Mel.MelHelp;
import UI_Script.Mel.MelTokenizer;
import UI_Script.Mel.ShaderProgress;
import Utilities.FileUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import kernal.Searchers.HTMLSearch;
import kernal.Searchers.SearchResult;
import kernal.Tokenizers.Tokenizer;

public class MelDocsDB {
    public static final String REFER_TO_FULL_DOCS = "Refer to full documentation";
    public static final int MENU_ABBREVIATION_LNGTH = 5;
    public static final String MELDOCS_45_CACHE_FILENAME = "mel_45_docs_cache.txt";
    public static final String CACHE_VERSION_45_STR = "version 4-5";
    public static final String MELDOCS_6_CACHE_FILENAME = "mel_6_docs_cache.txt";
    public static final String MELDOCS_6_COMMANDS = "mel_6_commands.txt";
    public static final String CACHE_VERSION_6_STR = "version 6";
    public static Hashtable<String, MelDocsDB> cache = null;
    public static int flagCount = 0;
    private Vector<DBItem> items = new Vector();
    public Vector<String> related = new Vector();
    private String commandName = "";
    private String commandDesc = "No description available.";
    public static Vector<String> listOfCommandsWithDuplicateFlags = new Vector();

    public int searchFor(String item) {
        if (item == null || item.length() == 0) {
            return 0;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(this.commandDesc + " ");
        for (int n = 0; n < this.items.size(); ++n) {
            DBItem i = this.items.elementAt(n);
            buff.append(i.desc + " ");
        }
        Tokenizer tok = new Tokenizer();
        tok.setBuffer(buff.toString());
        int[] offset = tok.searchFor(item, true, true);
        if (offset == null) {
            return 0;
        }
        int begin = offset[1];
        int counter = 1;
        while (begin < tok.getBufferLength()) {
            tok.setBufferIndex(begin);
            offset = tok.searchFor(item, true, true);
            if (offset == null) {
                return counter;
            }
            begin = offset[1];
            ++counter;
        }
        return counter;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.commandName + "\n");
        s.append(this.commandDesc + "\n");
        for (int n = 0; n < this.items.size(); ++n) {
            DBItem item = this.items.elementAt(n);
            s.append(item.shortFlag + " " + item.longFlag + "\n");
            s.append("  " + item.desc + "\n");
        }
        return s.toString();
    }

    public MelDocsDB(String name) {
        this.commandName = name;
    }

    public String getName() {
        return this.commandName;
    }

    public void setMainDescription(String str) {
        String tmp = TextUtils.format(str, MultiLineToolTip.DEFAULT_TIP_TEXT_WIDTH, MultiLineToolTip.DEFAULT_TIP_TEXT_LENGTH, REFER_TO_FULL_DOCS);
        this.commandDesc = tmp == null || tmp.length() == 0 ? this.commandDesc : tmp;
    }

    public String getMainDescription() {
        return this.commandDesc;
    }

    public void addFlag(String flag1, String flag2) {
        if (flag1 == null || flag2 == null) {
            return;
        }
        if (flag1.charAt(0) == '-') {
            flag1 = flag1.substring(1);
        }
        if (flag2.charAt(0) == '-') {
            flag2 = flag2.substring(1);
        }
        this.items.addElement(new DBItem(flag1, flag2));
    }

    public void addFlag(String flag1, String flag2, String desc) {
        if (flag1 == null || flag2 == null || desc == null) {
            return;
        }
        if (flag1.charAt(0) == '-') {
            flag1 = flag1.substring(1);
        }
        if (flag2.charAt(0) == '-') {
            flag2 = flag2.substring(1);
        }
        for (int n = 0; n < this.items.size(); ++n) {
            if (!this.items.elementAt((int)n).shortFlag.equals(flag1) || !this.items.elementAt((int)n).longFlag.equals(flag2)) continue;
            listOfCommandsWithDuplicateFlags.addElement(this.getName() + ": duplicated flags long name -" + flag1 + " short name -" + flag2);
            return;
        }
        this.items.addElement(new DBItem(flag1, flag2, desc));
    }

    public void addDescAt(String str, int index) {
        this.addDescAt(str, index, MultiLineToolTip.DEFAULT_TIP_TEXT_WIDTH);
    }

    public void addDescAt(String str, int index, int lineLength) {
        if (str == null || str.trim().length() == 0) {
            return;
        }
        if (index > this.items.size()) {
            Cutter.setLog("    Warning: MelDocsDB.addDescAt(str,int,int) str = >" + str + "< vector of items size is " + this.items.size() + " but index is " + index);
            return;
        }
        if (str.endsWith("-.")) {
            str = str.substring(0, str.length() - 2).trim();
        }
        DBItem item = new DBItem();
        item.copy(this.items.elementAt(index));
        str = str.trim();
        item.desc = TextUtils.format(str, lineLength);
        if (item.desc == null || item.desc.length() == 0) {
            item.desc = "No description available";
        }
        this.items.setElementAt(item, index);
    }

    public void addRelated(String item) {
        this.related.addElement(TextUtils.removeExtension(item));
    }

    public void addRelated(String[] items) {
        if (items == null || items.length == 0) {
            return;
        }
        for (int n = 0; n < items.length; ++n) {
            this.addRelated(items[n]);
        }
    }

    public void addRelated(String str, String separator) {
        if (str == null || str.length() == 0 || separator == null) {
            return;
        }
        String[] hrefs = TextUtils.tokenize(str, separator);
        if (hrefs != null && hrefs.length > 0) {
            this.addRelated(hrefs);
        }
    }

    public int flagCount() {
        return this.items.size();
    }

    public int relatedCount() {
        return this.related.size();
    }

    public String getShortFlagAt(int n) {
        return n >= this.items.size() ? null : this.items.elementAt((int)n).shortFlag;
    }

    public String getLongFlagAt(int n) {
        return n >= this.items.size() ? null : this.items.elementAt((int)n).longFlag;
    }

    public String getDescAt(int n) {
        return n >= this.items.size() ? null : this.items.elementAt((int)n).desc;
    }

    public String getRelatedAt(int n) {
        return n >= this.related.size() ? null : this.related.elementAt(n);
    }

    public void setAddedToMenu(int n, boolean done) {
        if (n >= this.items.size()) {
            return;
        }
        DBItem item = new DBItem();
        item.copy(this.items.elementAt(n));
        item.addedToMenu = done;
        this.items.setElementAt(item, n);
    }

    public boolean getAddedToMenu(int n) {
        return n >= this.items.size() ? true : this.items.elementAt((int)n).addedToMenu;
    }

    public void sortByAlpha() {
        Collator collator = Collator.getInstance(Locale.ENGLISH);
        for (int n = 0; n < this.items.size(); ++n) {
            for (int i = n + 1; i < this.items.size(); ++i) {
                String currFlag = this.items.elementAt((int)n).longFlag;
                String nextFlag = this.items.elementAt((int)i).longFlag;
                if (collator.compare(currFlag, nextFlag) <= 0) continue;
                DBItem nTmp = new DBItem();
                DBItem iTmp = new DBItem();
                nTmp.copy(this.items.elementAt(n));
                iTmp.copy(this.items.elementAt(i));
                this.items.setElementAt(nTmp, i);
                this.items.setElementAt(iTmp, n);
            }
        }
    }

    public static MelDocsDB getFromCache(String itemname) {
        if (cache != null) {
            return cache.get(itemname);
        }
        return null;
    }

    public static void putIntoCache(MelDocsDB db) {
        if (cache != null) {
            cache.put(db.getName(), db);
        }
    }

    public static int cacheSize() {
        return cache == null ? -1 : cache.size();
    }

    public static boolean cacheContains(String item) {
        if (item == null || item.length() == 0 || cache == null) {
            return false;
        }
        return cache.containsKey(item);
    }

    public static MelDocsDB[] getCacheItemsWithPrefix(String prefix) {
        if (MelTokenizer.sortedFunctionNames == null || cache == null) {
            return null;
        }
        Vector<MelDocsDB> list = new Vector<MelDocsDB>();
        for (int n = 0; n < MelTokenizer.sortedFunctionNames.length; ++n) {
            MelDocsDB db;
            String item = MelTokenizer.sortedFunctionNames[n];
            if (item == null || !item.startsWith(prefix) || (db = cache.get(item)) == null) continue;
            list.addElement(db);
        }
        MelDocsDB[] out = new MelDocsDB[list.size()];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = (MelDocsDB)list.elementAt(n);
        }
        return out;
    }

    public static Vector cacheGetAll() {
        Enumeration<String> e = cache.keys();
        Vector<MelDocsDB> list = new Vector<MelDocsDB>();
        while (e.hasMoreElements()) {
            MelDocsDB db;
            String key = e.nextElement();
            if (key == null || (db = cache.get(key)) == null) continue;
            list.addElement(db);
        }
        return list;
    }

    public static String[] cacheGetAllDocPaths() {
        Vector list = MelDocsDB.cacheGetAll();
        String[] out = new String[list.size()];
        String parentPath = Preferences.get(Preferences.PATH_MEL_DOCS);
        for (int n = 0; n < list.size(); ++n) {
            MelDocsDB db = (MelDocsDB)list.elementAt(n);
            out[n] = new File(parentPath, db.getName()).getPath();
        }
        return out;
    }

    public static Vector cacheItemsStrSearch(String item) {
        if (item == null || item.length() == 0 || cache == null) {
            return null;
        }
        Enumeration<String> e = cache.keys();
        int maxHits = 0;
        int hits = 0;
        int count = 0;
        int indexOfBestHit = -1;
        Vector<SearchResult> listOfResults = new Vector<SearchResult>();
        String parentPath = Preferences.get(Preferences.PATH_MEL_DOCS);
        String pathOfBestHit = null;
        while (e.hasMoreElements()) {
            MelDocsDB db;
            String key = e.nextElement();
            if (key == null || (db = cache.get(key)) == null) continue;
            hits = db.searchFor(item);
            if (hits > 0) {
                ++count;
                listOfResults.addElement(new SearchResult(db.getName() + ".html", hits));
            }
            if (hits <= maxHits) continue;
            maxHits = hits;
            pathOfBestHit = db.getName() + ".html";
        }
        Vector<SearchResult> out = new Vector<SearchResult>();
        out.addElement(new SearchResult(pathOfBestHit, maxHits));
        int max = maxHits - 1;
        while (out.size() <= 10) {
            for (int i = 0; i < listOfResults.size(); ++i) {
                if (out.size() > 10) {
                    return out;
                }
                if (((SearchResult)listOfResults.elementAt((int)i)).hits != max) continue;
                out.addElement((SearchResult)listOfResults.elementAt(i));
            }
            if (--max > 0) continue;
            return out;
        }
        if (out.size() == 0) {
            return null;
        }
        return out;
    }

    public static void writeCacheFile(MelHelp helper) {
        File commandsListFile = null;
        Cutter.setLog("MelDocsDB.writeCacheFile() - using MelDocsV6");
        File cacheFile = new File(FileUtils.getPWD(), "Cutter_Help/mel/mel_6_docs_cache.txt");
        commandsListFile = new File(FileUtils.getPWD(), "Cutter_Help/mel/mel_6_commands.txt");
        String versionStr = CACHE_VERSION_6_STR;
        String base = Preferences.get(Preferences.PATH_MEL_DOCS);
        String commandDirPath = base.equals("") ? new File(FileUtils.getPWD(), "Cutter_Help/mel/Commands").getPath() : base;
        HTMLSearch search = new HTMLSearch(commandDirPath);
        search.INDEX_PAGE = "index_all.html";
        String[] names = search.getTargetPaths();
        StringBuffer buff = new StringBuffer();
        StringBuffer listOfCommandNames = new StringBuffer();
        buff.append(versionStr + "\n");
        Cutter.setLog("MelDocsDB.writeCacheFile for " + names.length + " items");
        int totalFlagCount = 0;
        for (int n = 0; n < names.length; ++n) {
            String s;
            int i;
            String name;
            if (n % 50 == 0) {
                Cutter.setLog("MelDocsDB.writeCacheFile written " + n + " of " + names.length + " items");
            }
            if ((name = TextUtils.removeExtension(names[n])) == null) continue;
            MelDocsDB db = helper.getDocsDBFor(name, true);
            if (db == null) {
                Cutter.setLog("    Warning: MelDocsDB.writeCacheFile() - " + name + " does not appear to be a command");
            }
            if (db == null) continue;
            listOfCommandNames.append(name + "\n");
            buff.append("name \"" + name).append("\"\n");
            String desc = db.getMainDescription();
            if (desc == null) continue;
            desc = desc.replace('\n', ' ');
            buff.append("\tdesc \"" + desc).append("\"\n");
            totalFlagCount += db.flagCount();
            buff.append("\tfcount \"" + db.flagCount()).append("\"\n");
            for (i = 0; i < db.flagCount(); ++i) {
                buff.append("\tfnames \"" + db.getShortFlagAt(i) + " " + db.getLongFlagAt(i) + "\"\n");
                s = db.getDescAt(i);
                if (s == null) continue;
                if (s.endsWith("-.")) {
                    s = s.substring(0, s.length() - 2).trim();
                }
                buff.append("\t\tfdesc \"" + s.replace('\n', ' ')).append("\"\n");
            }
            buff.append("\trcount \"" + db.relatedCount()).append("\"\n");
            for (i = 0; i < db.relatedCount(); ++i) {
                s = db.getRelatedAt(i);
                if (s == null) continue;
                buff.append("\t\trname \"" + db.getRelatedAt(i) + "\"\n");
            }
        }
        FileUtils.writeFile(cacheFile, buff.toString());
        if (commandsListFile != null) {
            listOfCommandNames.append("Total flag count = " + totalFlagCount);
            FileUtils.writeFile(commandsListFile, listOfCommandNames.toString());
        }
        Cutter.setLog("MelDocsDB.writeCacheFile finished.");
        String[] dups = VectorUtils.toStringArray(listOfCommandsWithDuplicateFlags);
        Cutter.setLog("listOfCommandsWithDuplicateFlags___________");
        Cutter.setLog(dups);
        Cutter.setLog("_____________________________");
    }

    public static void initCache() {
    }

    public static void readCacheFile(ShaderProgress progress) {
        File cacheFile = new File(FileUtils.getPWD(), "Cutter_Help/mel/mel_6_docs_cache.txt");
        if (!cacheFile.exists()) {
            Cutter.setLog("    Debug:MelDocsDB.readCacheFile() - MelDocsDB.readCacheFile() - couldn't find docs in Cutter_Help/mel/");
            return;
        }
        Enumeration<String> e = FileUtils.readLines(cacheFile.getPath());
        if (e == null) {
            return;
        }
        String line = e.nextElement();
        if (!line.startsWith("version")) {
            Cutter.setLog("    Debug:MelDocsDB.readCacheFile() - The first line of the MEL cache file does not contain \"version\"");
            return;
        }
        String MelProcName = "";
        String flagName = null;
        MelDocsDB db = null;
        boolean debug = false;
        int totalItemCount = 0;
        int totalLineCount = 0;
        try {
            while (e.hasMoreElements()) {
                line = e.nextElement();
                ++totalLineCount;
                if (line.length() == 0) continue;
                String[] nameValue = MelDocsDB.getNameValue(line);
                line = null;
                if (nameValue == null) {
                    Cutter.setLog("    Debug:MelDocsDB.readCacheFile() - could not get nameValue pair from line >" + line + "<");
                    continue;
                }
                flagName = nameValue[1];
                if (nameValue[0].equals("name")) {
                    int flagID;
                    db = new MelDocsDB(nameValue[1]);
                    MelProcName = nameValue[1];
                    if (progress != null && ++totalItemCount % 16 == 0) {
                        progress.incrValue(16);
                        progress.tf.setText(MelProcName);
                        try {
                            Thread.currentThread();
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                        }
                    }
                    if ((nameValue = MelDocsDB.getNameValue(e.nextElement()))[0].equals("desc")) {
                        db.setMainDescription(nameValue[1]);
                    }
                    if ((nameValue = MelDocsDB.getNameValue(e.nextElement()))[0].equals("fcount") && !nameValue[1].equals("\"0\"")) {
                        boolean done = false;
                        line = e.nextElement();
                        flagID = 0;
                        while (!done) {
                            nameValue = MelDocsDB.getNameValue(line);
                            if (nameValue[0].equals("fnames")) {
                                ++flagCount;
                                String[] flags = MelDocsDB.getFlags(nameValue[1]);
                                db.addFlag(flags[0], flags[1]);
                                line = e.nextElement();
                                nameValue = MelDocsDB.getNameValue(line);
                                if (nameValue[0].equals("fdesc")) {
                                    db.addDescAt(nameValue[1], flagID++);
                                } else {
                                    if (debug) {
                                        Cutter.setLog("    Debug:MelDocsDB.readCacheFile() - No Flag Description for Mel procedure >" + MelProcName + "<  flag >" + flags[0] + "<");
                                        Cutter.setLog("    Debug: line >" + line + "<");
                                    }
                                    db.addDescAt("no description", flagID++);
                                    if (nameValue[0].equals("rcount")) {
                                        done = true;
                                        break;
                                    }
                                }
                            } else {
                                done = true;
                            }
                            if (done) continue;
                            line = e.nextElement();
                        }
                    }
                    if ((nameValue = MelDocsDB.getNameValue(line))[0].equals("rcount") && !nameValue[1].equals("\"0\"")) {
                        int num;
                        try {
                            num = Integer.parseInt(TextUtils.removeQuotes(nameValue[1]));
                        }
                        catch (NumberFormatException ex) {
                            Cutter.setLog("    Error: MelDocsDB.readCacheFile() - expected an integer but got " + nameValue[1]);
                            return;
                        }
                        flagID = 0;
                        for (int n = 0; n < num; ++n) {
                            line = e.nextElement();
                            nameValue = MelDocsDB.getNameValue(line);
                            if (!nameValue[0].equals("rname")) continue;
                            db.addRelated(nameValue[1]);
                        }
                    } else {
                        Cutter.setLog("    Error: MelDocsDB.readCacheFile() - expected \"rcount\" but got " + line);
                    }
                }
                if (db == null) continue;
                MelDocsDB.putIntoCache(db);
            }
        }
        catch (Exception ex) {
            System.out.println("    Exception: MelDocsDB.readCacheFile() mel command = " + flagName);
            System.out.println("\t   hash size = " + MelDocsDB.cacheSize());
            System.out.println("       " + ex.toString());
            return;
        }
        if (debug) {
            Cutter.setLog("------------------------------------");
            Cutter.setLog("MelDocsDB.readCacheFile() " + MelDocsDB.cacheSize() + " items in MelDocsDB");
            int mtCount = MelTokenizer.getNumFunctions();
            Cutter.setLog("MelDocsDB.readCacheFile() " + mtCount + " items in MelTokenizer");
            Cutter.setLog("MelDocsDB.readCacheFile() Last command in MelTokenizer list is >" + MelTokenizer.getFunctionNameByIndex(mtCount - 1) + "<");
            Cutter.setLog("MelDocsDB.readCacheFile() Last command in MelDocsDB list is >" + db.getName() + "<");
            Cutter.setLog("------------------------------------");
        }
    }

    private static String[] getFlags(String str) {
        String[] out = new String[]{" ", " "};
        if (str == null || str.length() == 0) {
            return out;
        }
        String[] tokens = TextUtils.tokenize(TextUtils.removeQuotes(str));
        if (tokens == null || tokens.length != 2) {
            return out;
        }
        return tokens;
    }

    private static String[] getNameValue(String line) throws Exception {
        if (line == null || line.length() == 0) {
            throw new Exception("getNameValue - no input");
        }
        int index = line.indexOf(34);
        String name = line.substring(0, index).trim();
        String value = line.substring(index + 1, line.length() - 1).trim();
        if (name == null || name.length() == 0 || value == null || value.length() == 0) {
            throw new Exception("getNameValue - either the name or the value is null");
        }
        value = TextUtils.removeQuotes(value);
        String[] out = new String[]{name, value};
        return out;
    }

    public static int getPrefsVersion() {
        String docsPath = Preferences.get(Preferences.PATH_MEL_DOCS);
        String[] tokens = TextUtils.tokenize(docsPath, "\\/");
        if (tokens != null) {
            for (int n = 0; n < tokens.length; ++n) {
                if (tokens[n].startsWith("Maya5")) {
                    return 5;
                }
                if (!tokens[n].startsWith("Maya6")) continue;
                return 6;
            }
        }
        return -1;
    }

    private class DBItem {
        public String shortFlag;
        public String longFlag;
        public String desc;
        public boolean addedToMenu = false;

        public DBItem() {
        }

        public DBItem(String a, String b) {
            this.shortFlag = a;
            this.longFlag = b;
        }

        public DBItem(String a, String b, String desc) {
            this.shortFlag = a;
            this.longFlag = b;
            this.desc = desc;
        }

        public void copy(DBItem src) {
            this.shortFlag = src.shortFlag;
            this.longFlag = src.longFlag;
            this.desc = src.desc;
            this.addedToMenu = src.addedToMenu;
        }
    }
}

