/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Mel;

import Preferences.Preferences;
import UI_Components.ToolTip.MultiLineToolTip;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.KCompletionManager;
import UI_Script.Html.HtmlTokenizer;
import UI_Script.Mel.CannotFindRelativeHRefsException;
import UI_Script.Mel.CannotFindSearchPatternException;
import UI_Script.Mel.CannotFindTagException;
import UI_Script.Mel.CannotGetBodyTextException;
import UI_Script.Mel.InvalidOffsetsException;
import UI_Script.Mel.InvalidSearchPatternException;
import UI_Script.Mel.MelDocsDB;
import UI_Script.Mel.MelTokenizer;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KTextPane;
import Utilities.FileUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MelHelp
extends KAbstractHelp {
    public static String docsIndexURL = null;
    private static String REFER_TO_FULL_DOCS = "Refer to full documentation";
    private static String MEL_DOCS_NOT_FOUND_URL = HELP_DOCS_BASE_URL + "mel/notfound.html";
    private static int MENU_ABBREVIATION_LNGTH = 5;
    public static String[] fileTypes = new String[]{".mel", ".MEL"};
    public static String descStr = "Description";
    public static String flagStr = "Flags";
    public static String examplesStr = "Examples";
    public static String relatedCommandStr = "Related commands";
    public static String returnValueStr = "Return value";
    public static String synopsisStr = "Synopsis";
    public static String docsPath;
    private static int MAX_FLAGS;
    private static Hashtable<String, String> languageTable;
    private KAbstractHelp.KPopupMenu popup;
    private JMenu currentFlagSubMenu = null;
    public boolean debugGetPopupDB = false;

    public MelHelp(KTextPane textpane) {
        super(textpane);
        MelHelp.initPaths();
        this.setDocsIndexURL();
        this.completer.completionActivate();
        this.completer.setWordStartDelims(null);
        this.completer.setListeners(textpane, this);
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        if (str == null || str.trim().length() < KCompletionManager.MIN_LEN) {
            return false;
        }
        return Character.isLowerCase(str.charAt(0));
    }

    @Override
    public String[] completionCandidates(String str) {
        return this.completionCandidates(str, languageTable);
    }

    public static void initPaths() {
        docsPath = MelHelp.configurePath(Preferences.get(Preferences.PATH_MEL_DOCS));
        if (docsPath.equals("")) {
            docsPath = new File(FileUtils.getPWD(), "Cutter_Help/mel/Commands").getPath();
        }
        docsPath = MelHelp.configurePath(docsPath);
        Cutter.setLog("    Info:MelHelp.initPaths() using docs path \"" + docsPath + "\"");
    }

    @Override
    protected void lookup(String item) {
        if (item == null) {
            return;
        }
        MelTokenizer tok = new MelTokenizer();
        tok.setBuffer(item);
        if (tok.isFunction(item) && !this.setHelpPage((docsPath = FileUtils.removeTrailingSeparator(docsPath, '/', '\\')) + "/" + item + ".html", false)) {
            docsPath = MelHelp.configurePath(Preferences.get(Preferences.PATH_MEL_DOCS));
            if (!this.setHelpPage((docsPath = FileUtils.removeTrailingSeparator(docsPath, '/', '\\')) + "/" + item + ".html")) {
                // empty if block
            }
        }
    }

    protected void setGenericPage() {
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        int n;
        if (this.textpane == null) {
            Cutter.setLog("    Error:MelHelp.popupOnlineHelp() - textpane is null!!");
            return;
        }
        String initialSelection = selection = selection.trim();
        if (MelDocsDB.cache == null) {
            Cutter.setLog("    Error:MelHelp.popupOnlineHelp() MelDocsDB.cache == null");
            KAbstractHelp.KPopupMenu p = this.getDefaultMenu(e, selection, insertAt - selection.length(), insertAt);
            JMenuItem warning = new JMenuItem("MEL Shortcuts");
            warning.setEnabled(false);
            p.addSeparator();
            p.add(warning);
            p.pack();
            p.show(this.textpane, e.getX(), e.getY());
            return;
        }
        this.popup = new KAbstractHelp.KPopupMenu();
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, insertAt - selection.length(), insertAt);
        if (items == null) {
            Cutter.setLog("    Error:MelHelp.popupOnlineHelp - getDefaultPopupItems() return null.");
            return;
        }
        for (int n2 = 0; n2 < items.length; ++n2) {
            if (items[n2] == null) continue;
            defaultMenu.add(items[n2]);
        }
        if (initialSelection.length() == 0) {
            KCaret caret = this.textpane.getKCaret();
            selection = caret.selectWord(insertAt);
        }
        if (selection == null || selection.length() == 0) {
            JMenuItem warning = new JMenuItem("MEL Shortcuts");
            warning.setEnabled(false);
            this.popup.add(warning);
            this.popup.addSeparator();
            this.popup.add(defaultMenu);
            this.popup.pack();
            this.popup.show(this.textpane, e.getX(), e.getY());
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:MelHelp.popupOnlineHelp - selection length is zero");
            }
            return;
        }
        selection = TextUtils.trimTrailingChar(selection, ';');
        MelDocsDB data = null;
        data = MelDocsDB.getFromCache(selection);
        if (data == null) {
            JMenu jmi = this.popupTypingCompletion(selection);
            if (jmi != null) {
                this.popup.add(jmi);
            }
            this.popup.addSeparator();
            this.popup.add(defaultMenu);
            this.popup.pack();
            this.popup.show(this.textpane, e.getX(), e.getY());
            return;
        }
        String description = data.getMainDescription();
        if (description == null) {
            Cutter.setLog("    Debug:MelHelp.popupOnlineHelp - data.getMainDescription() returned null.");
            return;
        }
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("MEL - " + selection, description);
        mi.applyItalic();
        this.popup.add(mi);
        int selectionEndOffset = this.textpane.getKCaret().getDot();
        this.currentFlagSubMenu = null;
        for (n = 0; n < data.flagCount(); ++n) {
            int subItems;
            mi = new KAbstractHelp.KPopupMenuItem(data.getShortFlagAt(n), data.getLongFlagAt(n), data.getDescAt(n), selectionEndOffset);
            if (n < MAX_FLAGS) {
                this.popup.add(mi);
                data.setAddedToMenu(n, true);
                continue;
            }
            if (this.currentFlagSubMenu == null) {
                this.currentFlagSubMenu = new JMenu("remainder...");
            }
            if ((subItems = this.currentFlagSubMenu.getMenuComponents().length) < MAX_FLAGS) {
                this.currentFlagSubMenu.add(mi);
                data.setAddedToMenu(n, true);
            } else if (subItems == MAX_FLAGS) {
                String title = this.getAbbreviatedNameFrom((JMenuItem)this.currentFlagSubMenu.getMenuComponent(0), (JMenuItem)this.currentFlagSubMenu.getMenuComponent(subItems - 1));
                this.currentFlagSubMenu.setText(title);
                this.currentFlagSubMenu.add(mi);
                data.setAddedToMenu(n, true);
                this.popup.add(this.currentFlagSubMenu);
                this.currentFlagSubMenu = new JMenu("remainder...");
                continue;
            }
            this.popup.add(this.currentFlagSubMenu);
        }
        if (data.relatedCount() > 0) {
            mi = new KAbstractHelp.KPopupMenuItem("Related Commands");
            mi.applyItalic();
            this.popup.add(mi);
        }
        for (n = 0; n < data.relatedCount(); ++n) {
            MelDocsDB d = MelDocsDB.getFromCache(data.getRelatedAt(n));
            JMenu sub = new JMenu(data.getRelatedAt(n));
            if (d == null) continue;
            if (d.flagCount() == 0) {
                description = d.getMainDescription();
                mi = new KAbstractHelp.KPopupMenuItem("Description - no flags", description);
                mi.applyItalic();
                sub.add(mi);
            } else {
                description = d.getMainDescription();
                mi = new KAbstractHelp.KPopupMenuItem("Description", description);
                mi.applyItalic();
                sub.add(mi);
                sub.addSeparator();
                for (int i = 0; i < d.flagCount(); ++i) {
                    String title = "-" + d.getShortFlagAt(i) + "/" + d.getLongFlagAt(i);
                    mi = new KAbstractHelp.KPopupMenuItem(title, d.getDescAt(i));
                    sub.add(mi);
                }
            }
            this.popup.add(sub);
        }
        this.popup.addSeparator();
        this.popup.add(defaultMenu);
        this.popup.pack();
        this.popup.show(this.textpane, e.getX(), e.getY());
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }

    public JMenu popupTypingCompletion(String textToComplete) {
        if ((textToComplete = textToComplete.trim()) == null || textToComplete.length() == 0) {
            return null;
        }
        JMenu subMenu = new JMenu("Typing Completion");
        JMenu subsubMenu = null;
        subMenu.addMouseListener(new KAbstractHelp.KSelectionExpander());
        Object description = null;
        String defaultDesc = "No description available";
        MelDocsDB[] db = MelDocsDB.getCacheItemsWithPrefix(textToComplete);
        if (db == null || db.length == 0) {
            return null;
        }
        Cutter.setLog("    Debug:MelHelp.popupTypingCompletion() - cache contains " + db.length + " matching items");
        for (int n = 0; n < db.length; ++n) {
            String desc = db[n].getMainDescription();
            final String cmd = db[n].getName();
            if (desc == null || cmd == null) continue;
            if ((desc = TextUtils.format(desc, MultiLineToolTip.DEFAULT_TIP_TEXT_WIDTH, MultiLineToolTip.DEFAULT_TIP_TEXT_LENGTH, "Refer to full documentation")) == null || desc.length() == 0) {
                desc = "No description available";
            }
            KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(cmd, desc);
            mi.addMouseListener(new KAbstractHelp.KSelectionExpander());
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MelHelp.this.textpane.replaceSelection(cmd);
                }
            };
            mi.addActionListener(action);
            if (n < 20) {
                subMenu.add(mi);
                continue;
            }
            if (n % 20 == 0) {
                subsubMenu = new JMenu("more...");
                subMenu.add(subsubMenu);
            }
            subsubMenu.add(mi);
        }
        return subMenu;
    }

    private String getAbbreviatedNameFrom(JMenuItem first, JMenuItem last) {
        String firstName = TextUtils.abbreviate(first.getText(), MENU_ABBREVIATION_LNGTH);
        String lastName = TextUtils.abbreviate(last.getText(), MENU_ABBREVIATION_LNGTH);
        return "\"" + firstName + "\" to \"" + lastName;
    }

    public void setDocsIndexURL() {
        docsIndexURL = docsPath.endsWith("/") || docsPath.endsWith("\\") ? docsPath + "index.html?MEL" : docsPath + File.separatorChar + "index.html?MEL";
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        this.useCutterBrowser = !e.isShiftDown();
        return this.launchBrowser(item);
    }

    public static String getDocsIndexURL() {
        return docsIndexURL;
    }

    public static boolean docsIndexURLIsValid() {
        String str = MelHelp.getDocsIndexURL();
        if (str == null || str.length() == 0) {
            return false;
        }
        return KAbstractHelp.docsIndexURLIsValid(str);
    }

    public MelDocsDB getDocsDBFor(String item, boolean getRelatedCommands) {
        MelDocsDB outDB;
        block35: {
            int flagsOffset;
            HtmlTokenizer tok;
            block34: {
                if (this.debugGetPopupDB) {
                    Cutter.setLog("getMelDocV6.getDocsDBFor() " + item);
                }
                MelTokenizer tokenizer = new MelTokenizer();
                tokenizer.setBuffer(item);
                outDB = new MelDocsDB(item);
                String urlstr = Preferences.get(Preferences.PATH_MEL_DOCS) + "/" + item + ".html";
                if (this.debugGetPopupDB) {
                    Cutter.setLog("getMelDocV6 " + urlstr);
                }
                if ((tok = HtmlTokenizer.getHtmlTokenizerFor(urlstr)) == null) {
                    Cutter.setLog("    Error: MelDocsV6.getDocsDBFor() - cannot get a tokenizer for item \"" + item + "\"\n           using url \"" + urlstr + "\"");
                    return null;
                }
                if (this.debugGetPopupDB) {
                    Cutter.setLog("=================== BEGINNING DESCRIPTION ======================");
                }
                int returnValueOffset = 0;
                String description = "No Description";
                try {
                    int synopsisOffset = this.searchBodyTextFor(tok, 0, synopsisStr);
                    if (this.debugGetPopupDB) {
                        Cutter.setLog("A synopsisOffset = " + synopsisOffset);
                    }
                    int nameFlagOffset = this.findTag(tok, synopsisOffset, "</P>");
                    if (this.debugGetPopupDB) {
                        Cutter.setLog("C nameFlagOffset ie. </P> = " + nameFlagOffset);
                    }
                    returnValueOffset = this.searchBodyTextFor(tok, nameFlagOffset, returnValueStr);
                    if (this.debugGetPopupDB) {
                        Cutter.setLog("D returnValueOffset = " + returnValueOffset);
                    }
                    description = this.getBodyTextBetween(tok, nameFlagOffset, returnValueOffset);
                }
                catch (InvalidOffsetsException oe) {
                    Cutter.setLog(item + "\n" + oe + "\n\n");
                    return null;
                }
                catch (InvalidSearchPatternException pe) {
                    Cutter.setLog(item + "\n" + pe + "\n\n");
                    return null;
                }
                catch (CannotFindSearchPatternException se) {
                    Cutter.setLog(item + "\n" + se + "\n\n");
                    return null;
                }
                catch (CannotFindTagException tg) {
                    Cutter.setLog(item + "\n" + tg + "\n\n");
                    return null;
                }
                catch (CannotGetBodyTextException te) {
                    if (this.debugGetPopupDB) {
                        Cutter.setLog(item + "\n" + te + "\n\n");
                    }
                    description = "No Description";
                }
                catch (Exception e) {
                    if (this.debugGetPopupDB) {
                        Cutter.setLog("    Exception: MelDocsV6.getDocsDBFor() description error\n    " + e.toString() + "\n\n");
                    }
                    return null;
                }
                outDB.setMainDescription(description);
                if (this.debugGetPopupDB) {
                    Cutter.setLog("=================== BEGINNING RELATED ======================");
                }
                flagsOffset = 0;
                try {
                    int relatedOffset = this.searchBodyTextFor(tok, returnValueOffset, relatedCommandStr);
                    if (this.debugGetPopupDB) {
                        Cutter.setLog("relatedOffset = " + relatedOffset);
                    }
                    flagsOffset = this.searchBodyTextFor(tok, relatedOffset, flagStr);
                    if (this.debugGetPopupDB) {
                        Cutter.setLog("flagsOffset = " + flagsOffset);
                    }
                    String str = tok.getBodyTextBetween(relatedOffset, flagsOffset);
                    if (getRelatedCommands && str != null) {
                        outDB.addRelated(str, " ,");
                    }
                }
                catch (Exception e) {
                    if (!this.debugGetPopupDB) break block34;
                    Cutter.setLog("    Exception: MelDocsV6.getDocsDBFor() during getting related commands\n" + e.toString());
                }
            }
            if (this.debugGetPopupDB) {
                Cutter.setLog("=================== BEGINNING FLAGS ======================");
            }
            int tbodyOffset = 0;
            String[] hrefs = new String[]{};
            Vector list = new Vector();
            String hrefStr = "not defined";
            try {
                tbodyOffset = this.findTag(tok, flagsOffset, "<tr>");
                hrefs = this.getRelativeHRefsBetween(tok, flagsOffset, tbodyOffset);
                if (this.debugGetPopupDB) {
                    Cutter.setLog("found " + hrefs.length + " related links");
                }
                Vector handledList = new Vector();
                for (int n = 0; n < hrefs.length; ++n) {
                    int tdEnd;
                    int tdBegin;
                    String desc;
                    hrefStr = hrefs[n];
                    int flagBegin = tok.findARef(tbodyOffset, hrefs[n]);
                    int flagEnd = tok.findTag("</CODE>", flagBegin, true);
                    if (this.debugGetPopupDB) {
                        Cutter.setLog("href name = " + hrefs[n] + " flagBegin: " + flagBegin + " flagEnd: " + flagEnd);
                    }
                    if (flagBegin == -1 || flagEnd == -1) continue;
                    String flagsStr = tok.getBodyTextBetween(flagBegin, flagEnd);
                    String[] flags = null;
                    if (flagsStr != null && flagsStr.length() > 0) {
                        flagsStr = flagsStr.replace('(', ' ');
                        flags = TextUtils.tokenize(flagsStr = flagsStr.replace(')', ' '));
                        if (flags == null || flags.length == 0) {
                            Cutter.setLog("continue 1 flags are null or zero for flagStr >" + flagStr + "<");
                            continue;
                        }
                        if (flags.length != 1 && flags.length != 2) {
                            Cutter.setLog("continue 2 flags length is " + flags.length + " for flagStr >" + flagStr + "<");
                            continue;
                        }
                    } else {
                        Cutter.setLog("Warning cannot find flagStr for href >" + hrefStr + "<");
                    }
                    if ((desc = tok.getBodyTextBetween(tdBegin = this.findTag(tok, flagEnd, "<td>"), tdEnd = this.findTag(tok, tdBegin, "</td>"))) == null || desc.length() == 0) {
                        desc = "No Description";
                    }
                    flags[1] = flags.length == 1 ? flags[0] : flags[1];
                    outDB.addFlag(flags[0], flags[1], desc);
                }
            }
            catch (CannotFindRelativeHRefsException ref) {
                Cutter.setLog(ref + "\n\n");
            }
            catch (Exception e) {
                if (!this.debugGetPopupDB) break block35;
                Cutter.setLog("    Exception: MelDocsV6.getDocsDBFor()\n        href = " + hrefStr + "\n        " + e.toString());
            }
        }
        return outDB;
    }

    private int findTag(HtmlTokenizer tok, int begin, String tagStr) throws Exception, CannotFindTagException {
        if (begin == -1 || tagStr == null) {
            throw new Exception("MelDocsV6.findTag() invalid inputs");
        }
        int offset = tok.findTag(tagStr, begin, false);
        if (offset == -1) {
            throw new CannotFindTagException(tagStr, begin);
        }
        return offset;
    }

    private int searchBodyTextFor(HtmlTokenizer tok, int begin, String pattern) throws InvalidSearchPatternException, CannotFindSearchPatternException {
        if (tok == null || pattern == null || pattern.length() == 0) {
            throw new InvalidSearchPatternException("searchBodyTextFor()");
        }
        int offset = tok.searchBodyTextFor(begin, pattern, true);
        if (offset == -1) {
            throw new CannotFindSearchPatternException("searchBodyTextFor()", begin, pattern);
        }
        return offset + pattern.length();
    }

    private String getBodyTextBetween(HtmlTokenizer tok, int begin, int end) throws InvalidOffsetsException, CannotGetBodyTextException {
        if (begin == -1 || end == -1) {
            throw new InvalidOffsetsException("getBodyTextBetween()", begin, end);
        }
        String str = tok.getBodyTextBetween(begin, end);
        if (str == null || str.length() == 0) {
            throw new CannotGetBodyTextException(begin, end);
        }
        return str;
    }

    private String[] getRelativeHRefsBetween(HtmlTokenizer tok, int begin, int end) throws InvalidOffsetsException, CannotFindRelativeHRefsException {
        if (this.debugGetPopupDB) {
            Cutter.setLog("MelDocsV6.getRelativeHRefsBetween() begin = " + begin + " end = " + end);
        }
        if (begin == -1 || end == -1) {
            throw new InvalidOffsetsException("getRelativeHRefsBetween()", begin, end);
        }
        String[] hrefs = tok.getHRefsBetween(begin, end);
        if (hrefs == null || hrefs.length == 0) {
            throw new CannotFindRelativeHRefsException(begin, end);
        }
        if (this.debugGetPopupDB) {
            Cutter.setLog("MelDocsV6.getRelativeHRefsBetween()  found " + hrefs.length + " links of the type #flagname");
            Cutter.setLog(hrefs);
        }
        Vector<String> list = new Vector<String>();
        for (int n = 0; n < hrefs.length; ++n) {
            int index = hrefs[n].lastIndexOf(35);
            String href = hrefs[n].substring(index + 1);
            if (href == null || href.length() == 0 || href.charAt(0) == 'h') continue;
            list.addElement(href);
        }
        return VectorUtils.toStringArray(list);
    }

    static {
        MAX_FLAGS = 20;
        languageTable = new Hashtable();
        docsPath = MelHelp.configurePath(Preferences.get(Preferences.PATH_MEL_DOCS));
        listOfSubClasses.addElement(MelHelp.class);
        MelDocsDB.initCache();
        if (docsPath != null && docsPath.trim().length() > 0) {
            docsIndexURL = docsPath.endsWith("/") || docsPath.endsWith("\\") ? docsPath + "index.html?MEL" : docsPath + File.separatorChar + "index.html?MEL";
        }
        Enumeration<String> e = MelTokenizer.language.keys();
        while (e.hasMoreElements()) {
            String str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
        }
    }
}

