/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Mel;

import Preferences.Preferences;
import UI_Script.Mel.MelTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import Utilities.DocumentUtils;
import javax.swing.text.StyleConstants;

public class MelListener
extends SyntaxListener {
    public MelListener(KTextPane textpane) {
        super(textpane, new MelTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        char[] begin = new char[]{'$', '-'};
        textpane.removeWordDelimitors(begin, null);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_C_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_FUNCTION));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_C_DATATYPE));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_C_STRING));
        StyleConstants.setUnderline(textpane.styleContext.stringStyle2, true);
        StyleConstants.setForeground(textpane.styleContext.commentStyle2, Preferences.getColor(Preferences.TEXT_COLOR_MEL_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_MEL_USER_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_MEL_COMMAND));
    }

    protected final int findClosingCommand(int begin) {
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), begin, this.textpane.getDocument().getLength() - begin);
        if (this.segment == null) {
            return -1;
        }
        for (int n = 0; n < this.segment.count; ++n) {
            if (this.segment.array[n + this.segment.offset] != '`') continue;
            return begin + n + 1;
        }
        return -1;
    }

    protected boolean commandRemoved(int[] syntax) {
        String strRemoved = this.textpane.stringRemoved();
        if (syntax[1] == 0 && syntax[2] != 0 || syntax[1] == 7 && syntax[2] != 7) {
            return false;
        }
        if (strRemoved.length() == 1 && strRemoved.charAt(0) == '`') {
            this.msg.append("- COMMAND REMOVED ");
            return true;
        }
        if (strRemoved.length() > 1 && this.count(strRemoved, '`') % 2 == 1) {
            this.msg.append("- UNBALANCED COMMAND REMOVED ");
            return true;
        }
        return false;
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (this.tok.isCommand(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle4, true);
            return true;
        }
        return false;
    }

    @Override
    public void addComments() {
        this.addComments("//");
    }
}

