/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Mel;

import ClientServer.ClientServer.client.Client;
import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.CommandPort.MayaCommandPort;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Mel.MelDocsDB;
import UI_Script.Mel.MelHelp;
import UI_Script.Mel.MelListener;
import UI_Script.Mel.MelTokenizer;
import UI_Script.Mel.OpenMelAction;
import UI_Script.Mel.ShaderProgress;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextHistoryWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DialogUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JMenuItem;

public class MelScriptHandler
extends ScriptHandler {
    @Override
    public boolean canRunSelection() {
        return true;
    }

    public MelScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".mel";
        this.ext[1] = ".MEL";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new MelTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.mel");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Mel";
    }

    @Override
    public String getExecuteLabel() {
        return null;
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(File file) {
        String str;
        KAbstractWindow front = BBxt.frontWindow();
        if (front != null && front instanceof KTextWindow && (str = BBxt.getWindowText()) != null && str.trim().length() > 0) {
            front.sendMelToMayaClient();
        }
    }

    @Override
    public void execute(String str) {
        KAbstractWindow front = BBxt.frontWindow();
        if (front != null && front instanceof KTextWindow) {
            front.sendMelToMayaClient(str);
        }
    }

    @Override
    public void executeFromHistory(KTextHistoryWindow window) {
        if (window == null) {
            Cutter.setLog("    Error:MelScriptHandler.executeFromHistory() - history window is null!!");
            return;
        }
        KAbstractTextWindow atw = window.getOwnersWindow();
        Client client = atw.getMayaClient();
        if (client == null) {
            String[] msg = new String[]{"The history window can send its mel script to Maya", "but only if its parent window is connectd to Maya."};
            DialogUtils.showWarningMessage("Must be connected to Maya", msg);
            return;
        }
        String str = BBxt.getSelectionFromAbstractTextWindow(window);
        MayaCommandPort maya = new MayaCommandPort((KTextWindow)atw, client);
        maya.sendStr(str);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return MelListener.class.getName();
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        String docsPath = Preferences.get(Preferences.PATH_MEL_DOCS);
        return KAbstractHelp.getInstanceByName(MelHelp.class.getName(), textpane);
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Mel");
        item.addActionListener(new OpenMelAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return super.getStructure();
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("mel", "Mel Script");
        return filter;
    }

    @Override
    public synchronized void loadCache(final KAbstractTextWindow window) {
        if (MelDocsDB.cache != null) {
            return;
        }
        final ShaderProgress progress = new ShaderProgress(300);
        progress.setTitle("Reading MEL Commands");
        progress.initBar(1068);
        Thread thread = new Thread(){

            @Override
            public void run() {
                MelDocsDB.cache = new Hashtable();
                if (window != null) {
                    window.getTextPane().setEditable(false);
                }
                if (Cutter.desktop.isVisible()) {
                    progress.showSelf();
                }
                MelDocsDB.readCacheFile(progress);
                Cutter.setLog("    Info: ScriptRegistry.loadCache() - read " + MelDocsDB.cache.size() + " commands and " + MelDocsDB.flagCount + " flags.");
                if (window != null) {
                    window.getTextPane().setEditable(true);
                }
                if (progress != null) {
                    progress.setVisible(false);
                }
            }
        };
        thread.start();
    }
}

