/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Mel;

import UI_Desktop.Cutter;
import UI_Script.Cpp.CppTokenizer;
import UI_Script.Mel.MELLanguageRsrc;
import UI_Script.Quotation;
import UI_Script.ScriptParser.ProcDBItem;
import Utilities.HashTableUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import kernal.Tokenizers.Tokenizer;

public class MelTokenizer
extends CppTokenizer {
    private static ResourceBundle MELLanguageRes;
    public static Hashtable<String, String> language;
    public static String[] sortedFunctionNames;
    public static final double version = 1.0;
    public boolean getComments = false;

    private static String getLanguage(String nm) {
        String str;
        try {
            str = MELLanguageRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numLanguageItems() {
        int num = 0;
        try {
            num = ((MELLanguageRsrc)MELLanguageRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read MELLanguageRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < MelTokenizer.numLanguageItems(); ++i) {
            language.put(((MELLanguageRsrc)MELLanguageRes).getKey(i), ((MELLanguageRsrc)MELLanguageRes).getContent(i));
        }
    }

    public static int getNumFunctions() {
        Enumeration<String> e = language.keys();
        int count = 0;
        while (e.hasMoreElements()) {
            String item = e.nextElement();
            if (!language.get(item).equals("function")) continue;
            ++count;
        }
        return count;
    }

    private static void initSortedFunctions() {
        Enumeration<String> e = language.keys();
        boolean n = false;
        Vector<String> list = new Vector<String>();
        while (e.hasMoreElements()) {
            String item = e.nextElement();
            if (!language.get(item).equals("function")) continue;
            list.addElement(item);
        }
        String[] strs = VectorUtils.toStringArray(list);
        if (strs == null) {
            sortedFunctionNames = null;
        }
        sortedFunctionNames = TextUtils.sortByAlpha(strs);
    }

    public static String getFunctionNameByIndex(int index) {
        if (sortedFunctionNames == null) {
            return null;
        }
        if (index < 0 || index > sortedFunctionNames.length - 1) {
            return null;
        }
        return sortedFunctionNames[index];
    }

    public MelTokenizer() {
        this.addQuotation("`", "`", null);
        this.setSyntaxLength(2);
        this.removeDelimitor("$");
        String[] ext = new String[]{"mel", "MEL"};
        Tokenizer.addToRegistry(MelTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    private void ___LANGUAGE__PROFILE__METHODS________() {
    }

    @Override
    public String[] getAccessTypes() {
        return null;
    }

    @Override
    public String[] getScopeTypes() {
        return new String[]{"global"};
    }

    @Override
    public String getPragmaStr() {
        return "#pragma";
    }

    @Override
    public String getProcKeyword() {
        return "proc";
    }

    @Override
    public String[] getDataTypes() {
        String[] own = HashTableUtils.getAllValuesWithKey(language, "datatype");
        String[] supers = super.getDataTypes();
        Vector all = new Vector();
        return VectorUtils.toStringArray(own, supers);
    }

    public ProcDBItem __lpGrabProc(String str) {
        if (!str.equals("global")) {
            return null;
        }
        int index = this.getBufferIndex();
        StringBuffer buff = new StringBuffer();
        for (int n = 0; n < 7; ++n) {
            buff.append(this.getNextStr()).append(" ");
        }
        this.setBufferIndex(index);
        return null;
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        ProcDBItem out = new ProcDBItem();
        int index = this.getBufferIndex();
        if (str.equals("global")) {
            out.procOffset[0] = index - str.length();
            out.scope = "global";
            str = this.getNextStr();
        }
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        if (!str.equals("proc")) {
            this.setBufferIndex(index);
            return null;
        }
        if (!out.scope.equals("global")) {
            out.procOffset[0] = index - str.length();
        }
        if ((str = this.getNextStr()).equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        if (this.isDataType(str)) {
            out.procType = str;
            if (this.nextNonWhiteCharIs(91)) {
                str = this.getNextStr();
                if (str.equals("")) {
                    this.setBufferIndex(index);
                    return null;
                }
                if (this.nextNonWhiteCharIs(93) && (str = this.getNextStr()).equals("")) {
                    this.setBufferIndex(index);
                    return null;
                }
            }
            if ((str = this.getNextStr()).equals("")) {
                this.setBufferIndex(index);
                return null;
            }
        }
        out.procName = str;
        out.procNameOffset = new int[2];
        out.procNameOffset[1] = this.getBufferIndex();
        out.procNameOffset[0] = out.procNameOffset[1] - str.length();
        String ptext = this.lpGrabProcParams("(", ")");
        if (ptext == null) {
            this.setBufferIndex(index);
            return null;
        }
        int[] offset = this.lpGrabProcBody("{", "}", null);
        if (offset == null) {
            this.setBufferIndex(index);
            return null;
        }
        out.procOffset[0] = out.procNameOffset[0];
        out.procOffset[1] = offset[1];
        return out;
    }

    private void ___QUERRY__METHODS________() {
    }

    @Override
    public boolean isUserVariable(String str) {
        return str.charAt(0) == '$';
    }

    @Override
    public boolean isCommand(String str) {
        return str.charAt(0) == '`';
    }

    @Override
    public boolean isSystemHeader(String str) {
        return false;
    }

    @Override
    public boolean isFunction(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("function");
        }
        return false;
    }

    @Override
    public boolean isDataType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("datatype");
        }
        return super.isDataType(str);
    }

    @Override
    public boolean isDataModifier(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("datamodifier");
        }
        return super.isDataModifier(str);
    }

    @Override
    public boolean isLanguageType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("language");
        }
        return super.isLanguageType(str);
    }

    public String __getNextStr() {
        char c;
        boolean literal = false;
        boolean command = false;
        boolean endOfString = false;
        boolean endOfComment = false;
        this.debug = false;
        if (this.debug) {
            Cutter.setLog("Entered GetNextStr");
        }
        if ((c = this.readChar()) == '\u0000') {
            if (this.debug) {
                Cutter.setLog("GetNextStr, readChar() ERROR, char = >" + c + "< index = " + this.getBufferIndex());
            }
            return "";
        }
        this.outBuff.setLength(0);
        if (this.debug) {
            Cutter.setLog("GetNextStr, read first char =  >" + c + "<");
        }
        if (this.debug) {
            Cutter.setLog("2c = |" + c + "|");
        }
        if (this.isSpace(c)) {
            c = this.removeSpace();
        }
        if (this.debug) {
            Cutter.setLog("stripped space c = |" + c + "| index = " + this.getBufferIndex());
        }
        if (c == '\u0000') {
            return "";
        }
        this.outBuff.append(c);
        if (c == ';') {
            return this.outBuff.toString();
        }
        if (this.debug) {
            Cutter.setLog("4c = |" + c + "|");
        }
        if (c == '*') {
            if (this.peekNextChar() == '/') {
                c = this.readChar();
                return this.outBuff.append(c).toString();
            }
            return this.outBuff.toString();
        }
        if (c == '<' && !this.isSpace(this.peekNextChar())) {
            int offset = this.getBufferIndex();
            c = this.readChar();
            if (c == '\u0000') {
                return this.outBuff.toString();
            }
            do {
                if (c == ' ') {
                    this.setBufferIndex(offset);
                    this.outBuff.setLength(1);
                    return this.outBuff.toString();
                }
                this.outBuff.append(c);
                if (c != '>') continue;
                return this.outBuff.toString();
            } while ((c = this.readChar()) != '\u0000');
            this.setBufferIndex(offset);
            this.outBuff.setLength(1);
            return this.outBuff.toString();
        }
        if (c == '/') {
            if (this.peekNextChar() == '*' || this.peekNextChar() == '/') {
                c = this.readChar();
                if (c == '\u0000') {
                    return this.outBuff.toString();
                }
                if (c == '/') {
                    do {
                        this.outBuff.append(c);
                        if (c != '\n' && c != '\r') continue;
                        return this.outBuff.toString();
                    } while ((c = this.readChar()) != '\u0000');
                    return this.outBuff.toString();
                }
                block10: while (true) {
                    this.outBuff.append(c);
                    c = this.readChar();
                    if (c == '\u0000') {
                        return this.outBuff.toString();
                    }
                    do {
                        if (c != '*') continue block10;
                        this.outBuff.append(c);
                        c = this.readChar();
                        if (c != '\u0000') continue;
                        return this.outBuff.toString();
                    } while (c != '/');
                    break;
                }
                return this.outBuff.append(c).toString();
            }
            return this.outBuff.toString();
        }
        if (this.isDelimitor(c)) {
            return this.outBuff.toString();
        }
        Quotation activeQuote = null;
        activeQuote = this.isOpenQuotation(c);
        if (activeQuote != null) {
            literal = true;
        }
        if (c == '`') {
            command = true;
        }
        while (!endOfString && !this.mEndOfBuffer) {
            c = this.readChar();
            if (activeQuote != null && activeQuote.isCloseQuotation(c)) {
                this.outBuff.append(c);
                return this.outBuff.toString();
            }
            if (activeQuote == null && this.isOpenQuotation(c) != null) {
                if (command) continue;
                this.ungetChar();
                return this.outBuff.toString();
            }
            if (this.debug) {
                Cutter.setLog("6c = |" + c + "|");
            }
            switch (c) {
                case '\u0000': {
                    return this.outBuff.toString();
                }
                case '`': {
                    if (literal) break;
                    if (command) {
                        this.outBuff.append(c);
                        return this.outBuff.toString();
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': {
                    if (literal || command) break;
                    if (this.debug) {
                        Cutter.setLog("Parenthesis c = " + c + " buff = |" + this.outBuff.toString() + "|");
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\t': 
                case ' ': {
                    if (literal || command) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\n': 
                case '\r': {
                    if (literal || command) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '/': {
                    if (literal || command) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
            }
            this.outBuff.append(c);
        }
        if (this.debug) {
            Cutter.setLog("getNextStr() is returning:" + this.outBuff.toString());
        }
        return this.outBuff.toString();
    }

    static {
        language = new Hashtable();
        sortedFunctionNames = null;
        try {
            MELLanguageRes = ResourceBundle.getBundle("UI_Script.Mel.MELLanguageRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: MELLanguageRes = " + mre);
        }
        MelTokenizer.initHashTable();
        MelTokenizer.initSortedFunctions();
    }
}

