/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Mtd;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Text.KTextPane.KTextPane;
import Utilities.BrowserUtils;
import Utilities.DialogUtils;
import Utilities.ListenerUtils;
import Utilities.MayaNodeIdUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class MtdHelp
extends KAbstractHelp {
    public MtdHelp(KTextPane textpane) {
        super(textpane);
        this.completer.completionDeActivate();
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
        this.completer.completionDeActivate();
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        int begin = insertAt - selection.length();
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, insertAt - selection.length(), insertAt);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null || items[n] instanceof KAbstractHelp.KPopupMenuItem && items[n] != null && ((KAbstractHelp.KPopupMenuItem)items[n]).getText() != null && ((KAbstractHelp.KPopupMenuItem)items[n]).getText().contains("Completion")) continue;
            defaultMenu.add(items[n]);
        }
        JMenuItem nodeIdReportItem = new JMenuItem("Generate NodeID Report");
        JMenuItem openOslItem = new JMenuItem("Open Arnold OSL File");
        ListenerUtils.removeAllActions(nodeIdReportItem);
        ListenerUtils.removeAllActions(openOslItem);
        popup.add(nodeIdReportItem);
        popup.add(openOslItem);
        popup.add(new JSeparator());
        nodeIdReportItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MayaNodeIdUtils.writeFullReport();
            }
        });
        openOslItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = MtdHelp.this.textpane.getFrameFile();
                String srcName = f.getName();
                if (srcName.endsWith(".mtd") || srcName.endsWith("MTD")) {
                    srcName = srcName.substring(0, srcName.length() - 4);
                }
                srcName = srcName + ".osl";
                File userShdDir = f.getParentFile();
                File userSrcDir = new File(Preferences.get(Preferences.PATH_USER_ARNOLD_OSL_SOURCE));
                if (!userSrcDir.exists()) {
                    String[] msg = new String[]{"To set Arnold's OSL prefs go to Edit->Show Preferences", "and select the Languages->Osl tab.\n", "In the Arnold panel make sure the \"bin path\",", "\"source\" and \"shaders\" paths have been set", "correctly.\n"};
                    DialogUtils.showErrorMessage("Arnold OSL Prefs Not Set", msg);
                    return;
                }
                File oslFile = new File(userSrcDir, srcName);
                if (oslFile.exists()) {
                    BBxt.newDocument(oslFile);
                    return;
                }
                String[] msg = new String[]{"Cannot find \"" + srcName + "\" in the,", "   \"" + userSrcDir.getPath() + "\"", "directory."};
                DialogUtils.showErrorMessage("Cannot Find OSL Source Code", msg);
            }
        });
        popup.add(defaultMenu);
        if (popup != null) {
            popup.setRequestFocusEnabled(false);
            try {
                popup.show(this.textpane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:LpeHelp.showPxrDoc()\n      " + ex.toString());
            }
        }
    }

    private JMenuItem showLpeHelp(boolean wantsExternalBrowser) {
        JMenuItem item = new JMenuItem("Quick Reference");
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        item.addActionListener(action);
        return item;
    }

    private JMenuItem showPxrDoc() {
        JMenuItem item = new JMenuItem("Pixar LPE Documentation");
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String index = "https://rmanwiki.pixar.com/display/REN/Light+Path+Expressions#LightPathExpressions-LPETokens";
                try {
                    BrowserUtils.open(index);
                }
                catch (Exception e) {
                    Cutter.setLog("    Error: LpeHelp.showPxrDoc() cannot load url \"" + index + "\"");
                }
            }
        };
        item.addActionListener(action);
        return item;
    }

    @Override
    protected void lookup(String item) {
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        return false;
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }
}

