/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Mtd;

import Preferences.Preferences;
import UI_Script.Mtd.MtdTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public class MtdListener
extends SyntaxListener {
    public MtdListener(KTextPane textpane, Tokenizer tok) {
        super(textpane, tok);
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    public MtdListener(KTextPane textpane) {
        super(textpane, new MtdTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        char[] delim = new char[]{'-', '$'};
        textpane.addWordDelimitors(delim, delim);
        char[] begin = new char[]{'$'};
        textpane.removeWordDelimitors(begin, null);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_LPE_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_LPE_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_LPE_KEYWORD));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_LPE_EVENTYPE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_LPE_SCATTERTYPE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_LPE_RE_QUALIFIER));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_LPE_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_LPE_STRING));
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        boolean handled = false;
        return handled;
    }

    @Override
    public void addComments() {
        this.addComments("#");
    }
}

