/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Mtd;

import kernal.Tokenizers.Tokenizer;

public class MtdTokenizer
extends Tokenizer {
    public MtdTokenizer() {
        this.addComment("#", "\n");
        char[] esc_chars = new char[]{'\\', '^'};
        this.addQuotation("'", "'", esc_chars);
        this.setSyntaxLength(1);
        this.addEscape("\\\"", "");
        this.addEscape("^\"", "");
        this.addEscape("\\\\", "");
        this.addEscape("\\'", "");
        this.addEscape("\\[", "");
        this.addEscape("\\]", "");
        this.addEscape("\\{", "");
        this.addEscape("\\}", "");
        this.addEscape("\\$", "");
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.appendDelimitor(">");
        this.appendDelimitor("<");
        this.grabCSystemHeader = false;
        this.removeDelimitor("$-");
        String[] ext = new String[]{"mtd", "MTD"};
        Tokenizer.addToRegistry(MtdTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public boolean isDataType(String str) {
        return str.compareTo("FLOAT") == 0 || str.compareTo("INT") == 0 || str.compareTo("VECTOR") == 0 || str.compareTo("BOOL") == 0 || str.compareTo("STRING") == 0 || str.compareTo("COLOR") == 0;
    }

    @Override
    public boolean isLanguageType(String str) {
        if (str.equals("color") || str.equals("float")) {
            // empty if block
        }
        return false;
    }

    @Override
    public boolean isFunction(String str) {
        return false;
    }

    @Override
    public boolean isSystemHeader(String str) {
        return false;
    }
}

