/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Osl.OslShader;
import UI_Script.Osl.OslinfoParser;
import UI_Tools.Monitor.Monitor;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.FileUtils;
import Utilities.MayaNodeIdUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ArnoldMtdWriter {
    public boolean writeMtdFile(String binPath, String userShdDirPath, String shaderName) {
        block27: {
            OslinfoParser parser = new OslinfoParser(binPath);
            File shd = new File(userShdDirPath, shaderName);
            OslinfoParser.RibInfo info = parser.getRibInfo(shaderName, shd);
            if (info == null) {
                Cutter.setLog("    Error: ArnoldMtdWriter.writeMtdFile() - OslinfoParser.RibInfo info is null.");
                Cutter.setLog("    Error: ArnoldMtdWriter.writeMtdFile() - shader name \"" + shaderName + "\".");
                return false;
            }
            if (info.outputs == null || info.outputs.length < 1) {
                return false;
            }
            String[] outputNames = new String[info.outputs.length];
            for (int n = 0; n < outputNames.length; ++n) {
                outputNames[n] = info.outputs[n].getName();
            }
            if (outputNames[0] == null || outputNames[0].trim().length() == 0) {
                return false;
            }
            int[] ids = MayaNodeIdUtils.getAllUsedNodeIds();
            int maya_id = 1;
            if (ids == null) {
                Cutter.setLog("    Info:ArnoldMtdWriter.writeMtdFile() - MayaNodeIdUtils.getAllUsedNodeIds() returned null.");
                return false;
            }
            maya_id = MayaNodeIdUtils.getFirstAvailable(ids);
            File mtd = new File(userShdDirPath, shaderName + ".mtd");
            StringBuffer b = new StringBuffer();
            if (Preferences.get(Preferences.ARNOLD_OSL_MTD_STYLE).equalsIgnoreCase("MAYA")) {
                b.append("# This .mtd file is intended for use with Maya. If your shader will be used by\n");
                b.append("# Houdini the \"style\" of the .mtd can be set in Preferences->Languages-OSL.\n");
                b.append("#\n");
                b.append("# This file is automatically updated by Cutter when its corresponding shader\n");
                b.append("# is compiled.\n");
                b.append("[").append("node ").append(shaderName).append("]\n");
                b.append("\tmaya.name").append("\t\t\t").append("STRING").append("\t").append("\"" + shaderName + "\"\n");
                b.append("\tmaya.id").append("\t\t\t\t").append("INT").append("\t\t").append(maya_id).append("\n");
                b.append("\tmaya.classification").append("\t\t").append("STRING").append("\t").append("\"Utility\"\n");
                b.append("\tmaya.output_name").append("\t\t").append("STRING").append("\t").append("\"").append(outputNames[0]).append("\"\n");
                b.append("\tmaya.output_shortname").append("\t").append("STRING").append("\t").append("\"").append(outputNames[0]).append("\"\n");
            } else {
                b.append("# This .mtd file is intended for use with Houdini. If your shader will be used by\n");
                b.append("# Maya the \"style\" of the .mtd can be set in Preferences->Languages-OSL.\n");
                b.append("#\n");
                b.append("# This file is automatically updated by Cutter when its corresponding shader\n");
                b.append("# is compiled.\n");
                b.append("[").append("node ").append(shaderName).append("]\n");
                b.append("\thoudini.icon").append("\t\t").append("STRING").append("\t").append("\"VOP_" + shaderName + "\"\n");
                b.append("\thoudini.category").append("\t").append("STRING").append("\t").append("\"Utility\"\n");
                b.append("\thoudini.help_url").append("\t").append("STRING").append("\t").append("\"\"\n");
            }
            String[] names = new String[]{shaderName + ".oso"};
            String rawtext = parser.getRawOslInfo(names, new File(userShdDirPath));
            OslShader[] shaders = parser.parseRawOsoInfo(rawtext);
            OslShader shader = shaders[0];
            StringBuffer defaultBuf = new StringBuffer();
            StringBuffer metaBuf = new StringBuffer();
            for (int n = 0; n < shader.getNumParams(); ++n) {
                OslShader.Parameter param = shader.getParamAtIndex(n);
                if (param.isOutput() || param.getDataType().equals("float") && (param.getName().equals("s") || param.getName().equals("t"))) continue;
                b.append("\t[attr ").append(param.getName()).append("]\n");
                if (Preferences.get(Preferences.ARNOLD_OSL_MTD_STYLE).equalsIgnoreCase("HOUDINI")) {
                    b.append("\t\t").append("houdini.label").append("\tSTRING\t\"").append(param.getName()).append("\"\n");
                }
                defaultBuf = new StringBuffer();
                if (param.getDataType().length() > 5) {
                    defaultBuf.append("\t\tdefault").append("\t\t\t").append(param.getDataType().toUpperCase()).append("\t").append(param.getValue()).append("\n");
                } else {
                    defaultBuf.append("\t\tdefault").append("\t\t\t").append(param.getDataType().toUpperCase()).append("\t\t").append(param.getValue()).append("\n");
                }
                Vector<String> metadata = param.getMetaData();
                metaBuf = new StringBuffer();
                for (int i = 0; i < metadata.size(); ++i) {
                    String[] items = TextUtils.tokenize(metadata.elementAt(i), '=');
                    String metavalue = items[1].trim();
                    String[] parts = TextUtils.tokenize(items[0]);
                    String metatype = parts[0].toUpperCase();
                    String metaname = parts[1];
                    if (param.getDataType().equals("int") && metavalue.equals("\"boolean\"")) {
                        String boolValue = param.getValue().equals("0") ? "False" : "True";
                        defaultBuf = new StringBuffer();
                        defaultBuf.append("\t\tdefault").append("\t\t\t").append("BOOL").append("\t\t").append(boolValue).append("\n");
                        continue;
                    }
                    if (metatype.equals("STRING") && metaname.equals("widget") && metavalue.equals("\"fileInput\"")) {
                        metatype = "BOOL";
                        metaname = "maya.usedAsFilename";
                        metavalue = "TRUE";
                    }
                    if (metatype.equals("STRING") && metaname.equals("widget") && metavalue.equals("\"mapper\"")) {
                        metavalue = "\"popup\"";
                    }
                    if (metatype.equals("STRING") && metaname.equals("widget") && metavalue.equals("\"checkBox\"")) {
                        metavalue = "\"boolean\"";
                    }
                    if (metatype.equals("STRING") && metaname.equals("help")) {
                        metaname = "desc";
                    }
                    if (metatype.equals("STRING") && metaname.equals("options")) {
                        metavalue = TextUtils.removeQuotes(metavalue);
                        String[] labels = TextUtils.tokenize(metavalue, '|');
                        StringBuffer labelsBuf = new StringBuffer();
                        labelsBuf.append("\"");
                        for (int j = 0; j < labels.length; ++j) {
                            int colonOffset = labels[j].indexOf(":");
                            if (colonOffset != -1) {
                                labels[j] = labels[j].substring(0, colonOffset);
                            }
                            labelsBuf.append(labels[j]);
                            if (j == labels.length - 1) continue;
                            labelsBuf.append("|");
                        }
                        labelsBuf.append("\"");
                        metavalue = labelsBuf.toString();
                    }
                    if (metaname.length() < 7) {
                        if (metatype.length() < 6) {
                            metaBuf.append("\t\t").append(metaname).append("\t\t").append(metatype).append("\t\t").append(metavalue).append("\n");
                            continue;
                        }
                        metaBuf.append("\t\t").append(metaname).append("\t\t").append(metatype).append("\t").append(metavalue).append("\n");
                        continue;
                    }
                    metaBuf.append("\t\t").append(metaname).append("\t").append(metatype).append("\t").append(metavalue).append("\n");
                }
                b.append(defaultBuf.toString());
                b.append(metaBuf.toString());
            }
            FileUtils.writeFile(mtd, b.toString());
            String msg = "\n\nThe metadata file \"" + mtd.getName() + "\" has been updated.";
            Monitor.appendPanelText("Arnold OSL Compile", msg);
            final KAbstractWindow kaw = KAbstractDesktop.getWindowWithFile(mtd);
            if (kaw != null) {
                try {
                    final String str = b.toString();
                    JEditorPane textpane = BBxt.getTextPane(kaw);
                    if (textpane == null) break block27;
                    textpane.setSelectionStart(0);
                    textpane.setSelectionEnd(textpane.getDocument().getLength());
                    final Document document = textpane.getDocument();
                    if (document == null) break block27;
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    document.remove(0, document.getLength());
                                    document.insertString(0, str, null);
                                    kaw.saveFile();
                                }
                                catch (BadLocationException ex) {
                                    Cutter.setLog("    Exception:OslCompilerManager.writeMtdFile() - " + ex.toString());
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                catch (Exception e) {
                    Cutter.setLog("    Exception:OslCompilerManager.writeMtdFile() - " + e.toString());
                    return false;
                }
            }
        }
        return true;
    }
}

