/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import UI_BBXT.BBxt;
import UI_Script.Osl.OslArgsStrings;
import UI_Script.Osl.OslMetaDataMapperItem;
import UI_Script.Osl.OslMetaDataParser;
import UI_Script.Osl.OslShader;
import Utilities.MayaNodeIdUtils;
import Utilities.TextUtils;

public class OslArgsWriter {
    private StringBuffer buff = new StringBuffer();

    private String setWidget(String str, OslShader.Parameter param) {
        String widget = OslMetaDataParser.getWidget(param);
        if (widget.trim().length() == 0) {
            str = str.replaceAll("(_WIDGET_)", "");
        } else {
            String replacement = "widget=\"" + widget + "\"";
            str = str.replaceAll("(_WIDGET_)", replacement);
        }
        return str;
    }

    private String _setStructInput(String str, OslShader.Parameter param) {
        str = this.setParamLabelDef(str, param);
        return str;
    }

    private String setRegularOutput(String str, OslShader.Parameter param) {
        str = str.replaceAll("(_OUTNAME_)", param.getName());
        str = str.replaceAll("(_LABEL_)", OslMetaDataParser.getLabel(param));
        str = str.replaceAll("(_DATATYPE_)", param.getDataType());
        String value = TextUtils.trimLeadingChar(param.getValue(), '\"');
        value = TextUtils.trimTrailingChar(value, '\"');
        str = str.replaceAll("(_DEFAULT_)", value);
        str = this.setWidget(str, param);
        str = str.replaceAll("(_CONNECTABLE_)", OslMetaDataParser.getConnectable(param));
        return this.setHelp(str, param);
    }

    private String setVStructOutput(String str, OslShader.Parameter param) {
        String exprStr;
        str = this.setRegularOutput(str, param);
        String memberStr = OslMetaDataParser.getVstructMember(param);
        if (memberStr != null) {
            str = str.replaceAll("(_MEMBER_)", memberStr);
        }
        if ((exprStr = OslMetaDataParser.getVstructExpr(param)) != null) {
            String expr = "\tvstructConditionalExpr=\"" + exprStr + "\"";
            str = str.replaceAll("(_VSTRUCT_EXPRESSION_)", expr + "\n");
        } else {
            str = str.replaceAll("(_VSTRUCT_EXPRESSION_)", "");
        }
        str = this.setWidget(str, param);
        return str;
    }

    private String setParamLabelDef(String str, OslShader.Parameter param) {
        str = str.replaceAll("(_PARAM_)", param.getName());
        str = str.replaceAll("(_LABEL_)", OslMetaDataParser.getLabel(param));
        String value = TextUtils.trimLeadingChar(param.getValue(), '\"');
        value = TextUtils.trimTrailingChar(value, '\"');
        str = str.replaceAll("(_DEFAULT_)", value);
        str = str.replaceAll("(_MIN_)", OslMetaDataParser.getMin(param));
        str = str.replaceAll("(_MAX_)", OslMetaDataParser.getMax(param));
        str = str.replaceAll("(_DATATYPE_)", param.getDataType());
        str = this.setWidget(str, param);
        str = str.replaceAll("(_CONNECTABLE_)", OslMetaDataParser.getConnectable(param));
        return this.setHelp(str, param);
    }

    private String setHelp(String str, OslShader.Parameter param) {
        String helpStr;
        String memberStr = OslMetaDataParser.getVstructMember(param);
        if (memberStr != null) {
            str = str.replaceAll("(_MEMBER_)", memberStr);
        }
        if ((helpStr = OslMetaDataParser.getHelp(param)) != null && helpStr.trim().length() > 0) {
            String[] help = TextUtils.formatAsArray(helpStr, 60);
            StringBuffer tmp = new StringBuffer();
            for (int k = 0; k < help.length; ++k) {
                String ss = this.indent(help[k]);
                if (k == 0) {
                    ss = ss.trim() + "\n";
                }
                if (k == help.length - 1) {
                    ss = TextUtils.trimTrailingChar(ss, '\n');
                }
                tmp.append(ss);
            }
            helpStr = tmp.toString();
            String s = OslArgsStrings.helpTag;
            s = s.replaceAll("(_HELP_)", helpStr);
            str = str.replaceAll("(_HELP_)", s);
        } else {
            str = str.replaceAll("(_HELP_)", "");
            str = memberStr != null ? str.replaceAll("(\n</param>)", "\n</param>\n") : str.replaceAll("(\n\n</param>)", "\n</param>\n");
        }
        return str;
    }

    private String setNumberMapperText(OslShader.Parameter param) {
        OslMetaDataMapperItem[] items = OslMetaDataParser.getSortedMapperItems(param);
        if (items == null) {
            return null;
        }
        String paramType = param.getDataType();
        String str = this.setParamLabelDef(OslArgsStrings.genericMenu, param);
        StringBuffer b = new StringBuffer();
        String s = "";
        for (int j = 0; j < items.length; ++j) {
            OslMetaDataMapperItem item = items[j];
            s = OslArgsStrings.menuItem.trim();
            s = s.replaceAll("(_ITEM_NAME_)", item.key);
            s = s.replaceAll("(_INDEX_)", item.val);
            b.append("        ").append(s);
            if (j >= items.length - 1) continue;
            b.append("\n");
        }
        str = this.setWidget(str, param);
        return str.replaceAll("(_MENU_ITEMS_)", b.toString());
    }

    public void writeParams(OslShader shader) {
        OslShader.Parameter param;
        int n;
        String currentPage = null;
        String str = "";
        String s = "";
        StringBuffer b = new StringBuffer();
        StringBuffer parserWarnings = new StringBuffer();
        int numOutputs = 0;
        for (n = 0; n < shader.getNumParams(); ++n) {
            param = shader.getParamAtIndex(n);
            if (param.parserNotes != null) {
                parserWarnings.append(param.parserNotes).append("\n");
            }
            if (!param.isOutput()) continue;
            ++numOutputs;
        }
        for (n = 0; n < shader.getNumParams(); ++n) {
            boolean isVirtualStructPlug;
            param = shader.getParamAtIndex(n);
            if (param.isLockGeom()) continue;
            String paramName = param.getName();
            String paramType = param.getDataType();
            String paramWidget = OslMetaDataParser.getWidget(param);
            String vstructMember = OslMetaDataParser.getVstructMember(param);
            boolean usesVStructMember = vstructMember != null;
            String paramValue = param.getValue();
            String paramLabel = OslMetaDataParser.getLabel(param);
            String min = OslMetaDataParser.getMin(param);
            String max = OslMetaDataParser.getMax(param);
            String pageName = OslMetaDataParser.getPageName(param);
            String paramTag = OslMetaDataParser.getTag(param);
            boolean bl = isVirtualStructPlug = paramTag.equals("vstruct");
            if (param.isOutput()) {
                str = isVirtualStructPlug ? this.setParamLabelDef(OslArgsStrings.structPlugOutput, param) : (!usesVStructMember ? (paramType.equals("float") || paramType.equals("int") ? this.setRegularOutput(OslArgsStrings.numberOut, param) : (paramType.equals("point") || paramType.equals("vector") || paramType.equals("normal") || paramType.equals("color") ? this.setRegularOutput(OslArgsStrings.type3Out, param) : paramName + "  is not used")) : (paramType.equals("float") || paramType.equals("int") ? this.setVStructOutput(OslArgsStrings.numberVStructMemberOut, param) : (paramType.equals("point") || paramType.equals("vector") || paramType.equals("normal") || paramType.equals("color") ? this.setVStructOutput(OslArgsStrings.type3VStructMemberOut, param) : paramName + "  is not used")));
            } else if (isVirtualStructPlug) {
                str = this.setParamLabelDef(OslArgsStrings.structPlugInput, param);
            } else if (paramWidget.equals("boolean") && (paramType.equals("int") || paramType.equals("string"))) {
                str = this.setParamLabelDef(OslArgsStrings.genericMenu, param);
                String trueStr = paramType.equals("string") ? "Yes" : "1";
                String falseStr = paramType.equals("string") ? "No" : "0";
                String trueIndexStr = paramType.equals("string") ? "true" : "1";
                String falseIndexStr = paramType.equals("string") ? "false" : "0";
                s = OslArgsStrings.menuItem.trim();
                s = s.replaceAll("(_ITEM_NAME_)", trueStr);
                s = s.replaceAll("(_INDEX_)", trueIndexStr);
                b.setLength(0);
                b.append("        ").append(s).append("\n");
                s = OslArgsStrings.menuItem.trim();
                s = s.replaceAll("(_ITEM_NAME_)", falseStr);
                s = s.replaceAll("(_INDEX_)", falseIndexStr);
                b.append("        ").append(s);
                str = str.replaceAll("(_MENU_ITEMS_)", b.toString());
            } else if (paramType.equals("point") || paramType.equals("vector") || paramType.equals("normal")) {
                if (usesVStructMember) {
                    str = this.setParamLabelDef(OslArgsStrings.type3VStructMemberInput, param);
                }
            } else if (paramType.equals("float") || paramType.equals("int")) {
                str = paramWidget.equals("mapper") ? this.setNumberMapperText(param) : (paramWidget.equals("checkBox") ? this.setParamLabelDef(OslArgsStrings.intCheckbox, param) : (usesVStructMember ? this.setParamLabelDef(OslArgsStrings.numberVStructMemberInput, param) : this.setParamLabelDef(OslArgsStrings.numberSlider, param)));
            } else if (paramType.equals("color")) {
                str = usesVStructMember ? this.setParamLabelDef(OslArgsStrings.colorVStructMemberInput, param) : this.setParamLabelDef(OslArgsStrings.colorSwatch, param);
            } else if (paramType.equals("string")) {
                Object item;
                Object[] items;
                if (paramWidget.equals("filename")) {
                    str = this.setParamLabelDef(OslArgsStrings.strFile, param);
                } else if (paramWidget.equals("mapper")) {
                    items = OslMetaDataParser.getSortedMapperItems(param);
                    if (items == null) continue;
                    str = this.setParamLabelDef(OslArgsStrings.genericMenu, param);
                    b.setLength(0);
                    for (int j = 0; j < items.length; ++j) {
                        item = items[j];
                        s = OslArgsStrings.menuItem.trim();
                        s = s.replaceAll("(_ITEM_NAME_)", ((OslMetaDataMapperItem)item).key);
                        s = s.replaceAll("(_INDEX_)", ((OslMetaDataMapperItem)item).val);
                        b.append("        ").append(s);
                        if (j >= items.length - 1) continue;
                        b.append("\n");
                    }
                    str = str.replaceAll("(_MENU_ITEMS_)", b.toString());
                } else if (paramWidget.equals("popup")) {
                    items = OslMetaDataParser.getPopupItems(param);
                    if (items == null) continue;
                    str = this.setParamLabelDef(OslArgsStrings.genericMenu, param);
                    b.setLength(0);
                    for (int j = 0; j < items.length; ++j) {
                        item = items[j];
                        s = OslArgsStrings.menuItem.trim();
                        s = s.replaceAll("(_ITEM_NAME_)", (String)item);
                        s = s.replaceAll("(_INDEX_)", (String)item);
                        b.append("        ").append(s);
                        if (j >= items.length - 1) continue;
                        b.append("\n");
                    }
                    str = str.replaceAll("(_MENU_ITEMS_)", b.toString());
                } else {
                    str = this.setParamLabelDef(OslArgsStrings.strPlain, param);
                }
            } else if (param.getDataType().equals("normal") || param.getDataType().equals("vector") || param.getDataType().equals("point")) {
                str = this.setParamLabelDef(OslArgsStrings.type3Input, param);
            }
            if (pageName.trim().length() > 0) {
                if (currentPage != null && !currentPage.equals(pageName)) {
                    this.buff.append(OslArgsStrings.pageClose).append("\n");
                }
                if (currentPage == null || currentPage != null && !currentPage.equals(pageName)) {
                    currentPage = pageName;
                    String openTag = OslArgsStrings.pageOpen;
                    openTag = openTag.replaceAll("(_PAGE_NAME_)", currentPage);
                    openTag = openTag.replaceAll("(_STATE_)", "True");
                    this.buff.append(openTag).append("\n");
                }
            }
            if (str != null && str.length() > 0) {
                this.buff.append(str).append("\n");
            }
            str = "";
        }
        String bodyText = this.indent(this.buff.toString());
        this.buff.setLength(0);
        String head = OslArgsStrings.headerText;
        if (parserWarnings.length() > 0) {
            head = "<!--\n" + parserWarnings.toString() + "-->\n" + head;
        }
        String shaderType = numOutputs > 0 ? "pattern" : "bxdf";
        head = head.replaceAll("(_SHADERTYPE_)", shaderType);
        String shdHelpStr = OslMetaDataParser.getHelp(shader.getMetaData());
        shdHelpStr = shdHelpStr == null ? "No Description Available" : shdHelpStr;
        String[] help = TextUtils.formatAsArray(shdHelpStr, 60);
        StringBuffer tmp = new StringBuffer();
        for (int k = 0; k < help.length; ++k) {
            String ss = this.indent(help[k]);
            if (k == 0) {
                ss = ss.trim() + "\n";
            }
            if (k == help.length - 1) {
                ss = TextUtils.trimTrailingChar(ss, '\n');
            }
            tmp.append(ss);
        }
        head = head.replaceAll("(_SHADER_HELP_)", tmp.toString());
        this.buff.append(head).append("\n");
        this.buff.append(bodyText);
        if (currentPage != null) {
            this.buff.append("\t").append(OslArgsStrings.pageClose).append("\n");
        }
        String tail = OslArgsStrings.tailText;
        tail = tail.replaceAll("(_SHADERTYPE_)", "pattern");
        String minNodeidStr = "" + MayaNodeIdUtils.getMinNodeId();
        tail = tail.replaceAll("(_NODEID_)", minNodeidStr);
        this.buff.append("\n").append(tail).append("\n");
        BBxt.newDocument(shader.getName() + ".args", this.buff.toString());
    }

    private String indent(String src) {
        StringBuffer b = new StringBuffer();
        String[] lines = TextUtils.tokenize(src, '\n');
        String tab1Str = "\t";
        String tab2Str = "\t\t";
        for (int n = 0; n < lines.length; ++n) {
            if (lines[n].trim().startsWith("<page") || lines[n].trim().startsWith("</page")) {
                b.append(tab1Str).append(lines[n]).append("\n");
                continue;
            }
            b.append(tab2Str).append(lines[n]).append("\n");
        }
        return b.toString();
    }
}

