/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Osl.ArnoldMtdWriter;
import UI_Script.Osl.OslShaderDuplicator;
import UI_Script.Osl.OslTokenizer;
import UI_Script.Osl.OslinfoParser;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.FileUtils;
import Utilities.MayaNodeIdUtils;
import Utilities.OslUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class OslCompilerManager {
    private static OslCompilerManager instance = null;
    public static int OSL_ENV_UNKNOWN = 0;
    public static int OSL_ENV_PIXAR = 1;
    public static int OSL_ENV_ARNOLD = 2;
    public static int OSL_ENV_VRAY = 3;
    private static String[] cannotAssignIdMsg = new String[]{"For a nodeid to be generated the shader must", "be compiled. Make sure the shader has been", "saved and can be compiled without errors."};
    static String[] errors = new String[]{"Failed", "Error:", "Error", "Unknown", "Can't"};

    public static OslCompilerManager getInstance() {
        if (instance == null) {
            new OslCompilerManager();
        }
        return instance;
    }

    private OslCompilerManager() {
        instance = this;
    }

    public boolean doRmanCompile(File srcFile) {
        String binPath = OslUtils.getRmanBin();
        if (binPath == null) {
            OslUtils.showRmanNoBinMsg();
            return false;
        }
        String userShdDirPath = Preferences.get(Preferences.PATH_USER_OSL_SHADERS);
        boolean exists = new File(userShdDirPath).exists();
        if (userShdDirPath.trim().length() == 0 || !exists) {
            OslUtils.showRmanNoShaderPathMsg();
            return false;
        }
        String outputOsoPath = this.doCompile(srcFile, binPath, "oslc", userShdDirPath, "PRMan OSL Compile", true);
        return outputOsoPath != null;
    }

    public boolean doArnoldCompile(File srcFile) {
        String binPath = OslUtils.getArnoldBin();
        if (binPath == null) {
            OslUtils.showArnoldNoBinMsg();
            return false;
        }
        String userShdDirPath = Preferences.get(Preferences.PATH_USER_ARNOLD_OSL_SHADERS);
        boolean exists = new File(userShdDirPath).exists();
        if (userShdDirPath.trim().length() == 0 || !exists) {
            OslUtils.showArnoldNoShaderPathMsg();
            return false;
        }
        String outputOsoPath = this.doCompile(srcFile, binPath, "oslc", userShdDirPath, "Arnold OSL Compile", true);
        return outputOsoPath != null;
    }

    private String doCompile(File srcFile, String binPath, String compilerName, String userShdDirPath, String processName, boolean attemptDup) {
        String path;
        File includes;
        OslTokenizer.ShdTypeName stn = OslUtils.getShaderTypeAndName(srcFile);
        if (stn == null) {
            OslUtils.showShaderTypeNameErrorMsg(srcFile);
            return null;
        }
        OslUtils.adjustDefine(srcFile, processName);
        File userSrcDir = srcFile.getParentFile();
        Vector<String> listOfDuoFlags = new Vector<String>();
        listOfDuoFlags.addElement("-I" + userSrcDir.getPath());
        if (processName.equals("Arnold OSL Compile") && (includes = new File(path = Preferences.get(Preferences.PATH_USER_ARNOLD_OSL_INCLUDES))).exists()) {
            listOfDuoFlags.addElement("-I" + includes.getPath());
        }
        String[] arr = new String[4 + listOfDuoFlags.size()];
        String mangledBinPath = TextUtils.trimTrailingChar(binPath, '/');
        mangledBinPath = !mangledBinPath.endsWith("bin") ? mangledBinPath + "/bin/" : mangledBinPath + "/";
        String outputOsoPath = new File(userShdDirPath, stn.shaderName).getPath() + ".oso";
        int index = 0;
        arr[index++] = mangledBinPath + "oslc";
        for (int n = 0; n < listOfDuoFlags.size(); ++n) {
            arr[index++] = (String)listOfDuoFlags.elementAt(n);
        }
        arr[index++] = "-o";
        arr[index++] = outputOsoPath;
        arr[index++] = srcFile.getPath();
        PostCompileActions actions = new PostCompileActions(processName, binPath, userShdDirPath, stn.shaderName);
        ProcessManager fp = new ProcessManager(processName);
        fp.launch(arr, null, true, actions, false, false);
        return outputOsoPath;
    }

    private boolean _writeMtdFile(File srcFile, String binPath, String userShdDirPath, String shaderName) {
        Cutter.setLog("    Info: OslCompileManager.writeMtdFile()  shaderName " + shaderName);
        OslinfoParser parser = new OslinfoParser(binPath);
        File shd = new File(userShdDirPath, shaderName);
        OslinfoParser.RibInfo info = parser.getRibInfo(shaderName, shd);
        if (info == null) {
            Cutter.setLog("    Error: OslCompilerManager.writeMtdFile() - OslinfoParser.RibInfo info is null.");
            Cutter.setLog("    Error: OslCompilerManager.writeMtdFile() - shader nae \"" + shaderName + "\".");
            return false;
        }
        if (info.outputs == null || info.outputs.length < 1) {
            return false;
        }
        String[] outputNames = new String[info.outputs.length];
        for (int n = 0; n < outputNames.length; ++n) {
            outputNames[n] = info.outputs[n].getName();
        }
        if (outputNames[0] == null || outputNames[0].trim().length() == 0) {
            return false;
        }
        int[] ids = MayaNodeIdUtils.getAllUsedNodeIds();
        int maya_id = 1;
        if (ids == null) {
            Cutter.setLog("    Info:OslCompilerManager.writeMtdFile() - MayaNodeIdUtils.getAllUsedNodeIds() returned null.");
        } else {
            maya_id = MayaNodeIdUtils.getFirstAvailable(ids);
        }
        File mtd = new File(userShdDirPath, shaderName + ".mtd");
        StringBuffer b = new StringBuffer();
        b.append("[").append("node ").append(shaderName).append("]\n");
        b.append("\tmaya.name").append("\t\t\t\t").append("STRING").append("\t").append("\"" + shaderName + "\"\n");
        b.append("\tmaya.id").append("\t\t\t\t\t").append("INT").append("\t\t").append(maya_id).append("\n");
        b.append("\tmaya.classification").append("\t\t").append("STRING").append("\t").append("\"Utility\"\n");
        b.append("\tmaya.output_name").append("\t\t").append("STRING").append("\t").append("\"").append(outputNames[0]).append("\"\n");
        b.append("\tmaya.output_shortname").append("\t").append("STRING").append("\t").append("\"").append(outputNames[0]).append("\"\n");
        FileUtils.writeFile(mtd, b.toString());
        final KAbstractWindow kaw = KAbstractDesktop.getWindowWithFile(mtd);
        if (kaw != null) {
            try {
                final String str = b.toString();
                JEditorPane textpane = BBxt.getTextPane(kaw);
                if (textpane != null) {
                    textpane.setSelectionStart(0);
                    textpane.setSelectionEnd(textpane.getDocument().getLength());
                    final Document document = textpane.getDocument();
                    if (document != null) {
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        document.remove(0, document.getLength());
                                        document.insertString(0, str, null);
                                        kaw.saveFile();
                                    }
                                    catch (BadLocationException ex) {
                                        Cutter.setLog("    Exception:OslCompilerManager.writeMtdFile() - " + ex.toString());
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                Cutter.setLog("    Exception:OslCompilerManager.writeMtdFile() - " + e.toString());
            }
        }
        return true;
    }

    private class PostCompileActions
    implements ProcListener {
        private boolean failure = false;
        private String processName;
        private String binPath;
        private String userShdDirPath;
        private String shaderName;

        private PostCompileActions(String procName, String binPath, String userShdDirPath, String shaderName) {
            this.processName = procName;
            this.binPath = binPath;
            this.userShdDirPath = userShdDirPath;
            this.shaderName = shaderName;
        }

        private boolean failureHappened(String output) {
            for (int n = 0; n < errors.length; ++n) {
                if (!TextUtils.contains(output, errors[n], true)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void processStarted(String procName, String[] progarray, String procID) {
        }

        @Override
        public void processSentString(String procName, String output) {
            if (this.failure) {
                return;
            }
            this.failure = this.failureHappened(output);
        }

        @Override
        public void processFinished(String[] progarray) {
            String boolStr;
            if (this.failure) {
                return;
            }
            if (this.processName.equals("Arnold OSL Compile")) {
                ArnoldMtdWriter writer = new ArnoldMtdWriter();
                boolean result = writer.writeMtdFile(this.binPath, this.userShdDirPath, this.shaderName);
                String boolStr2 = Preferences.get(Preferences.ARNOLD_DO_OSO_MTD_DUPLICATION);
                if (result && boolStr2.equals("true")) {
                    OslShaderDuplicator.doDuplication("Arnold OSL Compile", this.userShdDirPath, this.shaderName);
                }
            } else if (this.processName.equals("PRMan OSL Compile") && (boolStr = Preferences.get(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION)).equals("true")) {
                OslShaderDuplicator.doDuplication("PRMan OSL Compile", this.userShdDirPath, this.shaderName);
            }
            this.failure = false;
        }
    }
}

