/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.KMenuItem;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Osl.OslArgsWriter;
import UI_Script.Osl.OslCompilerManager;
import UI_Script.Osl.OslFuncStrs;
import UI_Script.Osl.OslHtmlWriter;
import UI_Script.Osl.OslMetaHelper;
import UI_Script.Osl.OslRis20RibGenerator;
import UI_Script.Osl.OslRis21RibGenerator;
import UI_Script.Osl.OslShader;
import UI_Script.Osl.OslTokenizer;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Rman.RIS.Ris20MenuActions;
import UI_Tools.Rman.RIS.Ris21MenuActions;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.Resources.OSLToolTips;
import UI_Tools.Rman.RmanMenus;
import Utilities.BrowserUtils;
import Utilities.DialogUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.ListenerUtils;
import Utilities.MayaNodeIdUtils;
import Utilities.OslUtils;
import Utilities.TextUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class OslHelp
extends KAbstractHelp
implements PopupMenuListener {
    static OslTokenizer funcLookup;
    private static Hashtable<String, String> languageTable;
    JMenu metaDataMenu = null;
    JMenuItem rmanCompileItem = new JMenuItem("Compile for PRMan");
    JMenuItem arnoldCompileItem = new JMenuItem("Compile for Arnold");
    JMenu miscOptions = new JMenu("Other Actions");
    JMenuItem previsUiItem = new JMenuItem("Open UI Preview in Browser");
    JMenuItem openMtdItem = new JMenuItem("Open Arnold mtd File");
    JMenuItem pxrOslArchiveItem = new JMenuItem("Create Rib Archive");
    JMenuItem pxrOslBeautyItem = new JMenuItem("Create Beauty Rib");
    JMenuItem exportAsArgsItem = new JMenuItem("Create Equivalent Args Script");
    JMenuItem nodeIdReportItem = new JMenuItem("Generate NodeID Report");
    JMenu closures = new JMenu("Closures");
    KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();

    public OslHelp(KTextPane textpane) {
        super(textpane);
        if (funcLookup == null) {
            funcLookup = new OslTokenizer();
        }
        this.completer.completionActivate();
        char[] delims = KCaret.getDefaultDelimitors();
        char[] modified = new char[delims.length - 1];
        int counter = 0;
        for (int n = 0; n < delims.length; ++n) {
            if (delims[n] == '#') continue;
            modified[counter] = delims[n];
            ++counter;
        }
        this.completer.setWordStartDelims(modified);
        this.completer.setListeners(textpane, this);
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        boolean result = false;
        if (str == null || str.trim().length() == 0) {
            result = false;
        } else if (str.startsWith("D") || str.startsWith("M") || str.startsWith("#")) {
            result = true;
        } else if (Character.isLowerCase(str.charAt(0)) && str.trim().length() >= 2) {
            result = true;
        }
        return result;
    }

    @Override
    public String[] completionCandidates(String str) {
        return this.completionCandidates(str, languageTable);
    }

    private void enableRmanItems(boolean state) {
        this.rmanCompileItem.setEnabled(state);
        this.pxrOslArchiveItem.setEnabled(state);
        this.pxrOslBeautyItem.setEnabled(state);
        this.exportAsArgsItem.setEnabled(state);
    }

    private void enableArnoldItems(boolean state) {
        this.arnoldCompileItem.setEnabled(state);
        this.openMtdItem.setEnabled(state);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        File winfile = BBxt.getWindowFile();
        if (winfile == null || !winfile.exists()) {
            this.enableRmanItems(false);
            this.enableArnoldItems(false);
            this.previsUiItem.setEnabled(false);
            return;
        }
        OslTokenizer tok = new OslTokenizer();
        tok.setBuffer(BBxt.getWindowText());
        tok.setBufferLength(10000);
        OslTokenizer.ShdTypeName stn = tok.getShaderTypeOffsets();
        if (stn == null) {
            this.enableRmanItems(false);
            this.enableArnoldItems(false);
            this.previsUiItem.setEnabled(false);
            Cutter.setLog("    Info:OslHelp.popupMenuWillBecomeVisible() - tok.getShaderTypeOffsets() return null.");
            return;
        }
        this.enableRmanItems(OslUtils.rmanIsAvailable());
        this.enableArnoldItems(OslUtils.arnoldIsAvailable());
        this.arnoldCompileItem.setEnabled(OslUtils.arnoldIsAvailable());
        if (!OslUtils.rmanIsAvailable() && !OslUtils.arnoldIsAvailable()) {
            this.enableRmanItems(false);
            this.enableArnoldItems(false);
            this.previsUiItem.setEnabled(false);
            Cutter.setLog("    Info:OslHelp.popupMenuWillBecomeVisible() - both rman and arnold are not available.");
            return;
        }
        File osoFile = null;
        if (OslUtils.rmanIsAvailable()) {
            osoFile = RenderInfo.prmanMajorVersionNumber() < 21 ? OslRis20RibGenerator.getShaderFile(this.textpane.getFrame().getFile()) : OslRis21RibGenerator.getShaderFile(this.textpane.getFrame().getFile(), stn.shaderName);
        } else if (OslUtils.arnoldIsAvailable()) {
            String userShdDirPath = Preferences.get(Preferences.PATH_USER_ARNOLD_OSL_SHADERS);
            osoFile = new File(userShdDirPath, stn.shaderName + ".oso");
        }
        if (osoFile != null && osoFile.exists()) {
            if (OslUtils.rmanIsAvailable()) {
                if (!stn.shaderType.equals("shader")) {
                    this.enableRmanItems(false);
                    this.previsUiItem.setEnabled(false);
                } else {
                    this.previsUiItem.setEnabled(true);
                    this.enableRmanItems(true);
                }
            } else if (OslUtils.rmanIsAvailable() || OslUtils.arnoldIsAvailable()) {
                this.previsUiItem.setEnabled(true);
            } else {
                this.previsUiItem.setEnabled(false);
            }
        }
        this.closures.setEnabled(true);
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        Object menuActions;
        boolean showParamMenu = true;
        OslTokenizer tok = new OslTokenizer();
        tok.setBuffer(BBxt.getWindowText());
        OslTokenizer.ShdTypeName stn = tok.getShaderTypeOffsets();
        if (stn != null && insertAt >= stn.bodyBegin) {
            showParamMenu = false;
        } else if (stn != null && insertAt < stn.endOfName - stn.shaderName.length()) {
            showParamMenu = false;
        }
        int begin = insertAt - selection.length();
        this.popup.removeAll();
        PopupMenuListener[] pops = this.popup.getPopupMenuListeners();
        if (pops != null) {
            for (int n = 0; n < pops.length; ++n) {
                this.popup.removePopupMenuListener(pops[n]);
            }
        }
        this.popup.addPopupMenuListener(this);
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, insertAt - selection.length(), insertAt);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            defaultMenu.add(items[n]);
        }
        if (showParamMenu) {
            OslMetaHelper helper = new OslMetaHelper(this.textpane);
            this.metaDataMenu = helper.getMetaDataMenu(selection, insertAt);
            this.popup.add(this.metaDataMenu);
        }
        if (!showParamMenu) {
            JMenu globals_menu = this.getGlobals("Global Variables", selection, insertAt);
            this.popup.add(globals_menu);
            JMenu const_menu = this.getConstants("Constants", selection, insertAt);
            this.popup.add(const_menu);
            JMenu math_menu = this.getMathFuncs("Maths", selection, insertAt);
            this.popup.add(math_menu);
            JMenu color_menu = this.getColorFuncs("Color", selection, insertAt);
            this.popup.add(color_menu);
            JMenu pat_menu = this.getPatternFuncs("Pattern", selection, insertAt);
            this.popup.add(pat_menu);
            JMenu geo_menu = this.getGeoFuncs("Geometric", selection, insertAt);
            this.popup.add(geo_menu);
            JMenu msg_menu = this.getMsgFuncs("State & Messages", selection, insertAt);
            this.popup.add(msg_menu);
            JMenu mat_menu = this.getMatrixFuncs("Matrix", selection, insertAt);
            this.popup.add(mat_menu);
            JMenu deriv_menu = this.getDerivFuncs("Derivatives", selection, insertAt);
            this.popup.add(deriv_menu);
            JMenu misc_menu = this.getMiscFuncs("Miscellaneous", selection, insertAt);
            this.popup.add(misc_menu);
            JMenu matclose_menu = this.getSurfaceClosures("Surface", selection, insertAt);
            this.closures.add(matclose_menu);
            JMenu volclose_menu = this.getVolumeClosures("Volume", selection, insertAt);
            this.closures.add(volclose_menu);
            JMenu litclose_menu = this.getLightClosures("Light", selection, insertAt);
            this.closures.add(litclose_menu);
            JMenu sigclose_menu = this.getLightClosures("Signal", selection, insertAt);
            this.closures.add(sigclose_menu);
            this.popup.add(this.closures);
            this.popup.add(new JSeparator());
        }
        ListenerUtils.removeAllActions(this.rmanCompileItem);
        ListenerUtils.removeAllActions(this.arnoldCompileItem);
        ListenerUtils.removeAllActions(this.previsUiItem);
        ListenerUtils.removeAllActions(this.openMtdItem);
        ListenerUtils.removeAllActions(this.pxrOslArchiveItem);
        ListenerUtils.removeAllActions(this.pxrOslBeautyItem);
        ListenerUtils.removeAllActions(this.exportAsArgsItem);
        ListenerUtils.removeAllActions(this.nodeIdReportItem);
        this.rmanCompileItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = OslHelp.this.textpane.getFrameFile();
                if (f != null) {
                    BBxt.save();
                    OslCompilerManager.getInstance().doRmanCompile(f);
                }
            }
        });
        this.arnoldCompileItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = OslHelp.this.textpane.getFrameFile();
                if (f != null) {
                    BBxt.save();
                    OslCompilerManager.getInstance().doArnoldCompile(f);
                }
            }
        });
        this.previsUiItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OslHelp.this.openPreViewInBrowser();
            }
        });
        this.openMtdItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String shadername = BBxt.oslGetShaderName();
                if (shadername == null || shadername.trim().length() == 0) {
                    Cutter.setLog("    Info:OslHelp.openMtd() - unable to get the name of the shader!");
                    return;
                }
                String mtd_name = shadername + ".mtd";
                String userShdDirPath = Preferences.get(Preferences.PATH_USER_ARNOLD_OSL_SHADERS);
                File f = new File(userShdDirPath, mtd_name);
                if (f.exists()) {
                    BBxt.newDocument(f);
                } else {
                    Cutter.setLog("    Info:OslHelp.openMtd() - cannot find \"" + f.getPath() + "\"");
                }
            }
        });
        this.pxrOslArchiveItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RenderInfo.prmanMajorVersionNumber() < 21) {
                    OslRis20RibGenerator.createDocument("untitled" + RmanMenus.untitledCounter++ + ".rib", "PxrOSL.rib", OslHelp.this.textpane.getFrame().getFile());
                } else {
                    OslRis21RibGenerator.createArchive("untitled" + RmanMenus.untitledCounter++ + ".rib", OslHelp.this.textpane.getFrame().getFile());
                }
            }
        });
        if (RenderInfo.prmanMajorVersionNumber() < 21) {
            menuActions = new Ris20MenuActions();
            this.pxrOslBeautyItem.addActionListener(((Ris20MenuActions)menuActions).getPxrOslBeautyAction());
        } else {
            menuActions = new Ris21MenuActions();
            this.pxrOslBeautyItem.addActionListener(((Ris21MenuActions)menuActions).getPxrOslBeautyAction());
        }
        this.exportAsArgsItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OslHelp.exportAsArgsFile();
            }
        });
        this.nodeIdReportItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MayaNodeIdUtils.writeFullReport();
            }
        });
        this.miscOptions.add(this.openMtdItem);
        this.miscOptions.add(this.previsUiItem);
        this.miscOptions.add(this.pxrOslArchiveItem);
        this.miscOptions.add(this.pxrOslBeautyItem);
        this.miscOptions.add(this.exportAsArgsItem);
        this.popup.add(new JSeparator());
        this.popup.add(this.rmanCompileItem);
        this.popup.add(this.arnoldCompileItem);
        this.popup.add(new JSeparator());
        this.popup.add(this.miscOptions);
        this.popup.add(this.nodeIdReportItem);
        this.popup.add(new JSeparator());
        this.popup.add(defaultMenu);
        if (this.popup != null) {
            this.popup.setRequestFocusEnabled(false);
            try {
                this.popup.show(this.textpane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:OslHelp.popupOnlineHelp()\n      " + ex.toString());
            }
        }
    }

    private static void exportAsArgsFile() {
        boolean result = false;
        File f = BBxt.getWindowFile();
        if (f != null) {
            BBxt.save();
            result = OslCompilerManager.getInstance().doRmanCompile(f);
        }
        if (!result) {
            String[] msg = new String[]{"For a .args file to be generated the shader must", "be compiled. Make sure the shader has been", "saved and can be compiled without errors."};
            DialogUtils.showErrorMessage("Error: Cannot Generate .args Script", msg);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OslShader shader = OslShader.getDesktopShader(OslCompilerManager.OSL_ENV_PIXAR);
                if (shader == null) {
                    return;
                }
                OslArgsWriter writer = new OslArgsWriter();
                writer.writeParams(shader);
            }
        });
    }

    private void openPreViewInBrowser() {
        boolean result = false;
        File f = BBxt.getWindowFile();
        int oslEnv = OslCompilerManager.OSL_ENV_UNKNOWN;
        if (f != null) {
            BBxt.save();
            if (Preferences.get(Preferences.OSL_COMPILE_KEYBOARD_SHORTCUT).equalsIgnoreCase("PRMAN")) {
                result = OslCompilerManager.getInstance().doRmanCompile(f);
                oslEnv = OslCompilerManager.OSL_ENV_PIXAR;
            } else {
                result = OslCompilerManager.getInstance().doArnoldCompile(f);
                oslEnv = OslCompilerManager.OSL_ENV_ARNOLD;
            }
        }
        if (!result) {
            String[] msg = new String[]{"For the UI to be previewed the shader must", "be compiled. Make sure the shader has been", "saved and can be compiled without errors."};
            DialogUtils.showErrorMessage("Error: Cannot Compile the Shader", msg);
            return;
        }
        final int env = oslEnv;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String srcText = BBxt.getWindowText();
                if (srcText == null) {
                    return;
                }
                String osoName = BBxt.oslGetShaderName(srcText);
                if (osoName == null) {
                    return;
                }
                OslShader shader = OslShader.getDesktopShader(env);
                if (shader == null) {
                    return;
                }
                try {
                    File dir = new File(FileUtils.getPWDFile(), "preview_" + osoName);
                    File index = new File(dir, "index.html");
                    OslHtmlWriter.deleteHostDir(dir);
                    OslHtmlWriter.createHostDir(dir);
                    OslHtmlWriter writer = new OslHtmlWriter(index);
                    writer.writeHeader();
                    writer.writeParams(shader);
                    writer.writeTail();
                    writer.writeSelf();
                    boolean isFirefox = false;
                    if (Preferences.get(Preferences.WEB_BROWSER_PREFERRED).equalsIgnoreCase("firefox")) {
                        isFirefox = true;
                    }
                    if (EnvUtils.getOSName().equalsIgnoreCase("Windows 7") && isFirefox) {
                        String str = "file:\\" + index.getPath();
                        BrowserUtils.open(str, true);
                    } else {
                        BrowserUtils.open(index);
                    }
                }
                catch (Exception ex) {
                    Cutter.setLog("    Exception: OslHelp.openPreViewInBrowser\n        " + ex.toString());
                }
            }
        });
    }

    private String[] commonTooltipFormat(String[] tips) {
        if (tips == null) {
            return null;
        }
        String[] out = new String[tips.length];
        for (int k = 0; k < tips.length; ++k) {
            out[k] = TextUtils.format(tips[k], 40, 100, null);
        }
        return out;
    }

    private JMenu getGlobals(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.Globals;
        String[] tips = OSLToolTips.globals;
        if (strns.length != tips.length) {
            Cutter.setLog("    Error:OslHelp.getGlobals() - strsns and tips have different lengths.");
            tips = null;
        } else {
            tips = this.commonTooltipFormat(tips);
        }
        for (int n = 0; n < strns.length; ++n) {
            KMenuItem mi = new KMenuItem(strns[n][0]);
            if (tips != null) {
                mi.setToolTipText(tips[n]);
            }
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getConstants(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.Constants;
        String[] tips = OSLToolTips.constants;
        if (strns.length != tips.length) {
            Cutter.setLog("    Error:OslHelp.getConstants() - strns and tips have different lengths " + strns.length + " and " + tips.length + ".");
            tips = null;
        } else {
            tips = this.commonTooltipFormat(tips);
        }
        for (int n = 0; n < strns.length; ++n) {
            KMenuItem mi = new KMenuItem(strns[n][0]);
            if (tips != null) {
                mi.setToolTipText(tips[n]);
            }
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getGeoFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.GeoFuncs;
        String[] tips = OSLToolTips.geom;
        if (strns.length != tips.length) {
            Cutter.setLog("    Error:OslHelp.getGeoFuncs() - strns and tips have different lengths " + strns.length + " and " + tips.length + ".");
            tips = null;
        } else {
            tips = this.commonTooltipFormat(tips);
        }
        for (int n = 0; n < strns.length; ++n) {
            KMenuItem mi = new KMenuItem(strns[n][0]);
            if (tips != null) {
                mi.setToolTipText(tips[n]);
            }
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getColorFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.ColorFuncs;
        String[] tips = OSLToolTips.color;
        if (strns.length != tips.length) {
            Cutter.setLog("    Error:OslHelp.getColorFuncs() - strns and tips have different lengths " + strns.length + " and " + tips.length + ".");
            tips = null;
        } else {
            tips = this.commonTooltipFormat(tips);
        }
        for (int n = 0; n < strns.length; ++n) {
            KMenuItem mi = new KMenuItem(strns[n][0]);
            if (tips != null) {
                mi.setToolTipText(tips[n]);
            }
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getPatternFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.PatternFuncs;
        String[] tips = OSLToolTips.patterns;
        if (strns.length != tips.length) {
            Cutter.setLog("    Error:OslHelp.getPatternFuncs() - strns and tips have different lengths " + strns.length + " and " + tips.length + ".");
            tips = null;
        } else {
            tips = this.commonTooltipFormat(tips);
        }
        for (int n = 0; n < strns.length; ++n) {
            KMenuItem mi = new KMenuItem(strns[n][0]);
            if (tips != null) {
                mi.setToolTipText(tips[n]);
            }
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getMathFuncs(String title, String sel, int at) {
        JMenuItem mi;
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.MathFuncs;
        int maxItems = strns.length / 2;
        for (int n = 0; n < maxItems; ++n) {
            mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        menu.add(new JSeparator());
        JMenu subMenu = new JMenu("more...");
        menu.add(subMenu);
        for (int n = maxItems; n < strns.length; ++n) {
            mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            subMenu.add(mi);
        }
        return menu;
    }

    private JMenu getDerivFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.DerivFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getMsgFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.MessageFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getMatrixFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.MatrixFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getMiscFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.MiscFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getSurfaceClosures(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.SurfaceClosures;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getVolumeClosures(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.VolumeClosures;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getLightClosures(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.LightClosures;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getSignalClosures(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = OslFuncStrs.SignalClosures;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }

    @Override
    public void lookup(String item) {
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        if (e.getModifiersEx() < 20) {
            Cutter.setLog("    Debug:OslHelp.showDocFor() - return false because e.getModifiers() < 20");
            return false;
        }
        this.useCutterBrowser = !e.isShiftDown();
        return this.launchBrowser(item);
    }

    public boolean showDocFor(String item, boolean shiftDown) {
        this.useCutterBrowser = !shiftDown;
        return this.launchBrowser(item);
    }

    private void insertParamStr(String str, int begin, int end) {
        try {
            this.textpane.setSelectionStart(begin);
            this.textpane.setSelectionEnd(end);
            this.textpane.replaceSelection(str + "\n");
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:OslHelp.insertParamStr()\n        " + e.toString());
            return;
        }
    }

    static {
        int i;
        String str;
        funcLookup = null;
        languageTable = new Hashtable();
        Enumeration<String> e = OslTokenizer.language.keys();
        while (e.hasMoreElements()) {
            str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
        }
        for (i = 0; i < OslTokenizer.SHADERTYPES.length; ++i) {
            str = OslTokenizer.SHADERTYPES[i];
            languageTable.put(str.toLowerCase(), str);
        }
        for (i = 0; i < OslTokenizer.DATATYPES.length; ++i) {
            str = OslTokenizer.DATATYPES[i];
            languageTable.put(str.toLowerCase(), str);
        }
        for (i = 0; i < OslTokenizer.DATAMODIFIERS.length; ++i) {
            str = OslTokenizer.DATAMODIFIERS[i];
            languageTable.put(str.toLowerCase(), str);
        }
        languageTable.put("#include", "include");
        languageTable.put("#define", "define");
        languageTable.put("#if", "if");
        languageTable.put("#endif", "endif");
        languageTable.put("#pragma", "pragma");
        languageTable.put("#ifndef", "ifndef");
        languageTable.put("#ifdef", "ifdef");
        languageTable.put("#include", "include");
    }

    private class FuncAction
    implements ActionListener {
        String payload;
        String selection;
        int offset;

        public FuncAction(String text, String sel, int at) {
            this.payload = text;
            this.selection = sel;
            this.offset = at;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int span = this.offset - this.selection.length();
            OslHelp.this.insertParamStr(this.payload, span, this.offset);
        }
    }
}

