/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import UI_Components.KTile;
import UI_Desktop.Cutter;
import UI_Script.Osl.OslMetaDataParser;
import UI_Script.Osl.OslShader;
import UI_Tools.AssetManagement.HtmlWriter;
import Utilities.FileUtils;
import Utilities.HashTableUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class OslHtmlWriter
extends HtmlWriter {
    static File SRC_HTML_DIR = null;
    static File SRC_IMAGES_DIR = null;
    static File headerFile = null;
    static File pagePanelHeaderFile = null;
    static File tailFile = null;
    static String headerStr = null;
    static String tailStr = null;
    static File colorFile = null;
    static File connectionFile = null;
    static File fileFile = null;
    static File textFile = null;
    static File strFile = null;
    static File menuFile = null;
    static File sliderKnobFile = null;
    static File sliderFile = null;
    static File checkboxFile = null;
    static File checkboxOnFile = null;
    static File manifoldFile = null;
    static File vectorFile = null;
    static String colorStr = null;
    static String connectionStr = null;
    static String fileStr = null;
    static String textStr = null;
    static String strStr = null;
    static String menuStr = null;
    static String pagePanelHeaderStr = null;
    static String sliderStr = null;
    static String checkboxStr = null;
    static String checkboxOnStr = null;
    static String manifoldStr = null;
    static String vectorStr = null;
    static double rangeSliderConnected;
    static double rangeSliderNotConnected;
    static double rangeColorSlider;
    String imageSrcStr = "<img src=\"images/IMAGE_PNG\" alt=\"\" border=\"0\">";

    public OslHtmlWriter(File file) throws IOException {
        super(file, SRC_IMAGES_DIR);
    }

    public static void deleteHostDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        FileUtils.deleteAll(dir);
    }

    public static void createHostDir(File dir) {
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    @Override
    public void writeHeader() {
        if (headerStr == null || headerStr.trim().length() == 0) {
            Cutter.setLog("    Error: OslHtmlWriter.writeHeader() - no header at        \"" + headerFile.getPath() + "\"");
            return;
        }
        this.buff.append(headerStr.replaceAll("(_TITLE_)", this.tightHostDirName));
    }

    private Color convertToColor(String input) {
        float b;
        float g;
        float r;
        if (input == null || input.trim().length() == 0) {
            return Color.black;
        }
        String[] tokens = TextUtils.tokenize(input, " ");
        if (tokens.length != 3) {
            return Color.white;
        }
        try {
            r = (float)NumberUtils.strToDouble(tokens[0]);
            g = (float)NumberUtils.strToDouble(tokens[1]);
            b = (float)NumberUtils.strToDouble(tokens[2]);
        }
        catch (NumberFormatException ex) {
            Cutter.setLog("    Exception:OslHtmlWriter.convertToColor() " + input);
            return Color.red;
        }
        r = (double)r > 1.0 ? 1.0f : r;
        g = (double)g > 1.0 ? 1.0f : g;
        b = (double)b > 1.0 ? 1.0f : b;
        return new Color(r, g, b);
    }

    private String getFloatFormat(String numStr) {
        Double d = NumberUtils.strToDouble(numStr);
        return NumberUtils.clip(d, 3);
    }

    private String writeColorPng(String srcPngName, Rectangle bbox, OslShader.Parameter param) {
        KTile tile;
        File colorUI_PNG = new File(this.srcImagesDir, srcPngName);
        try {
            tile = new KTile(colorUI_PNG);
        }
        catch (Exception ex) {
            String path = colorUI_PNG.getPath();
            Cutter.setLog("    Error: OslHtmlWriter.writeColorPng() - cannot find \"" + path + "\"");
            return "";
        }
        tile.fill(this.convertToColor(param.getValue()), bbox);
        String outName = tile.colorToOuputName() + ".png";
        outName = outName.trim();
        outName = outName.replace('\'', ' ');
        outName = outName.replace(' ', '_');
        File outFile = new File(this.hostImagesDir, outName);
        tile.write(outFile, "png");
        return outName;
    }

    private String writeStringPng(String srcPngName, Rectangle bbox, OslShader.Parameter param) {
        return this.writeStringPng(srcPngName, bbox, param, 14);
    }

    private String writeStringPng(String srcPngName, Rectangle bbox, OslShader.Parameter param, int baseLineHt) {
        KTile tile;
        File numberUI_PNG = new File(this.srcImagesDir, srcPngName);
        try {
            tile = new KTile(numberUI_PNG);
        }
        catch (Exception ex) {
            String path = numberUI_PNG.getPath();
            Cutter.setLog("    Error:OslHtmlWriter.writeStringPng() - cannot find \"" + path + "\"");
            return "";
        }
        String dv = param.getDataType().equals("float") ? this.getFloatFormat(param.getValue()) : TextUtils.removeQuotes(param.getValue());
        tile.setText(dv, bbox, 11, baseLineHt);
        String outName = tile.textToOuputName() + ".png";
        outName = outName.trim();
        outName = outName.replace('\'', ' ');
        outName = outName.replace(' ', '_');
        tile.write(new File(this.hostImagesDir, outName), "png");
        return outName;
    }

    private String overlaySliderKnob(String dstPngName, OslShader.Parameter param) {
        KTile tile;
        File dstPNG = new File(this.hostImagesDir, dstPngName);
        File knobPNG = new File(this.srcImagesDir, "knob.png");
        String outName = dstPngName;
        try {
            tile = new KTile(dstPNG);
        }
        catch (Exception ex) {
            Cutter.setLog("    Error: ArgsHtmlWriter.overlaySliderKnob() - cannot find \"" + dstPNG.getPath() + "\"");
            return outName;
        }
        if (param.getDataType().equals("float") || param.getDataType().equals("int")) {
            double max;
            double val = NumberUtils.strToFloat(param.getValue());
            String minStr = OslMetaDataParser.getMin(param);
            String maxStr = OslMetaDataParser.getMax(param);
            double min = NumberUtils.strToFloat(minStr);
            double delta = (val - min) / ((max = (double)NumberUtils.strToFloat(maxStr)) - min);
            delta = delta < 0.0 ? 0.0 : delta;
            delta = delta > 1.0 ? 1.0 : delta;
            double range = rangeSliderConnected;
            int knobOffset = (int)(range * delta);
            outName = tile.overlay(knobPNG, knobOffset + 76, 2);
        }
        if (param.getDataType().equals("color")) {
            Color c = this.convertToColor(param.getValue());
            float[] comps = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            double delta = comps[2];
            delta = delta < 0.0 ? 0.0 : delta;
            delta = delta > 1.0 ? 1.0 : delta;
            int knobOffset = (int)(rangeColorSlider * delta);
            outName = tile.overlay(knobPNG, knobOffset + 76, 2);
        }
        outName = outName.trim();
        outName = outName.replace('\'', ' ');
        outName = outName.replace(' ', '_');
        tile.write(new File(this.hostImagesDir, outName), "png");
        return outName;
    }

    private String writeMenuPng(String srcPngName, Rectangle bbox, OslShader.Parameter param) {
        KTile tile;
        String label = "Undefined menu items!";
        File numberUI_PNG = new File(this.srcImagesDir, srcPngName);
        try {
            tile = new KTile(numberUI_PNG);
        }
        catch (Exception ex) {
            String path = numberUI_PNG.getPath();
            Cutter.setLog("    Error: OslHtmlWriter.writeMenuPng() - cannot find \"" + path + "\"");
            return "";
        }
        Hashtable<String, String> items = OslMetaDataParser.getMapperItems(param);
        String[] keys = HashTableUtils.getAllKeys_Str_Str(items);
        if (items.size() == 1) {
            label = keys != null ? keys[0] : "Undefined menu items!";
        } else {
            String value = param.getValue();
            value = TextUtils.removeQuotes(value);
            for (int n = 0; n < keys.length; ++n) {
                if (!items.get(keys[n]).equals(value)) continue;
                label = keys[n];
                break;
            }
        }
        tile.setText(label, bbox, 11, 16, new Color(98, 98, 98));
        String outName = tile.textToOuputName().trim() + ".png";
        outName = outName.replace('\'', ' ');
        outName = outName.replace(' ', '_');
        tile.write(new File(this.hostImagesDir, outName), "png");
        return outName;
    }

    private String writePopupPng(String srcPngName, Rectangle bbox, OslShader.Parameter param) {
        KTile tile;
        String label = "Undefined";
        File numberUI_PNG = new File(this.srcImagesDir, srcPngName);
        try {
            tile = new KTile(numberUI_PNG);
        }
        catch (Exception ex) {
            String path = numberUI_PNG.getPath();
            Cutter.setLog("    Error: OslHtmlWriter.writePopupPng() - cannot find \"" + path + "\"");
            return "";
        }
        label = TextUtils.removeQuotes(param.getValue().trim());
        tile.setText(label, bbox, 11, 16, new Color(98, 98, 98));
        String outName = tile.textToOuputName().trim() + ".png";
        outName = outName.trim();
        outName = outName.replace('\'', ' ');
        outName = outName.replace(' ', '_');
        tile.write(new File(this.hostImagesDir, outName), "png");
        return outName;
    }

    private String writeBooleanCheckboxPng(Rectangle bbox, OslShader.Parameter param) {
        KTile tile;
        File png;
        String label = "Boolean Undefined";
        if (param.getDataType().equals("int") || param.getDataType().equals("float")) {
            png = param.getValue().equals("0") ? new File(this.srcImagesDir, "checkboxUI") : new File(this.srcImagesDir, "checkboxOnUI");
        } else {
            return "";
        }
        try {
            tile = new KTile(png);
        }
        catch (Exception ex) {
            String path = png.getPath();
            Cutter.setLog("    Error: OslHtmlWriter.writeBooleanCheckboxPng() - cannot find \"" + path + "\"");
            return "";
        }
        label = param.getValue().equals("false") ? "No" : "Yes";
        tile.setText("", bbox, 11, 16, new Color(98, 98, 98));
        String outName = tile.textToOuputName().trim() + ".png";
        outName = outName.trim();
        outName = outName.replace('\'', ' ');
        outName = outName.replace(' ', '_');
        tile.write(new File(this.hostImagesDir, outName), "png");
        return outName;
    }

    private String writeBooleanMenuPng(String srcPngName, Rectangle bbox, OslShader.Parameter param) {
        KTile tile;
        String label = "Boolean Undefined";
        File numberUI_PNG = new File(this.srcImagesDir, srcPngName);
        try {
            tile = new KTile(numberUI_PNG);
        }
        catch (Exception ex) {
            String path = numberUI_PNG.getPath();
            Cutter.setLog("    Error: OslHtmlWriter.writeBooleanMenuPng() - cannot find \"" + path + "\"");
            return "";
        }
        label = param.getDataType().equals("int") || param.getDataType().equals("float") ? (param.getValue().equals("0") ? "0" : "1") : (param.getValue().equals("false") ? "No" : "Yes");
        tile.setText(label, bbox, 11, 16, new Color(98, 98, 98));
        String outName = tile.textToOuputName().trim() + ".png";
        outName = outName.trim();
        outName = outName.replace('\'', ' ');
        outName = outName.replace(' ', '_');
        tile.write(new File(this.hostImagesDir, outName), "png");
        return outName;
    }

    private String writeVectorPng(String srcPngName, Rectangle bbox, OslShader.Parameter param) {
        return srcPngName;
    }

    public void writeParams(OslShader shader) {
        String currentPage = "";
        for (int n = 0; n < shader.getNumParams(); ++n) {
            String pageName;
            OslShader.Parameter param = shader.getParamAtIndex(n);
            if (param.isOutput() || param.isLockGeom()) continue;
            String paramName = param.getName();
            String paramType = param.getDataType();
            String str = "";
            String destPngName = "";
            String paramWidget = OslMetaDataParser.getWidget(param);
            if (paramWidget.equals("null")) continue;
            String paramValue = param.getValue();
            String paramLabel = OslMetaDataParser.getLabel(param);
            String paramTag = OslMetaDataParser.getTag(param);
            if (paramTag.equals("vstruct")) {
                param.setDataType("string");
                paramType = "string";
                param.setAbsValue("");
                paramValue = "";
                paramWidget = "string";
            }
            if (!(pageName = OslMetaDataParser.getPageName(param)).equals("") && !pageName.equals(currentPage)) {
                String panelLabel = TextUtils.removeQuotes(pageName);
                this.buff.append(pagePanelHeaderStr.replaceAll("(_PAGENAME_)", panelLabel));
                currentPage = pageName;
            }
            if (paramWidget.equals("boolean") && paramType.equals("string")) {
                str = sliderStr.replaceAll("(LABEL)", paramLabel);
                destPngName = this.writeBooleanMenuPng("menuUI.png", new Rectangle(7, 5, 75, 20), param);
                str = str.replaceAll("(NUMBER_PNG)", destPngName);
            } else if (paramType.equals("float") || paramType.equals("int")) {
                str = sliderStr.replaceAll("(LABEL)", paramLabel);
                if (paramWidget.equals("mapper")) {
                    destPngName = this.writeMenuPng("menuUI.png", new Rectangle(7, 5, 75, 20), param);
                } else if (paramWidget.equals("checkBox") || paramWidget.equals("boolean") && (paramType.equals("float") || paramType.equals("int"))) {
                    str = paramValue.equals("0") ? checkboxStr.replaceAll("(LABEL)", paramLabel) : checkboxOnStr.replaceAll("(LABEL)", paramLabel);
                } else {
                    String pngName = "sliderConnectedUI.png";
                    destPngName = this.writeStringPng(pngName, new Rectangle(5, 1, 72, 19), param);
                    destPngName = this.overlaySliderKnob(destPngName, param);
                }
                str = str.replaceAll("(NUMBER_PNG)", destPngName);
            } else if (paramType.equals("color")) {
                str = colorStr.replaceAll("(LABEL)", paramLabel);
                destPngName = this.writeColorPng("colorUI.png", new Rectangle(5, 2, 72, 16), param);
                destPngName = this.overlaySliderKnob(destPngName, param);
                str = str.replaceAll("(IMAGE_PNG)", destPngName);
            } else if (paramType.equals("string")) {
                String copy;
                if (paramWidget.equals("filename")) {
                    str = fileStr.replaceAll("(LABEL)", paramLabel);
                    destPngName = this.writeStringPng("fileUI.png", new Rectangle(5, 3, 209, 19), param, 15);
                    copy = this.imageSrcStr.replaceAll("(IMAGE_PNG)", destPngName);
                    str = str.replaceAll("(DIR_BUTTON)", copy);
                } else if (paramWidget.equals("mapper")) {
                    str = menuStr.replaceAll("(LABEL)", paramLabel);
                    destPngName = this.writeMenuPng("menuUI.png", new Rectangle(7, 5, 75, 20), param);
                    str = str.replaceAll("(MENU_PNG)", destPngName);
                } else if (paramWidget.equals("popup")) {
                    str = menuStr.replaceAll("(LABEL)", paramLabel);
                    destPngName = this.writePopupPng("menuUI.png", new Rectangle(7, 5, 75, 20), param);
                    str = str.replaceAll("(MENU_PNG)", destPngName);
                } else {
                    str = fileStr.replaceAll("(LABEL)", paramLabel);
                    destPngName = this.writeStringPng("stringUI.png", new Rectangle(5, 3, 209, 19), param, 15);
                    copy = this.imageSrcStr.replaceAll("(IMAGE_PNG)", destPngName);
                    str = str.replaceAll("(DIR_BUTTON)", copy);
                }
            } else if (param.getDataType().equals("normal") || param.getDataType().equals("vector") || param.getDataType().equals("point")) {
                str = vectorStr.replaceAll("(LABEL)", paramLabel);
                destPngName = this.writeVectorPng("vectorUI.png", new Rectangle(7, 5, 75, 20), param);
                str = str.replaceAll("(VECTOR_PNG)", destPngName);
            }
            str = str.replaceAll("(150)", "125");
            if (str.length() <= 0) continue;
            this.buff.append(str);
        }
    }

    @Override
    public void writeTail() {
        this.buff.append(tailStr);
    }

    static {
        SRC_HTML_DIR = new File(FileUtils.getPWDFile(), "Cutter_Help/ris/HTML");
        SRC_IMAGES_DIR = new File(SRC_HTML_DIR, "images");
        headerFile = new File(SRC_HTML_DIR, "header.html");
        headerStr = FileUtils.read(headerFile.getPath());
        pagePanelHeaderFile = new File(SRC_HTML_DIR, "pagePanelHeader.html");
        pagePanelHeaderStr = FileUtils.read(pagePanelHeaderFile.getPath());
        tailFile = new File(SRC_HTML_DIR, "tail.html");
        tailStr = FileUtils.read(tailFile.getPath());
        colorFile = new File(SRC_HTML_DIR, "color.html");
        connectionFile = new File(SRC_HTML_DIR, "connection.html");
        fileFile = new File(SRC_HTML_DIR, "file.html");
        textFile = new File(SRC_HTML_DIR, "text.html");
        strFile = new File(SRC_HTML_DIR, "string.html");
        menuFile = new File(SRC_HTML_DIR, "menu.html");
        vectorFile = new File(SRC_HTML_DIR, "vector.html");
        sliderFile = new File(SRC_HTML_DIR, "slider.html");
        checkboxFile = new File(SRC_HTML_DIR, "checkbox.html");
        checkboxOnFile = new File(SRC_HTML_DIR, "checkboxOn.html");
        manifoldFile = new File(SRC_HTML_DIR, "manifold.html");
        colorStr = FileUtils.read(colorFile.getPath());
        connectionStr = FileUtils.read(connectionFile.getPath());
        fileStr = FileUtils.read(fileFile.getPath());
        textStr = FileUtils.read(textFile.getPath());
        strStr = FileUtils.read(strFile.getPath());
        menuStr = FileUtils.read(menuFile.getPath());
        vectorStr = FileUtils.read(vectorFile.getPath());
        sliderStr = FileUtils.read(sliderFile.getPath());
        checkboxStr = FileUtils.read(checkboxFile.getPath());
        checkboxOnStr = FileUtils.read(checkboxOnFile.getPath());
        manifoldStr = FileUtils.read(manifoldFile.getPath());
        rangeSliderConnected = 79.0;
        rangeSliderNotConnected = 126.0;
        rangeColorSlider = 88.0;
    }
}

