/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Script.Osl.OslMetaDataParser;
import UI_Script.Osl.OslSyntax;
import UI_Script.Osl.OslTokenizer;
import UI_Script.Syntax;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import Utilities.DocumentUtils;
import Utilities.SegmentUtils;
import java.awt.Color;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public class OslListener
extends SyntaxListener {
    private String tmp = "";
    private boolean string;
    private boolean escape;

    public OslListener(KTextPane textpane) {
        super(textpane, new OslTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        StyleConstants.setForeground(textpane.styleContext.languageStyle, Color.blue);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_OSL_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_OSL_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_OSL_FUNCTION));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_OSL_DATATYPE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_OSL_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_OSL_METADATA));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_OSL_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_OSL_STRING));
        StyleConstants.setUnderline(textpane.styleContext.stringStyle2, true);
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (str.startsWith("[") && str.endsWith("]")) {
            if (!str.startsWith("[[")) {
                return false;
            }
            this.tmp = str.substring(1, str.length() - 1).trim();
            if (!this.tmp.startsWith("[") || !this.tmp.endsWith("]")) {
                return false;
            }
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle4, true);
            return true;
        }
        if (this.tok.isShaderType(str) || str.equals("ARNOLD") || str.equals("PRMAN")) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (this.tok.isSystemVariable(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        return false;
    }

    @Override
    public void addComments() {
        this.addComments("/*", "*/");
    }

    @Override
    public synchronized Syntax getExistingSyntax(int preUpdate, int postUpdate) {
        char c1 = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        int prevChar = 32;
        int prePrevChar = 32;
        boolean peek = false;
        if (postUpdate < 0) {
            Cutter.setLog("    Warning:OSLListener.getExistingSyntax() returning null");
            return null;
        }
        int len = this.tok.getSyntaxLength();
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), 0, this.textpane.getDocument().getLength());
        this.comment = false;
        this.string = false;
        this.escape = false;
        OslSyntax syntax = this.getSyntax(this.textpane.getDocument(), this.tok, preUpdate, postUpdate);
        syntax.preUpdateAt = preUpdate;
        syntax.postUpdateAt = postUpdate;
        for (int n = 0; n <= postUpdate; ++n) {
            int c0 = this.segment.array[n + this.segment.offset];
            c1 = n + 1 < this.segment.count ? this.segment.array[n + this.segment.offset + 1] : (char)' ';
            c2 = n + 2 < this.segment.count ? this.segment.array[n + this.segment.offset + 2] : (char)' ';
            char c = c3 = n + 3 < this.segment.count ? this.segment.array[n + this.segment.offset + 3] : (char)' ';
            if (this.escape && syntax.isCloseEscape(n)) {
                this.escape = false;
                syntax.prevActiveEscape = syntax.activeEscape;
                if (!this.string && n <= preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.currWordBegin = n;
                syntax.activeEscape = null;
            }
            if (this.comment && syntax.isCloseComment(n)) {
                this.comment = false;
                syntax.prevActiveCmnt = syntax.activeCmnt;
                syntax.prevBeginCmnt = syntax.beginCmnt;
                syntax.prevEndCmnt = n;
                if (n <= preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.currWordBegin = n;
                syntax.activeCmnt = null;
            }
            if (this.string && syntax.isCloseQuotation(n)) {
                this.string = false;
                syntax.prevActiveQuot = syntax.activeQuot;
                if (n <= preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.currWordBegin = n;
                syntax.activeQuot = null;
            }
            if (prevChar == 93 && prePrevChar == 93) {
                syntax.metadataOpen = false;
                syntax.prevActiveMeta = syntax.activeMeta;
                if (n <= preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.currWordBegin = n;
                syntax.metadataClosedAt = n;
            }
            if (!this.comment && !this.string && Character.isWhitespace((char)c0) && n <= preUpdate) {
                syntax.beginParse = syntax.currWordBegin;
                syntax.currWordBegin = n;
            }
            if (n <= preUpdate) {
                syntax.lookBack(n, (char)prevChar, (char)c0, c1, c2, c3);
            }
            if (n == preUpdate) {
                syntax.preUpdateCheckPoint(this.escape, this.comment, this.string, _getExistingSyntax, n);
            }
            syntax.lookBack(n, (char)prevChar, (char)c0, c1, c2, c3);
            if (!this.comment && !this.string && syntax.isOpenQuotation(n)) {
                this.string = true;
                if (n <= preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.beginQuot = n;
                n = n + syntax.activeQuot.openLen - 1;
            }
            if (!this.comment && !syntax.metadataOpen && syntax.isOpenMeta(n)) {
                syntax.metadataOpen = true;
                if (n <= preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.metadataOpenedAt = n;
                n = n + syntax.activeMeta.openLen - 1;
            }
            if (!this.comment && !this.string && syntax.isOpenComment(n)) {
                this.comment = true;
                if (n < preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.beginCmnt = n;
                n += syntax.activeCmnt.openLen - 1;
            }
            if (!this.comment && !this.escape && syntax.isOpenEscape(n)) {
                this.escape = true;
                syntax.prevActiveEscape = null;
                if (n <= preUpdate && !this.string) {
                    syntax.beginParse = n;
                } else if (this.string) {
                    syntax.beginParse = syntax.beginQuot;
                }
                syntax.beginEscape = n;
                n = n + syntax.activeEscape.openLen - 1;
            }
            if (n + 1 > postUpdate) {
                boolean bl = syntax.preUpdateCheckPoint(this.escape, this.comment, this.string, _getExistingSyntax, n);
            }
            prePrevChar = prevChar;
            prevChar = c0;
        }
        syntax.postUpdateCheckPoint(this.escape, this.comment, this.string, _getExistingSyntax);
        if (syntax.metadataOpen) {
            syntax.beginParse = syntax.metadataOpenedAt;
        }
        syntax.close();
        return syntax;
    }

    @Override
    protected int[] getInsertParseSpan(DocumentEvent evt, Syntax syntax) {
        int[] span = super.getInsertParseSpan(evt, syntax);
        int[] metadata = this.metaDataSpan(syntax);
        span[0] = metadata[0] < span[0] ? metadata[0] : span[0];
        int diff = Math.abs(syntax.postUpdate - metadata[1]);
        span[1] = diff < 2 && syntax.preUpdateChar != ']' ? this.textpane.getDocument().getLength() : (syntax.postUpdate > metadata[0] && syntax.postUpdate < metadata[1] ? metadata[1] : (metadata[1] > span[1] ? metadata[1] : span[1]));
        return span;
    }

    @Override
    protected int[] getRemoveParseSpan(DocumentEvent evt, Syntax syntax) {
        int[] span = super.getRemoveParseSpan(evt, syntax);
        int[] metadata = this.metaDataSpan(syntax);
        int n = span[0] = metadata[0] < span[0] ? metadata[0] : span[0];
        span[1] = syntax.postUpdate > metadata[0] && syntax.postUpdate < metadata[1] ? metadata[1] : (metadata[1] > span[1] ? metadata[1] : span[1]);
        return span;
    }

    private int[] metaDataSpan(Syntax syntax) {
        Segment seg = DocumentUtils.getSegment(this.textpane.getDocument(), 0, this.textpane.getDocument().getLength());
        int[] out = SegmentUtils.getOslMetaDataSpan(syntax.postUpdate, seg);
        return out;
    }

    private int[] _metaDataSpan(Syntax syntax) {
        Segment seg = DocumentUtils.getSegment(this.textpane.getDocument(), 0, this.textpane.getDocument().getLength());
        Cutter.setLog("OSLListener.metaDataSpan() syntax.postUpdate " + syntax.postUpdate);
        SegmentUtils.CharData prevChar = SegmentUtils.prevNonWhiteChar(syntax.postUpdate, seg);
        SegmentUtils.CharData nextChar = SegmentUtils.nextNonWhiteChar(syntax.postUpdate, seg);
        if (prevChar == null || nextChar == null || prevChar.c != '[' || nextChar.c != ']') {
            return null;
        }
        prevChar = SegmentUtils.prevNonWhiteChar(prevChar.offset, seg);
        nextChar = SegmentUtils.nextNonWhiteChar(nextChar.offset, seg);
        if (prevChar.c == '[' && nextChar.c == '[') {
            int nextCloseMeta = OslMetaDataParser.nextCloseMeta(syntax.postUpdate, seg);
            int[] out = new int[]{prevChar.offset, nextCloseMeta + 2};
            return out;
        }
        return null;
    }

    @Override
    protected OslSyntax getSyntax(Document doc, Tokenizer tok, int preUpdate, int postUpdate) {
        return new OslSyntax(doc, tok, preUpdate, postUpdate);
    }
}

