/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import UI_Script.Osl.OslMetaDataMapperItem;
import UI_Script.Osl.OslShader;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.Segment;

public class OslMetaDataParser {
    public String openStr = "[[";
    public char[] openMeta = new char[this.openLen];
    public int openLen = 2;
    public String closeStr = null;
    public char[] closeMeta = null;
    public int closeLen = 0;
    private static Hashtable<OslMetaDataParser, OslMetaDataParser> table = new Hashtable();

    public OslMetaDataParser() {
        int n;
        for (n = 0; n < this.openLen; ++n) {
            this.openMeta[n] = this.openStr.charAt(n);
        }
        this.closeStr = "]]";
        this.closeLen = 2;
        this.closeMeta = new char[this.closeLen];
        for (n = 0; n < this.closeLen; ++n) {
            this.closeMeta[n] = this.closeStr.charAt(n);
        }
        table.put(this, this);
    }

    public int findOpenMeta(String str) {
        if (str.length() < this.openLen) {
            return -1;
        }
        int offset = str.indexOf(this.openStr.charAt(0), 0);
        if (offset != -1 && offset + this.openLen < str.length() && (str = str.substring(offset, offset + 3)).equals(this.openStr)) {
            return offset;
        }
        return -1;
    }

    public int findOpenMeta(Segment segment, int from) {
        if (from + this.openLen > segment.count) {
            return -1;
        }
        int foundAt = -1;
        boolean match = false;
        for (int n = from; n < segment.count - this.openLen; ++n) {
            if (segment.array[n + segment.offset] != this.openMeta[0]) continue;
            foundAt = n;
            match = true;
            for (int j = 0; j < this.openLen; ++j) {
                if (segment.array[n + j + segment.offset] == this.openMeta[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return foundAt + this.openLen;
        }
        return foundAt;
    }

    public int findCloseMeta(Segment segment, int from) {
        if (from + this.closeLen > segment.count) {
            return -1;
        }
        int foundAt = -1;
        boolean match = false;
        for (int n = from; n <= segment.count - this.closeLen; ++n) {
            if (segment.array[n + segment.offset] != this.closeMeta[0]) continue;
            foundAt = n;
            match = true;
            for (int j = 0; j < this.closeLen; ++j) {
                if (segment.array[n + j + segment.offset] == this.closeMeta[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return foundAt + this.closeLen;
        }
        return -1;
    }

    public boolean isOpenMeta(Segment segment, int from) {
        if (this.openLen == 1 && from + this.openLen >= segment.count || this.openLen > 1 && from + this.openLen > segment.count) {
            return false;
        }
        for (int j = 0; j < this.openLen; ++j) {
            if (segment.array[from + j + segment.offset] == this.openMeta[j]) continue;
            return false;
        }
        return true;
    }

    public boolean isOpenMeta(String str) {
        if (str == null) {
            return false;
        }
        if (this.openStr == null) {
            return false;
        }
        if ((str = str.trim()).length() < this.openStr.length()) {
            return false;
        }
        return str.substring(0, this.openStr.length()).equals(this.openStr);
    }

    public boolean isOpenMeta(char[] chars) {
        return this.isOpenMeta(new String(chars));
    }

    public boolean isCloseMeta(Segment segment, int from) {
        if (from + this.closeLen > segment.count) {
            return false;
        }
        for (int j = 0; j < this.closeLen; ++j) {
            if (segment.array[from + j + segment.offset] == this.closeMeta[j]) continue;
            return false;
        }
        return true;
    }

    public boolean _isCloseMeta(Segment segment, int at) {
        char c1 = segment.array[at - 1 + segment.offset];
        char c0 = segment.array[at - 0 + segment.offset];
        return c1 == ']' && c0 == ']';
    }

    public boolean isCloseMeta(String str) {
        if (str == null) {
            return false;
        }
        if (this.closeStr.length() > 1) {
            str = str.trim();
        }
        if (str.length() < this.closeStr.length()) {
            return false;
        }
        return str.substring(0, this.closeStr.length()).equals(this.closeStr);
    }

    public boolean isCloseMeta(char[] chars) {
        return this.isCloseMeta(new String(chars));
    }

    public boolean isPartialOpenMeta(String str) {
        for (int n = 0; n < str.length(); ++n) {
            for (int i = 0; i < this.openStr.length(); ++i) {
                if (str.charAt(n) != this.openStr.charAt(i)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsOpenMeta(String str) {
        if (str.length() < this.openLen) {
            return false;
        }
        int offset = str.indexOf(this.openMeta[0], 0);
        return offset != -1 && offset + this.openLen <= str.length() && (str = str.substring(offset, offset + this.openLen)).equals(this.openStr);
    }

    public boolean containsClosingMeta(String str) {
        if (str.length() < this.closeLen) {
            return false;
        }
        int offset = str.indexOf(this.closeMeta[0], 0);
        return offset != -1 && offset + this.closeLen <= str.length() && (str = str.substring(offset, offset + this.closeLen)).equals(this.closeStr);
    }

    public static int nextOpenMeta(int from, Segment segment) {
        int seg_offset = segment.offset;
        for (int j = from; j < segment.count - 1; ++j) {
            char c0 = segment.array[j + seg_offset];
            char c1 = segment.array[j + 1 + seg_offset];
            if (c0 != '[' || c1 != '[') continue;
            return j;
        }
        return segment.count;
    }

    public static int nextCloseMeta(int from, Segment segment) {
        int seg_offset = segment.offset;
        for (int j = from; j < segment.count - 1; ++j) {
            char c0 = segment.array[j + seg_offset];
            char c1 = segment.array[j + 1 + seg_offset];
            if (c0 != ']' || c1 != ']') continue;
            return j;
        }
        return segment.count;
    }

    public static String getWidget(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        String widget = "";
        for (int i = 0; i < metadata.size(); ++i) {
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("string") || (tokens = TextUtils.tokenize(metaStr, '\"')) == null || tokens.length != 2 || !tokens[0].trim().substring(6).trim().startsWith("widget")) continue;
            widget = tokens[tokens.length - 1].trim();
        }
        widget = TextUtils.trimLeadingChar(widget, '\n');
        return widget;
    }

    public static String getVstructMember(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        String name = null;
        for (int i = 0; i < metadata.size(); ++i) {
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("string") || (tokens = TextUtils.tokenize(metaStr, '\"')) == null || tokens.length != 2 || !tokens[0].trim().substring(6).trim().startsWith("vstructmember")) continue;
            name = tokens[tokens.length - 1].trim();
        }
        if (name == null) {
            return null;
        }
        return TextUtils.trimLeadingChars(name, "\\n");
    }

    public static int getNodeId(OslShader shader) {
        Vector<String> metadata = shader.getMetaData();
        String idStr = "-1";
        for (int i = 0; i < metadata.size(); ++i) {
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("int") || (tokens = TextUtils.tokenize(metaStr)).length != 4 || !tokens[1].trim().equals("rfm_nodeid")) continue;
            idStr = tokens[tokens.length - 1].trim();
        }
        try {
            return NumberUtils.strToInt(idStr);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static String getPageName(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        String name = "";
        for (int i = 0; i < metadata.size(); ++i) {
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("string") || (tokens = TextUtils.tokenize(metaStr, '\"')) == null || tokens.length != 2 || !tokens[0].trim().substring(6).trim().startsWith("page")) continue;
            name = tokens[tokens.length - 1].trim();
        }
        name = TextUtils.trimLeadingChars(name, "\\n");
        return name;
    }

    public static String getConnectable(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        String value = "True";
        for (int i = 0; i < metadata.size(); ++i) {
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("int") || (tokens = TextUtils.tokenize(metaStr, '=')) == null || tokens.length != 2 || !tokens[0].trim().substring(3).trim().startsWith("connectable")) continue;
            value = tokens[tokens.length - 1].trim();
        }
        return value.equals("0") ? "False" : "True";
    }

    public static String getVstructExpr(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        String tag = "";
        for (int i = 0; i < metadata.size(); ++i) {
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("string") || (tokens = TextUtils.tokenize(metaStr, '\"')) == null || tokens.length != 2 || !tokens[0].trim().substring(6).trim().startsWith("vstructConditionalExpr")) continue;
            tag = tokens[tokens.length - 1].trim();
        }
        tag = TextUtils.trimLeadingChars(tag, "\\n");
        return tag.trim();
    }

    public static String getTag(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        String tag = "";
        for (int i = 0; i < metadata.size(); ++i) {
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("string") || (tokens = TextUtils.tokenize(metaStr, '\"')) == null || tokens.length != 2 || !tokens[0].trim().substring(6).trim().startsWith("tag")) continue;
            tag = tokens[tokens.length - 1].trim();
        }
        tag = TextUtils.trimLeadingChars(tag, "\\n");
        return tag.trim();
    }

    public static String getLabel(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        String label = param.getName();
        for (int i = 0; i < metadata.size(); ++i) {
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("string") || (tokens = TextUtils.tokenize(metaStr, '\"')) == null || tokens.length != 2 || !tokens[0].trim().substring(6).trim().startsWith("label")) continue;
            label = tokens[tokens.length - 1].trim();
        }
        label = TextUtils.trimLeadingChars(label, "\\n");
        return label.trim();
    }

    public static String getHelp(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        return OslMetaDataParser.getHelp(metadata);
    }

    public static String getHelp(Vector<String> metadata) {
        String help = null;
        for (int i = 0; i < metadata.size(); ++i) {
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("string") || (tokens = TextUtils.tokenize(metaStr, '\"')) == null || tokens.length != 2 || !tokens[0].trim().substring(6).trim().startsWith("help")) continue;
            help = tokens[tokens.length - 1].trim();
        }
        if (help == null) {
            return null;
        }
        help = TextUtils.trimLeadingChars(help, "\\n");
        return help.trim();
    }

    public static String getMin(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        String min = "0";
        for (int i = 0; i < metadata.size(); ++i) {
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("float") && !metaStr.startsWith("int") || (tokens = TextUtils.tokenize(metaStr)).length != 4 || !tokens[1].trim().equals("min")) continue;
            min = tokens[tokens.length - 1].trim();
        }
        return min;
    }

    public static String getMax(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        String max = "1";
        for (int i = 0; i < metadata.size(); ++i) {
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("float") && !metaStr.startsWith("int") || (tokens = TextUtils.tokenize(metaStr)).length != 4 || !tokens[1].trim().equals("max")) continue;
            max = tokens[tokens.length - 1].trim();
        }
        return max;
    }

    public static OslMetaDataMapperItem[] getSortedMapperItems(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        Vector<OslMetaDataMapperItem> listOfItems = new Vector<OslMetaDataMapperItem>();
        for (int i = 0; i < metadata.size(); ++i) {
            String itemsStr;
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("string") || (tokens = TextUtils.tokenize(metaStr, '\"')) == null || tokens.length != 2 || !tokens[0].trim().substring(6).trim().startsWith("options") || (tokens = TextUtils.tokenize(itemsStr = tokens[tokens.length - 1], '|')) == null || tokens.length == 0) continue;
            for (int n = 0; n < tokens.length; ++n) {
                String token = tokens[n].trim();
                int index = token.indexOf(58);
                if (index == -1) continue;
                String key = token.substring(0, index).trim();
                String val = token.substring(index + 1).trim();
                key = TextUtils.trimLeadingChars(key, "\\n");
                val = TextUtils.trimLeadingChars(val, "\\n");
                listOfItems.add(new OslMetaDataMapperItem(key, val));
            }
        }
        if (listOfItems.size() == 0) {
            return null;
        }
        OslMetaDataMapperItem[] out = new OslMetaDataMapperItem[listOfItems.size()];
        for (int n = 0; n < listOfItems.size(); ++n) {
            out[n] = (OslMetaDataMapperItem)listOfItems.elementAt(n);
        }
        return out;
    }

    public static Hashtable<String, String> getMapperItems(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int i = 0; i < metadata.size(); ++i) {
            String itemsStr;
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("string") || (tokens = TextUtils.tokenize(metaStr, '\"')) == null || tokens.length != 2 || !tokens[0].trim().substring(6).trim().startsWith("options") || (tokens = TextUtils.tokenize(itemsStr = tokens[tokens.length - 1], '|')) == null || tokens.length == 0) continue;
            for (int n = 0; n < tokens.length; ++n) {
                String token = tokens[n].trim();
                int index = token.indexOf(58);
                if (index == -1) continue;
                String key = token.substring(0, index).trim();
                String val = token.substring(index + 1).trim();
                key = TextUtils.trimLeadingChars(key, "\\n");
                val = TextUtils.trimLeadingChars(val, "\\n");
                table.put(key, val);
            }
        }
        if (table.size() == 0) {
            table.put("NOT DEFINED", "NOT DEFINED");
        }
        return table;
    }

    public static String[] getPopupItems(OslShader.Parameter param) {
        Vector<String> metadata = param.getMetaData();
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < metadata.size(); ++i) {
            String itemsStr;
            String[] tokens;
            String metaStr = metadata.elementAt(i).trim();
            if (!metaStr.startsWith("string") || (tokens = TextUtils.tokenize(metaStr, '\"')) == null || tokens.length != 2 || !tokens[0].trim().substring(6).trim().startsWith("options") || (tokens = TextUtils.tokenize(itemsStr = tokens[tokens.length - 1], '|')) == null || tokens.length == 0) continue;
            for (int n = 0; n < tokens.length; ++n) {
                String token = tokens[n].trim();
                token = TextUtils.trimLeadingChars(token, "\\n");
                list.add(token);
            }
        }
        return VectorUtils.toStringArray(list);
    }
}

