/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Osl.OslCompilerManager;
import UI_Script.Osl.OslShader;
import UI_Script.Osl.OslTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Rman.RenderInfo;
import Utilities.DialogUtils;
import Utilities.DocumentUtils;
import Utilities.MayaNodeIdUtils;
import Utilities.OslUtils;
import Utilities.TextUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class OslMetaHelper {
    static final String META_INDENT = "\t\t";
    private static String[] cannotAssignIdMsg = new String[]{"For a nodeid to be generated the shader must", "be compiled. Make sure the shader has been", "saved and can be compiled without errors."};
    private static String[] nodeIdNotRelevant = new String[]{"The current compilation environment is not set to", "Pixar's RenderMan - see:", "       Preferences->Languages->Osl.", "The \"rfm_nodeid\" information that will be inserted", "into the source code is relevent ONLY to RenderMan", "and will be ignored by other environments."};
    private static String[][] metadata20 = new String[][]{{"Label", "label", "string label = \"YourLabel\","}, {"Help", "help", "string help = \"\","}, {"Primvar", "lockgeom", "int lockgeom = 0,\n\t\tstring widget = \"null\","}, {"---", "ignored", "ignored"}, {"CheckBox", "checkBox", "string widget = \"checkBox\","}, {"Menu", "mapper", "string widget = \"mapper\",\n\t\tstring options = \"Label_A:0|Label_B:1|Label_C:2\","}, {"File", "mapper", "string widget = \"filename\","}, {"---", "ignored", "ignored"}, {"Panel", "panel", "string page = \"PanelName\","}, {"Connectable", "connectable", "int connectable = 0,"}, {"min/max", "min", "float min = 0,\n\t\tfloat max = 1,"}};
    private static String[][] metadata21 = new String[][]{{"Label", "label", "string label = \"YourLabel\","}, {"Help", "help", "string help = \"\","}, {"Primvar", "lockgeom", "int lockgeom = 0,\n\t\tstring widget = \"null\","}, {"---", "ignored", "ignored"}, {"CheckBox", "checkBox", "string widget = \"boolean\","}, {"Menu (Arnold)", "mapper", "string widget = \"mapper\",\n\t\tstring options = \"Label_A:0|Label_B:1|Label_C:2\","}, {"Popup (PRMan)", "popup", "string widget = \"popup\",\n\t\tstring options = \"Label_A:0|Label_B:1|Label_C:2\","}, {"File", "fileInput", "string widget = \"fileInput\","}, {"---", "ignored", "ignored"}, {"Panel", "panel", "string page = \"PanelName\","}, {"Connectable", "connectable", "int connectable = 0,"}, {"Min/Max", "min", "float min = 0,\n\t\tfloat max = 1,"}, {"---", "ignored", "ignored"}, {"Vstruct", "vstruct", "string tag = \"vstruct\","}, {"Vstruct Member", "vstructmember", "string vstructmember = \"\","}, {"Vstruct Expr", "vstructConditionalExpr", "string vstructConditionalExpr = \"\","}};
    private static String[][] metadata22 = new String[][]{{"Label", "label", "string label = \"YourLabel\","}, {"Help", "help", "string help = \"\","}, {"Primvar", "lockgeom", "int lockgeom = 0,\n\t\tstring widget = \"null\","}, {"---", "ignored", "ignored"}, {"CheckBox (RenderMan)", "checkBox", "string widget = \"checkBox\","}, {"CheckBox (Arnold)", "checkBox", "string widget = \"boolean\","}, {"Menu (RenderMan)", "popup", "string widget = \"mapper\",\n\t\tstring options = \"Label_A:0|Label_B:1|Label_C:2\","}, {"Menu (Arnold)", "popup", "string widget = \"popup\",\n\t\tstring options = \"Label_A|Label_B|Label_C\","}, {"File", "fileInput", "string widget = \"fileInput\","}, {"---", "ignored", "ignored"}, {"Panel", "panel", "string page = \"PanelName\","}, {"Connectable", "connectable", "int connectable = 0,"}, {"Min/Max", "min", "float min = 0,\n\t\tfloat max = 1,"}, {"---", "ignored", "ignored"}, {"Vstruct", "vstruct", "string tag = \"vstruct\","}, {"Vstruct Member", "vstructmember", "string vstructmember = \"\","}, {"Vstruct Expr", "vstructConditionalExpr", "string vstructConditionalExpr = \"\","}};
    private KTextPane textpane;
    private Document document;

    public OslMetaHelper(KTextPane textpane) {
        this.textpane = textpane;
        this.document = textpane.getDocument();
    }

    public JMenu getMetaDataMenu(String sel, int at) {
        String[][] strns;
        JMenu menu = new JMenu("MetaData");
        OslTokenizer tok = new OslTokenizer();
        tok.setBuffer(this.textpane.getText());
        int openMetaOffset = tok.findBackward(at, '[');
        if (openMetaOffset != -1) {
            openMetaOffset = tok.findBackward(openMetaOffset - 1, '[');
        }
        int closeMetaOffset = openMetaOffset != -1 ? tok.findBackward(openMetaOffset, ']') : -1;
        boolean enabled = true;
        boolean addNewline = false;
        if (openMetaOffset == -1 && closeMetaOffset == -1 || openMetaOffset < closeMetaOffset) {
            enabled = false;
        }
        if (enabled) {
            int[] el = DocumentUtils.getElementOffsets(this.document, openMetaOffset);
            char[] chars = tok.getBuffer(el[1], openMetaOffset);
            String leadingText = "";
            if (chars != null) {
                leadingText = new String(chars);
            }
            if ((leadingText = TextUtils.trimTrailingChar(leadingText, '[')).trim().length() > 0) {
                addNewline = true;
            }
        }
        String metaBlock = "";
        if (enabled) {
            closeMetaOffset = tok.findForward(openMetaOffset, ']');
            if (closeMetaOffset != -1) {
                closeMetaOffset = tok.findForward(closeMetaOffset + 1, ']');
            }
            if (closeMetaOffset != -1) {
                ++closeMetaOffset;
            }
            try {
                metaBlock = this.textpane.getText(openMetaOffset, closeMetaOffset - openMetaOffset);
                metaBlock = metaBlock.replaceAll("\\[", "");
                metaBlock = metaBlock.replaceAll("\\]", "").trim();
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:OslMetaHelper - " + ex.toString());
                metaBlock = "";
            }
        }
        String[][] stringArray = strns = RenderInfo.prmanMajorVersionNumber() < 21 ? metadata20 : metadata21;
        if (RenderInfo.prmanMajorVersionNumber() >= 22) {
            strns = metadata22;
        }
        for (int n = 0; n < strns.length; ++n) {
            String name = strns[n][0];
            if (name.equals("---")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = new JMenuItem(name);
            String target = strns[n][1];
            String payload = strns[n][2];
            mi.addActionListener(new MetaAction(target, payload, metaBlock, openMetaOffset, closeMetaOffset, addNewline));
            mi.setEnabled(enabled);
            menu.add(mi);
        }
        if (RenderInfo.prmanMajorVersionNumber() >= 21) {
            JMenuItem assignNodeidItem = new JMenuItem("Assign Pixar \"node_id\"");
            assignNodeidItem.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OslMetaHelper.assignPixarNodeID();
                }
            });
            menu.addSeparator();
            menu.add(assignNodeidItem);
        }
        return menu;
    }

    private static void assignPixarNodeID() {
        boolean result = false;
        File f = BBxt.getWindowFile();
        if (!OslUtils.envIsPRMan()) {
            DialogUtils.showErrorMessage("node_id Not Relevant", nodeIdNotRelevant);
            return;
        }
        if (f != null) {
            BBxt.save();
            result = OslCompilerManager.getInstance().doRmanCompile(f);
        }
        if (!result) {
            DialogUtils.showErrorMessage("Error 1: Cannot Assign Node ID", cannotAssignIdMsg);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OslShader shader = OslShader.getDesktopShader(OslCompilerManager.OSL_ENV_PIXAR);
                if (shader == null) {
                    DialogUtils.showErrorMessage("Error 2: Cannot Assign Node ID", cannotAssignIdMsg);
                    return;
                }
                OslTokenizer tok = new OslTokenizer();
                tok.setBuffer(BBxt.getWindowText());
                OslTokenizer.ShdTypeName data = tok.getShaderTypeOffsets();
                if (data == null) {
                    DialogUtils.showErrorMessage("Error 3: Cannot Assign Node ID", cannotAssignIdMsg);
                    return;
                }
                int[] ids = MayaNodeIdUtils.getAllUsedNodeIds();
                if (ids == null) {
                    DialogUtils.showErrorMessage("Error 4: Cannot Assign Node ID", cannotAssignIdMsg);
                    return;
                }
                int id = MayaNodeIdUtils.getFirstAvailable(ids);
                StringBuffer buff = new StringBuffer();
                buff.append("\n[[\n");
                buff.append("int rfm_nodeid = ").append(id).append(",\n");
                buff.append("string rfm_classification = \"rendernode/RenderMan/pattern\",\n");
                String helpStr = shader.getHelpStr();
                helpStr = helpStr == null ? "Brief description goes here." : helpStr;
                buff.append("string help = \"" + helpStr + "\"\n");
                buff.append("]]\n");
                if (data.paramsBegin > -1 && data.endOfName > -1) {
                    BBxt.setSelection(data.endOfName, data.paramsBegin - 1);
                    BBxt.paste(buff.toString());
                    BBxt.save();
                    boolean result = false;
                    File f = BBxt.getWindowFile();
                    if (f != null) {
                        BBxt.save();
                        OslCompilerManager.getInstance().doRmanCompile(f);
                    }
                } else {
                    DialogUtils.showErrorMessage("Error 5: Cannot Assign Node ID", cannotAssignIdMsg);
                }
            }
        });
    }

    private class MetaAction
    implements ActionListener {
        String target;
        String payload;
        String metaBlock;
        int openOffset;
        int closeOffset;
        boolean addNewline;

        public MetaAction(String target, String payload, String metaBlock, int openMetaOffset, int closeMetaOffset, boolean addNewline) {
            this.target = target;
            this.payload = payload;
            this.metaBlock = metaBlock;
            this.openOffset = openMetaOffset;
            this.closeOffset = closeMetaOffset;
            this.addNewline = addNewline;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String[] lines = TextUtils.tokenize(this.metaBlock, "\n,");
            StringBuffer buf = new StringBuffer();
            if (this.addNewline) {
                buf.append("\n").append(OslMetaHelper.META_INDENT);
            }
            buf.append("[[\n");
            boolean itemIsPresent = false;
            if (lines != null) {
                for (int n = 0; n < lines.length; ++n) {
                    String line = lines[n].trim();
                    if (!line.endsWith(",")) {
                        line = line + ",";
                    }
                    if (line.contains(this.target)) {
                        itemIsPresent = true;
                    }
                    buf.append(OslMetaHelper.META_INDENT).append(line).append("\n");
                }
            }
            if (!itemIsPresent) {
                buf.append(OslMetaHelper.META_INDENT).append(this.payload).append("\n");
            }
            buf.append(OslMetaHelper.META_INDENT).append("]]");
            String bufStr = buf.toString();
            if (OslMetaHelper.this.textpane.getText().charAt(this.closeOffset) != ',') {
                bufStr = bufStr + ",";
            }
            OslMetaHelper.this.textpane.select(this.openOffset, this.closeOffset);
            OslMetaHelper.this.textpane.replaceSelection(bufStr);
        }
    }
}

