/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Script.Osl.OslShader;
import UI_Script.Osl.OslinfoParser;
import Utilities.FileUtils;
import Utilities.HashTableUtils;
import Utilities.MayaNodeIdUtilsDB;
import Utilities.OslUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class OslNodeIdInfo {
    public static String[] msgNoRegistrations = new String[]{"The custom \"RenderMan_for_Maya.ini\" appears not  ", "have registered any plugin \"nodeids\" with RfM!   "};
    public static String[] msgNoIni = new String[]{"Cannot find the users custom \"RenderMan_for_Maya.ini\".", "The path to the .ini file must be set in:", "    Preferences Tool->Rman->User", "Otherwise a report of the nodeids registered by the users", "plugins cannot be generated."};

    public static Vector<OslShader> getNodeIdsInUse() {
        OslinfoParser parser;
        int n;
        File parentDir;
        String[] names;
        Hashtable<String, File> tableOfOsoFiles = new Hashtable<String, File>();
        String srcPath = Preferences.get(Preferences.PATH_USER_OSL_SOURCE);
        String shdPath = Preferences.get(Preferences.PATH_USER_OSL_SHADERS);
        if (new File(srcPath).exists() && (names = FileUtils.getListOfFileNames(parentDir = new File(srcPath), ".oso")) != null) {
            for (n = 0; n < names.length; ++n) {
                tableOfOsoFiles.put(names[n], parentDir);
            }
        }
        if (new File(shdPath).exists() && (names = FileUtils.getListOfFileNames(parentDir = new File(shdPath), ".oso")) != null) {
            for (n = 0; n < names.length; ++n) {
                tableOfOsoFiles.put(names[n], parentDir);
            }
        }
        if (OslUtils.arnoldIsAvailable()) {
            parser = new OslinfoParser(OslUtils.getArnoldBin());
        } else if (OslUtils.rmanIsAvailable()) {
            parser = new OslinfoParser(OslUtils.getRmanBin());
        } else {
            Cutter.setLog("    Error: OslNodeidInfo.getNodeIdsInUse() - oslinfo is not available!");
            return null;
        }
        Vector<OslShader> listOfShaders = new Vector<OslShader>();
        Vector<String> listOfNodeids = new Vector<String>();
        names = HashTableUtils.getAllKeys_Str_File(tableOfOsoFiles);
        if (names == null) {
            return null;
        }
        for (int n2 = 0; n2 < names.length; ++n2) {
            String[] temp = new String[]{names[n2]};
            File parent = tableOfOsoFiles.get(names[n2]);
            String osoInfo = parser.getRawOslInfo(temp, parent);
            OslShader[] shaders = parser.parseRawOsoInfo(osoInfo);
            if (shaders == null || shaders[0].getNodeId() == -1) continue;
            shaders[0].setCompiledShdDir(parent);
            shaders[0].setSorted(false);
            listOfNodeids.add(shaders[0].getNodeIdStr());
            listOfShaders.add(shaders[0]);
        }
        String[] unsorted = VectorUtils.toStringArray(listOfNodeids);
        if (unsorted == null) {
            return null;
        }
        String[] sorted = TextUtils.sortByAlpha(unsorted);
        Vector<OslShader> sortedShaders = new Vector<OslShader>();
        for (int n3 = 0; n3 < sorted.length; ++n3) {
            String idStr = sorted[n3];
            for (int i = 0; i < listOfShaders.size(); ++i) {
                OslShader shader = (OslShader)listOfShaders.elementAt(i);
                if (!shader.getNodeIdStr().equals(idStr) || shader.getSorted()) continue;
                shader.setSorted(true);
                sortedShaders.add(shader);
            }
        }
        return sortedShaders;
    }

    public static String writeReport(Vector<OslShader> listOfShaders, MayaNodeIdUtilsDB mayaNodeDB) {
        if (listOfShaders == null) {
            return "None of the user OSL shaders are using \"rfm_nodeid\" metadata.\n";
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer header = new StringBuffer();
        if (listOfShaders.size() == 0) {
            header.append("None of the user OSL shaders are using \"rfm_nodeid\" metadata.\n");
            return header.toString();
        }
        header.append("--------------------------------------------------------------\n");
        header.append("PIXAR RENDERMAN OSL\n");
        header.append("The nodeids for OSL shaders are assigned directly within the \n");
        header.append("source code of the shader. Shaders do NOT have corresponding\n");
        header.append("args files.\n\n");
        header.append("Nodeid's assigned to the users OSL shaders:\n");
        for (int n = 0; n < listOfShaders.size(); ++n) {
            OslShader shader = listOfShaders.elementAt(n);
            mayaNodeDB.addItem(shader.nodeid, shader.getName() + ".oso", shader.getCompiledShdDir().getPath());
            File f = new File(shader.getCompiledShdDir().getPath(), shader.getName());
            String path = f.getPath();
            if (path.startsWith(".")) {
                path = FileUtils.relativeToFull(FileUtils.getPWD(), path);
            }
            f = new File(path);
            f = f.getParentFile();
            String name = new File(path).getName();
            buf.append(shader.getNodeId() + ":\t\t\"" + f.getName() + "/" + name + ".oso\"\n");
        }
        buf.append("\n");
        header.append(buf);
        return header.toString();
    }
}

