/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Osl.OslinfoParser;
import UI_Tools.Rman.RenderInfo;
import Utilities.FileUtils;
import Utilities.OslUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class OslRis20RibGenerator {
    private static final String RIB_ROOT_DIR = "rman_tool_docs";
    private static final String RIB_DIR = "rib";
    private static final String OSL_DIRNAME = "osl";
    public static final String OSL_PXR_DEFAULT_RIB = "PxrDefault.rib";
    public static final String OSL_AS_RIB = "PxrOSL.rib";
    public static final String OSL_PXR_DISNEY_RIB = "PxrDisney.rib";
    public static final String OSL_PXR_DISNEY_PARAMS = "PxrDisneyParams.rib";
    private static File osl_ribdocs_dir = null;
    private static File pxrDefaultFile;
    private static File pxrDisneyFile;
    private static File pxrDisneyParamsFile;

    public static File getShaderFile(File oslSrcFile) {
        File f;
        if (oslSrcFile == null) {
            return null;
        }
        String oslSrcText = BBxt.getWindowText();
        String osoShaderName = BBxt.oslGetShaderName(oslSrcText);
        String userOsoDirPath = Preferences.get(Preferences.PATH_USER_OSL_SHADERS);
        if (userOsoDirPath == null || userOsoDirPath.trim().length() == 0) {
            userOsoDirPath = null;
        } else if (userOsoDirPath.startsWith(".")) {
            f = FileUtils.resolveRelativePath(FileUtils.getPWDFile(), userOsoDirPath);
            userOsoDirPath = !f.exists() ? null : f.getPath();
        } else {
            f = new File(userOsoDirPath);
            String string = userOsoDirPath = !f.exists() ? null : f.getPath();
        }
        if (userOsoDirPath == null || !new File(userOsoDirPath).exists()) {
            userOsoDirPath = oslSrcFile.getParentFile().getPath();
        }
        File osoFile = null;
        File osoDir = new File(userOsoDirPath);
        if (osoDir.exists()) {
            osoFile = new File(osoDir, osoShaderName + ".oso");
            return osoFile;
        }
        return null;
    }

    public static void createDocument(String title, String ribType, File oslSrcFile) {
        String params;
        OslinfoParser osoParser;
        File osoFile = OslRis20RibGenerator.getShaderFile(oslSrcFile);
        if (osoFile == null || !osoFile.exists()) {
            if (osoFile != null && !osoFile.exists()) {
                Cutter.setLog("    Error:OslRibGenerator.createDocument() - cannot find \"" + osoFile.getPath() + "\"");
            }
            JOptionPane.showMessageDialog(Cutter.desktop, "The Open Shading Language shader document has not been \ncompiled. Cutter can only generate a rib file specific \nto the shader if it can locate the compiled shader.\n", "Shader Not Compiled Error", 0);
            return;
        }
        String ribTemplate = FileUtils.read(pxrDisneyFile);
        StringBuffer ribBuf = new StringBuffer();
        StringBuffer bxdfBuf = new StringBuffer();
        if (OslUtils.arnoldIsAvailable()) {
            osoParser = new OslinfoParser(OslUtils.getArnoldBin());
        } else if (OslUtils.rmanIsAvailable()) {
            osoParser = new OslinfoParser(OslUtils.getRmanBin());
        } else {
            Cutter.setLog("    Error: OslRis20RibGenerator.createDocument() - oslinfo is not available!");
            return;
        }
        String oslSrcText = FileUtils.read(oslSrcFile);
        String osoName = BBxt.oslGetShaderName(oslSrcText);
        OslinfoParser.RibInfo ribInfo = osoParser.getRibInfo(osoName, osoFile);
        if (ribInfo == null) {
            JOptionPane.showMessageDialog(Cutter.desktop, "Using the command \"oslinfo -v\" to query the following shader\n\n" + osoFile.getPath() + "\n\nfailed to generate any information that could be used to create\na rib statement.\n", "Unable to Query Shader Error", 0);
            return;
        }
        String ribDeclaration = ribInfo.toString(0);
        if (ribType.equals(OSL_AS_RIB)) {
            ribBuf.append(ribDeclaration);
            BBxt.newDocument(osoName + ".rib", ribBuf.toString());
            return;
        }
        if (ribType.equals(OSL_PXR_DEFAULT_RIB) && !ribInfo.getType().equals("shader")) {
            JOptionPane.showMessageDialog(Cutter.desktop, "The open shading language document implements \na shader of type \"" + ribInfo.getType().toLowerCase() + "\". Only compiled shaders\nof type \"shader\" can be used with the PxrOSL node.\n", "Wrong Shader Type Error", 0);
            return;
        }
        boolean diffuseColorDone = false;
        boolean presenceDone = false;
        ribBuf.append(ribDeclaration);
        ribTemplate = ribTemplate.replaceAll("(__Pattern__)", ribBuf.toString());
        ribBuf.setLength(0);
        String oslShadersPath = Preferences.get(Preferences.PATH_USER_OSL_SHADERS);
        File oslShadersFile = new File(oslShadersPath);
        String rslShadersPath = Preferences.get(Preferences.PATH_USER_SHADERS);
        File rslShadersFile = new File(rslShadersPath);
        File d = oslSrcFile.getParentFile();
        String paths = d.exists() ? d.getPath() + ":" : "";
        paths = paths + (oslShadersFile.exists() ? oslShadersPath + ":" : "");
        paths = paths + (rslShadersFile.exists() ? rslShadersPath : "");
        ribBuf.append("Option \"ribparse\" \"string varsubst\" [\"$\"]\n");
        String rmspath = Preferences.get(Preferences.PATH_PIXAR_RMS);
        if (rmspath.trim().length() > 0) {
            rmspath = rmspath.replace('\\', '/');
            rmspath = TextUtils.trimTrailingChar(rmspath, '/');
            ribBuf.append("IfBegin \"!defined(RMSTREE)\"\n");
            ribBuf.append("\tOption \"user\" \"string RMSTREE\" [\"" + rmspath + "/\"]\n");
            ribBuf.append("IfEnd\n");
        }
        ribBuf.append("Option \"searchpath\" \"shader\"    [\"" + paths + ":@\"]\n");
        ribBuf.append(RenderInfo.getOption("searchpath", "rixplugin"));
        ribBuf.append(RenderInfo.getOption("searchpath", "texture"));
        ribBuf.append(RenderInfo.getOption("searchpath", "archive"));
        ribBuf.append("\n");
        bxdfBuf.append("Bxdf \"PxrDisney\" \"PxrDisney1\"\n");
        String refTabs = "\t\t\t";
        String stdTabs = "\t\t\t";
        for (int n = 0; n < ribInfo.outputs.length; ++n) {
            String pname = ribInfo.outputs[n].getName();
            if (ribInfo.outputs[n].getDataType().equals("color")) {
                if (!diffuseColorDone) {
                    bxdfBuf.append(refTabs).append("\"reference color baseColor\" [\"" + ribInfo.getHandle() + ":" + pname + "\"]\n");
                } else if (!diffuseColorDone) {
                    bxdfBuf.append(stdTabs).append("\"color baseColor\" [1 1 1]\n");
                }
                diffuseColorDone = true;
            }
            if (!ribInfo.outputs[n].getDataType().equals("float")) continue;
            if (!presenceDone) {
                bxdfBuf.append(refTabs).append("\"reference float presence\" [\"" + ribInfo.getHandle() + ":" + pname + "\"]\n");
            } else if (!presenceDone) {
                bxdfBuf.append(stdTabs).append("\"float presence\" 1\n");
            }
            presenceDone = true;
        }
        if (!diffuseColorDone) {
            bxdfBuf.append(stdTabs).append("\"color baseColor\" [1 1 1]\n");
        }
        if (!presenceDone) {
            bxdfBuf.append(stdTabs).append("\"float presence\" 1\n");
        }
        if ((params = FileUtils.read(pxrDisneyParamsFile)) != null) {
            bxdfBuf.append(params);
        }
        ribTemplate = ribTemplate.replaceAll("(__Bxdf_PxrDisney__)", bxdfBuf.toString().trim());
        ribBuf.append(ribTemplate);
        BBxt.newDocument(osoName + ".rib", ribBuf.toString());
    }

    private static String[] _getOslRibFromHelp(String docName) {
        File f = new File(osl_ribdocs_dir, docName);
        if (!f.exists()) {
            return null;
        }
        String text = FileUtils.read(f);
        StringTokenizer t = new StringTokenizer(text, "\n");
        Vector<String> v = new Vector<String>();
        while (t.hasMoreTokens()) {
            String str = t.nextToken();
            v.addElement(str);
        }
        return VectorUtils.toStringArray(v);
    }

    static {
        File f = new File(FileUtils.getPWDFile(), "Cutter_Help");
        f = new File(f, RIB_ROOT_DIR);
        File rib_dir = new File(f, RIB_DIR);
        osl_ribdocs_dir = new File(rib_dir, OSL_DIRNAME);
        pxrDefaultFile = new File(osl_ribdocs_dir, OSL_PXR_DEFAULT_RIB);
        pxrDisneyFile = new File(osl_ribdocs_dir, OSL_PXR_DISNEY_RIB);
        pxrDisneyParamsFile = new File(osl_ribdocs_dir, OSL_PXR_DISNEY_PARAMS);
    }
}

