/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Osl.OslRis23RibStrings;
import UI_Script.Osl.OslinfoParser;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.Ris23RibStrings;
import Utilities.FileUtils;
import Utilities.OslUtils;
import Utilities.TextUtils;
import java.io.File;
import javax.swing.JOptionPane;

public class OslRis23RibGenerator {
    private static String DEFAULT_DIFFUSE_DECL = "\"color diffuseColor\" [0.18 0.18 0.18]";
    private static String DEFAULT_PRESENCE_DECL = "\"float presence\" [1]";

    public static File getShaderFile(File oslSrcFile) {
        return OslRis23RibGenerator.getShaderFile(oslSrcFile, null);
    }

    public static File getShaderFile(File oslSrcFile, String shaderName) {
        File f;
        if (oslSrcFile == null) {
            return null;
        }
        String oslSrcText = BBxt.getWindowText();
        String osoShaderName = shaderName == null ? BBxt.oslGetShaderName(oslSrcText) : shaderName;
        String userOsoDirPath = Preferences.get(Preferences.PATH_USER_OSL_SHADERS);
        if (userOsoDirPath == null || userOsoDirPath.trim().length() == 0) {
            userOsoDirPath = null;
        } else if (userOsoDirPath.startsWith(".")) {
            f = FileUtils.resolveRelativePath(FileUtils.getPWDFile(), userOsoDirPath);
            userOsoDirPath = !f.exists() ? null : f.getPath();
        } else {
            f = new File(userOsoDirPath);
            String string = userOsoDirPath = !f.exists() ? null : f.getPath();
        }
        if (userOsoDirPath == null || !new File(userOsoDirPath).exists()) {
            userOsoDirPath = oslSrcFile.getParentFile().getPath();
        }
        File osoFile = null;
        File osoDir = new File(userOsoDirPath);
        if (osoDir.exists()) {
            osoFile = new File(osoDir, osoShaderName + ".oso");
            return osoFile;
        }
        return null;
    }

    public static OslinfoParser.RibInfo getRibInfo(File oslSrcFile) {
        OslinfoParser osoParser;
        File osoFile = OslRis23RibGenerator.getShaderFile(oslSrcFile);
        if (osoFile == null || !osoFile.exists()) {
            if (osoFile != null && !osoFile.exists()) {
                Cutter.setLog("    Error:OslRis23RibGenerator.createBeauty() - cannot find \"" + osoFile.getPath() + "\"");
            }
            JOptionPane.showMessageDialog(Cutter.desktop, "The Open Shading Language shader document has not been \ncompiled. Cutter can only generate a rib file specific \nto the shader if it can locate the compiled shader.\n", "Shader Not Compiled Error", 0);
            return null;
        }
        String osoName = BBxt.oslGetShaderName(FileUtils.read(oslSrcFile));
        if (OslUtils.arnoldIsAvailable()) {
            osoParser = new OslinfoParser(OslUtils.getArnoldBin());
        } else if (OslUtils.rmanIsAvailable()) {
            osoParser = new OslinfoParser(OslUtils.getRmanBin());
        } else {
            return null;
        }
        OslinfoParser.RibInfo ribInfo = osoParser.getRibInfo(osoName, osoFile);
        if (ribInfo == null) {
            JOptionPane.showMessageDialog(Cutter.desktop, "Using the command \"oslinfo -v\" to query the following shader\n\n" + osoFile.getPath() + "\n\nfailed to generate any information that could be used to create\na rib statement.\n", "Unable to Query Shader Error", 0);
            return null;
        }
        if (!ribInfo.getType().equals("shader")) {
            JOptionPane.showMessageDialog(Cutter.desktop, "The open shading language document implements \na shader of type \"" + ribInfo.getType().toLowerCase() + "\". Only compiled shaders\nof type \"shader\" can be used by RenderMan.\n", "Wrong Shader Type Error", 0);
            return null;
        }
        return ribInfo;
    }

    public static void createArchive(String title, File oslSrcFile) {
        OslinfoParser.RibInfo ribInfo = OslRis23RibGenerator.getRibInfo(oslSrcFile);
        if (ribInfo != null) {
            BBxt.newDocument(ribInfo.getName() + ".rib", ribInfo.toString(0));
        }
    }

    public static void createBeauty(String title, File oslSrcFile) {
        OslinfoParser.RibInfo ribInfo = OslRis23RibGenerator.getRibInfo(oslSrcFile);
        if (ribInfo == null) {
            return;
        }
        String oslDeclaration = ribInfo.toString(0);
        String bxdfDeclaration = OslRis23RibStrings.PXR_DIFFUSE;
        boolean diffuseColorDone = false;
        boolean presenceDone = false;
        for (int n = 0; n < ribInfo.outputs.length; ++n) {
            String replacement;
            String pname = ribInfo.outputs[n].getName();
            if (ribInfo.outputs[n].getDataType().equals("color") && !diffuseColorDone) {
                replacement = "\"reference color diffuseColor\" [\"" + ribInfo.getHandle() + ":" + pname + "\"]";
                bxdfDeclaration = bxdfDeclaration.replaceAll("(__DIFFUSE_COLOR_CONNECTION__)", replacement);
                diffuseColorDone = true;
            }
            if (!ribInfo.outputs[n].getDataType().equals("float") || presenceDone) continue;
            replacement = "\"reference float presence\" [\"" + ribInfo.getHandle() + ":" + pname + "\"]";
            bxdfDeclaration = bxdfDeclaration.replaceAll("(__PRESENCE_CONNECTION__)", replacement);
            presenceDone = true;
        }
        if (!diffuseColorDone) {
            bxdfDeclaration = bxdfDeclaration.replaceAll("(__DIFFUSE_COLOR_CONNECTION__)", DEFAULT_DIFFUSE_DECL);
        }
        if (!presenceDone) {
            bxdfDeclaration = bxdfDeclaration.replaceAll("(__PRESENCE_CONNECTION__)", DEFAULT_PRESENCE_DECL);
        }
        String beautyRib = OslRis23RibStrings.OSL_BEAUTY_RIB;
        String options = OslRis23RibGenerator.getSharedOptions();
        beautyRib = beautyRib.replaceAll("(__SHARED_OPTIONS__)", options);
        oslDeclaration = TextUtils.replaceAll(oslDeclaration, "$", "\\$", true, false);
        beautyRib = beautyRib.replaceAll("(__OSL_PATTERN__)", oslDeclaration);
        beautyRib = beautyRib.replaceAll("(__PXR_DIFFUSE__)", bxdfDeclaration);
        BBxt.newDocument(ribInfo.getName() + ".rib", beautyRib);
    }

    public static String getSharedOptions() {
        String options = Ris23RibStrings.basicOptions;
        String rmspath = Preferences.get(Preferences.PATH_PIXAR_RMS);
        if (rmspath.trim().length() > 0) {
            rmspath = rmspath.replace('\\', '/');
            rmspath = TextUtils.trimTrailingChar(rmspath, '/');
            options = options.replaceAll("(__RMSTREE__)", rmspath);
        }
        String path = RenderInfo.get(27);
        options = options.replaceAll("(__OSL_SHADERS__)", path);
        path = RenderInfo.get(26);
        options = options.replaceAll("(__RIXPLUGINS__)", path);
        path = RenderInfo.get(14);
        options = options.replaceAll("(__TEXTURES__)", path);
        path = RenderInfo.get(20);
        options = options.replaceAll("(__ARCHIVES__)", path);
        return options;
    }
}

