/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import Preferences.Preferences;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Osl.OpenOslAction;
import UI_Script.Osl.OslCompilerManager;
import UI_Script.Osl.OslHelp;
import UI_Script.Osl.OslListener;
import UI_Script.Osl.OslTokenizer;
import UI_Script.ScriptHandler;
import UI_Text.KTextPane.KTextPane;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import java.io.File;
import javax.swing.JMenuItem;

public class OslScriptHandler
extends ScriptHandler {
    @Override
    public boolean canRunSelection() {
        return false;
    }

    public OslScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".osl";
        this.ext[1] = ".OSL";
        this.setTokenizer();
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp.osl");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public void execute(File file) {
        if (Preferences.get(Preferences.OSL_COMPILE_KEYBOARD_SHORTCUT).equalsIgnoreCase("PRMAN")) {
            OslCompilerManager.getInstance().doRmanCompile(file);
        } else {
            OslCompilerManager.getInstance().doArnoldCompile(file);
        }
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(OslHelp.class.getName(), textpane);
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new OslTokenizer();
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return OslListener.class.getName();
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("osl", "Open Shading Language");
        return filter;
    }

    @Override
    public String getExecuteLabel() {
        return "Compile " + this.getScriptName();
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.osl");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Osl";
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Osl");
        item.addActionListener(new OpenOslAction());
        return item;
    }
}

