/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Osl.OslCompilerManager;
import UI_Script.Osl.OslMetaDataParser;
import UI_Script.Osl.OslinfoParser;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import UI_Tools.Rman.RenderInfo;
import Utilities.NumberUtils;
import Utilities.OslUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kernal.Tokenizers.Tokenizer;

public class OslShader {
    private File compiledShdDir = null;
    private String name = "";
    private String type = "unknown";
    private int typeID = -1;
    public int nodeid = -1;
    public String nodeidStr = "-1";
    private boolean nodeidSorted = false;
    private Vector<String> metadata = new Vector();
    private Vector<Parameter> listOfParams = new Vector();
    public int index = 0;

    public boolean getSorted() {
        return this.nodeidSorted;
    }

    public void setSorted(boolean f) {
        this.nodeidSorted = f;
    }

    public int getNumParams() {
        return this.listOfParams.size();
    }

    public Parameter getParamAtIndex(int n) {
        return this.listOfParams.elementAt(n);
    }

    public OslShader(String type) {
        if (type.compareTo("shader") == 0) {
            this.type = "shader";
            this.typeID = 0;
        } else if (type.compareTo("surface") == 0) {
            this.type = "Surface";
            this.typeID = 1;
        } else if (type.compareTo("displacement") == 0) {
            this.type = "Displacement";
            this.typeID = 2;
        } else if (type.compareTo("light") == 0) {
            this.type = "Light";
            this.typeID = 3;
        } else if (type.compareTo("volume") == 0) {
            this.type = "Volume";
            this.typeID = 4;
        } else {
            this.type = "unknown";
            this.typeID = -1;
        }
    }

    public boolean setName(String name) {
        String nameOnly;
        if (name.length() == 0) {
            return false;
        }
        this.name = nameOnly = new File(name).getName();
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setCompiledShdDir(File d) {
        this.compiledShdDir = d;
    }

    public File getCompiledShdDir() {
        return this.compiledShdDir;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTypeID(int id) {
        this.typeID = id;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public void addParameter(Parameter p) {
        this.listOfParams.addElement(p);
    }

    public Parameter getNewParameter() {
        return new Parameter();
    }

    public void appendMetaData(String str) {
        this.metadata.add(str);
    }

    public Vector<String> getMetaData() {
        return this.metadata;
    }

    public void setNodeId() {
        this.nodeid = OslMetaDataParser.getNodeId(this);
        this.nodeidStr = "" + this.nodeid;
    }

    public int getNodeId() {
        return this.nodeid;
    }

    public String getNodeIdStr() {
        return this.nodeidStr;
    }

    public String getHelpStr() {
        return OslMetaDataParser.getHelp(this.metadata);
    }

    public String toString(int tabs) {
        StringBuffer buff = new StringBuffer();
        File csd = this.getCompiledShdDir();
        if (csd == null) {
            String s = RenderInfo.get(13);
            this.setCompiledShdDir(new File(s));
            csd = this.getCompiledShdDir();
        }
        String sysShadersPath = new File(RenderInfo.get(7)).getPath();
        boolean isUserShader = !csd.getPath().equals(sysShadersPath);
        String nameOnly = new File(this.name).getName();
        nameOnly = TextUtils.removeQuotes(nameOnly);
        String ribStatement = this.type + " \"" + nameOnly + "\"\n";
        buff.append(ribStatement);
        int n = 0;
        for (n = 0; n < this.listOfParams.size(); ++n) {
            Parameter p = this.listOfParams.elementAt(n);
            for (int i = 0; i < tabs; ++i) {
                buff.append('\t');
            }
            buff.append(p.toString()).append("\n");
        }
        if (n > 0) {
            for (int i = 0; i < tabs; ++i) {
                buff.append('\t');
            }
        }
        return buff.toString();
    }

    public static OslShader[] convertToArray(Hashtable table) {
        if (table == null || table.size() == 0) {
            return null;
        }
        OslShader[] out = new OslShader[table.size()];
        Enumeration e = table.elements();
        while (e.hasMoreElements()) {
            OslShader shader = (OslShader)e.nextElement();
            if (shader.index >= table.size()) continue;
            out[shader.index] = shader;
        }
        return out;
    }

    public static OslShader getDesktopShader(int oslEnv) {
        OslinfoParser parser;
        String srcText = BBxt.getWindowText();
        if (srcText == null) {
            return null;
        }
        String osoName = BBxt.oslGetShaderName(srcText);
        if (osoName == null) {
            return null;
        }
        String usrOSODirPath = "";
        if (oslEnv == OslCompilerManager.OSL_ENV_PIXAR) {
            usrOSODirPath = Preferences.get(Preferences.PATH_USER_OSL_SHADERS);
        } else if (oslEnv == OslCompilerManager.OSL_ENV_ARNOLD) {
            usrOSODirPath = Preferences.get(Preferences.PATH_USER_ARNOLD_OSL_SHADERS);
        }
        File usrOSODir = new File(usrOSODirPath);
        if (!usrOSODir.exists()) {
            File windowFile = BBxt.getWindowFile();
            usrOSODir = windowFile.getParentFile();
        }
        if (oslEnv == OslCompilerManager.OSL_ENV_ARNOLD) {
            Cutter.setLog("    Debug: OslShader.getDesktopShader() - using arnold parser");
            parser = new OslinfoParser(OslUtils.getArnoldBin());
        } else if (oslEnv == OslCompilerManager.OSL_ENV_PIXAR) {
            Cutter.setLog("    Debug: OslShader.getDesktopShader() - using rman parser");
            parser = new OslinfoParser(OslUtils.getRmanBin());
        } else {
            Cutter.setLog("    Error: OslShader.getDesktopShader() - oslinfo is not available!");
            return null;
        }
        String[] names = new String[]{osoName + ".oso"};
        String rawtext = parser.getRawOslInfo(names, usrOSODir);
        OslShader[] shaders = parser.parseRawOsoInfo(rawtext);
        return shaders == null ? null : shaders[0];
    }

    static boolean __compileDesktopShader() {
        File file = BBxt.getWindowFile();
        ScriptHandler handler = ScriptRegistry.getHandlerForExtension(".osl");
        if (handler != null && file != null) {
            BBxt.save();
            handler.execute(file);
            return true;
        }
        return false;
    }

    public class Parameter {
        public static final int UNKNOWN = 0;
        public static final int FLOAT = 1;
        public static final int POINT = 2;
        public static final int COLOR = 3;
        public static final int STRING = 4;
        public static final int VECTOR = 5;
        public static final int NORMAL = 6;
        public static final int MATRIX = 7;
        public static final int SHADER_OBJ = 8;
        public static final int FLOAT_ARRAY = 9;
        public static final int POINT_ARRAY = 10;
        public static final int COLOR_ARRAY = 11;
        public static final int STRING_ARRAY = 12;
        public static final int VECTOR_ARRAY = 13;
        public static final int NORMAL_ARRAY = 14;
        public static final int MATRIX_ARRAY = 15;
        public static final int SHADER_OBJ_ARRAY = 16;
        public static final int INT = 17;
        public static final int INT_ARRAY = 18;
        private String name = "";
        private String type = "unknown";
        private String modifier = "";
        private String space = "";
        private int typeID = 0;
        public int arraySize = -1;
        private boolean isOutputVariable = false;
        private StringBuffer value = new StringBuffer();
        private Vector<String> metadata = new Vector();
        private boolean isLockGeom = false;
        public String parserNotes = null;
        static final String PRE_BRACKET = "([^\\[]*)\\[";
        static final String BRACKET_CONTENT = "([^\\]]*)";
        static final String POST_BRACKET = "\\]((.*))";
        Pattern arraySizePattern = Pattern.compile("([^\\[]*)\\[([^\\]]*)\\]((.*))");

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setModifier(String mod) {
            this.modifier = mod;
        }

        public String getModifier() {
            return this.modifier;
        }

        public void setIsOutput() {
            this.isOutputVariable = true;
        }

        public boolean isOutput() {
            return this.isOutputVariable;
        }

        public void setDataType(int type) {
            this.typeID = type;
        }

        public String getDataType() {
            return this.type;
        }

        public Vector<String> getMetaData() {
            return this.metadata;
        }

        public String getValue() {
            return this.value.toString();
        }

        public boolean isLockGeom() {
            return this.isLockGeom;
        }

        public void appendMetaData(String str) {
            this.metadata.add(str);
            if (str.contains("lockgeom")) {
                this.isLockGeom = true;
            }
        }

        public boolean setDataType(String typeStr) {
            int beginAt;
            if (typeStr.length() == 0) {
                Cutter.setLog("    Error:OSLParser.setDataType() - has been passed an empty type string.");
                Cutter.setLog("        Shader is named \"" + this.name + "\".");
                return false;
            }
            if ((typeStr = Tokenizer.removeQuotes(typeStr).trim()).startsWith("output ")) {
                this.isOutputVariable = true;
                typeStr = typeStr.substring(7);
            }
            String[] strs = TextUtils.tokenize(typeStr);
            StringBuffer nameBuff = new StringBuffer();
            for (int n = beginAt = 0; n < strs.length; ++n) {
                nameBuff.append(strs[n]).append(" ");
            }
            this.type = nameBuff.toString().trim();
            this.typeID = 0;
            String s = strs[strs.length - 1];
            if (s == null) {
                Cutter.setLog("    Error: OSLParser.Parametsr.setDataType() - substring = null");
                return false;
            }
            if (s.regionMatches(0, "float[", 0, 6)) {
                this.typeID = 9;
                this.setArraySize(s);
                return true;
            }
            if (s.regionMatches(0, "point[", 0, 6)) {
                this.typeID = 10;
                this.setArraySize(s);
                return true;
            }
            if (s.regionMatches(0, "color[", 0, 6)) {
                this.typeID = 11;
                this.setArraySize(s);
                return true;
            }
            if (s.regionMatches(0, "string[", 0, 7)) {
                this.typeID = 12;
                this.setArraySize(s);
                return true;
            }
            if (s.regionMatches(0, "vector[", 0, 7)) {
                this.typeID = 13;
                this.setArraySize(s);
                return true;
            }
            if (s.regionMatches(0, "normal[", 0, 7)) {
                this.typeID = 14;
                this.setArraySize(s);
                return true;
            }
            if (s.regionMatches(0, "matrix[", 0, 7)) {
                this.typeID = 15;
                this.setArraySize(s);
                return true;
            }
            if (s.regionMatches(0, "int[", 0, 4)) {
                this.typeID = 18;
                this.setArraySize(s);
                return true;
            }
            if (s.regionMatches(0, "shader[", 0, 7)) {
                this.typeID = 16;
                this.setArraySize(s);
                return true;
            }
            if (s.equals("int")) {
                this.typeID = 17;
                return true;
            }
            if (s.equals("float")) {
                this.typeID = 1;
                return true;
            }
            if (s.equals("point")) {
                this.typeID = 2;
                return true;
            }
            if (s.equals("color")) {
                this.typeID = 3;
                return true;
            }
            if (s.equals("vector")) {
                this.typeID = 5;
                return true;
            }
            if (s.equals("string")) {
                this.typeID = 4;
                return true;
            }
            if (s.equals("normal")) {
                this.typeID = 6;
                return true;
            }
            if (s.equals("matrix")) {
                this.typeID = 7;
                return true;
            }
            if (s.equals("shader")) {
                this.typeID = 8;
                return true;
            }
            this.typeID = 0;
            Cutter.setLog("    Warning:OSLParser.Parameter.setDataType() - parameter named \"" + this.getName() + "\" expected a datatype.");
            Cutter.setLog("        but got \"" + s + "\". The shader in question is \"" + this.name + "<\n    is of unknown type >" + s + "<");
            return false;
        }

        public void setArraySize(String s) {
            Matcher m = this.arraySizePattern.matcher(s);
            if (m.matches()) {
                try {
                    this.arraySize = Integer.parseInt(m.group(2).trim());
                }
                catch (NumberFormatException e) {
                    this.arraySize = 0;
                }
            }
        }

        public boolean setSpaceName(String sp) {
            if (sp.length() == 0) {
                return false;
            }
            this.space = sp;
            return true;
        }

        public void setAbsValue(String val) {
            this.value.setLength(0);
            this.value.append(val);
        }

        public boolean setValue(String num) {
            if (num.length() == 0) {
                return false;
            }
            this.value.append(NumberUtils.clip(num));
            return true;
        }

        public boolean appendValue(String num) {
            if (num.length() == 0) {
                return false;
            }
            if (this.value.length() == 0) {
                this.value.append(NumberUtils.clip(num));
            } else {
                this.value.append(" " + NumberUtils.clip(num));
            }
            return true;
        }

        public boolean appendStringValue(String str) {
            this.value.append(" " + str);
            return true;
        }

        public int dataTypeID() {
            return this.typeID;
        }

        public String dump() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.toString()).append("\n");
            buff.append("space: ").append(this.space).append("\n");
            buff.append("typeID: ").append(this.typeID).append("\n");
            buff.append("isOutputVariable: ").append(this.isOutputVariable).append("\n");
            buff.append("value: ").append(this.value).append("\n");
            buff.append("metadata: ").append(this.metadata).append("\n");
            buff.append("isLockGeom: ").append(this.isLockGeom).append("\n");
            return buff.toString();
        }

        public String toString() {
            StringBuffer paramOutBuf = new StringBuffer();
            String[] item = TextUtils.tokenize(TextUtils.removeQuotes(this.type));
            paramOutBuf.append("\"");
            if (this.isOutputVariable) {
                paramOutBuf.append("ouput ");
            }
            paramOutBuf.append(this.type).append(" ").append(TextUtils.removeQuotes(this.name)).append("\" ");
            if (this.typeID == 1) {
                paramOutBuf.append(this.value.toString());
            } else {
                paramOutBuf.append("[").append(this.value.toString().trim()).append("]");
            }
            return paramOutBuf.toString();
        }
    }
}

