/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Tools.Monitor.Monitor;
import Utilities.FileUtils;
import java.io.File;

public class OslShaderDuplicator {
    static String[] errors = new String[]{"Failed", "Error:", "Error", "Unknown", "Can't"};

    public static void doDuplication(String processName, String userShdDirPath, String shdName) {
        boolean isPRMAN_COMPILE = false;
        boolean isARNOLD_COMPILE = false;
        if (processName.equals("PRMan OSL Compile")) {
            isPRMAN_COMPILE = true;
        }
        if (processName.equals("Arnold OSL Compile")) {
            isARNOLD_COMPILE = true;
        }
        File originalShdFile = new File(userShdDirPath, shdName + ".oso");
        if (isPRMAN_COMPILE) {
            String dupPath = Preferences.get(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION_PATH);
            if (dupPath.trim().length() == 0) {
                Cutter.setLog("    Warning:OslShaderDuplicator.doDuplication() - dupPath \"" + dupPath + "\" is empty!");
                return;
            }
            File dupDir = new File(dupPath);
            if (dupDir == null || !dupDir.exists()) {
                Cutter.setLog("    Error:OslShaderDuplicator.doDuplication() - cannot find RenderMan shader duplication directory:");
                Cutter.setLog("        \"" + dupPath + "\"");
                return;
            }
            byte[] bytes = FileUtils.readAsBinary(originalShdFile.getPath());
            File copiedShdFile = new File(dupDir, shdName + ".oso");
            FileUtils.writeAsBinary(copiedShdFile, bytes);
            String msg = "\n\nPIXAR A duplicate of \"" + shdName + ".oso" + "\" has been copied to -> " + dupPath + "/";
            Monitor.appendPanelText("PRMan OSL Compile", msg);
        } else if (isARNOLD_COMPILE) {
            String dupPath = Preferences.get(Preferences.PATH_USER_ARNOLD_OSO_MTD_DUPLICATION);
            if (dupPath.trim().length() == 0) {
                return;
            }
            File dupDir = new File(dupPath);
            if (dupDir == null || !dupDir.exists()) {
                Cutter.setLog("    Error:OslShaderDuplicator.doDuplication() - cannot find Arnold shader duplication directory:");
                Cutter.setLog("        \"" + dupPath + "\"");
                return;
            }
            byte[] bytes = FileUtils.readAsBinary(originalShdFile.getPath());
            File copiedShdFile = new File(dupDir, shdName + ".oso");
            FileUtils.writeAsBinary(copiedShdFile, bytes);
            File originalMtdFile = new File(originalShdFile.getParentFile(), shdName + ".mtd");
            bytes = FileUtils.readAsBinary(originalMtdFile.getPath());
            File copiedMtdFile = new File(dupDir, shdName + ".mtd");
            if (bytes == null) {
                String msg = "\n\nARNOLD Failure: A duplicate of \"" + shdName + ".oso" + "\" has been copied to -> " + dupPath + "/ \nBUT the \"" + shdName + ".mtd" + "\" failed to be copied. Try compiling again.";
                Monitor.appendPanelText("Arnold OSL Compile", msg);
                return;
            }
            FileUtils.writeAsBinary(copiedMtdFile, bytes);
            String msg = "\n\nDuplicates of \"" + shdName + ".oso" + "\" and \"" + shdName + ".mtd" + "\" has been copied to -> " + dupPath + "/";
            Monitor.appendPanelText("Arnold OSL Compile", msg);
        }
    }
}

