/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import UI_Desktop.Cutter;
import UI_Script.Osl.OslMetaDataParser;
import UI_Script.Syntax;
import UI_Text.Style.KStyleContext;
import javax.swing.text.Document;
import kernal.Tokenizers.Tokenizer;

public class OslSyntax
extends Syntax {
    public OslMetaDataParser activeMeta = null;
    public OslMetaDataParser prevActiveMeta = null;
    public boolean metadataOpen = false;
    public int metadataOpenedAt = 0;
    public int metadataClosedAt = 0;
    public int endMeta = 0;

    public OslSyntax(Document doc, Tokenizer tok, int preUpdate, int postUpdate) {
        super(doc, tok, preUpdate, postUpdate);
    }

    public void _lookBack(int n, char prevChar, char c0, char c1, char c2, char c3) {
        if (this.activeCmnt == null && !this.metadataOpen && prevChar == '[' && c0 == '[') {
            this.metadataOpen = true;
            this.beginParse = n - 1;
            this.metadataOpenedAt = n - 1;
            Cutter.setLog("OslSyntax.lookBack n: " + n + " metadataOpen at " + this.metadataOpenedAt);
        } else if (this.activeCmnt == null && this.metadataOpen && prevChar == ']' && c0 == ']') {
            this.metadataOpen = false;
            this.currWordBegin = n;
            this.beginParse = n;
            Cutter.setLog("OslSyntax.lookBack n: " + n + " metadataOpen false at " + n);
        }
    }

    @Override
    public boolean preUpdateCheckPoint(boolean escape, boolean comment, boolean string, boolean doLog, int offset) {
        if (this.preUpdateDone) {
            return false;
        }
        super.preUpdateCheckPoint(false, comment, string, doLog, offset);
        if (this.metadataOpen) {
            this.preUpdateStyleID = 7;
            this.postUpdateStyleID = 7;
        }
        if (!this.metadataOpen && this.activeCmnt == null) {
            this.preUpdateStyleID = 0;
            this.postUpdateStyleID = 0;
        }
        return true;
    }

    @Override
    public void postUpdateCheckPoint(boolean escape, boolean comment, boolean string, boolean doLog) {
        super.postUpdateCheckPoint(false, comment, string, false);
        if (this.metadataOpen && !comment) {
            this.postUpdateStyleID = 7;
        }
    }

    public boolean isCloseMeta(int n) {
        if (this.activeMeta == null) {
            return false;
        }
        if (n < this.metadataOpenedAt + this.activeMeta.openLen + this.activeMeta.closeLen) {
            return false;
        }
        boolean b = this.activeMeta._isCloseMeta(this.segment, n);
        return b;
    }

    public boolean isOpenMeta(int n) {
        if (this.preUpdate == this.postUpdate && this.preUpdateDone) {
            return false;
        }
        OslMetaDataParser md = new OslMetaDataParser();
        if (md.isOpenMeta(this.segment, n)) {
            this.activeMeta = md;
        }
        boolean b = this.activeMeta != null;
        return b;
    }

    @Override
    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("\n");
        out.append("     preUpdate: " + this.preUpdate + "\n");
        out.append("     postUpdate: " + this.postUpdate + "\n");
        out.append("     beginParse: " + this.beginParse + "\n");
        out.append("     preUpdateStyleID: " + KStyleContext.lookup(this.preUpdateStyleID) + "\n");
        out.append("     postUpdateStyleID: " + KStyleContext.lookup(this.postUpdateStyleID) + "\n");
        out.append("     prevActiveCmnt: " + (this.prevActiveCmnt == null ? "[null]" : this.prevActiveCmnt.getName()) + "\n");
        out.append("     prevBeginCmnt: " + this.prevBeginCmnt + "\n");
        out.append("     prevEndCmnt: " + this.prevEndCmnt + "\n");
        out.append("     prevActiveQuot: " + (this.prevActiveQuot == null ? "[null]" : this.prevActiveQuot.getName()) + "\n");
        out.append("     prevActiveEscape: " + (this.prevActiveEscape == null ? "[null]" : this.prevActiveEscape.getName()) + "\n");
        out.append("     activeCmnt: " + (this.activeCmnt == null ? "[null]" : this.activeCmnt.getName()) + "\n");
        out.append("     activeQuot: " + (this.activeQuot == null ? "[null]" : this.activeQuot.getName()) + "\n");
        out.append("     activeEscape: " + (this.activeEscape == null ? "[null]" : this.activeEscape.getName()) + "\n");
        if (this.preUpdateChar != '0') {
            out.append("     preUpdateChar > " + this.preUpdateChar + "< asci: " + this.preUpdateChar + "\n");
        }
        out.append("     postUpdateChar > " + this.postUpdateChar + "<\n");
        out.append("     metadataOpen " + this.metadataOpen + "\n");
        out.append("     metadataOpenedAt " + this.metadataOpenedAt + "\n");
        out.append("     metadataClosedAt " + this.metadataClosedAt + "\n");
        out.append("     endMeta " + this.endMeta + "\n");
        return out.toString();
    }
}

