/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import UI_Desktop.Cutter;
import UI_Script.Osl.OslLanguageRsrc;
import UI_Script.Quotation;
import UI_Script.ScriptParser.ProcDBItem;
import Utilities.TextUtils;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import kernal.Tokenizers.Tokenizer;

public class OslTokenizer
extends Tokenizer {
    public static final String MATH_CONSTANT = "constant";
    public static final String MATH_FUNCTION = "math";
    public static final String GEO_FUNCTION = "geometric";
    public static final String COLOR_FUNCTION = "color";
    public static final String MATRIX_FUNCTION = "matrix";
    public static final String PATTERN_FUNCTION = "pattern";
    public static final String DISPLACE_FUNCTION = "displace";
    public static final String STRING_FUNCTION = "string";
    public static final String TEXTURE_FUNCTION = "texture";
    public static final String MESSAGE_FUNCTION = "message";
    public static final String MISC_FUNCTION = "misc";
    public static final String SURFACE_CLOSURE = "mat_closure";
    public static final String VOLUME_CLOSURE = "vol_closure";
    public static final String LIGHT_CLOSURE = "lit_closure";
    public static final String SIGNAL_CLOSURE = "sig_closure";
    public static final int UNKNOWN_FUNCTION_ID = 0;
    public static final int MATH_CONSTANT_ID = 1;
    public static final int MATH_FUNCTION_ID = 2;
    public static final int GEO_FUNCTION_ID = 3;
    public static final int COLOR_FUNCTION_ID = 4;
    public static final int MATRIX_FUNCTION_ID = 5;
    public static final int PATTERN_FUNCTION_ID = 6;
    public static final int DISPLACE_FUNCTION_ID = 7;
    public static final int STRING_FUNCTION_ID = 8;
    public static final int TEXTURE_FUNCTION_ID = 9;
    public static final int MESSAGE_FUNCTION_ID = 10;
    public static final int MISC_FUNCTION_ID = 11;
    public static final int SURFACE_CLOSURE_ID = 12;
    public static final int VOLUME_CLOSURE_ID = 13;
    public static final int LIGHT_CLOSURE_ID = 14;
    public static final int SIGNAL_CLOSURE_ID = 15;
    private static ResourceBundle OslStatementsRes;
    public static Hashtable<String, String> language;
    public static final double version = 1.0;
    public static final String[] SHADERTYPES;
    public static final String[] DATATYPES;
    public static final String[] DATAMODIFIERS;
    private String[] shaderTypes = SHADERTYPES;
    private String[] dataTypes = DATATYPES;
    private String[] dataModifiers = DATAMODIFIERS;
    public boolean getComments = false;
    protected int typeStringOffset = -1;
    protected int nameStringOffset = -1;
    protected int shaderTypeBegin = -1;
    protected int shaderVarsBegin = -1;
    protected String shaderName = null;
    protected String shaderType = null;
    protected String shaderDescription = null;
    private int paramsBeginIndex = -1;
    private int paramsEndIndex = -1;
    private String currentPage = "";
    private StringBuffer sb = new StringBuffer();

    private static String getFunction(String nm) {
        String str;
        try {
            str = OslStatementsRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numFunctions() {
        int num = 0;
        try {
            num = ((OslLanguageRsrc)OslStatementsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read SLLanguageRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < OslTokenizer.numFunctions(); ++i) {
            language.put(((OslLanguageRsrc)OslStatementsRes).getKey(i), ((OslLanguageRsrc)OslStatementsRes).getContent(i));
        }
    }

    public OslTokenizer() {
        this.addComment("/*", "*/");
        this.addComment("//", "\n");
        this.addQuotation("\"", "\"", '\\');
        this.setSyntaxLength(2);
        this.name = "OslTokenizer";
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        String[] ext = new String[]{"osl", "OSL"};
        Tokenizer.addToRegistry(OslTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public boolean lpGetClassInterfaceSpans() {
        int currentIndex = this.getBufferIndex();
        this.setBufferIndex(0);
        ShdTypeName data = this.getShaderTypeOffsets();
        this.paramsBeginIndex = data.paramsBegin;
        this.paramsEndIndex = data.paramsEnd - 1;
        this.setBufferIndex(currentIndex);
        this.addQuotation("[[", "]]", null);
        return true;
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        int currentIndex = this.getBufferIndex();
        if (this.paramsBeginIndex == -1) {
            return null;
        }
        if (currentIndex <= this.paramsBeginIndex || currentIndex > this.paramsEndIndex || !this.isDataType(str)) {
            return null;
        }
        String paramname = this.getNextStr();
        if (paramname.equals("")) {
            this.setBufferIndex(currentIndex);
            return null;
        }
        ProcDBItem out = new ProcDBItem();
        int endOfVarnameIndex = this.getBufferIndex();
        out.procName = paramname;
        out.procNameOffset[0] = endOfVarnameIndex - paramname.length();
        out.procNameOffset[1] = endOfVarnameIndex;
        String prevStr = this.peekPrevStr(currentIndex - (str.length() + 1));
        if (prevStr.trim().equals("output")) {
            out.procModifier = "output";
            out.procName = "OUTPUT::" + out.procName;
        }
        if (this.paramsEndIndex == -1) {
            this.setBufferIndex(endOfVarnameIndex);
            return out;
        }
        int openMetaOffset = this.findForward(endOfVarnameIndex, '[');
        if (openMetaOffset == -1 || this.peekNextChar() != '[') {
            this.setBufferIndex(endOfVarnameIndex);
            return out;
        }
        this.setBufferIndex(openMetaOffset);
        int nextDataTypeIndex = -1;
        String s = this.getNextStr();
        int index = this.getBufferIndex();
        while (index > 0 && index < this.paramsEndIndex) {
            if (!this.isMetaData(s) && (this.isDataType(s) || s.equals("output"))) {
                nextDataTypeIndex = this.getBufferIndex() - s.length();
                break;
            }
            s = this.getNextStr();
            index = this.getBufferIndex();
        }
        if (nextDataTypeIndex == -1) {
            this.setBufferIndex(endOfVarnameIndex);
            return out;
        }
        if (openMetaOffset < nextDataTypeIndex) {
            int trimmedIndex;
            String metadata = new String(this.getBuffer(openMetaOffset, nextDataTypeIndex));
            if (metadata.startsWith("[[")) {
                metadata = metadata.substring(2);
            }
            if ((trimmedIndex = metadata.indexOf("]]")) != -1) {
                metadata = metadata.substring(0, trimmedIndex);
            }
            if ((metadata = metadata.trim()).length() == 0) {
                this.setBufferIndex(endOfVarnameIndex);
                return out;
            }
            String[] metas = TextUtils.tokenize(metadata, ",");
            for (int n = 0; n < metas.length; ++n) {
                String[] parts;
                String meta = metas[n];
                if (!meta.contains(STRING_FUNCTION) || !meta.contains("page") || !meta.contains("=") || (parts = TextUtils.tokenize(meta, "=")) == null || parts.length != 2) continue;
                this.currentPage = TextUtils.removeQuotes(parts[1]);
            }
        }
        if (out.procModifier.equals("") && this.currentPage.trim().length() > 0) {
            out.procName = this.currentPage + "::" + out.procName;
        }
        this.setBufferIndex(endOfVarnameIndex);
        return out;
    }

    public String peekPrevStr(int offset) {
        int nwIndex = this.peekPrevNonWhite(offset);
        if (nwIndex == -1) {
            return "";
        }
        int wIndex = this.peekPrevWhite(nwIndex - 1);
        if (wIndex == -1) {
            return "";
        }
        return new String(this.getBuffer(wIndex + 1, nwIndex));
    }

    @Override
    public boolean isSystemVariable(String str) {
        return str.compareTo("P") == 0 || str.compareTo("I") == 0 || str.compareTo("N") == 0 || str.compareTo("Ng") == 0 || str.compareTo("u") == 0 || str.compareTo("v") == 0 || str.compareTo("dPdu") == 0 || str.compareTo("dPdv") == 0 || str.compareTo("time") == 0 || str.compareTo("dtime") == 0 || str.compareTo("dPdtime") == 0;
    }

    public static int getFunctionType(String functionName) {
        if (!language.containsKey(functionName)) {
            return 0;
        }
        String obj = language.get(functionName);
        if (obj == null) {
            return 0;
        }
        if (obj.equals(MATH_CONSTANT)) {
            return 3;
        }
        if (obj.equals(MATH_FUNCTION)) {
            return 2;
        }
        if (obj.equals(GEO_FUNCTION)) {
            return 3;
        }
        if (obj.equals(COLOR_FUNCTION)) {
            return 4;
        }
        if (obj.equals(MATRIX_FUNCTION)) {
            return 5;
        }
        if (obj.equals(PATTERN_FUNCTION)) {
            return 6;
        }
        if (obj.equals(DISPLACE_FUNCTION)) {
            return 7;
        }
        if (obj.equals(STRING_FUNCTION)) {
            return 8;
        }
        if (obj.equals(TEXTURE_FUNCTION)) {
            return 9;
        }
        if (obj.equals(MESSAGE_FUNCTION)) {
            return 10;
        }
        if (obj.equals(MISC_FUNCTION)) {
            return 11;
        }
        if (obj.equals(SURFACE_CLOSURE)) {
            return 12;
        }
        if (obj.equals(VOLUME_CLOSURE)) {
            return 13;
        }
        if (obj.equals(LIGHT_CLOSURE)) {
            return 14;
        }
        if (obj.equals(SIGNAL_CLOSURE)) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean isFunction(String str) {
        return OslTokenizer.getFunctionType(str) != 0;
    }

    @Override
    public boolean isDataType(String str) {
        for (int n = 0; n < this.dataTypes.length; ++n) {
            if (!str.equals(this.dataTypes[n])) continue;
            return !this.nextNonWhiteCharIs(40) && !this.nextNonWhiteCharIs(34);
        }
        return false;
    }

    @Override
    public boolean isComment(String str) {
        return str.length() > 1 && str.charAt(0) == '/' && str.charAt(1) == '*';
    }

    @Override
    public String[] getDataTypes() {
        return this.dataTypes;
    }

    @Override
    public boolean isDataModifier(String str) {
        for (int n = 0; n < this.dataModifiers.length; ++n) {
            if (!str.equals(this.dataModifiers[n])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLanguageType(String str) {
        if (!language.containsKey(str)) {
            return false;
        }
        return language.get(str).equals("language");
    }

    public String[] getShaderTypes() {
        return this.shaderTypes;
    }

    @Override
    public boolean isShaderType(String str) {
        for (int n = 0; n < this.shaderTypes.length; ++n) {
            if (!str.equals(this.shaderTypes[n])) continue;
            return true;
        }
        return str.equals("class");
    }

    public boolean isMetaData(String str) {
        return str.startsWith("[[") && str.endsWith("]]");
    }

    public ShdTypeName getShaderTypeOffsets() {
        int offset;
        String possibleName;
        int n;
        int oldIndex = this.getBufferIndex();
        Vector<ShdTypeName> candidates = new Vector<ShdTypeName>();
        String peekStr = this.peekNextStr();
        for (n = 0; n < this.shaderTypes.length; ++n) {
            if (!peekStr.equals(this.shaderTypes[n])) continue;
            this.getNextStr();
            possibleName = this.getNextStr();
            offset = this.getBufferIndex();
            ShdTypeName db = new ShdTypeName(this.shaderTypes[n], possibleName, offset - this.shaderTypes[n].length(), this.getBufferIndex());
            db.endOfName = offset;
            candidates.addElement(db);
        }
        for (n = 0; n < this.shaderTypes.length; ++n) {
            int possibleEndOfName = -1;
            this.setBufferIndex(0);
            offset = this.searchFor(this.shaderTypes[n], true);
            if (offset == -1) continue;
            String s = this.getNextStr();
            while (this.isComment(s)) {
                s = this.getNextStr();
            }
            if (this.isMetaData(s)) {
                s = this.getNextStr();
            }
            if (s.equals("(") || s.equals(",") || TextUtils.isInList(this.shaderTypes, s)) continue;
            possibleEndOfName = this.getBufferIndex();
            possibleName = s;
            s = this.getNextStr();
            if (this.isMetaData(s)) {
                s = this.getNextStr();
            }
            if (!s.equals("(")) continue;
            ShdTypeName db = new ShdTypeName(this.shaderTypes[n], possibleName, offset - this.shaderTypes[n].length(), this.getBufferIndex());
            db.endOfName = possibleEndOfName;
            candidates.addElement(db);
        }
        this.setBufferIndex(oldIndex);
        if (candidates.size() == 0) {
            return null;
        }
        ShdTypeName outDB = null;
        if (candidates.size() == 1) {
            outDB = (ShdTypeName)candidates.elementAt(0);
        }
        if (outDB == null) {
            ShdTypeName tmp;
            int n2;
            int minOffset = 1000000;
            for (n2 = 0; n2 < candidates.size(); ++n2) {
                tmp = (ShdTypeName)candidates.elementAt(n2);
                if (tmp.beginOffset > minOffset) continue;
                minOffset = tmp.beginOffset;
            }
            for (n2 = 0; n2 < candidates.size(); ++n2) {
                tmp = (ShdTypeName)candidates.elementAt(n2);
                if (tmp.beginOffset > minOffset) continue;
                outDB = tmp;
                break;
            }
        }
        if (outDB == null) {
            return null;
        }
        this.setBufferIndex(outDB.paramsBegin);
        String s = this.getNextStr();
        while (!s.equals("")) {
            while (this.isComment(s)) {
                s = this.getNextStr();
            }
            if (this.isMetaData(s)) {
                s = this.getNextStr();
            }
            if (s.equals("{")) {
                outDB.bodyBegin = this.getBufferIndex();
                break;
            }
            s = this.getNextStr();
        }
        if (outDB.bodyBegin == -1) {
            return null;
        }
        outDB.paramsEnd = this.findBackward(outDB.bodyBegin, ')') + 1;
        return outDB;
    }

    @Override
    public String getNextStr() {
        return this.getNextStr(true);
    }

    public String getNextStr(boolean getMetaData) {
        String cmnt;
        String sysHdr;
        String md;
        boolean literal = false;
        boolean endOfString = false;
        this.debug = false;
        this.outBuff.setLength(0);
        char c = this.gnsGrabNonWhiteChar();
        if (c == '\u0000') {
            return "";
        }
        this.outBuff.append(c);
        if (getMetaData && (md = this.grabMetaData(c)) != null) {
            return md;
        }
        if (this.grabCSystemHeader && (sysHdr = this.gnsGrabCSystemHeader(c)) != null) {
            return sysHdr;
        }
        if (this.grabComments && (cmnt = this.gnsGrabComment(c)) != null) {
            return cmnt;
        }
        String esc = this.gnsGrabEscape(c);
        if (esc != null) {
            return esc;
        }
        if (this.isDelimitor(c)) {
            return this.outBuff.toString();
        }
        Quotation activeQuote = this.isOpenQuotation(c);
        boolean bl = literal = activeQuote != null;
        while (!endOfString && !this.mEndOfBuffer) {
            c = this.readChar();
            if (c == '\u0000') {
                return this.outBuff.toString();
            }
            if (literal && activeQuote.isCloseQuotation(c)) {
                return this.outBuff.append(c).toString();
            }
            if (!literal && this.isOpenQuotation(c) != null) {
                this.ungetChar();
                return this.outBuff.toString();
            }
            if (this.gnsPeekEscape(c)) {
                if (literal) {
                    this.outBuff.append(this.gnsGrabEscape(c));
                    continue;
                }
                this.ungetChar();
                return this.outBuff.toString();
            }
            if (literal) {
                this.outBuff.append(c);
                continue;
            }
            if (this.isDelimitor(c)) {
                this.ungetChar();
                return this.outBuff.toString();
            }
            this.outBuff.append(c);
        }
        return this.outBuff.toString();
    }

    public String grabMetaData(char c) {
        int offset = this.getBufferIndex();
        if (c == '[' && this.peekNextNonWhite(this.getBufferIndex()) == '[') {
            this.sb.setLength(0);
            this.sb.append(c);
            this.sb.append(this.readChar());
            c = this.readChar();
            while (true) {
                if (c == '\u0000') {
                    return this.sb.toString();
                }
                this.sb.append(c);
                if (c == ']' && this.peekNextNonWhite() == ']') {
                    c = this.readChar();
                    while (c != ']') {
                        this.sb.append(c);
                        c = this.readChar();
                    }
                    this.sb.append(c);
                    return this.sb.toString();
                }
                c = this.readChar();
            }
        }
        this.setBufferIndex(offset);
        return null;
    }

    static {
        language = new Hashtable();
        try {
            OslStatementsRes = ResourceBundle.getBundle("UI_Script.Osl.OslLanguageRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: OslTokenizer = " + mre);
        }
        OslTokenizer.initHashTable();
        SHADERTYPES = new String[]{"shader", "surface", "displacement", "light", "volume"};
        DATATYPES = new String[]{"int", "float", "point", "vector", "normal", COLOR_FUNCTION, MATRIX_FUNCTION, STRING_FUNCTION, "void"};
        DATAMODIFIERS = new String[]{MATH_CONSTANT, "uniform", "output", "varying"};
    }

    public class ShdTypeName {
        public String shaderType = "";
        public String shaderName = "";
        public int beginOffset = -1;
        public int paramsBegin = -1;
        public int paramsEnd = -1;
        public int bodyBegin = -1;
        public int endOfName = -1;

        public ShdTypeName(String t, String n, int b, int e) {
            this.shaderType = t;
            this.shaderName = n;
            this.beginOffset = b;
            this.paramsBegin = e;
        }

        public String toString() {
            return "shaderType \"" + this.shaderType + "\" shaderName \"" + this.shaderName + "\"\nbeginOffset at \"" + this.beginOffset + "\" paramsBegin at \"" + this.paramsBegin + "\" paramsEnd at \"" + this.paramsEnd + "\"\nbodyBegin at \"" + this.bodyBegin + "\"";
        }
    }
}

