/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Osl;

import Preferences.Preferences;
import Processes.ProcessManager;
import UI_Desktop.Cutter;
import UI_Script.Osl.OslShader;
import UI_Script.Osl.OslTokenizer;
import UI_Script.Rib.RibTokenizer;
import UI_Tools.Rman.RenderInfo;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import kernal.Tokenizers.Tokenizer;

public class OslinfoParser {
    private static HashMap<String, Integer> handleDB = new HashMap();
    public static final int UNKNOWN = -1;
    public static final int SHADER = 0;
    public static final int SURFACE = 1;
    public static final int DISPLACEMENT = 2;
    public static final int LIGHT = 3;
    public static final int VOLUME = 4;
    private Hashtable<String, OslShader> tableOfShaders = new Hashtable();
    private String oslCompilerPath = "";
    public static final String oslCompileCmd = "oslc";
    public static final String oslInfoCmd = "oslinfo";
    private static File prevSloDir = null;

    public OslinfoParser(String compilerBinPath) {
        this.osoInit(compilerBinPath);
    }

    private void osoInit(String compilerBinPath) {
        this.tableOfShaders.clear();
        this.oslCompilerPath = FileUtils.toUnixPath(compilerBinPath);
        String binPath = TextUtils.trimTrailingChar(this.oslCompilerPath, '/');
        binPath = !binPath.endsWith("bin") ? binPath + "/bin/" : binPath + "/";
        if (this.oslCompilerPath.trim().length() > 0) {
            this.oslCompilerPath = this.oslCompilerPath.replace('\\', '/');
            this.oslCompilerPath = TextUtils.trimTrailingChars(this.oslCompilerPath, "/");
        }
    }

    private void osoInit() {
        this.tableOfShaders.clear();
        this.oslCompilerPath = Preferences.get(Preferences.PATH_OSL_COMPILER_BIN);
        boolean exists = new File(this.oslCompilerPath).exists();
        if (this.oslCompilerPath.trim().length() == 0 || !exists) {
            this.oslCompilerPath = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
            if (this.oslCompilerPath.trim().length() > 0) {
                this.oslCompilerPath = this.oslCompilerPath + "/bin/";
            }
        } else {
            this.oslCompilerPath = FileUtils.toUnixPath(this.oslCompilerPath);
            String binPath = TextUtils.trimTrailingChar(this.oslCompilerPath, '/');
            binPath = !binPath.endsWith("bin") ? binPath + "/bin/" : binPath + "/";
            this.oslCompilerPath = binPath;
        }
        if (this.oslCompilerPath.trim().length() > 0) {
            this.oslCompilerPath = this.oslCompilerPath.replace('\\', '/');
            this.oslCompilerPath = TextUtils.trimTrailingChars(this.oslCompilerPath, "/");
        }
    }

    public OslShader[] parseRawOsoInfo(String info) {
        if (info == null || info.length() == 0) {
            Cutter.setLog("    Error: OslinfoParser.parseOsoInfo() has been passed a null or empty String");
            return null;
        }
        int count = 0;
        RibTokenizer ribtok = new RibTokenizer();
        Hashtable<String, OslShader> table = new Hashtable<String, OslShader>();
        ribtok.setBuffer(info);
        String str = ribtok.getNextStr();
        boolean moreShaders = true;
        OslTokenizer osltok = new OslTokenizer();
        while (moreShaders) {
            while (osltok.isShaderType(str)) {
                OslShader shader = new OslShader(str);
                String name = TextUtils.removeQuotes(ribtok.getNextStr());
                if (name.equals("")) {
                    Cutter.setLog("    Error:OslinfoParser.parseRawOsoInfo() - shader name is empty string.");
                    return null;
                }
                if (!shader.setName(name = TextUtils.removeExtension(name))) {
                    Cutter.setLog("    Error:OslinfoParser.parseRawOsoInfo() - shader.setName() failure.");
                    return null;
                }
                str = ribtok.getNextStr();
                if (str.equals("")) {
                    Cutter.setLog("    Info:OslinfoParser.parseRawOsoInfo() - shader \"" + name + "\" has no parameters");
                    OslShader[] out = new OslShader[]{shader};
                    return out;
                }
                while (str.equalsIgnoreCase("metadata")) {
                    int index = ribtok.peekNextCharIndex(10, ribtok.getBufferIndex());
                    String meta = new String(ribtok.getBuffer(ribtok.getBufferIndex(), index));
                    meta = meta.substring(1);
                    shader.appendMetaData(meta);
                    ribtok.setBufferIndex(index);
                    str = ribtok.getNextStr();
                }
                shader.setNodeId();
                while (!str.equals("")) {
                    if (osltok.isShaderType(str)) {
                        Cutter.setLog("    Info:OslinfoParser.parseRawOsoInfo() - osltok.isShaderType(str) " + str + " returned false.");
                        break;
                    }
                    OslShader.Parameter param = shader.getNewParameter();
                    param.setName(TextUtils.removeQuotes(str));
                    String tmp = ribtok.getNextStr();
                    tmp = TextUtils.removeQuotes(tmp);
                    param.setDataType(tmp);
                    block0 : switch (param.dataTypeID()) {
                        case 0: {
                            while (!str.equals("")) {
                                if (Tokenizer.isADouble(str)) {
                                    param.appendValue(str);
                                }
                                if (!Tokenizer.isLiteral(str = ribtok.getNextStr()) && !osltok.isShaderType(str)) continue;
                                ribtok.ungetString(str);
                                break block0;
                            }
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 18: {
                            boolean isEmptyArray = false;
                            if (param.arraySize == 0) {
                                while (!str.equals("")) {
                                    if (str.equals("}")) {
                                        isEmptyArray = true;
                                        break;
                                    }
                                    str = ribtok.getNextStr();
                                }
                                if (isEmptyArray) break;
                            }
                            while (!str.equals("")) {
                                if (Tokenizer.isADouble(str)) {
                                    param.appendValue(str);
                                }
                                if ((str = ribtok.getNextStr()).equals("\"rgb\"") || str.equals("\"current\"")) {
                                    param.setSpaceName(TextUtils.removeQuotes(str));
                                    continue;
                                }
                                if (!Tokenizer.isLiteral(str) && !osltok.isShaderType(str) && !str.equals("shader")) continue;
                                ribtok.ungetString(str);
                                break block0;
                            }
                            break;
                        }
                        case 12: {
                            if (param.arraySize == 0) break;
                            int numAppended = 0;
                            while (!str.equals("")) {
                                if (Tokenizer.isLiteral(str) && !str.equals(param.getName())) {
                                    param.appendStringValue(str);
                                    ++numAppended;
                                }
                                if (numAppended == param.arraySize) break block0;
                                str = ribtok.getNextStr();
                            }
                            break;
                        }
                        case 1: {
                            while (!str.equals("")) {
                                if (Tokenizer.isADouble(str)) {
                                    param.setValue(str);
                                    break block0;
                                }
                                str = ribtok.getNextStr();
                            }
                            break;
                        }
                        case 17: {
                            while (!str.equals("")) {
                                if (Tokenizer.isADouble(str)) {
                                    param.setValue(str);
                                    break block0;
                                }
                                str = ribtok.getNextStr();
                            }
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: {
                            String prev;
                            boolean foundUnknownValue = false;
                            while (!str.equals("")) {
                                prev = str;
                                str = ribtok.getNextStr();
                                if (str.equalsIgnoreCase("Unknown")) {
                                    ribtok.getNextStr();
                                    ribtok.getNextStr();
                                    param.appendValue("0");
                                    param.appendValue("0");
                                    param.appendValue("0");
                                    foundUnknownValue = true;
                                    param.parserNotes = "Warning:\nFound \"Unknown default value\" for param named \"" + param.getName() + "\".\nCutter has set it's value to \"[0 0 0]\". The default value\nin this .args file may require editing.";
                                    break;
                                }
                                if (Tokenizer.isLiteral(str)) {
                                    if (param.setSpaceName(str)) break;
                                    Cutter.setLog("    Error:OsoInfoParser.parseRawOsoInfo() - cannot set space name >" + str + "<");
                                    return null;
                                }
                                if (prev.equals(":") && str.equalsIgnoreCase("Unknown")) {
                                    Cutter.setLog("    Error:OsoInfoParser.parseRawOsoInfo() - >" + str + "<");
                                    if (Cutter.input.debug) {
                                        Cutter.setLog("    Debug:OsoInfoParser.parseRawOsoInfo() - the shader \"" + shader.getName() + "\" has a default value of \"Unknown\"");
                                        Cutter.setLog("          for a parameter named " + param.getName() + ". Setting its value to \"rgb\" [1 1 1].");
                                    }
                                    param.appendValue("1");
                                    param.appendValue("1");
                                    param.appendValue("1");
                                    foundUnknownValue = true;
                                    break;
                                }
                                if (!str.equals("[")) continue;
                                ribtok.ungetString(str);
                                break;
                            }
                            if (foundUnknownValue) break;
                            prev = str;
                            str = ribtok.getNextStr();
                            if (!str.equals("") && str.charAt(0) != '[') {
                                Cutter.setLog("    Error:OsoInfoParser.parseRawOsoInfo() - found >" + str + "< expected '['");
                                Cutter.setLog("        prev string >" + prev + "<");
                                Cutter.setLog("        current string >" + str + "<");
                                Cutter.setLog("        next string >" + ribtok.getNextStr() + "<");
                                Cutter.setLog("        parameter data type \"" + param.getDataType() + "\" parameter name\"" + param.getName() + "\"");
                                return null;
                            }
                            str = ribtok.getNextStr();
                            if (!param.setValue(str)) {
                                Cutter.setLog("    Error in OSLParser.parseRqwOsoInfo(): line 373");
                                return null;
                            }
                            str = ribtok.getNextStr();
                            while (str.compareTo("]") != 0) {
                                if (!param.appendValue(str)) {
                                    return null;
                                }
                                str = ribtok.getNextStr();
                            }
                            break;
                        }
                        case 4: {
                            str = ribtok.getNextStr();
                            while (!str.equals("")) {
                                if (Tokenizer.isLiteral(str)) {
                                    param.setValue(str);
                                    break block0;
                                }
                                str = ribtok.getNextStr();
                            }
                            break;
                        }
                    }
                    str = ribtok.getNextStr();
                    if (str.equals("")) {
                        shader.addParameter(param);
                        break;
                    }
                    while (str.equalsIgnoreCase("metadata")) {
                        int index = ribtok.peekNextCharIndex(10, ribtok.getBufferIndex());
                        String meta = new String(ribtok.getBuffer(ribtok.getBufferIndex(), index));
                        meta = meta.substring(1);
                        param.appendMetaData(meta);
                        ribtok.setBufferIndex(index);
                        str = ribtok.getNextStr();
                        if (!str.equals("")) continue;
                        break;
                    }
                    shader.addParameter(param);
                    if (!osltok.isShaderType(str)) continue;
                    break;
                }
                if (this.tableOfShaders.containsKey(shader.getName())) continue;
                shader.index = count++;
                table.put(shader.getName(), shader);
            }
            str = ribtok.getNextStr();
            if (!str.equals("")) continue;
            moreShaders = false;
        }
        Enumeration e = table.elements();
        while (e.hasMoreElements()) {
            OslShader shader = (OslShader)e.nextElement();
            this.tableOfShaders.put(shader.getName(), shader);
        }
        OslShader[] out = OslShader.convertToArray(table);
        return out;
    }

    public String getRawOslInfo(String[] shaderNames, File parentDir) {
        StringBuffer infoOut = new StringBuffer();
        String quotes = "\"";
        String parentDirPath = parentDir.getPath().replace('\\', '/') + '/';
        String cmd = this.oslCompilerPath.trim().length() == 0 ? oslInfoCmd : this.oslCompilerPath + "/" + oslInfoCmd;
        String[] progarray = new String[3];
        progarray[0] = cmd;
        progarray[1] = "-v";
        for (int n = 0; n < shaderNames.length; ++n) {
            String name = TextUtils.removeExtension(shaderNames[n]);
            progarray[2] = parentDirPath + name;
            ProcessManager.launchProcess(progarray, infoOut, true);
        }
        return infoOut.toString();
    }

    public RibInfo getRibInfo(String shaderName, File shaderFile) {
        int n;
        OslinfoParser parser = new OslinfoParser(this.oslCompilerPath);
        String[] names = new String[]{shaderName};
        String rawtext = parser.getRawOslInfo(names, shaderFile.getParentFile());
        if (rawtext == null || rawtext.trim().length() == 0) {
            Cutter.setLog("    Error:OslArgsParser.getRibInfo() - getAllOsoText() returned null for\n       \"" + shaderFile.getPath() + "\"");
            return null;
        }
        OslShader[] shader = parser.parseRawOsoInfo(rawtext);
        if (shader == null || shader.length == 0) {
            Cutter.setLog("    Error:OsoInfoParser.getRibInfo() - parseOsoInfo() returned null for\n       \"" + shaderFile.getPath() + "\"");
            Cutter.setLog("        oslCompilerPath >" + this.oslCompilerPath + "<");
            return null;
        }
        RibInfo outInfo = new RibInfo(shader[0].getType(), shader[0].getName());
        Vector<OslShader.Parameter> outputParams = new Vector<OslShader.Parameter>();
        Vector<OslShader.Parameter> inputParams = new Vector<OslShader.Parameter>();
        for (n = 0; n < shader[0].getNumParams(); ++n) {
            OslShader.Parameter p = shader[0].getParamAtIndex(n);
            if (p.isOutput()) {
                outputParams.add(p);
                continue;
            }
            inputParams.add(p);
        }
        outInfo.inputs = new OslShader.Parameter[inputParams.size()];
        outInfo.outputs = new OslShader.Parameter[outputParams.size()];
        for (n = 0; n < inputParams.size(); ++n) {
            outInfo.inputs[n] = (OslShader.Parameter)inputParams.elementAt(n);
        }
        for (n = 0; n < outputParams.size(); ++n) {
            outInfo.outputs[n] = (OslShader.Parameter)outputParams.elementAt(n);
        }
        if (Cutter.input.debug) {
            // empty if block
        }
        return outInfo;
    }

    public File __sloChooseShader() {
        File file = null;
        JFileChooser chooser = new JFileChooser();
        if (prevSloDir != null) {
            chooser.setCurrentDirectory(prevSloDir);
        } else {
            chooser.setCurrentDirectory(new File(FileUtils.getPWD()));
        }
        chooser.setDialogTitle("Select Shader");
        chooser.setApproveButtonText("OK");
        FileFilter allFilter = chooser.getAcceptAllFileFilter();
        FileFilter[] filters = chooser.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            chooser.removeChoosableFileFilter(filters[i]);
        }
        chooser.addChoosableFileFilter(allFilter);
        String ext = TextUtils.remove(RenderInfo.get(11), '.');
        chooser.addChoosableFileFilter(new KFileFilter(ext, "RenderMan Shaders"));
        if (chooser.showOpenDialog(Cutter.desktop) == 0) {
            file = chooser.getSelectedFile();
            prevSloDir = chooser.getCurrentDirectory();
        }
        return file;
    }

    public int __sloCountShaders(File hostDir) {
        if (hostDir == null || !hostDir.exists()) {
            return -1;
        }
        String extension = RenderInfo.get(11);
        FileUtils.SourceFileFilter filter = new FileUtils.SourceFileFilter(extension);
        String[] name = hostDir.list(filter);
        if (name == null) {
            return -1;
        }
        return name.length;
    }

    public String[] __getOsoNames(File hostDir) {
        if (hostDir == null) {
            return null;
        }
        if (!hostDir.exists()) {
            Cutter.setLog("    Error:SLParser.getOsoNames(File hostDir) - the hostDir\n        \"" + hostDir.getPath() + "\"        cannot be found!");
            return null;
        }
        String extension = RenderInfo.get(11);
        FileUtils.SourceFileFilter filter = new FileUtils.SourceFileFilter(extension);
        String[] name = hostDir.list(filter);
        if (name == null) {
            Cutter.setLog("    Error: SLParser.getOsoNames() - cannot get list of shader names from directory,\n        >" + hostDir.getPath() + "<");
            Cutter.setLog("    The extension used for the search was >" + extension + "<");
            return null;
        }
        String[] out = new String[name.length];
        for (int n = 0; n < name.length; ++n) {
            if (name[n].compareTo(extension) != 0) {
                out[n] = name[n];
                continue;
            }
            Cutter.setLog("Warning from SLParser.getOsoNames(): found a shader named \"" + name[n] + "\"");
        }
        return out;
    }

    public class RibInfo {
        private String name = "";
        private String type = "";
        private String handle = "";
        public int id = 0;
        public OslShader.Parameter[] inputs = null;
        public OslShader.Parameter[] outputs = null;

        public RibInfo(String type, String name) {
            this.type = type;
            this.name = name;
        }

        private void updateHandle() {
            if (handleDB.containsKey(this.name)) {
                Integer idAsInt = (Integer)handleDB.get(this.name);
                this.id = idAsInt;
            }
            ++this.id;
            handleDB.put(this.name, this.id);
            this.handle = RenderInfo.prmanMajorVersionNumber() < 21 ? this.name + this.id : "OSL_" + this.name + this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getHandle() {
            return this.handle;
        }

        public String toString(int tabs) {
            return this.toString(tabs, true);
        }

        public String toString(int tabs, boolean doIncrement) {
            this.updateHandle();
            StringBuffer tabB = new StringBuffer();
            for (int i = 0; i < tabs; ++i) {
                tabB.append("\t");
            }
            StringBuffer out = new StringBuffer();
            if (RenderInfo.prmanMajorVersionNumber() < 21) {
                out.append(tabB.toString() + "Pattern \"PxrOSL\" \"" + this.handle + "\" \"string " + this.type + "\" \"" + this.name + "\"\n");
            } else {
                out.append(tabB.toString() + "Pattern \"" + this.name + "\" \"" + this.handle + "\"\n");
            }
            if (tabs == 0) {
                tabB.append("\t");
            } else {
                tabB.append("\t\t\t");
            }
            for (int n = 0; n < this.inputs.length; ++n) {
                if (this.inputs[n].isLockGeom()) {
                    out.append(tabB).append("# uses primvar ").append(this.inputs[n].getName()).append("\n");
                    continue;
                }
                out.append(tabB).append(this.inputs[n].toString()).append("\n");
            }
            for (int i = 0; i < this.outputs.length; ++i) {
                OslShader.Parameter param = this.outputs[i];
                String shdInstance = RenderInfo.prmanMajorVersionNumber() < 21 ? this.handle + ":" + param.getName() : this.handle + ":" + param.getName();
                out.append("\t# output ").append(param.getDataType()).append(" [\"").append(shdInstance).append("\"]\n");
            }
            return out.toString();
        }
    }
}

