/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Perl;

import Preferences.Preferences;
import UI_Script.Perl.PerlTokenizer;
import UI_Script.SyntaxListener;
import UI_Script.Tcl.TclTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import javax.swing.text.StyleConstants;

public class PerlListener
extends SyntaxListener {
    private TclTokenizer tcl = new TclTokenizer();

    public PerlListener(KTextPane textpane) {
        super(textpane, new PerlTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        char[] begin = new char[]{'$', '%', '@'};
        textpane.removeWordDelimitors(begin, null);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setBold(textpane.styleContext.keywordStyle2, false);
        StyleConstants.setBold(textpane.styleContext.keywordStyle3, false);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_C_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_C_DATATYPE));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_C_STRING));
        StyleConstants.setUnderline(textpane.styleContext.stringStyle2, true);
        StyleConstants.setForeground(textpane.styleContext.commentStyle2, Preferences.getColor(Preferences.TEXT_COLOR_PERL_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_PERL_USER_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_PERL_USER_VARIABLE));
        StyleConstants.setBold(textpane.styleContext.keywordStyle4, true);
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_PERL_FUNCTION));
    }

    @Override
    protected void colorizeLiteral(int offset, String str, StyleEdits editList) {
        this.tcl.setBuffer(str);
        this.tcl.getComments = true;
        String s = this.tcl.getNextStr();
        while (!s.equals("")) {
            int index = this.tcl.getBufferIndex() - 1 < 0 ? 0 : this.tcl.getBufferIndex();
            int begin = (index += offset) - s.length();
            int length = s.length();
            if (this.tok.isUserVariable(s)) {
                int i;
                if (s.charAt(0) == '-') {
                    editList.addEdit(begin, 1, this.textpane.styleContext.stringStyle1, true);
                    length = s.length() - 1;
                    editList.addEdit(++begin, length, this.textpane.styleContext.keywordStyle3, true);
                }
                if ((i = s.indexOf(92)) != -1) {
                    editList.addEdit(begin, length, this.textpane.styleContext.keywordStyle3, true);
                    editList.addEdit(begin += i, length -= i, this.textpane.styleContext.stringStyle1, true);
                } else {
                    editList.addEdit(begin, s.length(), this.textpane.styleContext.keywordStyle3, true);
                }
            } else {
                editList.addEdit(begin, s.length(), this.textpane.styleContext.stringStyle1, true);
            }
            s = this.tcl.getNextStr();
        }
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (str.charAt(0) == '\"') {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.stringStyle1, true);
            String tmp = str.substring(1, str.length() - 0);
            if (tmp.length() > 0) {
                this.colorizeLiteral(begin + 1, tmp, editList);
                return true;
            }
            return false;
        }
        if (((PerlTokenizer)this.tok).isReference(str)) {
            String tmp = str.substring(1, str.length());
            if (tmp.length() > 0) {
                editList.addEdit(begin, 1, this.textpane.styleContext.languageStyle, true);
                editList.addEdit(begin + 1, tmp.length(), this.textpane.styleContext.plainStyle, true);
                return true;
            }
            return false;
        }
        char c = str.charAt(0);
        if (c == '$' || c == '%' || c == '@') {
            if (((PerlTokenizer)this.tok).isGlobalSpecialVariable(str)) {
                editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle4, true);
            } else {
                editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addComments() {
        this.addComments("#");
    }
}

